/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.jdt.internal.core.nd.field;

import org.greenrobot.eclipse.jdt.internal.core.nd.Nd;
import org.greenrobot.eclipse.jdt.internal.core.nd.db.Database;
import org.greenrobot.eclipse.jdt.internal.core.nd.db.ModificationLog;
import org.greenrobot.eclipse.jdt.internal.core.nd.field.BaseField;

public class FieldLong
extends BaseField {
    private final ModificationLog.Tag tag;

    public FieldLong(String structName, int fieldNumber) {
        this.setFieldName("field " + fieldNumber + ", a " + this.getClass().getSimpleName() + " in struct " + structName);
        this.tag = ModificationLog.createTag("Writing " + this.getFieldName());
    }

    public long get(Nd nd, long address) {
        Database db = nd.getDB();
        return db.getLong(address + (long)this.offset);
    }

    public void put(Nd nd, long address, long newValue) {
        Database db = nd.getDB();
        db.getLog().start(this.tag);
        try {
            nd.getDB().putLong(address + (long)this.offset, newValue);
        }
        finally {
            db.getLog().end(this.tag);
        }
    }

    @Override
    public int getRecordSize() {
        return 8;
    }
}

