/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.osgi.internal.loader.buddy;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.greenrobot.eclipse.osgi.internal.loader.BundleLoader;
import org.greenrobot.eclipse.osgi.internal.loader.buddy.IBuddyPolicy;
import org.greenrobot.osgi.service.packageadmin.ExportedPackage;
import org.greenrobot.osgi.service.packageadmin.PackageAdmin;

public class GlobalPolicy
implements IBuddyPolicy {
    private PackageAdmin admin;

    public GlobalPolicy(PackageAdmin admin) {
        this.admin = admin;
    }

    @Override
    public Class<?> loadClass(String name) {
        ExportedPackage pkg = this.admin.getExportedPackage(BundleLoader.getPackageName(name));
        if (pkg == null) {
            return null;
        }
        try {
            return pkg.getExportingBundle().loadClass(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    @Override
    public URL loadResource(String name) {
        ExportedPackage pkg = this.admin.getExportedPackage(BundleLoader.getResourcePackageName(name));
        if (pkg == null) {
            return null;
        }
        return pkg.getExportingBundle().getResource(name);
    }

    @Override
    public Enumeration<URL> loadResources(String name) {
        ExportedPackage[] pkgs = this.admin.getExportedPackages(BundleLoader.getResourcePackageName(name));
        if (pkgs == null || pkgs.length == 0) {
            return null;
        }
        Enumeration<URL> results = null;
        ExportedPackage[] exportedPackageArray = pkgs;
        int n = pkgs.length;
        int n2 = 0;
        while (n2 < n) {
            ExportedPackage pkg = exportedPackageArray[n2];
            try {
                results = BundleLoader.compoundEnumerations(results, pkg.getExportingBundle().getResources(name));
            }
            catch (IOException iOException) {}
            ++n2;
        }
        return results;
    }
}

