/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.osgi.internal.loader.classpath;

import org.greenrobot.eclipse.osgi.internal.loader.classpath.TitleVersionVendor;

class ManifestPackageAttributes {
    static final ManifestPackageAttributes NONE = new ManifestPackageAttributes(TitleVersionVendor.NONE, TitleVersionVendor.NONE);
    private final TitleVersionVendor implementation;
    private final TitleVersionVendor specification;

    private static String or(String first, String second) {
        return first == null ? second : first;
    }

    static ManifestPackageAttributes of(String specificationTitle, String specificationVersion, String specificationVendor, String implementationTitle, String implementationVersion, String implementationVendor, ManifestPackageAttributes defaultAttributes) {
        if (defaultAttributes == null) {
            defaultAttributes = NONE;
        }
        return ManifestPackageAttributes.of(ManifestPackageAttributes.or(specificationTitle, defaultAttributes.getSpecification().getTitle()), ManifestPackageAttributes.or(specificationVersion, defaultAttributes.getSpecification().getVersion()), ManifestPackageAttributes.or(specificationVendor, defaultAttributes.getSpecification().getVendor()), ManifestPackageAttributes.or(implementationTitle, defaultAttributes.getImplementation().getTitle()), ManifestPackageAttributes.or(implementationVersion, defaultAttributes.getImplementation().getVersion()), ManifestPackageAttributes.or(implementationVendor, defaultAttributes.getImplementation().getVendor()));
    }

    private static ManifestPackageAttributes of(String specificationTitle, String specificationVersion, String specificationVendor, String implementationTitle, String implementationVersion, String implementationVendor) {
        TitleVersionVendor specification = TitleVersionVendor.of(specificationTitle, specificationVersion, specificationVendor);
        TitleVersionVendor implementation = TitleVersionVendor.of(implementationTitle, implementationVersion, implementationVendor);
        if (specification == TitleVersionVendor.NONE && implementation == TitleVersionVendor.NONE) {
            return NONE;
        }
        return new ManifestPackageAttributes(implementation, specification);
    }

    private ManifestPackageAttributes(TitleVersionVendor implementation, TitleVersionVendor specification) {
        if (implementation == null || specification == null) {
            throw new IllegalArgumentException();
        }
        this.implementation = implementation;
        this.specification = specification;
    }

    TitleVersionVendor getImplementation() {
        return this.implementation;
    }

    TitleVersionVendor getSpecification() {
        return this.specification;
    }
}

