/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.text.templates;

import java.util.Objects;
import java.util.UUID;
import org.greenrobot.eclipse.core.runtime.Assert;
import org.greenrobot.eclipse.jface.text.templates.Template;

public class TemplatePersistenceData {
    private final Template fOriginalTemplate;
    private final String fId;
    private final boolean fOriginalIsEnabled;
    private Template fCustomTemplate = null;
    private boolean fIsDeleted = false;
    private boolean fCustomIsEnabled = true;
    private final UUID uniqueIdForEquals = UUID.randomUUID();

    public TemplatePersistenceData(Template template, boolean enabled) {
        this(template, enabled, null);
    }

    public TemplatePersistenceData(Template template, boolean enabled, String id) {
        Assert.isNotNull(template);
        this.fOriginalTemplate = template;
        this.fCustomTemplate = template;
        this.fOriginalIsEnabled = enabled;
        this.fCustomIsEnabled = enabled;
        this.fId = id;
    }

    public String getId() {
        return this.fId;
    }

    public boolean isDeleted() {
        return this.fIsDeleted;
    }

    public void setDeleted(boolean isDeleted) {
        this.fIsDeleted = isDeleted;
    }

    public Template getTemplate() {
        return this.fCustomTemplate;
    }

    public void setTemplate(Template template) {
        this.fCustomTemplate = template;
    }

    public boolean isCustom() {
        return this.fId == null || this.fIsDeleted || this.fOriginalIsEnabled != this.fCustomIsEnabled || !this.fOriginalTemplate.equals(this.fCustomTemplate);
    }

    public boolean isModified() {
        return this.isCustom() && !this.isUserAdded();
    }

    public boolean isUserAdded() {
        return this.fId == null;
    }

    public void revert() {
        this.fCustomTemplate = this.fOriginalTemplate;
        this.fCustomIsEnabled = this.fOriginalIsEnabled;
        this.fIsDeleted = false;
    }

    public boolean isEnabled() {
        return this.fCustomIsEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        this.fCustomIsEnabled = isEnabled;
    }

    public int hashCode() {
        return Objects.hash(this.uniqueIdForEquals);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TemplatePersistenceData)) {
            return false;
        }
        TemplatePersistenceData other = (TemplatePersistenceData)obj;
        return Objects.equals(this.uniqueIdForEquals, other.getUniqueIdForEquals());
    }

    protected UUID getUniqueIdForEquals() {
        return this.uniqueIdForEquals;
    }

    protected static final UUID getUniqueIdForEquals(TemplatePersistenceData data) {
        return data.getUniqueIdForEquals();
    }
}

