/*
 * Decompiled with CFR 0.152.
 */
package org.akhikhl.gretty;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.authentication.DeferredAuthentication;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.security.authentication.SpnegoAuthenticator;
import org.eclipse.jetty.server.AbstractHttpConnection;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.MultiMap;

public class SSOSpnegoAuthenticator
extends SpnegoAuthenticator {
    public SSOSpnegoAuthenticator() {
    }

    public SSOSpnegoAuthenticator(String authMethod) {
        super(authMethod);
    }

    public Authentication validateRequest(ServletRequest req, ServletResponse res, boolean mandatory) throws ServerAuthException {
        HttpServletRequest request = (HttpServletRequest)req;
        if (!mandatory) {
            return new DeferredAuthentication((LoginAuthenticator)this);
        }
        HttpSession session = request.getSession(true);
        Authentication authentication = (Authentication)session.getAttribute("org.eclipse.jetty.security.UserIdentity");
        if (authentication != null) {
            if (authentication instanceof Authentication.User && this._loginService != null && !this._loginService.validate(((Authentication.User)authentication).getUserIdentity())) {
                session.removeAttribute("org.eclipse.jetty.security.UserIdentity");
            } else {
                String j_uri = (String)session.getAttribute("org.eclipse.jetty.security.form_URI");
                if (j_uri != null) {
                    MultiMap j_post = (MultiMap)session.getAttribute("org.eclipse.jetty.security.form_POST");
                    if (j_post != null) {
                        StringBuffer buf = request.getRequestURL();
                        if (request.getQueryString() != null) {
                            buf.append("?").append(request.getQueryString());
                        }
                        if (j_uri.equals(buf.toString())) {
                            session.removeAttribute("org.eclipse.jetty.security.form_POST");
                            Request base_request = req instanceof Request ? (Request)req : AbstractHttpConnection.getCurrentConnection().getRequest();
                            base_request.setMethod("POST");
                            base_request.setParameters(j_post);
                        }
                    } else {
                        session.removeAttribute("org.eclipse.jetty.security.form_URI");
                    }
                }
                return authentication;
            }
        }
        return super.validateRequest(req, res, mandatory);
    }
}

