/*
 * Decompiled with CFR 0.152.
 */
package org.akhikhl.gretty;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.io.InputStream;
import java.util.Locale;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.eclipse.jetty.annotations.AnnotationParser;
import org.eclipse.jetty.annotations.ClassNameResolver;
import org.eclipse.jetty.util.MultiException;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;

public class AnnotationParserEx
extends AnnotationParser
implements GroovyObject {
    private static final Logger LOG;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public AnnotationParserEx() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    private boolean isValidClassFileName(String name) {
        int n;
        if (name == null || name.length() == 0) {
            return false;
        }
        if (!name.toLowerCase(Locale.ENGLISH).endsWith(".class")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Not a class: {}", new Object[]{name});
            }
            return false;
        }
        int c0 = 0;
        int ldir = name.lastIndexOf("/", name.length() - 6);
        c0 = n = ScriptBytecodeAdapter.compareGreaterThan((Object)ldir, (Object)-1) ? ldir + 1 : c0;
        if (!Character.isJavaIdentifierStart(name.charAt(c0))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(StringGroovyMethods.plus((String)"Not a java identifier: {}", (CharSequence)name), new Object[0]);
            }
            return false;
        }
        return true;
    }

    private boolean isValidClassFilePath(String path) {
        if (path == null || path.length() == 0) {
            return false;
        }
        if (path.startsWith(".") || path.contains("/.")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(StringGroovyMethods.plus((String)"Contains hidden dirs: {}", (CharSequence)path), new Object[0]);
            }
            return false;
        }
        return true;
    }

    public void parse(Resource res, ClassNameResolver resolver) {
        if (res.exists() && !res.isDirectory() && res.toString().endsWith(".jar")) {
            this.parseJar(res, resolver);
        } else {
            super.parse(res, resolver);
        }
    }

    protected void parseJar(Resource jarResource, ClassNameResolver resolver) {
        InputStream ins = jarResource.getInputStream();
        if (ins == null) {
            return;
        }
        MultiException me = new MultiException();
        try (JarInputStream jar_in = new JarInputStream(ins);){
            JarEntry entry = jar_in.getNextJarEntry();
            while (entry != null) {
                JarEntry jarEntry;
                try {
                    this.parseJarEntry(jarResource, entry, resolver);
                }
                catch (Exception e) {
                    DefaultGroovyMethods.println((Object)((Object)this), (Object)StringGroovyMethods.plus((String)StringGroovyMethods.plus((CharSequence)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"Error scanning entry ", (CharSequence)entry.getName()), (CharSequence)" from jar "), (Object)jarResource), (CharSequence)new GStringImpl(new Object[]{e}, new String[]{" e=", ""})));
                    me.add((Throwable)new RuntimeException(StringGroovyMethods.plus((CharSequence)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"Error scanning entry ", (CharSequence)entry.getName()), (CharSequence)" from jar "), (Object)jarResource), e));
                }
                entry = jarEntry = jar_in.getNextJarEntry();
            }
        }
        me.ifExceptionThrow();
    }

    protected void parseJarEntry(Resource jar, JarEntry entry, ClassNameResolver resolver) {
        if (jar == null || entry == null) {
            return;
        }
        if (entry.isDirectory()) {
            return;
        }
        String name = entry.getName();
        if (this.isValidClassFileName(name) && this.isValidClassFilePath(name)) {
            String shortName = name.replace("/", ".").substring(0, name.length() - 6);
            if (resolver == null || !resolver.isExcluded(shortName) && (!this.isParsed(shortName) || resolver.shouldOverride(shortName))) {
                Resource clazz = Resource.newResource((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)StringGroovyMethods.plus((CharSequence)"jar:", (Object)jar.getURI()), (CharSequence)"!/"), (CharSequence)name));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Scanning class from jar {}", new Object[]{clazz});
                }
                this.scanClass(clazz.getInputStream());
            }
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != AnnotationParserEx.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        LOG = logger = Log.getLogger(AnnotationParserEx.class);
    }
}

