/*
 * Decompiled with CFR 0.152.
 */
package org.akhikhl.gretty;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.security.authentication.DeferredAuthentication;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.security.authentication.SessionAuthentication;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.MultiMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSOBasicAuthenticator
extends BasicAuthenticator {
    private static final Logger LOG = LoggerFactory.getLogger(SSOBasicAuthenticator.class);

    public UserIdentity login(String username, Object password, ServletRequest request) {
        UserIdentity user = super.login(username, password, request);
        if (user != null) {
            HttpSession session = ((HttpServletRequest)request).getSession(true);
            SessionAuthentication cached = new SessionAuthentication(this.getAuthMethod(), user, password);
            session.setAttribute("org.eclipse.jetty.security.UserIdentity", (Object)cached);
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Authentication validateRequest(ServletRequest req, ServletResponse res, boolean mandatory) throws ServerAuthException {
        HttpServletRequest request = (HttpServletRequest)req;
        if (!mandatory) {
            return new DeferredAuthentication((LoginAuthenticator)this);
        }
        HttpSession session = request.getSession(true);
        Authentication authentication = (Authentication)session.getAttribute("org.eclipse.jetty.security.UserIdentity");
        if (authentication != null) {
            if (authentication instanceof Authentication.User && this._loginService != null && !this._loginService.validate(((Authentication.User)authentication).getUserIdentity())) {
                LOG.debug("auth revoked {}", (Object)authentication);
                session.removeAttribute("org.eclipse.jetty.security.UserIdentity");
            } else {
                HttpSession httpSession = session;
                synchronized (httpSession) {
                    String j_uri = (String)session.getAttribute("org.eclipse.jetty.security.form_URI");
                    if (j_uri != null) {
                        LOG.debug("auth retry {}->{}", (Object)authentication, (Object)j_uri);
                        StringBuffer buf = request.getRequestURL();
                        if (request.getQueryString() != null) {
                            buf.append("?").append(request.getQueryString());
                        }
                        if (j_uri.equals(buf.toString())) {
                            MultiMap j_post = (MultiMap)session.getAttribute("org.eclipse.jetty.security.form_POST");
                            if (j_post != null) {
                                LOG.debug("auth rePOST {}->{}", (Object)authentication, (Object)j_uri);
                                Request base_request = HttpChannel.getCurrentHttpChannel().getRequest();
                                base_request.setContentParameters(j_post);
                            }
                            session.removeAttribute("org.eclipse.jetty.security.form_URI");
                            session.removeAttribute("org.eclipse.jetty.security.form_METHOD");
                            session.removeAttribute("org.eclipse.jetty.security.form_POST");
                        }
                    }
                }
                LOG.debug("auth {}", (Object)authentication);
                return authentication;
            }
        }
        return super.validateRequest(req, res, mandatory);
    }
}

