/*
 * Decompiled with CFR 0.152.
 */
package org.akhikhl.gretty;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;

public class FilteringClassLoader
extends URLClassLoader {
    private final List<String> serverClasses = new ArrayList<String>();
    private final List<String> serverResources = new ArrayList<String>();
    private ClassLoader bootClassLoader;

    public FilteringClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
        this.findBootClassLoader();
    }

    protected void findBootClassLoader() {
        this.bootClassLoader = this.getParent();
        if (this.bootClassLoader != null) {
            while (this.bootClassLoader.getParent() != null) {
                this.bootClassLoader = this.bootClassLoader.getParent();
            }
        }
    }

    public void addServerClass(String serverClass) {
        this.serverClasses.add(serverClass);
        this.serverResources.add(serverClass.replace('.', '/'));
        this.serverResources.add("META-INF/services/" + serverClass);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        for (String serverClass : this.serverClasses) {
            if (!name.startsWith(serverClass)) continue;
            Class<?> c = this.findLoadedClass(name);
            if (c == null) {
                c = this.findClass(name);
            }
            if (c != null) {
                if (resolve) {
                    this.resolveClass(c);
                }
                return c;
            }
            throw new ClassNotFoundException(name);
        }
        return super.loadClass(name, resolve);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        for (String serverResource : this.serverResources) {
            if (!name.startsWith(serverResource)) continue;
            ArrayList<URL> resources = new ArrayList<URL>();
            resources.addAll(Collections.list(this.getBootstrapResources(name)));
            resources.addAll(Collections.list(this.findResources(name)));
            return Collections.enumeration(resources);
        }
        return super.getResources(name);
    }

    private Enumeration<URL> getBootstrapResources(String name) throws IOException {
        return this.bootClassLoader.getResources(name);
    }
}

