/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.client.hadoop;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.ProtocolSignature;
import org.apache.hadoop.ipc.VersionedProtocol;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.mapreduce.ClusterMetrics;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.QueueAclsInfo;
import org.apache.hadoop.mapreduce.QueueInfo;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskCompletionEvent;
import org.apache.hadoop.mapreduce.TaskReport;
import org.apache.hadoop.mapreduce.TaskTrackerInfo;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.protocol.ClientProtocol;
import org.apache.hadoop.mapreduce.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.mapreduce.v2.LogParams;
import org.apache.hadoop.mapreduce.v2.jobhistory.JobHistoryUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.security.token.Token;
import org.gridgain.client.GridClient;
import org.gridgain.client.GridClientException;
import org.gridgain.grid.hadoop.GridHadoopJobId;
import org.gridgain.grid.hadoop.GridHadoopJobProperty;
import org.gridgain.grid.hadoop.GridHadoopJobStatus;
import org.gridgain.grid.kernal.processors.hadoop.GridHadoopUtils;
import org.gridgain.grid.kernal.processors.hadoop.proto.GridHadoopProtocolConfigurationWrapper;
import org.gridgain.grid.kernal.processors.hadoop.proto.GridHadoopProtocolJobStatusTask;
import org.gridgain.grid.kernal.processors.hadoop.proto.GridHadoopProtocolKillJobTask;
import org.gridgain.grid.kernal.processors.hadoop.proto.GridHadoopProtocolNextTaskIdTask;
import org.gridgain.grid.kernal.processors.hadoop.proto.GridHadoopProtocolSubmitJobTask;
import org.gridgain.grid.kernal.processors.hadoop.proto.GridHadoopProtocolTaskArguments;

public class GridHadoopClientProtocol
implements ClientProtocol {
    public static final String FRAMEWORK_NAME = "gridgain";
    private static final long PROTO_VER = 1L;
    private static final String SYS_DIR = ".gridgain/system";
    private final Configuration conf;
    private volatile GridClient cli;
    private long lastVer = -1L;
    private GridHadoopJobStatus lastStatus;

    GridHadoopClientProtocol(Configuration conf, GridClient cli) {
        assert (cli != null);
        this.conf = conf;
        this.cli = cli;
    }

    public JobID getNewJobID() throws IOException, InterruptedException {
        try {
            GridHadoopJobId jobID = (GridHadoopJobId)this.cli.compute().execute(GridHadoopProtocolNextTaskIdTask.class.getName(), null);
            return new JobID(jobID.globalId().toString(), jobID.localId());
        }
        catch (GridClientException e) {
            throw new IOException("Failed to get new job ID.", e);
        }
    }

    public JobStatus submitJob(JobID jobId, String jobSubmitDir, Credentials ts) throws IOException, InterruptedException {
        try {
            GridHadoopJobStatus status = (GridHadoopJobStatus)this.cli.compute().execute(GridHadoopProtocolSubmitJobTask.class.getName(), (Object)new GridHadoopProtocolTaskArguments(jobId.getJtIdentifier(), jobId.getId(), new GridHadoopProtocolConfigurationWrapper(this.conf)));
            assert (status != null);
            return this.processStatus(status);
        }
        catch (GridClientException e) {
            throw new IOException("Failed to submit job.", e);
        }
    }

    public ClusterMetrics getClusterMetrics() throws IOException, InterruptedException {
        return new ClusterMetrics(0, 0, 0, 0, 0, 0, 1000, 1000, 1, 100, 0, 0);
    }

    public Cluster.JobTrackerStatus getJobTrackerStatus() throws IOException, InterruptedException {
        return Cluster.JobTrackerStatus.RUNNING;
    }

    public long getTaskTrackerExpiryInterval() throws IOException, InterruptedException {
        return 0L;
    }

    public AccessControlList getQueueAdmins(String queueName) throws IOException {
        return new AccessControlList("*");
    }

    public void killJob(JobID jobId) throws IOException, InterruptedException {
        try {
            this.cli.compute().execute(GridHadoopProtocolKillJobTask.class.getName(), (Object)new GridHadoopProtocolTaskArguments(jobId.getJtIdentifier(), jobId.getId()));
        }
        catch (GridClientException e) {
            throw new IOException("Failed to kill job: " + jobId, e);
        }
    }

    public void setJobPriority(JobID jobid, String priority) throws IOException, InterruptedException {
    }

    public boolean killTask(TaskAttemptID taskId, boolean shouldFail) throws IOException, InterruptedException {
        return false;
    }

    public JobStatus getJobStatus(JobID jobId) throws IOException, InterruptedException {
        try {
            Long delay = this.conf.getLong(GridHadoopJobProperty.JOB_STATUS_POLL_DELAY.propertyName(), -1L);
            GridHadoopProtocolTaskArguments args = delay >= 0L ? new GridHadoopProtocolTaskArguments(jobId.getJtIdentifier(), jobId.getId(), delay) : new GridHadoopProtocolTaskArguments(jobId.getJtIdentifier(), jobId.getId());
            GridHadoopJobStatus status = (GridHadoopJobStatus)this.cli.compute().execute(GridHadoopProtocolJobStatusTask.class.getName(), (Object)args);
            if (status == null) {
                throw new IOException("Job tracker doesn't have any information about the job: " + jobId);
            }
            return this.processStatus(status);
        }
        catch (GridClientException e) {
            throw new IOException("Failed to get job status: " + jobId, e);
        }
    }

    public Counters getJobCounters(JobID jobid) throws IOException, InterruptedException {
        return null;
    }

    public TaskReport[] getTaskReports(JobID jobid, TaskType type) throws IOException, InterruptedException {
        return new TaskReport[0];
    }

    public String getFilesystemName() throws IOException, InterruptedException {
        return FileSystem.get((Configuration)this.conf).getUri().toString();
    }

    public JobStatus[] getAllJobs() throws IOException, InterruptedException {
        return new JobStatus[0];
    }

    public TaskCompletionEvent[] getTaskCompletionEvents(JobID jobid, int fromEventId, int maxEvents) throws IOException, InterruptedException {
        return new TaskCompletionEvent[0];
    }

    public String[] getTaskDiagnostics(TaskAttemptID taskId) throws IOException, InterruptedException {
        return new String[0];
    }

    public TaskTrackerInfo[] getActiveTrackers() throws IOException, InterruptedException {
        return new TaskTrackerInfo[0];
    }

    public TaskTrackerInfo[] getBlacklistedTrackers() throws IOException, InterruptedException {
        return new TaskTrackerInfo[0];
    }

    public String getSystemDir() throws IOException, InterruptedException {
        Path sysDir = new Path(SYS_DIR);
        return sysDir.toString();
    }

    public String getStagingAreaDir() throws IOException, InterruptedException {
        String usr = UserGroupInformation.getCurrentUser().getShortUserName();
        return GridHadoopUtils.stagingAreaDir(this.conf, usr).toString();
    }

    public String getJobHistoryDir() throws IOException, InterruptedException {
        return JobHistoryUtils.getConfiguredHistoryServerDoneDirPrefix((Configuration)this.conf);
    }

    public QueueInfo[] getQueues() throws IOException, InterruptedException {
        return new QueueInfo[0];
    }

    public QueueInfo getQueue(String queueName) throws IOException, InterruptedException {
        return null;
    }

    public QueueAclsInfo[] getQueueAclsForCurrentUser() throws IOException, InterruptedException {
        return new QueueAclsInfo[0];
    }

    public QueueInfo[] getRootQueues() throws IOException, InterruptedException {
        return new QueueInfo[0];
    }

    public QueueInfo[] getChildQueues(String queueName) throws IOException, InterruptedException {
        return new QueueInfo[0];
    }

    public Token<DelegationTokenIdentifier> getDelegationToken(Text renewer) throws IOException, InterruptedException {
        return null;
    }

    public long renewDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException, InterruptedException {
        return 0L;
    }

    public void cancelDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException, InterruptedException {
    }

    public LogParams getLogFileParams(JobID jobID, TaskAttemptID taskAttemptID) throws IOException, InterruptedException {
        return null;
    }

    public long getProtocolVersion(String protocol, long clientVersion) throws IOException {
        return 1L;
    }

    public ProtocolSignature getProtocolSignature(String protocol, long clientVersion, int clientMethodsHash) throws IOException {
        return ProtocolSignature.getProtocolSignature((VersionedProtocol)this, (String)protocol, (long)clientVersion, (int)clientMethodsHash);
    }

    private JobStatus processStatus(GridHadoopJobStatus status) {
        if (this.lastVer < status.version()) {
            this.lastVer = status.version();
            this.lastStatus = status;
        } else assert (this.lastStatus != null);
        return GridHadoopUtils.status(this.lastStatus, this.conf);
    }
}

