/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.client.hadoop;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.protocol.ClientProtocol;
import org.apache.hadoop.mapreduce.protocol.ClientProtocolProvider;
import org.gridgain.client.GridClient;
import org.gridgain.client.GridClientConfiguration;
import org.gridgain.client.GridClientException;
import org.gridgain.client.GridClientFactory;
import org.gridgain.client.GridClientProtocol;
import org.gridgain.client.hadoop.GridHadoopClientProtocol;
import org.gridgain.client.marshaller.GridClientMarshaller;
import org.gridgain.client.marshaller.optimized.GridClientOptimizedMarshaller;
import org.gridgain.grid.GridException;
import org.gridgain.grid.GridFuture;
import org.gridgain.grid.util.future.GridFutureAdapter;
import org.gridgain.grid.util.typedef.F;

public class GridHadoopClientProtocolProvider
extends ClientProtocolProvider {
    private static final ConcurrentHashMap<String, GridFuture<GridClient>> cliMap = new ConcurrentHashMap();

    public ClientProtocol create(Configuration conf) throws IOException {
        if ("gridgain".equals(conf.get("mapreduce.framework.name"))) {
            String addr = conf.get("mapreduce.jobtracker.address");
            if (F.isEmpty((String)addr)) {
                throw new IOException("Failed to create client protocol because server address is not specified (is mapreduce.jobtracker.address property set?).");
            }
            if (F.eq((Object)addr, (Object)"local")) {
                throw new IOException("Local execution mode is not supported, please point mapreduce.jobtracker.address to real GridGain node.");
            }
            return GridHadoopClientProtocolProvider.createProtocol(addr, conf);
        }
        return null;
    }

    public ClientProtocol create(InetSocketAddress addr, Configuration conf) throws IOException {
        if ("gridgain".equals(conf.get("mapreduce.framework.name"))) {
            return GridHadoopClientProtocolProvider.createProtocol(addr.getHostString() + ":" + addr.getPort(), conf);
        }
        return null;
    }

    public void close(ClientProtocol cliProto) throws IOException {
    }

    private static ClientProtocol createProtocol(String addr, Configuration conf) throws IOException {
        return new GridHadoopClientProtocol(conf, GridHadoopClientProtocolProvider.client(addr));
    }

    private static GridClient client(String addr) throws IOException {
        try {
            GridFuture<GridClient> fut = cliMap.get(addr);
            if (fut == null) {
                GridFutureAdapter fut0 = new GridFutureAdapter();
                GridFuture<GridClient> oldFut = cliMap.putIfAbsent(addr, (GridFuture<GridClient>)fut0);
                if (oldFut != null) {
                    return (GridClient)oldFut.get();
                }
                GridClientConfiguration cliCfg = new GridClientConfiguration();
                cliCfg.setProtocol(GridClientProtocol.TCP);
                cliCfg.setServers(Collections.singletonList(addr));
                cliCfg.setMarshaller((GridClientMarshaller)new GridClientOptimizedMarshaller());
                cliCfg.setDaemon(true);
                try {
                    GridClient cli = GridClientFactory.start((GridClientConfiguration)cliCfg);
                    fut0.onDone((Object)cli);
                    return cli;
                }
                catch (GridClientException e) {
                    fut0.onDone((Throwable)e);
                    throw new IOException("Failed to establish connection with GridGain node: " + addr, e);
                }
            }
            return (GridClient)fut.get();
        }
        catch (GridException e) {
            throw new IOException("Failed to establish connection with GridGain node: " + addr, e);
        }
    }
}

