/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.cache.eviction.ggfs;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.gridgain.grid.GridException;
import org.gridgain.grid.cache.GridCacheEntry;
import org.gridgain.grid.cache.eviction.GridCacheEvictionPolicy;
import org.gridgain.grid.cache.eviction.ggfs.GridCacheGgfsPerBlockLruEvictionPolicyMBean;
import org.gridgain.grid.ggfs.GridGgfsPath;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsBlockKey;
import org.jdk8.backport.ConcurrentLinkedDeque8;
import org.jdk8.backport.LongAdder;
import org.jetbrains.annotations.Nullable;

public class GridCacheGgfsPerBlockLruEvictionPolicy
implements GridCacheEvictionPolicy<GridGgfsBlockKey, byte[]>,
GridCacheGgfsPerBlockLruEvictionPolicyMBean {
    public static final String META_NODE = "ggfs_node";
    private volatile long maxSize;
    private volatile int maxBlocks;
    private volatile Collection<String> excludePaths;
    private volatile Collection<Pattern> excludePatterns;
    private final AtomicBoolean excludeRecompile = new AtomicBoolean(true);
    private final ConcurrentLinkedDeque8<GridCacheEntry<GridGgfsBlockKey, byte[]>> queue = new ConcurrentLinkedDeque8();
    private final LongAdder curSize = new LongAdder();

    public GridCacheGgfsPerBlockLruEvictionPolicy() {
    }

    public GridCacheGgfsPerBlockLruEvictionPolicy(long maxSize, int maxBlocks) {
        this(maxSize, maxBlocks, null);
    }

    public GridCacheGgfsPerBlockLruEvictionPolicy(long maxSize, int maxBlocks, @Nullable Collection<String> excludePaths) {
        this.maxSize = maxSize;
        this.maxBlocks = maxBlocks;
        this.excludePaths = excludePaths;
    }

    public void onEntryAccessed(boolean rmv, GridCacheEntry<GridGgfsBlockKey, byte[]> entry) {
        if (!rmv) {
            if (!entry.isCached()) {
                return;
            }
            if (this.touch(entry)) {
                this.shrink();
            }
        } else {
            MetaEntry meta = (MetaEntry)entry.removeMeta(META_NODE);
            if (meta != null && this.queue.unlinkx(meta.node())) {
                this.changeSize(-meta.size());
            }
        }
    }

    private boolean touch(GridCacheEntry<GridGgfsBlockKey, byte[]> entry) {
        byte[] val = (byte[])entry.peek();
        int blockSize = val != null ? val.length : 0;
        MetaEntry meta = (MetaEntry)entry.meta(META_NODE);
        if (meta == null) {
            ConcurrentLinkedDeque8.Node node;
            do {
                if (entry.putMetaIfAbsent(META_NODE, (Object)(meta = new MetaEntry(node = this.queue.offerLastx(entry), blockSize))) != null) {
                    this.queue.unlinkx(node);
                    return false;
                }
                if (node.item() == null) continue;
                if (!entry.isCached()) {
                    this.queue.unlinkx(node);
                    return false;
                }
                this.changeSize(blockSize);
                return true;
            } while (entry.removeMeta(META_NODE, (Object)node));
            return false;
        }
        int oldBlockSize = meta.size();
        ConcurrentLinkedDeque8.Node node = meta.node();
        if (this.queue.unlinkx(node)) {
            ConcurrentLinkedDeque8.Node newNode = this.queue.offerLastx(entry);
            int delta = blockSize - oldBlockSize;
            if (!entry.replaceMeta(META_NODE, (Object)meta, (Object)new MetaEntry(newNode, blockSize)) && this.queue.unlinkx(newNode)) {
                delta -= blockSize;
            }
            if (delta != 0) {
                this.changeSize(delta);
                if (delta > 0) {
                    return true;
                }
            }
        }
        return false;
    }

    private void shrink() {
        GridCacheEntry entry;
        long maxSize = this.maxSize;
        int maxBlocks = this.maxBlocks;
        int cnt = this.queue.sizex();
        for (int i = 0; i < cnt && (maxBlocks > 0 && this.queue.sizex() > maxBlocks || maxSize > 0L && this.curSize.longValue() > maxSize) && (entry = (GridCacheEntry)this.queue.poll()) != null; ++i) {
            byte[] val = (byte[])entry.peek();
            if (val != null) {
                this.changeSize(-val.length);
            }
            if (entry.evict()) continue;
            entry.removeMeta(META_NODE);
            this.touch((GridCacheEntry<GridGgfsBlockKey, byte[]>)entry);
        }
    }

    private void changeSize(int delta) {
        if (delta != 0) {
            this.curSize.add((long)delta);
        }
    }

    @Override
    public long getMaxSize() {
        return this.maxSize;
    }

    @Override
    public void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    public int getMaxBlocks() {
        return this.maxBlocks;
    }

    @Override
    public void setMaxBlocks(int maxBlocks) {
        this.maxBlocks = maxBlocks;
    }

    @Override
    public Collection<String> getExcludePaths() {
        return Collections.unmodifiableCollection(this.excludePaths);
    }

    @Override
    public void setExcludePaths(@Nullable Collection<String> excludePaths) {
        this.excludePaths = excludePaths;
        this.excludeRecompile.set(true);
    }

    @Override
    public long getCurrentSize() {
        return this.curSize.longValue();
    }

    @Override
    public int getCurrentBlocks() {
        return this.queue.size();
    }

    public boolean exclude(GridGgfsPath path) throws GridException {
        Collection<Pattern> excludePatterns0;
        assert (path != null);
        if (this.excludeRecompile.compareAndSet(true, false)) {
            Collection<String> excludePaths0 = this.excludePaths;
            if (excludePaths0 != null) {
                excludePatterns0 = new HashSet<Pattern>(excludePaths0.size(), 1.0f);
                for (String excludePath : excludePaths0) {
                    try {
                        excludePatterns0.add(Pattern.compile(excludePath));
                    }
                    catch (PatternSyntaxException ignore) {
                        throw new GridException("Invalid regex pattern: " + excludePath);
                    }
                }
                this.excludePatterns = excludePatterns0;
            } else {
                this.excludePatterns = null;
                excludePatterns0 = null;
            }
        } else {
            excludePatterns0 = this.excludePatterns;
        }
        if (excludePatterns0 != null) {
            String pathStr = path.toString();
            for (Pattern pattern : excludePatterns0) {
                if (!pattern.matcher(pathStr).matches()) continue;
                return true;
            }
        }
        return false;
    }

    private static class MetaEntry {
        private final ConcurrentLinkedDeque8.Node<GridCacheEntry<GridGgfsBlockKey, byte[]>> node;
        private final int size;

        private MetaEntry(ConcurrentLinkedDeque8.Node<GridCacheEntry<GridGgfsBlockKey, byte[]>> node, int size) {
            assert (node != null);
            assert (size >= 0);
            this.node = node;
            this.size = size;
        }

        private ConcurrentLinkedDeque8.Node<GridCacheEntry<GridGgfsBlockKey, byte[]>> node() {
            return this.node;
        }

        private int size() {
            return this.size;
        }
    }
}

