/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.ggfs;

import org.gridgain.grid.kernal.processors.cache.GridCacheDefaultAffinityKeyMapper;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsBlockKey;
import org.gridgain.grid.util.typedef.internal.A;
import org.gridgain.grid.util.typedef.internal.S;

public class GridGgfsGroupDataBlocksKeyMapper
extends GridCacheDefaultAffinityKeyMapper {
    private static final long serialVersionUID = 0L;
    private final int grpSize;

    public GridGgfsGroupDataBlocksKeyMapper(int grpSize) {
        A.ensure((grpSize >= 1 ? 1 : 0) != 0, (String)"grpSize >= 1");
        this.grpSize = grpSize;
    }

    public Object affinityKey(Object key) {
        if (key != null && GridGgfsBlockKey.class.equals(key.getClass())) {
            GridGgfsBlockKey blockKey = (GridGgfsBlockKey)key;
            if (blockKey.affinityKey() != null) {
                return blockKey.affinityKey();
            }
            long grpId = blockKey.getBlockId() / (long)this.grpSize;
            return blockKey.getFileId().hashCode() + (int)(grpId ^ grpId >>> 32);
        }
        return super.affinityKey(key);
    }

    public int groupSize() {
        return this.grpSize;
    }

    public String toString() {
        return S.toString(GridGgfsGroupDataBlocksKeyMapper.class, (Object)((Object)this));
    }
}

