/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.ggfs.hadoop.v1;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.InvalidPathException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;
import org.gridgain.grid.GridRuntimeException;
import org.gridgain.grid.ggfs.GridGgfsBlockLocation;
import org.gridgain.grid.ggfs.GridGgfsConfiguration;
import org.gridgain.grid.ggfs.GridGgfsException;
import org.gridgain.grid.ggfs.GridGgfsFile;
import org.gridgain.grid.ggfs.GridGgfsMode;
import org.gridgain.grid.ggfs.GridGgfsPath;
import org.gridgain.grid.ggfs.GridGgfsPathSummary;
import org.gridgain.grid.kernal.ggfs.hadoop.GridGgfsHadoopInputStream;
import org.gridgain.grid.kernal.ggfs.hadoop.GridGgfsHadoopLogger;
import org.gridgain.grid.kernal.ggfs.hadoop.GridGgfsHadoopOutputStream;
import org.gridgain.grid.kernal.ggfs.hadoop.GridGgfsHadoopProxyInputStream;
import org.gridgain.grid.kernal.ggfs.hadoop.GridGgfsHadoopProxyOutputStream;
import org.gridgain.grid.kernal.ggfs.hadoop.GridGgfsHadoopStreamDelegate;
import org.gridgain.grid.kernal.ggfs.hadoop.GridGgfsHadoopUtils;
import org.gridgain.grid.kernal.ggfs.hadoop.GridGgfsHadoopWrapper;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsHandshakeResponse;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsModeResolver;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsPaths;
import org.gridgain.grid.util.typedef.F;
import org.gridgain.grid.util.typedef.T2;
import org.gridgain.grid.util.typedef.internal.A;
import org.gridgain.grid.util.typedef.internal.S;
import org.gridgain.grid.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class GridGgfsHadoopFileSystem
extends FileSystem {
    public static final String GGFS_MANAGEMENT = "fs.ggfs.management.connection";
    private static final BlockLocation[] EMPTY_BLOCK_LOCATIONS = new BlockLocation[0];
    public static final FileStatus[] EMPTY_FILE_STATUS = new FileStatus[0];
    private GridGgfsHadoopWrapper rmtClient;
    private GridGgfsPath workingDir = GridGgfsConfiguration.DFLT_WORKING_DIR;
    private short dfltReplication;
    private URI uri;
    private String uriAuthority;
    private GridGgfsHadoopLogger clientLog;
    private URI secondaryUri;
    private GridGgfsModeResolver modeRslvr;
    private FileSystem secondaryFs;
    private boolean mgmt;
    private boolean seqReadsBeforePrefetchOverride;
    private long ggfsGrpBlockSize;
    private boolean colocateFileWrites;
    private int seqReadsBeforePrefetch;

    public URI getUri() {
        if (this.uri == null) {
            throw new IllegalStateException("URI is null (was GridGgfsHadoopFileSystem properly initialized?).");
        }
        return this.uri;
    }

    private void enterBusy() throws IOException {
    }

    private void leaveBusy() {
    }

    public void colocateFileWrites(boolean colocateFileWrites) {
        this.colocateFileWrites = colocateFileWrites;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(URI name, Configuration cfg) throws IOException {
        this.enterBusy();
        try {
            boolean initSecondary;
            if (this.rmtClient != null) {
                throw new IOException("File system is already initialized: " + this.rmtClient);
            }
            A.notNull((Object)name, (String)"name");
            A.notNull((Object)cfg, (String)"cfg");
            super.initialize(name, cfg);
            this.mgmt = cfg.getBoolean(GGFS_MANAGEMENT, false);
            if (!"ggfs".equals(name.getScheme())) {
                throw new IOException("Illegal file system URI [expected=ggfs://[name]/[optional_path], actual=" + name + ']');
            }
            this.uri = name;
            this.uriAuthority = this.uri.getAuthority();
            this.seqReadsBeforePrefetch = GridGgfsHadoopUtils.parameter(cfg, "fs.ggfs.%s.open.sequential_reads_before_prefetch", this.uriAuthority, 0);
            if (this.seqReadsBeforePrefetch > 0) {
                this.seqReadsBeforePrefetchOverride = true;
            }
            this.dfltReplication = (short)cfg.getInt("dfs.replication", 3);
            this.colocateFileWrites = GridGgfsHadoopUtils.parameter(cfg, "fs.ggfs.%s.colocated.writes", this.uriAuthority, false);
            String logDirCfg = GridGgfsHadoopUtils.parameter(cfg, "fs.ggfs.%s.log.dir", this.uriAuthority, "work/ggfs/log");
            File logDirFile = U.resolveGridGainPath((String)logDirCfg);
            String logDir = logDirFile != null ? logDirFile.getAbsolutePath() : null;
            this.rmtClient = new GridGgfsHadoopWrapper(this.uriAuthority, logDir, cfg, LOG);
            GridGgfsHandshakeResponse handshake = this.rmtClient.handshake(logDir);
            this.ggfsGrpBlockSize = handshake.blockSize();
            GridGgfsPaths paths = handshake.secondaryPaths();
            Boolean logEnabled = GridGgfsHadoopUtils.parameter(cfg, "fs.ggfs.%s.log.enabled", this.uriAuthority, false);
            if ((handshake.sampling() != null ? handshake.sampling() : logEnabled).booleanValue()) {
                if (logDir == null) {
                    throw new IOException("Failed to resolve log directory: " + logDirCfg);
                }
                Integer batchSize = GridGgfsHadoopUtils.parameter(cfg, "fs.ggfs.%s.log.batch_size", this.uriAuthority, 100);
                this.clientLog = GridGgfsHadoopLogger.logger(this.uriAuthority, handshake.ggfsName(), logDir, batchSize);
            } else {
                this.clientLog = GridGgfsHadoopLogger.disabledLogger();
            }
            this.modeRslvr = new GridGgfsModeResolver(paths.defaultMode(), paths.pathModes());
            boolean bl = initSecondary = paths.defaultMode() == GridGgfsMode.PROXY;
            if (paths.pathModes() != null && !paths.pathModes().isEmpty()) {
                for (T2<GridGgfsPath, GridGgfsMode> pathMode : paths.pathModes()) {
                    GridGgfsMode mode = (GridGgfsMode)pathMode.getValue();
                    initSecondary |= mode == GridGgfsMode.PROXY;
                }
            }
            if (initSecondary) {
                if (paths.secondaryConfigurationPath() == null) {
                    throw new IOException("Failed to connect to the secondary file system because configuration path is not provided.");
                }
                if (paths.secondaryUri() == null) {
                    throw new IOException("Failed to connect to the secondary file system because URI is not provided.");
                }
                String secondaryConfPath = paths.secondaryConfigurationPath();
                try {
                    this.secondaryUri = new URI(paths.secondaryUri());
                    URL secondaryCfgUrl = U.resolveGridGainUrl((String)secondaryConfPath);
                    Configuration conf = new Configuration();
                    if (secondaryCfgUrl != null) {
                        conf.addResource(secondaryCfgUrl);
                    }
                    String prop = String.format("fs.%s.impl.disable.cache", this.secondaryUri.getScheme());
                    conf.setBoolean(prop, true);
                    this.secondaryFs = FileSystem.get((URI)this.secondaryUri, (Configuration)conf);
                }
                catch (URISyntaxException ignore) {
                    if (!this.mgmt) {
                        throw new IOException("Failed to resolve secondary file system URI: " + paths.secondaryUri());
                    }
                    LOG.warn((Object)"Visor failed to create secondary file system (operations on paths with PROXY mode will have no effect).");
                }
                catch (IOException e) {
                    if (!this.mgmt) {
                        throw new IOException("Failed to connect to the secondary file system: " + paths.secondaryUri(), e);
                    }
                    LOG.warn((Object)("Visor failed to create secondary file system (operations on paths with PROXY mode will have no effect): " + e.getMessage()));
                }
            }
        }
        finally {
            this.leaveBusy();
        }
    }

    protected void checkPath(Path path) {
        URI uri = path.toUri();
        if (uri.isAbsolute()) {
            if (!F.eq((Object)uri.getScheme(), (Object)"ggfs")) {
                throw new InvalidPathException("Wrong path scheme [expected=ggfs, actual=" + uri.getAuthority() + ']');
            }
            if (!F.eq((Object)uri.getAuthority(), (Object)this.uriAuthority)) {
                throw new InvalidPathException("Wrong path authority [expected=" + this.uriAuthority + ", actual=" + uri.getAuthority() + ']');
            }
        }
    }

    public short getDefaultReplication() {
        return this.dfltReplication;
    }

    public void close() throws IOException {
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close0();
    }

    private void close0() throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("File system closed [uri=" + this.uri + ", endpoint=" + this.uriAuthority + ']'));
        }
        if (this.rmtClient == null) {
            return;
        }
        super.close();
        this.rmtClient.close(false);
        if (this.clientLog.isLogEnabled()) {
            this.clientLog.close();
        }
        if (this.secondaryFs != null) {
            U.closeQuiet((Closeable)this.secondaryFs);
        }
        this.uri = null;
        this.rmtClient = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimes(Path p, long mtime, long atime) throws IOException {
        this.enterBusy();
        try {
            A.notNull((Object)p, (String)"p");
            if (this.mode(p) == GridGgfsMode.PROXY) {
                if (this.secondaryFs == null) {
                    assert (this.mgmt);
                    return;
                }
                this.secondaryFs.setTimes(this.toSecondary(p), mtime, atime);
            } else {
                GridGgfsPath path = this.convert(p);
                this.rmtClient.setTimes(path, atime, mtime);
            }
        }
        finally {
            this.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPermission(Path p, FsPermission perm) throws IOException {
        this.enterBusy();
        try {
            A.notNull((Object)p, (String)"p");
            if (this.mode(p) == GridGgfsMode.PROXY) {
                if (this.secondaryFs == null) {
                    assert (this.mgmt);
                    return;
                }
                this.secondaryFs.setPermission(this.toSecondary(p), perm);
            } else if (this.rmtClient.update(this.convert(p), this.permission(perm)) == null) {
                throw new IOException("Failed to set file permission (file not found?) [path=" + p + ", perm=" + perm + ']');
            }
        }
        finally {
            this.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOwner(Path p, String username, String grpName) throws IOException {
        A.notNull((Object)p, (String)"p");
        A.notNull((Object)username, (String)"username");
        A.notNull((Object)grpName, (String)"grpName");
        this.enterBusy();
        try {
            if (this.mode(p) == GridGgfsMode.PROXY) {
                if (this.secondaryFs == null) {
                    assert (this.mgmt);
                    return;
                }
                this.secondaryFs.setOwner(this.toSecondary(p), username, grpName);
            } else if (this.rmtClient.update(this.convert(p), F.asMap((Object)"usrName", (Object)username, (Object)"grpName", (Object)grpName)) == null) {
                throw new IOException("Failed to set file permission (file not found?) [path=" + p + ", userName=" + username + ", groupName=" + grpName + ']');
            }
        }
        finally {
            this.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSDataInputStream open(Path f, int bufSize) throws IOException {
        A.notNull((Object)f, (String)"f");
        this.enterBusy();
        try {
            GridGgfsPath path = this.convert(f);
            GridGgfsMode mode = this.mode(path);
            if (mode == GridGgfsMode.PROXY) {
                if (this.secondaryFs == null) {
                    assert (this.mgmt);
                    throw new IOException("Failed to open file (secondary file system is not initialized): " + f);
                }
                FSDataInputStream is = this.secondaryFs.open(this.toSecondary(f), bufSize);
                if (this.clientLog.isLogEnabled()) {
                    FileStatus status = this.secondaryFs.getFileStatus(this.toSecondary(f));
                    long size = status != null ? status.getLen() : -1L;
                    long logId = GridGgfsHadoopLogger.nextId();
                    this.clientLog.logOpen(logId, path, GridGgfsMode.PROXY, bufSize, size);
                    FSDataInputStream fSDataInputStream = new FSDataInputStream((InputStream)new GridGgfsHadoopProxyInputStream(is, this.clientLog, logId));
                    return fSDataInputStream;
                }
                FSDataInputStream status = is;
                return status;
            }
            GridGgfsHadoopStreamDelegate stream = this.seqReadsBeforePrefetchOverride ? this.rmtClient.open(path, this.seqReadsBeforePrefetch) : this.rmtClient.open(path);
            long logId = -1L;
            if (this.clientLog.isLogEnabled()) {
                logId = GridGgfsHadoopLogger.nextId();
                this.clientLog.logOpen(logId, path, mode, bufSize, stream.length());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Opening input stream [thread=" + Thread.currentThread().getName() + ", path=" + path + ", bufSize=" + bufSize + ']'));
            }
            GridGgfsHadoopInputStream ggfsIn = new GridGgfsHadoopInputStream(stream, stream.length(), bufSize, LOG, this.clientLog, logId);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Opened input stream [path=" + path + ", delegate=" + stream + ']'));
            }
            FSDataInputStream fSDataInputStream = new FSDataInputStream((InputStream)ggfsIn);
            return fSDataInputStream;
        }
        finally {
            this.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSDataOutputStream create(Path f, FsPermission perm, boolean overwrite, int bufSize, short replication, long blockSize, Progressable progress) throws IOException {
        FSDataOutputStream fSDataOutputStream;
        BufferedOutputStream out;
        block15: {
            GridGgfsMode mode;
            GridGgfsPath path;
            block12: {
                FSDataOutputStream os;
                block13: {
                    FSDataOutputStream fSDataOutputStream2;
                    block14: {
                        A.notNull((Object)f, (String)"f");
                        this.enterBusy();
                        out = null;
                        path = this.convert(f);
                        mode = this.mode(path);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Opening output stream in create [thread=" + Thread.currentThread().getName() + "path=" + path + ", overwrite=" + overwrite + ", bufSize=" + bufSize + ']'));
                        }
                        if (mode != GridGgfsMode.PROXY) break block12;
                        if (this.secondaryFs == null) {
                            assert (this.mgmt);
                            throw new IOException("Failed to create file (secondary file system is not initialized): " + f);
                        }
                        os = this.secondaryFs.create(this.toSecondary(f), perm, overwrite, bufSize, replication, blockSize, progress);
                        if (!this.clientLog.isLogEnabled()) break block13;
                        long logId = GridGgfsHadoopLogger.nextId();
                        this.clientLog.logCreate(logId, path, GridGgfsMode.PROXY, overwrite, bufSize, replication, blockSize);
                        fSDataOutputStream2 = new FSDataOutputStream((OutputStream)new GridGgfsHadoopProxyOutputStream(os, this.clientLog, logId));
                        if (out == null) break block14;
                        U.closeQuiet((Closeable)out);
                    }
                    this.leaveBusy();
                    return fSDataOutputStream2;
                }
                FSDataOutputStream logId = os;
                return logId;
            }
            GridGgfsHadoopStreamDelegate stream = this.rmtClient.create(path, overwrite, this.colocateFileWrites, replication, blockSize, this.permission(perm));
            assert (stream != null);
            long logId = -1L;
            if (this.clientLog.isLogEnabled()) {
                logId = GridGgfsHadoopLogger.nextId();
                this.clientLog.logCreate(logId, path, mode, overwrite, bufSize, replication, blockSize);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Opened output stream in create [path=" + path + ", delegate=" + stream + ']'));
            }
            GridGgfsHadoopOutputStream ggfsOut = new GridGgfsHadoopOutputStream(stream, LOG, this.clientLog, logId);
            bufSize = Math.max(65536, bufSize);
            out = new BufferedOutputStream(ggfsOut, bufSize);
            FSDataOutputStream res = new FSDataOutputStream((OutputStream)out, null, 0L);
            out = null;
            fSDataOutputStream = res;
            if (out == null) break block15;
            U.closeQuiet((Closeable)out);
        }
        this.leaveBusy();
        return fSDataOutputStream;
        finally {
            if (out != null) {
                U.closeQuiet(out);
            }
            this.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSDataOutputStream append(Path f, int bufSize, Progressable progress) throws IOException {
        A.notNull((Object)f, (String)"f");
        this.enterBusy();
        try {
            GridGgfsPath path = this.convert(f);
            GridGgfsMode mode = this.mode(path);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Opening output stream in append [thread=" + Thread.currentThread().getName() + ", path=" + path + ", bufSize=" + bufSize + ']'));
            }
            if (mode == GridGgfsMode.PROXY) {
                if (this.secondaryFs == null) {
                    assert (this.mgmt);
                    throw new IOException("Failed to append file (secondary file system is not initialized): " + f);
                }
                FSDataOutputStream os = this.secondaryFs.append(this.toSecondary(f), bufSize, progress);
                if (this.clientLog.isLogEnabled()) {
                    long logId = GridGgfsHadoopLogger.nextId();
                    this.clientLog.logAppend(logId, path, GridGgfsMode.PROXY, bufSize);
                    FSDataOutputStream fSDataOutputStream = new FSDataOutputStream((OutputStream)new GridGgfsHadoopProxyOutputStream(os, this.clientLog, logId));
                    return fSDataOutputStream;
                }
                FSDataOutputStream logId = os;
                return logId;
            }
            GridGgfsHadoopStreamDelegate stream = this.rmtClient.append(path, false, null);
            assert (stream != null);
            long logId = -1L;
            if (this.clientLog.isLogEnabled()) {
                logId = GridGgfsHadoopLogger.nextId();
                this.clientLog.logAppend(logId, path, mode, bufSize);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Opened output stream in append [path=" + path + ", delegate=" + stream + ']'));
            }
            GridGgfsHadoopOutputStream ggfsOut = new GridGgfsHadoopOutputStream(stream, LOG, this.clientLog, logId);
            bufSize = Math.max(65536, bufSize);
            BufferedOutputStream out = new BufferedOutputStream(ggfsOut, bufSize);
            FSDataOutputStream fSDataOutputStream = new FSDataOutputStream((OutputStream)out, null, 0L);
            return fSDataOutputStream;
        }
        finally {
            this.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rename(Path src, Path dst) throws IOException {
        A.notNull((Object)src, (String)"src");
        A.notNull((Object)dst, (String)"dst");
        this.enterBusy();
        try {
            GridGgfsPath srcPath = this.convert(src);
            GridGgfsPath dstPath = this.convert(dst);
            GridGgfsMode mode = this.mode(srcPath);
            if (mode == GridGgfsMode.PROXY) {
                if (this.secondaryFs == null) {
                    assert (this.mgmt);
                    boolean bl = false;
                    return bl;
                }
                if (this.clientLog.isLogEnabled()) {
                    this.clientLog.logRename(srcPath, GridGgfsMode.PROXY, dstPath);
                }
                boolean bl = this.secondaryFs.rename(this.toSecondary(src), this.toSecondary(dst));
                return bl;
            }
            this.rmtClient.rename(srcPath, dstPath);
            if (this.clientLog.isLogEnabled()) {
                this.clientLog.logRename(srcPath, mode, dstPath);
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            if (F.eq(IOException.class, e.getClass()) && (e.getCause() == null || !GridGgfsException.class.isAssignableFrom(e.getCause().getClass()))) {
                throw e;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.leaveBusy();
        }
    }

    public boolean delete(Path f) throws IOException {
        return this.delete(f, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(Path f, boolean recursive) throws IOException {
        A.notNull((Object)f, (String)"f");
        this.enterBusy();
        try {
            GridGgfsPath path = this.convert(f);
            GridGgfsMode mode = this.mode(path);
            if (mode == GridGgfsMode.PROXY) {
                if (this.secondaryFs == null) {
                    assert (this.mgmt);
                    boolean bl = false;
                    return bl;
                }
                if (this.clientLog.isLogEnabled()) {
                    this.clientLog.logDelete(path, GridGgfsMode.PROXY, recursive);
                }
                boolean bl = this.secondaryFs.delete(this.toSecondary(f), recursive);
                return bl;
            }
            boolean res = this.rmtClient.delete(path, recursive);
            if (this.clientLog.isLogEnabled()) {
                this.clientLog.logDelete(path, mode, recursive);
            }
            boolean bl = res;
            return bl;
        }
        catch (IOException e) {
            if (F.eq(IOException.class, e.getClass()) && (e.getCause() == null || !GridGgfsException.class.isAssignableFrom(e.getCause().getClass()))) {
                throw e;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileStatus[] listStatus(Path f) throws IOException {
        A.notNull((Object)f, (String)"f");
        this.enterBusy();
        try {
            GridGgfsPath path = this.convert(f);
            GridGgfsMode mode = this.mode(path);
            if (mode == GridGgfsMode.PROXY) {
                if (this.secondaryFs == null) {
                    assert (this.mgmt);
                    FileStatus[] fileStatusArray = EMPTY_FILE_STATUS;
                    return fileStatusArray;
                }
                FileStatus[] arr = this.secondaryFs.listStatus(this.toSecondary(f));
                if (arr != null) {
                    for (int i = 0; i < arr.length; ++i) {
                        arr[i] = this.toPrimary(arr[i]);
                    }
                }
                if (this.clientLog.isLogEnabled()) {
                    String[] fileArr = null;
                    if (arr != null) {
                        fileArr = new String[arr.length];
                        for (int i = 0; i < arr.length; ++i) {
                            fileArr[i] = arr[i].getPath().toString();
                        }
                    }
                    this.clientLog.logListDirectory(path, GridGgfsMode.PROXY, fileArr);
                }
                FileStatus[] fileArr = arr;
                return fileArr;
            }
            Collection<GridGgfsFile> list = this.rmtClient.listFiles(path);
            if (list == null) {
                FileStatus[] fileArr = null;
                return fileArr;
            }
            ArrayList<GridGgfsFile> files = new ArrayList<GridGgfsFile>(list);
            FileStatus[] arr = new FileStatus[files.size()];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = this.convert((GridGgfsFile)files.get(i));
            }
            if (this.clientLog.isLogEnabled()) {
                String[] fileArr = new String[arr.length];
                for (int i = 0; i < arr.length; ++i) {
                    fileArr[i] = arr[i].getPath().toString();
                }
                this.clientLog.logListDirectory(path, mode, fileArr);
            }
            FileStatus[] fileStatusArray = arr;
            return fileStatusArray;
        }
        catch (FileNotFoundException ignored) {
            FileStatus[] fileStatusArray = null;
            return fileStatusArray;
        }
        finally {
            this.leaveBusy();
        }
    }

    public void setWorkingDirectory(Path newPath) {
        if (newPath == null) {
            if (this.secondaryFs != null) {
                this.secondaryFs.setWorkingDirectory(this.toSecondary(this.convert(GridGgfsConfiguration.DFLT_WORKING_DIR)));
            }
            this.workingDir = GridGgfsConfiguration.DFLT_WORKING_DIR;
        } else {
            if (this.secondaryFs != null) {
                this.secondaryFs.setWorkingDirectory(this.toSecondary(newPath));
            }
            this.workingDir = this.convert(newPath);
        }
    }

    public Path getWorkingDirectory() {
        return this.convert(this.workingDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mkdirs(Path f, FsPermission perm) throws IOException {
        A.notNull((Object)f, (String)"f");
        this.enterBusy();
        try {
            GridGgfsPath path = this.convert(f);
            GridGgfsMode mode = this.mode(path);
            if (mode == GridGgfsMode.PROXY) {
                if (this.secondaryFs == null) {
                    assert (this.mgmt);
                    boolean bl = false;
                    return bl;
                }
                if (this.clientLog.isLogEnabled()) {
                    this.clientLog.logMakeDirectory(path, GridGgfsMode.PROXY);
                }
                boolean bl = this.secondaryFs.mkdirs(this.toSecondary(f), perm);
                return bl;
            }
            boolean mkdirRes = this.rmtClient.mkdirs(path, this.permission(perm));
            if (this.clientLog.isLogEnabled()) {
                this.clientLog.logMakeDirectory(path, mode);
            }
            boolean bl = mkdirRes;
            return bl;
        }
        catch (IOException e) {
            if (F.eq(IOException.class, e.getClass()) && (e.getCause() == null || !GridGgfsException.class.isAssignableFrom(e.getCause().getClass()))) {
                throw e;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileStatus getFileStatus(Path f) throws IOException {
        A.notNull((Object)f, (String)"f");
        this.enterBusy();
        try {
            if (this.mode(f) == GridGgfsMode.PROXY) {
                if (this.secondaryFs == null) {
                    assert (this.mgmt);
                    throw new IOException("Failed to get file status (secondary file system is not initialized): " + f);
                }
                FileStatus fileStatus = this.toPrimary(this.secondaryFs.getFileStatus(this.toSecondary(f)));
                return fileStatus;
            }
            GridGgfsFile info = this.rmtClient.info(this.convert(f));
            if (info == null) {
                throw new FileNotFoundException("File not found: " + f);
            }
            FileStatus fileStatus = this.convert(info);
            return fileStatus;
        }
        finally {
            this.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentSummary getContentSummary(Path f) throws IOException {
        A.notNull((Object)f, (String)"f");
        this.enterBusy();
        try {
            if (this.mode(f) == GridGgfsMode.PROXY) {
                if (this.secondaryFs == null) {
                    assert (this.mgmt);
                    throw new IOException("Failed to get content summary (secondary file system is not initialized): " + f);
                }
                ContentSummary contentSummary = this.secondaryFs.getContentSummary(this.toSecondary(f));
                return contentSummary;
            }
            GridGgfsPathSummary sum = this.rmtClient.contentSummary(this.convert(f));
            ContentSummary contentSummary = new ContentSummary(sum.totalLength(), (long)sum.filesCount(), (long)sum.directoriesCount(), -1L, sum.totalLength(), this.rmtClient.fsStatus().spaceTotal());
            return contentSummary;
        }
        finally {
            this.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockLocation[] getFileBlockLocations(FileStatus status, long start, long len) throws IOException {
        A.notNull((Object)status, (String)"status");
        GridGgfsPath path = this.convert(status.getPath());
        this.enterBusy();
        try {
            if (this.mode(status.getPath()) == GridGgfsMode.PROXY) {
                if (this.secondaryFs == null) {
                    assert (this.mgmt);
                    BlockLocation[] blockLocationArray = EMPTY_BLOCK_LOCATIONS;
                    return blockLocationArray;
                }
                Path secPath = this.toSecondary(status.getPath());
                BlockLocation[] blockLocationArray = this.secondaryFs.getFileBlockLocations(this.secondaryFs.getFileStatus(secPath), start, len);
                return blockLocationArray;
            }
            long now = System.currentTimeMillis();
            ArrayList<GridGgfsBlockLocation> affinity = new ArrayList<GridGgfsBlockLocation>(this.rmtClient.affinity(path, start, len));
            BlockLocation[] arr = new BlockLocation[affinity.size()];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = this.convert((GridGgfsBlockLocation)affinity.get(i));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Fetched file locations [path=" + path + ", fetchTime=" + (System.currentTimeMillis() - now) + ", locations=" + Arrays.asList(arr) + ']'));
            }
            BlockLocation[] blockLocationArray = arr;
            return blockLocationArray;
        }
        catch (FileNotFoundException ignored) {
            BlockLocation[] blockLocationArray = EMPTY_BLOCK_LOCATIONS;
            return blockLocationArray;
        }
        finally {
            this.leaveBusy();
        }
    }

    public long getDefaultBlockSize() {
        return this.ggfsGrpBlockSize;
    }

    public GridGgfsMode mode(Path path) {
        return this.mode(this.convert(path));
    }

    public GridGgfsMode mode(GridGgfsPath path) {
        return this.modeRslvr.resolveMode(path);
    }

    private Path toPrimary(Path path) {
        return this.convertPath(path, this.uri);
    }

    private Path toSecondary(Path path) {
        assert (this.secondaryFs != null);
        assert (this.secondaryUri != null);
        return this.convertPath(path, this.secondaryUri);
    }

    private Path convertPath(Path path, URI newUri) {
        assert (newUri != null);
        if (path != null) {
            URI pathUri = path.toUri();
            try {
                return new Path(new URI(pathUri.getScheme() != null ? newUri.getScheme() : null, pathUri.getAuthority() != null ? newUri.getAuthority() : null, pathUri.getPath(), null, null));
            }
            catch (URISyntaxException e) {
                throw new GridRuntimeException("Failed to construct secondary file system path from the primary file system path: " + path, (Throwable)e);
            }
        }
        return null;
    }

    private FileStatus toPrimary(FileStatus status) {
        return status != null ? new FileStatus(status.getLen(), status.isDir(), (int)status.getReplication(), status.getBlockSize(), status.getModificationTime(), status.getAccessTime(), status.getPermission(), status.getOwner(), status.getGroup(), this.toPrimary(status.getPath())) : null;
    }

    private Path convert(GridGgfsPath path) {
        return new Path("ggfs", this.uriAuthority, path.toString());
    }

    @Nullable
    private GridGgfsPath convert(@Nullable Path path) {
        if (path == null) {
            return null;
        }
        return path.isAbsolute() ? new GridGgfsPath(path.toUri().getPath()) : new GridGgfsPath(this.workingDir, path.toUri().getPath());
    }

    private BlockLocation convert(GridGgfsBlockLocation block) {
        Collection names = block.names();
        Collection hosts = block.hosts();
        return new BlockLocation(names.toArray(new String[names.size()]), hosts.toArray(new String[hosts.size()]), block.start(), block.length()){

            public String toString() {
                try {
                    return "BlockLocation [offset=" + this.getOffset() + ", length=" + this.getLength() + ", hosts=" + Arrays.asList(this.getHosts()) + ", names=" + Arrays.asList(this.getNames()) + ']';
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private FileStatus convert(GridGgfsFile file) {
        return new FileStatus(file.length(), file.isDirectory(), this.getDefaultReplication(), file.groupBlockSize(), file.modificationTime(), file.accessTime(), this.permission(file), file.property("usrName", GridGgfsConfiguration.DFLT_USER_NAME), file.property("grpName", "users"), this.convert(file.path())){

            public String toString() {
                return "FileStatus [path=" + this.getPath() + ", isDir=" + this.isDir() + ", len=" + this.getLen() + ", mtime=" + this.getModificationTime() + ", atime=" + this.getAccessTime() + ']';
            }
        };
    }

    private Map<String, String> permission(FsPermission perm) {
        if (perm == null) {
            perm = FsPermission.getDefault();
        }
        return F.asMap((Object)"permission", (Object)String.format("%04o", perm.toShort()));
    }

    private FsPermission permission(GridGgfsFile file) {
        String perm = file.property("permission", null);
        if (perm == null) {
            return FsPermission.getDefault();
        }
        try {
            return new FsPermission((short)Integer.parseInt(perm, 8));
        }
        catch (NumberFormatException ignore) {
            return FsPermission.getDefault();
        }
    }

    public String toString() {
        return S.toString(GridGgfsHadoopFileSystem.class, (Object)((Object)this));
    }
}

