/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.ggfs.hadoop.v2;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.AbstractFileSystem;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.InvalidPathException;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.Progressable;
import org.gridgain.grid.GridRuntimeException;
import org.gridgain.grid.ggfs.GridGgfsBlockLocation;
import org.gridgain.grid.ggfs.GridGgfsConfiguration;
import org.gridgain.grid.ggfs.GridGgfsFile;
import org.gridgain.grid.ggfs.GridGgfsMode;
import org.gridgain.grid.ggfs.GridGgfsPath;
import org.gridgain.grid.kernal.ggfs.hadoop.GridGgfsHadoopEndpoint;
import org.gridgain.grid.kernal.ggfs.hadoop.GridGgfsHadoopInputStream;
import org.gridgain.grid.kernal.ggfs.hadoop.GridGgfsHadoopLogger;
import org.gridgain.grid.kernal.ggfs.hadoop.GridGgfsHadoopOutputStream;
import org.gridgain.grid.kernal.ggfs.hadoop.GridGgfsHadoopProxyInputStream;
import org.gridgain.grid.kernal.ggfs.hadoop.GridGgfsHadoopProxyOutputStream;
import org.gridgain.grid.kernal.ggfs.hadoop.GridGgfsHadoopStreamDelegate;
import org.gridgain.grid.kernal.ggfs.hadoop.GridGgfsHadoopUtils;
import org.gridgain.grid.kernal.ggfs.hadoop.GridGgfsHadoopWrapper;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsHandshakeResponse;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsModeResolver;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsPaths;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsStatus;
import org.gridgain.grid.util.typedef.F;
import org.gridgain.grid.util.typedef.T2;
import org.gridgain.grid.util.typedef.internal.A;
import org.gridgain.grid.util.typedef.internal.S;
import org.gridgain.grid.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class GridGgfsHadoopFileSystem
extends AbstractFileSystem
implements Closeable {
    private static final Log LOG = LogFactory.getLog(GridGgfsHadoopFileSystem.class);
    private GridGgfsHadoopWrapper rmtClient;
    private GridGgfsPath workingDir = GridGgfsConfiguration.DFLT_WORKING_DIR;
    private URI uri;
    private String uriAuthority;
    private GridGgfsHadoopLogger clientLog;
    private long grpBlockSize;
    private short dfltReplication;
    private URI secondaryUri;
    private GridGgfsModeResolver modeRslvr;
    private AbstractFileSystem secondaryFs;
    private boolean seqReadsBeforePrefetchOverride;
    private int seqReadsBeforePrefetch;
    private boolean colocateFileWrites;

    public GridGgfsHadoopFileSystem(URI name, Configuration cfg) throws URISyntaxException, IOException {
        super(GridGgfsHadoopEndpoint.normalize(name), "ggfs", false, -1);
        this.uri = name;
        try {
            this.initialize(name, cfg);
        }
        catch (IOException e) {
            if (this.rmtClient != null) {
                this.rmtClient.close(false);
            }
            throw e;
        }
    }

    public void checkPath(Path path) {
        URI uri = path.toUri();
        if (uri.isAbsolute()) {
            if (!F.eq((Object)uri.getScheme(), (Object)"ggfs")) {
                throw new InvalidPathException("Wrong path scheme [expected=ggfs, actual=" + uri.getAuthority() + ']');
            }
            if (!F.eq((Object)uri.getAuthority(), (Object)this.uriAuthority)) {
                throw new InvalidPathException("Wrong path authority [expected=" + this.uriAuthority + ", actual=" + uri.getAuthority() + ']');
            }
        }
    }

    public void colocateFileWrites(boolean colocateFileWrites) {
        this.colocateFileWrites = colocateFileWrites;
    }

    private void enterBusy() throws IOException {
    }

    private void leaveBusy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(URI name, Configuration cfg) throws IOException {
        block17: {
            this.enterBusy();
            try {
                boolean initSecondary;
                if (this.rmtClient != null) {
                    throw new IOException("File system is already initialized: " + this.rmtClient);
                }
                A.notNull((Object)name, (String)"name");
                A.notNull((Object)cfg, (String)"cfg");
                if (!"ggfs".equals(name.getScheme())) {
                    throw new IOException("Illegal file system URI [expected=ggfs://[name]/[optional_path], actual=" + name + ']');
                }
                this.uriAuthority = name.getAuthority();
                this.seqReadsBeforePrefetch = GridGgfsHadoopUtils.parameter(cfg, "fs.ggfs.%s.open.sequential_reads_before_prefetch", this.uriAuthority, 0);
                if (this.seqReadsBeforePrefetch > 0) {
                    this.seqReadsBeforePrefetchOverride = true;
                }
                this.dfltReplication = (short)cfg.getInt("dfs.replication", 3);
                this.colocateFileWrites = GridGgfsHadoopUtils.parameter(cfg, "fs.ggfs.%s.colocated.writes", this.uriAuthority, false);
                String logDirCfg = GridGgfsHadoopUtils.parameter(cfg, "fs.ggfs.%s.log.dir", this.uriAuthority, "work/ggfs/log");
                File logDirFile = U.resolveGridGainPath((String)logDirCfg);
                String logDir = logDirFile != null ? logDirFile.getAbsolutePath() : null;
                this.rmtClient = new GridGgfsHadoopWrapper(this.uriAuthority, logDir, cfg, LOG);
                GridGgfsHandshakeResponse handshake = this.rmtClient.handshake(logDir);
                this.grpBlockSize = handshake.blockSize();
                GridGgfsPaths paths = handshake.secondaryPaths();
                Boolean logEnabled = GridGgfsHadoopUtils.parameter(cfg, "fs.ggfs.%s.log.enabled", this.uriAuthority, false);
                if ((handshake.sampling() != null ? handshake.sampling() : logEnabled).booleanValue()) {
                    if (logDir == null) {
                        throw new IOException("Failed to resolve log directory: " + logDirCfg);
                    }
                    Integer batchSize = GridGgfsHadoopUtils.parameter(cfg, "fs.ggfs.%s.log.batch_size", this.uriAuthority, 100);
                    this.clientLog = GridGgfsHadoopLogger.logger(this.uriAuthority, handshake.ggfsName(), logDir, batchSize);
                } else {
                    this.clientLog = GridGgfsHadoopLogger.disabledLogger();
                }
                this.modeRslvr = new GridGgfsModeResolver(paths.defaultMode(), paths.pathModes());
                boolean bl = initSecondary = paths.defaultMode() == GridGgfsMode.PROXY;
                if (paths.pathModes() != null) {
                    for (T2<GridGgfsPath, GridGgfsMode> pathMode : paths.pathModes()) {
                        GridGgfsMode mode = (GridGgfsMode)pathMode.getValue();
                        initSecondary |= mode == GridGgfsMode.PROXY;
                    }
                }
                if (!initSecondary) break block17;
                if (paths.secondaryConfigurationPath() == null) {
                    throw new IOException("Failed to connect to the secondary file system because configuration path is not provided.");
                }
                if (paths.secondaryUri() == null) {
                    throw new IOException("Failed to connect to the secondary file system because URI is not provided.");
                }
                String secondaryConfPath = paths.secondaryConfigurationPath();
                try {
                    this.secondaryUri = new URI(paths.secondaryUri());
                    URL secondaryCfgUrl = U.resolveGridGainUrl((String)secondaryConfPath);
                    if (secondaryCfgUrl == null) {
                        throw new IOException("Failed to resolve secondary file system config URL: " + secondaryConfPath);
                    }
                    Configuration conf = new Configuration();
                    conf.addResource(secondaryCfgUrl);
                    String prop = String.format("fs.%s.impl.disable.cache", this.secondaryUri.getScheme());
                    conf.setBoolean(prop, true);
                    this.secondaryFs = AbstractFileSystem.get((URI)this.secondaryUri, (Configuration)conf);
                }
                catch (URISyntaxException ignore) {
                    throw new IOException("Failed to resolve secondary file system URI: " + paths.secondaryUri());
                }
                catch (IOException e) {
                    throw new IOException("Failed to connect to the secondary file system: " + paths.secondaryUri(), e);
                }
            }
            finally {
                this.leaveBusy();
            }
        }
    }

    @Override
    public void close() throws IOException {
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close0();
    }

    private void close0() {
        if (this.rmtClient == null) {
            return;
        }
        this.rmtClient.close(false);
        if (this.clientLog.isLogEnabled()) {
            this.clientLog.close();
        }
        this.rmtClient = null;
    }

    public URI getUri() {
        return this.uri;
    }

    public int getUriDefaultPort() {
        return -1;
    }

    public FsServerDefaults getServerDefaults() throws IOException {
        return new FsServerDefaults(this.grpBlockSize, (int)this.grpBlockSize, (int)this.grpBlockSize, this.dfltReplication, 65536, false, 0L, DataChecksum.Type.NULL);
    }

    public boolean setReplication(Path f, short replication) throws IOException {
        return this.mode(f) == GridGgfsMode.PROXY && this.secondaryFs.setReplication(f, replication);
    }

    public void setTimes(Path f, long mtime, long atime) throws IOException {
        if (this.mode(f) == GridGgfsMode.PROXY) {
            this.secondaryFs.setTimes(f, mtime, atime);
        } else {
            if (mtime == -1L && atime == -1L) {
                return;
            }
            this.rmtClient.setTimes(this.convert(f), atime, mtime);
        }
    }

    public FsStatus getFsStatus() throws IOException {
        GridGgfsStatus status = this.rmtClient.fsStatus();
        return new FsStatus(status.spaceTotal(), status.spaceUsed(), status.spaceTotal() - status.spaceUsed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPermission(Path p, FsPermission perm) throws IOException {
        this.enterBusy();
        try {
            A.notNull((Object)p, (String)"p");
            if (this.mode(p) == GridGgfsMode.PROXY) {
                this.secondaryFs.setPermission(this.toSecondary(p), perm);
            } else if (this.rmtClient.update(this.convert(p), this.permission(perm)) == null) {
                throw new IOException("Failed to set file permission (file not found?) [path=" + p + ", perm=" + perm + ']');
            }
        }
        finally {
            this.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOwner(Path p, String usr, String grp) throws IOException {
        A.notNull((Object)p, (String)"p");
        A.notNull((Object)usr, (String)"username");
        A.notNull((Object)grp, (String)"grpName");
        this.enterBusy();
        try {
            if (this.mode(p) == GridGgfsMode.PROXY) {
                this.secondaryFs.setOwner(this.toSecondary(p), usr, grp);
            } else if (this.rmtClient.update(this.convert(p), F.asMap((Object)"usrName", (Object)usr, (Object)"grpName", (Object)grp)) == null) {
                throw new IOException("Failed to set file permission (file not found?) [path=" + p + ", username=" + usr + ", grpName=" + grp + ']');
            }
        }
        finally {
            this.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSDataInputStream open(Path f, int bufSize) throws IOException {
        A.notNull((Object)f, (String)"f");
        this.enterBusy();
        try {
            GridGgfsPath path = this.convert(f);
            GridGgfsMode mode = this.modeRslvr.resolveMode(path);
            if (mode == GridGgfsMode.PROXY) {
                FSDataInputStream is = this.secondaryFs.open(this.toSecondary(f), bufSize);
                if (this.clientLog.isLogEnabled()) {
                    FileStatus status = this.secondaryFs.getFileStatus(this.toSecondary(f));
                    long size = status != null ? status.getLen() : -1L;
                    long logId = GridGgfsHadoopLogger.nextId();
                    this.clientLog.logOpen(logId, path, GridGgfsMode.PROXY, bufSize, size);
                    FSDataInputStream fSDataInputStream = new FSDataInputStream((InputStream)new GridGgfsHadoopProxyInputStream(is, this.clientLog, logId));
                    return fSDataInputStream;
                }
                FSDataInputStream status = is;
                return status;
            }
            GridGgfsHadoopStreamDelegate stream = this.seqReadsBeforePrefetchOverride ? this.rmtClient.open(path, this.seqReadsBeforePrefetch) : this.rmtClient.open(path);
            long logId = -1L;
            if (this.clientLog.isLogEnabled()) {
                logId = GridGgfsHadoopLogger.nextId();
                this.clientLog.logOpen(logId, path, mode, bufSize, stream.length());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Opening input stream [thread=" + Thread.currentThread().getName() + ", path=" + path + ", bufSize=" + bufSize + ']'));
            }
            GridGgfsHadoopInputStream ggfsIn = new GridGgfsHadoopInputStream(stream, stream.length(), bufSize, LOG, this.clientLog, logId);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Opened input stream [path=" + path + ", delegate=" + stream + ']'));
            }
            FSDataInputStream fSDataInputStream = new FSDataInputStream((InputStream)ggfsIn);
            return fSDataInputStream;
        }
        finally {
            this.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FSDataOutputStream createInternal(Path f, EnumSet<CreateFlag> flag, FsPermission perm, int bufSize, short replication, long blockSize, Progressable progress, Options.ChecksumOpt checksumOpt, boolean createParent) throws IOException {
        FSDataOutputStream fSDataOutputStream;
        BufferedOutputStream out;
        block19: {
            GridGgfsHadoopStreamDelegate stream;
            GridGgfsMode mode;
            GridGgfsPath path;
            boolean create;
            boolean append;
            boolean overwrite;
            block16: {
                FSDataOutputStream os;
                block17: {
                    FSDataOutputStream fSDataOutputStream2;
                    block18: {
                        A.notNull((Object)f, (String)"f");
                        this.enterBusy();
                        overwrite = flag.contains(CreateFlag.OVERWRITE);
                        append = flag.contains(CreateFlag.APPEND);
                        create = flag.contains(CreateFlag.CREATE);
                        out = null;
                        path = this.convert(f);
                        mode = this.modeRslvr.resolveMode(path);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Opening output stream in create [thread=" + Thread.currentThread().getName() + "path=" + path + ", overwrite=" + overwrite + ", bufSize=" + bufSize + ']'));
                        }
                        if (mode != GridGgfsMode.PROXY) break block16;
                        os = this.secondaryFs.createInternal(this.toSecondary(f), flag, perm, bufSize, replication, blockSize, progress, checksumOpt, createParent);
                        if (!this.clientLog.isLogEnabled()) break block17;
                        long logId = GridGgfsHadoopLogger.nextId();
                        if (append) {
                            this.clientLog.logAppend(logId, path, GridGgfsMode.PROXY, bufSize);
                        } else {
                            this.clientLog.logCreate(logId, path, GridGgfsMode.PROXY, overwrite, bufSize, replication, blockSize);
                        }
                        fSDataOutputStream2 = new FSDataOutputStream((OutputStream)new GridGgfsHadoopProxyOutputStream(os, this.clientLog, logId));
                        if (out == null) break block18;
                        U.closeQuiet((Closeable)out);
                    }
                    this.leaveBusy();
                    return fSDataOutputStream2;
                }
                FSDataOutputStream logId = os;
                return logId;
            }
            Map<String, String> permMap = this.permission(perm);
            long logId = -1L;
            if (append) {
                stream = this.rmtClient.append(path, create, permMap);
                if (this.clientLog.isLogEnabled()) {
                    logId = GridGgfsHadoopLogger.nextId();
                    this.clientLog.logAppend(logId, path, mode, bufSize);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Opened output stream in append [path=" + path + ", delegate=" + stream + ']'));
                }
            } else {
                stream = this.rmtClient.create(path, overwrite, this.colocateFileWrites, replication, blockSize, permMap);
                if (this.clientLog.isLogEnabled()) {
                    logId = GridGgfsHadoopLogger.nextId();
                    this.clientLog.logCreate(logId, path, mode, overwrite, bufSize, replication, blockSize);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Opened output stream in create [path=" + path + ", delegate=" + stream + ']'));
                }
            }
            assert (stream != null);
            GridGgfsHadoopOutputStream ggfsOut = new GridGgfsHadoopOutputStream(stream, LOG, this.clientLog, logId);
            bufSize = Math.max(65536, bufSize);
            out = new BufferedOutputStream(ggfsOut, bufSize);
            FSDataOutputStream res = new FSDataOutputStream((OutputStream)out, null, 0L);
            out = null;
            fSDataOutputStream = res;
            if (out == null) break block19;
            U.closeQuiet((Closeable)out);
        }
        this.leaveBusy();
        return fSDataOutputStream;
        finally {
            if (out != null) {
                U.closeQuiet(out);
            }
            this.leaveBusy();
        }
    }

    public boolean supportsSymlinks() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameInternal(Path src, Path dst) throws IOException {
        A.notNull((Object)src, (String)"src");
        A.notNull((Object)dst, (String)"dst");
        this.enterBusy();
        try {
            GridGgfsPath srcPath = this.convert(src);
            GridGgfsPath dstPath = this.convert(dst);
            Set<GridGgfsMode> childrenModes = this.modeRslvr.resolveChildrenModes(srcPath);
            if (childrenModes.contains(GridGgfsMode.PROXY)) {
                if (this.clientLog.isLogEnabled()) {
                    this.clientLog.logRename(srcPath, GridGgfsMode.PROXY, dstPath);
                }
                this.secondaryFs.renameInternal(this.toSecondary(src), this.toSecondary(dst));
            }
            this.rmtClient.rename(srcPath, dstPath);
            if (this.clientLog.isLogEnabled()) {
                this.clientLog.logRename(srcPath, this.modeRslvr.resolveMode(srcPath), dstPath);
            }
        }
        finally {
            this.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(Path f, boolean recursive) throws IOException {
        A.notNull((Object)f, (String)"f");
        this.enterBusy();
        try {
            GridGgfsPath path = this.convert(f);
            GridGgfsMode mode = this.modeRslvr.resolveMode(path);
            Set<GridGgfsMode> childrenModes = this.modeRslvr.resolveChildrenModes(path);
            if (childrenModes.contains(GridGgfsMode.PROXY)) {
                if (this.clientLog.isLogEnabled()) {
                    this.clientLog.logDelete(path, GridGgfsMode.PROXY, recursive);
                }
                boolean bl = this.secondaryFs.delete(this.toSecondary(f), recursive);
                return bl;
            }
            boolean res = this.rmtClient.delete(path, recursive);
            if (this.clientLog.isLogEnabled()) {
                this.clientLog.logDelete(path, mode, recursive);
            }
            boolean bl = res;
            return bl;
        }
        finally {
            this.leaveBusy();
        }
    }

    public void setVerifyChecksum(boolean verifyChecksum) throws IOException {
        if (this.secondaryFs != null) {
            this.secondaryFs.setVerifyChecksum(verifyChecksum);
        }
    }

    public FileChecksum getFileChecksum(Path f) throws IOException {
        if (this.mode(f) == GridGgfsMode.PROXY) {
            return this.secondaryFs.getFileChecksum(f);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileStatus[] listStatus(Path f) throws IOException {
        A.notNull((Object)f, (String)"f");
        this.enterBusy();
        try {
            GridGgfsPath path = this.convert(f);
            GridGgfsMode mode = this.modeRslvr.resolveMode(path);
            if (mode == GridGgfsMode.PROXY) {
                FileStatus[] arr = this.secondaryFs.listStatus(this.toSecondary(f));
                if (arr != null) {
                    for (int i = 0; i < arr.length; ++i) {
                        arr[i] = this.toPrimary(arr[i]);
                    }
                }
                if (this.clientLog.isLogEnabled()) {
                    String[] fileArr = null;
                    if (arr != null) {
                        fileArr = new String[arr.length];
                        for (int i = 0; i < arr.length; ++i) {
                            fileArr[i] = arr[i].getPath().toString();
                        }
                    }
                    this.clientLog.logListDirectory(path, GridGgfsMode.PROXY, fileArr);
                }
                FileStatus[] fileArr = arr;
                return fileArr;
            }
            ArrayList<GridGgfsFile> files = new ArrayList<GridGgfsFile>(this.rmtClient.listFiles(path));
            FileStatus[] arr = new FileStatus[files.size()];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = this.convert((GridGgfsFile)files.get(i));
            }
            if (this.clientLog.isLogEnabled()) {
                String[] fileArr = new String[arr.length];
                for (int i = 0; i < arr.length; ++i) {
                    fileArr[i] = arr[i].getPath().toString();
                }
                this.clientLog.logListDirectory(path, mode, fileArr);
            }
            FileStatus[] fileStatusArray = arr;
            return fileStatusArray;
        }
        finally {
            this.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mkdir(Path f, FsPermission perm, boolean createParent) throws IOException {
        A.notNull((Object)f, (String)"f");
        this.enterBusy();
        try {
            GridGgfsPath path = this.convert(f);
            GridGgfsMode mode = this.modeRslvr.resolveMode(path);
            if (mode == GridGgfsMode.PROXY) {
                if (this.clientLog.isLogEnabled()) {
                    this.clientLog.logMakeDirectory(path, GridGgfsMode.PROXY);
                }
                this.secondaryFs.mkdir(this.toSecondary(f), perm, createParent);
            } else {
                this.rmtClient.mkdirs(path, this.permission(perm));
                if (this.clientLog.isLogEnabled()) {
                    this.clientLog.logMakeDirectory(path, mode);
                }
            }
        }
        finally {
            this.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileStatus getFileStatus(Path f) throws IOException {
        A.notNull((Object)f, (String)"f");
        this.enterBusy();
        try {
            if (this.mode(f) == GridGgfsMode.PROXY) {
                FileStatus fileStatus = this.toPrimary(this.secondaryFs.getFileStatus(this.toSecondary(f)));
                return fileStatus;
            }
            GridGgfsFile info = this.rmtClient.info(this.convert(f));
            if (info == null) {
                throw new FileNotFoundException("File not found: " + f);
            }
            FileStatus fileStatus = this.convert(info);
            return fileStatus;
        }
        finally {
            this.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockLocation[] getFileBlockLocations(Path path, long start, long len) throws IOException {
        A.notNull((Object)path, (String)"path");
        GridGgfsPath ggfsPath = this.convert(path);
        this.enterBusy();
        try {
            if (this.modeRslvr.resolveMode(ggfsPath) == GridGgfsMode.PROXY) {
                BlockLocation[] blockLocationArray = this.secondaryFs.getFileBlockLocations(path, start, len);
                return blockLocationArray;
            }
            long now = System.currentTimeMillis();
            ArrayList<GridGgfsBlockLocation> affinity = new ArrayList<GridGgfsBlockLocation>(this.rmtClient.affinity(ggfsPath, start, len));
            BlockLocation[] arr = new BlockLocation[affinity.size()];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = this.convert((GridGgfsBlockLocation)affinity.get(i));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Fetched file locations [path=" + path + ", fetchTime=" + (System.currentTimeMillis() - now) + ", locations=" + Arrays.asList(arr) + ']'));
            }
            BlockLocation[] blockLocationArray = arr;
            return blockLocationArray;
        }
        finally {
            this.leaveBusy();
        }
    }

    public GridGgfsMode mode(Path path) {
        return this.modeRslvr.resolveMode(this.convert(path));
    }

    private Path toPrimary(Path path) {
        return this.convertPath(path, this.getUri());
    }

    private Path toSecondary(Path path) {
        assert (this.secondaryFs != null);
        assert (this.secondaryUri != null);
        return this.convertPath(path, this.secondaryUri);
    }

    private Path convertPath(Path path, URI newUri) {
        assert (newUri != null);
        if (path != null) {
            URI pathUri = path.toUri();
            try {
                return new Path(new URI(pathUri.getScheme() != null ? newUri.getScheme() : null, pathUri.getAuthority() != null ? newUri.getAuthority() : null, pathUri.getPath(), null, null));
            }
            catch (URISyntaxException e) {
                throw new GridRuntimeException("Failed to construct secondary file system path from the primary file system path: " + path, (Throwable)e);
            }
        }
        return null;
    }

    private FileStatus toPrimary(FileStatus status) {
        return status != null ? new FileStatus(status.getLen(), status.isDirectory(), (int)status.getReplication(), status.getBlockSize(), status.getModificationTime(), status.getAccessTime(), status.getPermission(), status.getOwner(), status.getGroup(), this.toPrimary(status.getPath())) : null;
    }

    private Path convert(GridGgfsPath path) {
        return new Path("ggfs", this.uriAuthority, path.toString());
    }

    @Nullable
    private GridGgfsPath convert(Path path) {
        if (path == null) {
            return null;
        }
        return path.isAbsolute() ? new GridGgfsPath(path.toUri().getPath()) : new GridGgfsPath(this.workingDir, path.toUri().getPath());
    }

    private BlockLocation convert(GridGgfsBlockLocation block) {
        Collection names = block.names();
        Collection hosts = block.hosts();
        return new BlockLocation(names.toArray(new String[names.size()]), hosts.toArray(new String[hosts.size()]), block.start(), block.length()){

            public String toString() {
                try {
                    return "BlockLocation [offset=" + this.getOffset() + ", length=" + this.getLength() + ", hosts=" + Arrays.asList(this.getHosts()) + ", names=" + Arrays.asList(this.getNames()) + ']';
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private FileStatus convert(GridGgfsFile file) {
        return new FileStatus(file.length(), file.isDirectory(), this.dfltReplication, file.groupBlockSize(), file.modificationTime(), file.accessTime(), this.permission(file), file.property("usrName", GridGgfsConfiguration.DFLT_USER_NAME), file.property("grpName", "users"), this.convert(file.path())){

            public String toString() {
                return "FileStatus [path=" + this.getPath() + ", isDir=" + this.isDirectory() + ", len=" + this.getLen() + "]";
            }
        };
    }

    private Map<String, String> permission(FsPermission perm) {
        if (perm == null) {
            perm = FsPermission.getDefault();
        }
        return F.asMap((Object)"permission", (Object)String.format("%04o", perm.toShort()));
    }

    private FsPermission permission(GridGgfsFile file) {
        String perm = file.property("permission", null);
        if (perm == null) {
            return FsPermission.getDefault();
        }
        try {
            return new FsPermission((short)Integer.parseInt(perm, 8));
        }
        catch (NumberFormatException ignore) {
            return FsPermission.getDefault();
        }
    }

    public String toString() {
        return S.toString(GridGgfsHadoopFileSystem.class, (Object)this);
    }
}

