/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.hadoop;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.gridgain.grid.GridException;
import org.gridgain.grid.hadoop.GridHadoopJob;
import org.gridgain.grid.hadoop.GridHadoopJobId;
import org.gridgain.grid.hadoop.GridHadoopJobInfo;
import org.gridgain.grid.kernal.processors.hadoop.v2.GridHadoopV2Job;
import org.jetbrains.annotations.Nullable;

public class GridHadoopDefaultJobInfo
implements GridHadoopJobInfo,
Externalizable {
    private static final String OLD_MAP_CLASS_ATTR = "mapred.mapper.class";
    private static final String OLD_REDUCE_CLASS_ATTR = "mapred.reducer.class";
    private JobConf cfg;

    public GridHadoopDefaultJobInfo() {
    }

    public GridHadoopDefaultJobInfo(Configuration cfg) throws GridException {
        this.cfg = new JobConf(cfg);
        this.setUseNewAPI();
    }

    private void ensureNotSet(String attr, String msg) throws GridException {
        if (this.cfg.get(attr) != null) {
            throw new GridException(attr + " is incompatible with " + msg + " mode.");
        }
    }

    private void setUseNewAPI() throws GridException {
        String mode;
        int numReduces = this.cfg.getNumReduceTasks();
        this.cfg.setBooleanIfUnset("mapred.mapper.new-api", this.cfg.get(OLD_MAP_CLASS_ATTR) == null);
        if (this.cfg.getUseNewMapper()) {
            mode = "new map API";
            this.ensureNotSet("mapred.input.format.class", mode);
            this.ensureNotSet(OLD_MAP_CLASS_ATTR, mode);
            if (numReduces != 0) {
                this.ensureNotSet("mapred.partitioner.class", mode);
            } else {
                this.ensureNotSet("mapred.output.format.class", mode);
            }
        } else {
            mode = "map compatibility";
            this.ensureNotSet("mapreduce.job.inputformat.class", mode);
            this.ensureNotSet("mapreduce.job.map.class", mode);
            if (numReduces != 0) {
                this.ensureNotSet("mapreduce.job.partitioner.class", mode);
            } else {
                this.ensureNotSet("mapreduce.job.outputformat.class", mode);
            }
        }
        if (numReduces != 0) {
            this.cfg.setBooleanIfUnset("mapred.reducer.new-api", this.cfg.get(OLD_REDUCE_CLASS_ATTR) == null);
            if (this.cfg.getUseNewReducer()) {
                mode = "new reduce API";
                this.ensureNotSet("mapred.output.format.class", mode);
                this.ensureNotSet(OLD_REDUCE_CLASS_ATTR, mode);
            } else {
                mode = "reduce compatibility";
                this.ensureNotSet("mapreduce.job.outputformat.class", mode);
                this.ensureNotSet("mapreduce.job.reduce.class", mode);
            }
        }
    }

    @Nullable
    public String property(String name) {
        return this.cfg.get(name);
    }

    public GridHadoopJob createJob(GridHadoopJobId jobId) {
        return new GridHadoopV2Job(jobId, this);
    }

    public boolean hasCombiner() {
        return this.cfg.get("mapred.combiner.class") != null || this.cfg.get("mapreduce.job.combine.class") != null;
    }

    public boolean hasReducer() {
        return this.reducers() > 0;
    }

    public int reducers() {
        return this.cfg.getNumReduceTasks();
    }

    public JobConf configuration() {
        return this.cfg;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.cfg.write((DataOutput)out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.cfg = new JobConf();
        this.cfg.readFields((DataInput)in);
    }
}

