/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.hadoop;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Scanner;
import org.gridgain.grid.kernal.GridProductImpl;
import org.gridgain.grid.util.typedef.F;
import org.gridgain.grid.util.typedef.X;
import org.gridgain.grid.util.typedef.internal.U;

public class GridHadoopSetup {
    public static final String WINUTILS_EXE = "winutils.exe";

    public static void main(String[] ignore) throws IOException {
        X.println((String)"  _____     _     _______      _         ", (Object[])new Object[]{" / ___/____(_)___/ / ___/___ _(_)___     ", "/ (_ // __/ // _  / (_ // _ `/ // _ \\   ", "\\___//_/ /_/ \\_,_/\\___/ \\_,_/_//_//_/", "                for Apache Hadoop        ", "  "});
        GridHadoopSetup.println("Version " + GridProductImpl.ACK_VER);
        GridHadoopSetup.configureHadoop();
    }

    private static void configureHadoop() {
        File hadoopEtc;
        File gridgainLibs;
        File hadoopCommonLibDir;
        File hadoopCommonDir;
        String hadoopCommonHome;
        String gridgainHome = U.getGridGainHome();
        GridHadoopSetup.println("GRIDGAIN_HOME is set to '" + gridgainHome + "'.");
        GridHadoopSetup.checkGridGainHome(gridgainHome);
        String hadoopHome = System.getenv("HADOOP_HOME");
        if (hadoopHome == null || hadoopHome.isEmpty()) {
            GridHadoopSetup.exit("HADOOP_HOME environment variable is not set. Please set HADOOP_HOME to valid Hadoop installation directory and run setup tool again.", null);
        }
        hadoopHome = hadoopHome.replaceAll("\"", "");
        GridHadoopSetup.println("HADOOP_HOME is set to '" + hadoopHome + "'.");
        File hadoopDir = new File(hadoopHome);
        if (!hadoopDir.exists()) {
            GridHadoopSetup.exit("Hadoop installation folder does not exist.", null);
        }
        if (!hadoopDir.isDirectory()) {
            GridHadoopSetup.exit("HADOOP_HOME must point to a directory.", null);
        }
        if (!hadoopDir.canRead()) {
            GridHadoopSetup.exit("Hadoop installation folder can not be read. Please check permissions.", null);
        }
        if (F.isEmpty((String)(hadoopCommonHome = System.getenv("HADOOP_COMMON_HOME")))) {
            hadoopCommonDir = new File(hadoopDir, "share/hadoop/common");
            GridHadoopSetup.println("HADOOP_COMMON_HOME is not set, will use '" + hadoopCommonDir.getPath() + "'.");
        } else {
            GridHadoopSetup.println("HADOOP_COMMON_HOME is set to '" + hadoopCommonHome + "'.");
            hadoopCommonDir = new File(hadoopCommonHome);
        }
        if (!hadoopCommonDir.canRead()) {
            GridHadoopSetup.exit("Failed to read Hadoop common dir in '" + hadoopCommonHome + "'.", null);
        }
        if (!(hadoopCommonLibDir = new File(hadoopCommonDir, "lib")).canRead()) {
            GridHadoopSetup.exit("Failed to read Hadoop 'lib' folder in '" + hadoopCommonLibDir.getPath() + "'.", null);
        }
        if (U.isWindows()) {
            File winutilsFile;
            GridHadoopSetup.checkJavaPathSpaces();
            File hadoopBinDir = new File(hadoopDir, "bin");
            if (!hadoopBinDir.canRead()) {
                GridHadoopSetup.exit("Failed to read subdirectory 'bin' in HADOOP_HOME.", null);
            }
            if (!(winutilsFile = new File(hadoopBinDir, WINUTILS_EXE)).exists()) {
                if (GridHadoopSetup.ask("File 'winutils.exe' does not exist. It may be replaced by a stub. Create it?")) {
                    GridHadoopSetup.println("Creating file stub '" + winutilsFile.getAbsolutePath() + "'.");
                    boolean ok = false;
                    try {
                        ok = winutilsFile.createNewFile();
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                    if (!ok) {
                        GridHadoopSetup.exit("Failed to create 'winutils.exe' file. Please check permissions.", null);
                    }
                } else {
                    GridHadoopSetup.println("Ok. But Hadoop client probably will not work on Windows this way...");
                }
            }
            GridHadoopSetup.processCmdFiles(hadoopDir, "bin", "sbin", "libexec");
        }
        if (!(gridgainLibs = new File(new File(gridgainHome), "libs")).exists()) {
            GridHadoopSetup.exit("GridGain 'libs' folder is not found.", null);
        }
        File[] jarFiles = gridgainLibs.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        boolean jarsExist = true;
        for (File file : jarFiles) {
            File targetFile = new File(hadoopCommonLibDir, file.getName());
            if (GridHadoopSetup.linkTargetExists(targetFile) && targetFile.exists()) continue;
            jarsExist = false;
        }
        if (!jarsExist) {
            if (GridHadoopSetup.ask("GridGain JAR files are not found in Hadoop 'lib' directory. Create appropriate symbolic links?")) {
                File[] oldGridGainJarFiles = hadoopCommonLibDir.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.startsWith("gridgain-");
                    }
                });
                if (oldGridGainJarFiles.length > 0 && GridHadoopSetup.ask("The Hadoop 'lib' directory contains JARs from other GridGain installation. They must be deleted to continue. Continue?")) {
                    for (File file : oldGridGainJarFiles) {
                        GridHadoopSetup.println("Deleting file '" + file.getAbsolutePath() + "'.");
                        if (file.delete()) continue;
                        GridHadoopSetup.exit("Failed to delete file '" + file.getPath() + "'.", null);
                    }
                }
                for (File file : jarFiles) {
                    File targetFile = new File(hadoopCommonLibDir, file.getName());
                    try {
                        GridHadoopSetup.println("Creating symbolic link '" + targetFile.getAbsolutePath() + "'.");
                        Files.createSymbolicLink(targetFile.toPath(), file.toPath(), new FileAttribute[0]);
                    }
                    catch (IOException e) {
                        GridHadoopSetup.warn("Creating symbolic link failed! (Windows NTFS requires Admin rights to create symlinks.)");
                        GridHadoopSetup.println("Copying file to '" + targetFile.getAbsolutePath() + "'.");
                        try {
                            U.copy((File)file, (File)targetFile, (boolean)false);
                        }
                        catch (IOException e1) {
                            GridHadoopSetup.exit("Failed to copy file to '" + targetFile + "'. Check permissions.", e1);
                        }
                    }
                }
            } else {
                GridHadoopSetup.println("Ok. But Hadoop client will not be able to talk to GridGain cluster without those JARs in classpath...");
            }
        }
        if ((hadoopEtc = new File(hadoopDir, "etc" + File.separator + "hadoop")).canWrite()) {
            if (GridHadoopSetup.ask("Replace 'core-site.xml' and 'mapred-site.xml' files with preconfigured templates (existing files will be backed up)?")) {
                File gridgainDocs = new File(gridgainHome, "docs");
                if (!gridgainDocs.canRead()) {
                    GridHadoopSetup.exit("Failed to read GridGain 'docs' folder at '" + gridgainDocs.getAbsolutePath() + "'.", null);
                }
                GridHadoopSetup.replace(new File(gridgainDocs, "core-site.gridgain.xml"), GridHadoopSetup.renameToBak(new File(hadoopEtc, "core-site.xml")));
                GridHadoopSetup.replace(new File(gridgainDocs, "mapred-site.gridgain.xml"), GridHadoopSetup.renameToBak(new File(hadoopEtc, "mapred-site.xml")));
            } else {
                GridHadoopSetup.println("Ok. You can configure them later, the templates are available at GridGain's 'docs' directory...");
            }
        }
        GridHadoopSetup.println("Apache Hadoop setup is complete.");
    }

    private static void checkJavaPathSpaces() {
        String javaHome = System.getProperty("java.home");
        if (javaHome.contains(" ")) {
            GridHadoopSetup.warn("Java installation path contains space characters!");
            GridHadoopSetup.warn("Hadoop client will not be able to start using '" + javaHome + "'.");
            GridHadoopSetup.warn("Please install JRE to path which does not contain spaces and point JAVA_HOME to that installation.");
        }
    }

    private static void checkGridGainHome(String ggHome) {
        URL jarUrl = U.class.getProtectionDomain().getCodeSource().getLocation();
        try {
            Path jar = Paths.get(jarUrl.toURI());
            Path gg = Paths.get(ggHome, new String[0]);
            if (!jar.startsWith(gg)) {
                GridHadoopSetup.exit("GridGain JAR files are not under GRIDGAIN_HOME.", null);
            }
        }
        catch (Exception e) {
            GridHadoopSetup.exit(e.getMessage(), e);
        }
    }

    private static void replace(File from, File to) {
        if (!from.canRead()) {
            GridHadoopSetup.exit("Failed to read source file '" + from.getAbsolutePath() + "'.", null);
        }
        GridHadoopSetup.println("Replacing file '" + to.getAbsolutePath() + "'.");
        try {
            U.copy((File)from, (File)GridHadoopSetup.renameToBak(to), (boolean)true);
        }
        catch (IOException e) {
            GridHadoopSetup.exit("Failed to replace file '" + to.getAbsolutePath() + "'.", e);
        }
    }

    private static File renameToBak(File file) {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
        if (file.exists() && !file.renameTo(new File(file.getAbsolutePath() + "." + fmt.format(new Date()) + ".bak"))) {
            GridHadoopSetup.exit("Failed to rename file '" + file.getPath() + "'.", null);
        }
        return file;
    }

    private static boolean linkTargetExists(File link) {
        if (!Files.isSymbolicLink(link.toPath())) {
            return true;
        }
        Path target = null;
        try {
            target = Files.readSymbolicLink(link.toPath());
        }
        catch (IOException e) {
            GridHadoopSetup.exit("Failed to read symbolic link: " + link.getAbsolutePath(), e);
        }
        if (Files.notExists(target, new LinkOption[0])) {
            GridHadoopSetup.warn("Found link pointing to non-existing location: '" + link.getAbsolutePath() + "'.");
            return false;
        }
        return true;
    }

    private static boolean ask(String question) {
        X.println();
        X.print((String)(" <  " + question + " (Y/N): "), (Object[])new Object[0]);
        String answer = null;
        if (!F.isEmpty((String)System.getenv("GRIDGAIN_HADOOP_SETUP_YES"))) {
            answer = "Y";
        } else {
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            try {
                answer = br.readLine();
            }
            catch (IOException e) {
                GridHadoopSetup.exit("Failed to read answer: " + e.getMessage(), e);
            }
        }
        if (answer != null && "Y".equals(answer.toUpperCase().trim())) {
            X.println((String)" >  Yes.", (Object[])new Object[0]);
            return true;
        }
        X.println((String)" >  No.", (Object[])new Object[0]);
        return false;
    }

    private static void exit(String msg, Exception e) {
        X.println((String)("  # " + msg), (Object[])new Object[0]);
        X.println((String)"  # Setup failed, exiting... ", (Object[])new Object[0]);
        if (e != null && !F.isEmpty((String)System.getenv("GRIDGAIN_HADOOP_SETUP_DEBUG"))) {
            e.printStackTrace();
        }
        System.exit(1);
    }

    private static void println(String msg) {
        X.println((String)("  > " + msg), (Object[])new Object[0]);
    }

    private static void warn(String msg) {
        X.println((String)("  ! " + msg), (Object[])new Object[0]);
    }

    private static void processCmdFiles(File rootDir, String ... dirs) {
        boolean answer = false;
        for (String dir : dirs) {
            File[] cmdFiles;
            File subDir = new File(rootDir, dir);
            for (File file : cmdFiles = subDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.toLowerCase().endsWith(".cmd");
                }
            })) {
                String content = null;
                try (Scanner scanner = new Scanner(file);){
                    content = scanner.useDelimiter("\\Z").next();
                }
                catch (FileNotFoundException e) {
                    GridHadoopSetup.exit("Failed to read file '" + file + "'.", e);
                }
                boolean invalid = false;
                for (int i = 0; i < content.length(); ++i) {
                    if (content.charAt(i) != '\n' || i != 0 && content.charAt(i - 1) == '\r') continue;
                    invalid = true;
                    break;
                }
                if (!invalid) continue;
                boolean bl = answer = answer || GridHadoopSetup.ask("One or more *.CMD files has invalid new line character. Replace them?");
                if (!answer) {
                    GridHadoopSetup.println("Ok. But Windows most probably will fail to execute them...");
                    return;
                }
                GridHadoopSetup.println("Fixing newline characters in file '" + file.getAbsolutePath() + "'.");
                GridHadoopSetup.renameToBak(file);
                try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
                    for (int i = 0; i < content.length(); ++i) {
                        if (content.charAt(i) == '\n' && (i == 0 || content.charAt(i - 1) != '\r')) {
                            writer.write("\r");
                        }
                        writer.write(content.charAt(i));
                    }
                }
                catch (IOException e) {
                    GridHadoopSetup.exit("Failed to write file '" + file.getPath() + "': " + e.getMessage(), e);
                }
            }
        }
    }
}

