/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.ggfs.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import org.gridgain.grid.GridException;
import org.gridgain.grid.ggfs.GridGgfsBlockLocation;
import org.gridgain.grid.ggfs.GridGgfsCorruptedFileException;
import org.gridgain.grid.ggfs.GridGgfsException;
import org.gridgain.grid.ggfs.GridGgfsFile;
import org.gridgain.grid.ggfs.GridGgfsFileNotFoundException;
import org.gridgain.grid.ggfs.GridGgfsInvalidHdfsVersionException;
import org.gridgain.grid.ggfs.GridGgfsParentNotDirectoryException;
import org.gridgain.grid.ggfs.GridGgfsPath;
import org.gridgain.grid.ggfs.GridGgfsPathAlreadyExistsException;
import org.gridgain.grid.ggfs.GridGgfsPathSummary;
import org.gridgain.grid.kernal.ggfs.common.GridGgfsIpcCommand;
import org.gridgain.grid.kernal.ggfs.common.GridGgfsMessage;
import org.gridgain.grid.kernal.ggfs.hadoop.GridGgfsHadoopUtils;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsBlockLocationImpl;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsDirectoryNotEmptyException;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsFileImpl;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsHandshakeResponse;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsInputStreamDescriptor;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsStatus;
import org.gridgain.grid.util.tostring.GridToStringInclude;
import org.gridgain.grid.util.typedef.X;
import org.gridgain.grid.util.typedef.internal.S;
import org.gridgain.grid.util.typedef.internal.U;

public class GridGgfsControlResponse
extends GridGgfsMessage {
    private static final int ERR_GENERIC = 0;
    private static final int ERR_GGFS_GENERIC = 1;
    private static final int ERR_FILE_NOT_FOUND = 2;
    private static final int ERR_PATH_ALREADY_EXISTS = 3;
    private static final int ERR_DIRECTORY_NOT_EMPTY = 4;
    private static final int ERR_PARENT_NOT_DIRECTORY = 5;
    private static final int ERR_INVALID_HDFS_VERSION = 6;
    private static final int ERR_CORRUPTED_FILE = 7;
    public static final int RES_TYPE_BOOLEAN = 0;
    public static final int RES_TYPE_LONG = 1;
    public static final int RES_TYPE_GGFS_FILE = 2;
    public static final int RES_TYPE_GGFS_STREAM_DESCRIPTOR = 3;
    public static final int RES_TYPE_GGFS_PATH = 4;
    public static final int RES_TYPE_COL_GGFS_FILE = 5;
    public static final int RES_TYPE_COL_GGFS_PATH = 6;
    public static final int RES_TYPE_COL_GGFS_BLOCK_LOCATION = 7;
    public static final int RES_TYPE_BYTE_ARRAY = 8;
    public static final int RES_TYPE_ERR_STREAM_ID = 9;
    public static final int RES_TYPE_HANDSHAKE = 10;
    public static final int RES_TYPE_STATUS = 11;
    public static final int RES_TYPE_GGFS_PATH_SUMMARY = 12;
    public static final int RES_HEADER_SIZE = 9;
    private int resType = -1;
    @GridToStringInclude
    private Object res;
    private int len;
    private String err;
    private int errCode = -1;

    public GridGgfsControlResponse() {
        this.command(GridGgfsIpcCommand.CONTROL_RESPONSE);
    }

    public Object response() {
        return this.res;
    }

    public void response(boolean res) {
        this.resType = 0;
        this.res = res;
    }

    public void response(long res) {
        this.resType = 1;
        this.res = res;
    }

    public void response(byte[][] res) {
        this.resType = 8;
        this.res = res;
    }

    public void response(GridGgfsInputStreamDescriptor res) {
        this.resType = 3;
        this.res = res;
    }

    public void response(GridGgfsFile res) {
        this.resType = 2;
        this.res = res;
    }

    public void response(GridGgfsPath res) {
        this.resType = 4;
        this.res = res;
    }

    public void response(GridGgfsPathSummary res) {
        this.resType = 12;
        this.res = res;
    }

    public void files(Collection<GridGgfsFile> res) {
        this.resType = 5;
        this.res = res;
    }

    public void paths(Collection<GridGgfsPath> res) {
        this.resType = 6;
        this.res = res;
    }

    public void locations(Collection<GridGgfsBlockLocation> res) {
        this.resType = 7;
        this.res = res;
    }

    public void handshake(GridGgfsHandshakeResponse res) {
        this.resType = 10;
        this.res = res;
    }

    public void status(GridGgfsStatus res) {
        this.resType = 11;
        this.res = res;
    }

    public void length(int len) {
        this.len = len;
    }

    public boolean hasError() {
        return this.errCode != -1;
    }

    public static void throwError(Integer errCode, String err) throws GridException {
        assert (err != null);
        assert (errCode != -1);
        if (errCode == 2) {
            throw new GridGgfsFileNotFoundException(err);
        }
        if (errCode == 3) {
            throw new GridGgfsPathAlreadyExistsException(err);
        }
        if (errCode == 4) {
            throw new GridGgfsDirectoryNotEmptyException(err);
        }
        if (errCode == 5) {
            throw new GridGgfsParentNotDirectoryException(err);
        }
        if (errCode == 6) {
            throw new GridGgfsInvalidHdfsVersionException(err);
        }
        if (errCode == 7) {
            throw new GridGgfsCorruptedFileException(err);
        }
        if (errCode == 1) {
            throw new GridGgfsException(err);
        }
        throw new GridException(err);
    }

    public void throwError() throws GridException {
        GridGgfsControlResponse.throwError(this.errCode, this.err);
    }

    public int errorCode() {
        return this.errCode;
    }

    public void error(GridException e) {
        this.err = e.getMessage();
        this.errCode = this.errorCode(e);
    }

    public void error(long streamId, String err) {
        this.resType = 9;
        this.res = streamId;
        this.errCode = 0;
        this.err = err;
    }

    private int errorCode(GridException e) {
        return this.errorCode(e, true);
    }

    private int errorCode(GridException e, boolean checkIo) {
        if (X.hasCause((Throwable)e, (Class[])new Class[]{GridGgfsFileNotFoundException.class})) {
            return 2;
        }
        if (GridGgfsPathAlreadyExistsException.class.isInstance((Object)e)) {
            return 3;
        }
        if (GridGgfsDirectoryNotEmptyException.class.isInstance((Object)e)) {
            return 4;
        }
        if (GridGgfsParentNotDirectoryException.class.isInstance((Object)e)) {
            return 5;
        }
        if (GridGgfsInvalidHdfsVersionException.class.isInstance((Object)e)) {
            return 6;
        }
        if (X.hasCause((Throwable)e, (Class[])new Class[]{GridGgfsCorruptedFileException.class})) {
            return 7;
        }
        if (GridGgfsException.class.isInstance((Object)e)) {
            if (checkIo && e.hasCause(new Class[]{IOException.class})) {
                IOException e0 = (IOException)e.getCause(IOException.class);
                return this.errorCode((GridException)GridGgfsHadoopUtils.cast(e0), false);
            }
            return 1;
        }
        return 0;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        byte[] hdr = new byte[9];
        U.intToBytes((int)this.resType, (byte[])hdr, (int)0);
        int off = 4;
        byte by = hdr[off++] = this.err != null ? (byte)1 : 0;
        if (this.resType == 8) {
            U.intToBytes((int)this.len, (byte[])hdr, (int)off);
        }
        out.write(hdr);
        if (this.err != null) {
            out.writeUTF(this.err);
            out.writeInt(this.errCode);
            if (this.resType == 9) {
                out.writeLong((Long)this.res);
            }
            return;
        }
        switch (this.resType) {
            case 0: {
                out.writeBoolean((Boolean)this.res);
                break;
            }
            case 1: {
                out.writeLong((Long)this.res);
                break;
            }
            case 8: {
                byte[][] buf;
                for (byte[] bytes : buf = (byte[][])this.res) {
                    out.write(bytes);
                }
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: {
                out.writeBoolean(this.res != null);
                if (this.res == null) break;
                ((Externalizable)this.res).writeExternal(out);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                Collection items = (Collection)this.res;
                if (items != null) {
                    out.writeInt(items.size());
                    for (Externalizable item : items) {
                        item.writeExternal(out);
                    }
                    break;
                }
                out.writeInt(-1);
                break;
            }
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        boolean hasErr;
        byte[] hdr = new byte[9];
        in.readFully(hdr);
        this.resType = U.bytesToInt((byte[])hdr, (int)0);
        boolean bl = hasErr = hdr[4] != 0;
        if (hasErr) {
            this.err = in.readUTF();
            this.errCode = in.readInt();
            if (this.resType == 9) {
                this.res = in.readLong();
            }
            return;
        }
        switch (this.resType) {
            case 0: {
                this.res = in.readBoolean();
                break;
            }
            case 1: {
                this.res = in.readLong();
                break;
            }
            case 4: {
                boolean hasVal = in.readBoolean();
                if (!hasVal) break;
                GridGgfsPath path = new GridGgfsPath();
                path.readExternal(in);
                this.res = path;
                break;
            }
            case 12: {
                boolean hasVal = in.readBoolean();
                if (!hasVal) break;
                GridGgfsPathSummary sum = new GridGgfsPathSummary();
                sum.readExternal(in);
                this.res = sum;
                break;
            }
            case 2: {
                boolean hasVal = in.readBoolean();
                if (!hasVal) break;
                GridGgfsFileImpl file = new GridGgfsFileImpl();
                file.readExternal(in);
                this.res = file;
                break;
            }
            case 3: {
                boolean hasVal = in.readBoolean();
                if (!hasVal) break;
                GridGgfsInputStreamDescriptor desc = new GridGgfsInputStreamDescriptor();
                desc.readExternal(in);
                this.res = desc;
                break;
            }
            case 10: {
                boolean hasVal = in.readBoolean();
                if (!hasVal) break;
                GridGgfsHandshakeResponse msg = new GridGgfsHandshakeResponse();
                msg.readExternal(in);
                this.res = msg;
                break;
            }
            case 11: {
                boolean hasVal = in.readBoolean();
                if (!hasVal) break;
                GridGgfsStatus msg = new GridGgfsStatus();
                msg.readExternal(in);
                this.res = msg;
                break;
            }
            case 5: {
                ArrayList<GridGgfsFileImpl> files = null;
                int size = in.readInt();
                if (size >= 0) {
                    files = new ArrayList<GridGgfsFileImpl>(size);
                    for (int i = 0; i < size; ++i) {
                        GridGgfsFileImpl file = new GridGgfsFileImpl();
                        file.readExternal(in);
                        files.add(file);
                    }
                }
                this.res = files;
                break;
            }
            case 6: {
                ArrayList<GridGgfsPath> paths = null;
                int size = in.readInt();
                if (size >= 0) {
                    paths = new ArrayList<GridGgfsPath>(size);
                    for (int i = 0; i < size; ++i) {
                        GridGgfsPath path = new GridGgfsPath();
                        path.readExternal(in);
                        paths.add(path);
                    }
                }
                this.res = paths;
                break;
            }
            case 7: {
                ArrayList<GridGgfsBlockLocationImpl> locations = null;
                int size = in.readInt();
                if (size >= 0) {
                    locations = new ArrayList<GridGgfsBlockLocationImpl>(size);
                    for (int i = 0; i < size; ++i) {
                        GridGgfsBlockLocationImpl location = new GridGgfsBlockLocationImpl();
                        location.readExternal(in);
                        locations.add(location);
                    }
                }
                this.res = locations;
                break;
            }
            case 8: {
                assert (false) : "Response type of byte array should never be processed by marshaller.";
                break;
            }
        }
    }

    public String toString() {
        return S.toString(GridGgfsControlResponse.class, (Object)this);
    }
}

