/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.ggfs.common;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.gridgain.grid.GridException;
import org.gridgain.grid.ggfs.GridGgfsPath;
import org.gridgain.grid.kernal.ggfs.common.GridGgfsControlResponse;
import org.gridgain.grid.kernal.ggfs.common.GridGgfsHandshakeRequest;
import org.gridgain.grid.kernal.ggfs.common.GridGgfsIpcCommand;
import org.gridgain.grid.kernal.ggfs.common.GridGgfsMessage;
import org.gridgain.grid.kernal.ggfs.common.GridGgfsPathControlRequest;
import org.gridgain.grid.kernal.ggfs.common.GridGgfsStatusRequest;
import org.gridgain.grid.kernal.ggfs.common.GridGgfsStreamControlRequest;
import org.gridgain.grid.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class GridGgfsMarshaller {
    public static final int HEADER_SIZE = 24;

    public static byte[] createHeader(long reqId, GridGgfsIpcCommand cmd) {
        assert (cmd != null);
        byte[] hdr = new byte[24];
        U.longToBytes((long)reqId, (byte[])hdr, (int)0);
        U.intToBytes((int)cmd.ordinal(), (byte[])hdr, (int)8);
        return hdr;
    }

    public static byte[] fillHeader(byte[] hdr, long reqId, GridGgfsIpcCommand cmd) {
        assert (cmd != null);
        Arrays.fill(hdr, (byte)0);
        U.longToBytes((long)reqId, (byte[])hdr, (int)0);
        U.intToBytes((int)cmd.ordinal(), (byte[])hdr, (int)8);
        return hdr;
    }

    public void marshall(GridGgfsMessage msg, byte[] hdr, ObjectOutput out) throws GridException {
        assert (hdr != null);
        assert (hdr.length == 24);
        try {
            switch (msg.command()) {
                case HANDSHAKE: {
                    out.write(hdr);
                    GridGgfsHandshakeRequest req = (GridGgfsHandshakeRequest)msg;
                    U.writeString((DataOutput)out, (String)req.gridName());
                    U.writeString((DataOutput)out, (String)req.ggfsName());
                    U.writeString((DataOutput)out, (String)req.logDirectory());
                    break;
                }
                case STATUS: {
                    out.write(hdr);
                    break;
                }
                case EXISTS: 
                case INFO: 
                case PATH_SUMMARY: 
                case UPDATE: 
                case RENAME: 
                case DELETE: 
                case MAKE_DIRECTORIES: 
                case LIST_PATHS: 
                case LIST_FILES: 
                case AFFINITY: 
                case SET_TIMES: 
                case OPEN_READ: 
                case OPEN_APPEND: 
                case OPEN_CREATE: {
                    out.write(hdr);
                    GridGgfsPathControlRequest req = (GridGgfsPathControlRequest)msg;
                    this.writePath(out, req.path());
                    this.writePath(out, req.destinationPath());
                    out.writeBoolean(req.flag());
                    out.writeBoolean(req.colocate());
                    U.writeStringMap((DataOutput)out, req.properties());
                    if (msg.command() == GridGgfsIpcCommand.AFFINITY) {
                        out.writeLong(req.start());
                        out.writeLong(req.length());
                        break;
                    }
                    if (msg.command() == GridGgfsIpcCommand.OPEN_CREATE) {
                        out.writeInt(req.replication());
                        out.writeLong(req.blockSize());
                        break;
                    }
                    if (msg.command() == GridGgfsIpcCommand.SET_TIMES) {
                        out.writeLong(req.accessTime());
                        out.writeLong(req.modificationTime());
                        break;
                    }
                    if (msg.command() == GridGgfsIpcCommand.OPEN_READ && req.flag()) {
                        out.writeInt(req.sequentialReadsBeforePrefetch());
                    }
                    break;
                }
                case CLOSE: 
                case READ_BLOCK: 
                case WRITE_BLOCK: {
                    assert (msg.command() != GridGgfsIpcCommand.WRITE_BLOCK) : "WRITE_BLOCK should be marshalled manually.";
                    GridGgfsStreamControlRequest req = (GridGgfsStreamControlRequest)msg;
                    U.longToBytes((long)req.streamId(), (byte[])hdr, (int)12);
                    if (msg.command() == GridGgfsIpcCommand.READ_BLOCK) {
                        U.intToBytes((int)req.length(), (byte[])hdr, (int)20);
                    }
                    out.write(hdr);
                    if (msg.command() == GridGgfsIpcCommand.READ_BLOCK) {
                        out.writeLong(req.position());
                    }
                    break;
                }
                case CONTROL_RESPONSE: {
                    out.write(hdr);
                    GridGgfsControlResponse res = (GridGgfsControlResponse)msg;
                    res.writeExternal(out);
                    break;
                }
                default: {
                    assert (false) : "Invalid command: " + (Object)((Object)msg.command());
                    throw new IllegalArgumentException("Failed to marshal message (invalid command): " + (Object)((Object)msg.command()));
                }
            }
        }
        catch (IOException e) {
            throw new GridException("Failed to send message to GGFS data node (is data node up and running?)", (Throwable)e);
        }
    }

    public GridGgfsMessage unmarshall(GridGgfsIpcCommand cmd, byte[] hdr, ObjectInput in) throws GridException {
        assert (hdr != null);
        assert (hdr.length == 24);
        try {
            GridGgfsMessage msg;
            switch (cmd) {
                case HANDSHAKE: {
                    GridGgfsHandshakeRequest req = new GridGgfsHandshakeRequest();
                    req.gridName(U.readString((DataInput)in));
                    req.ggfsName(U.readString((DataInput)in));
                    req.logDirectory(U.readString((DataInput)in));
                    msg = req;
                    break;
                }
                case STATUS: {
                    msg = new GridGgfsStatusRequest();
                    break;
                }
                case EXISTS: 
                case INFO: 
                case PATH_SUMMARY: 
                case UPDATE: 
                case RENAME: 
                case DELETE: 
                case MAKE_DIRECTORIES: 
                case LIST_PATHS: 
                case LIST_FILES: 
                case AFFINITY: 
                case SET_TIMES: 
                case OPEN_READ: 
                case OPEN_APPEND: 
                case OPEN_CREATE: {
                    GridGgfsPathControlRequest req = new GridGgfsPathControlRequest();
                    req.path(this.readPath(in));
                    req.destinationPath(this.readPath(in));
                    req.flag(in.readBoolean());
                    req.colocate(in.readBoolean());
                    req.properties(U.readStringMap((DataInput)in));
                    if (cmd == GridGgfsIpcCommand.AFFINITY) {
                        req.start(in.readLong());
                        req.length(in.readLong());
                    } else if (cmd == GridGgfsIpcCommand.OPEN_CREATE) {
                        req.replication(in.readInt());
                        req.blockSize(in.readLong());
                    } else if (cmd == GridGgfsIpcCommand.SET_TIMES) {
                        req.accessTime(in.readLong());
                        req.modificationTime(in.readLong());
                    } else if (cmd == GridGgfsIpcCommand.OPEN_READ && req.flag()) {
                        req.sequentialReadsBeforePrefetch(in.readInt());
                    }
                    msg = req;
                    break;
                }
                case CLOSE: 
                case READ_BLOCK: 
                case WRITE_BLOCK: {
                    GridGgfsStreamControlRequest req = new GridGgfsStreamControlRequest();
                    long streamId = U.bytesToLong((byte[])hdr, (int)12);
                    req.streamId(streamId);
                    req.length(U.bytesToInt((byte[])hdr, (int)20));
                    if (cmd == GridGgfsIpcCommand.READ_BLOCK) {
                        req.position(in.readLong());
                    }
                    msg = req;
                    break;
                }
                case CONTROL_RESPONSE: {
                    GridGgfsControlResponse res = new GridGgfsControlResponse();
                    res.readExternal(in);
                    msg = res;
                    break;
                }
                default: {
                    assert (false) : "Invalid command: " + (Object)((Object)cmd);
                    throw new IllegalArgumentException("Failed to unmarshal message (invalid command): " + (Object)((Object)cmd));
                }
            }
            assert (msg != null);
            ((GridGgfsMessage)msg).command(cmd);
            return msg;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new GridException("Failed to unmarshal client message: " + (Object)((Object)cmd), (Throwable)e);
        }
    }

    private void writePath(ObjectOutput out, @Nullable GridGgfsPath path) throws IOException {
        out.writeBoolean(path != null);
        if (path != null) {
            path.writeExternal(out);
        }
    }

    @Nullable
    private GridGgfsPath readPath(ObjectInput in) throws IOException {
        if (in.readBoolean()) {
            GridGgfsPath path = new GridGgfsPath();
            path.readExternal(in);
            return path;
        }
        return null;
    }

    private void writeString(DataOutput out, @Nullable String str) throws IOException {
        out.writeBoolean(str != null);
        if (str != null) {
            out.writeUTF(str);
        }
    }

    @Nullable
    private String readString(DataInput in) throws IOException {
        boolean hasStr = in.readBoolean();
        if (hasStr) {
            return in.readUTF();
        }
        return null;
    }
}

