/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.ggfs.hadoop;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.gridgain.grid.GridException;
import org.gridgain.grid.lang.GridBiTuple;
import org.gridgain.grid.util.typedef.F;
import org.gridgain.grid.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class GridGgfsHadoopEndpoint {
    public static final String LOCALHOST = "127.0.0.1";
    private final String ggfsName;
    private final String gridName;
    private final String host;
    private final int port;

    public static URI normalize(URI uri) throws IOException {
        try {
            if (!F.eq((Object)"ggfs", (Object)uri.getScheme())) {
                throw new IOException("Failed to normalize UIR because it has non GGFS scheme: " + uri);
            }
            GridGgfsHadoopEndpoint endpoint = new GridGgfsHadoopEndpoint(uri.getAuthority());
            StringBuilder sb = new StringBuilder();
            if (endpoint.ggfs() != null) {
                sb.append(endpoint.ggfs());
            }
            if (endpoint.grid() != null) {
                sb.append(":").append(endpoint.grid());
            }
            return new URI(uri.getScheme(), sb.length() != 0 ? sb.toString() : null, endpoint.host(), endpoint.port(), uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException | GridException e) {
            throw new IOException("Failed to normalize URI: " + uri, e);
        }
    }

    public GridGgfsHadoopEndpoint(@Nullable String connStr) throws GridException {
        GridBiTuple<String, Integer> hostPort;
        String[] tokens;
        if (connStr == null) {
            connStr = "";
        }
        if ((tokens = connStr.split("@", -1)).length == 1) {
            this.ggfsName = null;
            this.gridName = null;
            hostPort = this.hostPort(connStr, connStr);
        } else if (tokens.length == 2) {
            String authStr = tokens[0];
            if (authStr.isEmpty()) {
                this.gridName = null;
                this.ggfsName = null;
            } else {
                String[] authTokens = authStr.split(":", -1);
                String string = this.ggfsName = F.isEmpty((String)authTokens[0]) ? null : authTokens[0];
                if (authTokens.length == 1) {
                    this.gridName = null;
                } else if (authTokens.length == 2) {
                    this.gridName = F.isEmpty((String)authTokens[1]) ? null : authTokens[1];
                } else {
                    throw new GridException("Invalid connection string format: " + connStr);
                }
            }
            hostPort = this.hostPort(connStr, tokens[1]);
        } else {
            throw new GridException("Invalid connection string format: " + connStr);
        }
        this.host = (String)hostPort.get1();
        assert (hostPort.get2() != null);
        this.port = (Integer)hostPort.get2();
    }

    private GridBiTuple<String, Integer> hostPort(String connStr, String hostPortStr) throws GridException {
        int port;
        String host;
        block7: {
            String[] tokens = hostPortStr.split(":", -1);
            host = tokens[0];
            if (F.isEmpty((String)host)) {
                host = LOCALHOST;
            }
            if (tokens.length == 1) {
                port = 10500;
            } else {
                if (tokens.length == 2) {
                    String portStr = tokens[1];
                    try {
                        port = Integer.valueOf(portStr);
                        if (port < 0 || port > 65535) {
                            throw new GridException("Invalid port number: " + connStr);
                        }
                        break block7;
                    }
                    catch (NumberFormatException e) {
                        throw new GridException("Invalid port number: " + connStr);
                    }
                }
                throw new GridException("Invalid connection string format: " + connStr);
            }
        }
        return F.t((Object)host, (Object)port);
    }

    @Nullable
    public String ggfs() {
        return this.ggfsName;
    }

    @Nullable
    public String grid() {
        return this.gridName;
    }

    public String host() {
        return this.host;
    }

    public boolean isLocal() {
        return F.eq((Object)LOCALHOST, (Object)this.host);
    }

    public int port() {
        return this.port;
    }

    public String toString() {
        return S.toString(GridGgfsHadoopEndpoint.class, (Object)this);
    }
}

