/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.ggfs.hadoop;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.gridgain.grid.GridException;
import org.gridgain.grid.ggfs.GridGgfsBlockLocation;
import org.gridgain.grid.ggfs.GridGgfsFile;
import org.gridgain.grid.ggfs.GridGgfsOutputStream;
import org.gridgain.grid.ggfs.GridGgfsPath;
import org.gridgain.grid.ggfs.GridGgfsPathSummary;
import org.gridgain.grid.kernal.ggfs.hadoop.GridGgfsHadoopCommunicationException;
import org.gridgain.grid.kernal.ggfs.hadoop.GridGgfsHadoopEx;
import org.gridgain.grid.kernal.ggfs.hadoop.GridGgfsHadoopStreamDelegate;
import org.gridgain.grid.kernal.ggfs.hadoop.GridGgfsHadoopStreamEventListener;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsEx;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsHandshakeResponse;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsInputStreamAdapter;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsStatus;
import org.gridgain.grid.util.lang.GridPlainFuture;
import org.gridgain.grid.util.lang.GridPlainFutureAdapter;
import org.jetbrains.annotations.Nullable;

public class GridGgfsHadoopInProc
implements GridGgfsHadoopEx {
    private final GridGgfsEx ggfs;
    private final int bufSize;
    private final Map<GridGgfsHadoopStreamDelegate, GridGgfsHadoopStreamEventListener> lsnrs = new ConcurrentHashMap<GridGgfsHadoopStreamDelegate, GridGgfsHadoopStreamEventListener>();
    private final Log log;

    public GridGgfsHadoopInProc(GridGgfsEx ggfs, Log log) {
        this.ggfs = ggfs;
        this.log = log;
        this.bufSize = ggfs.configuration().getBlockSize() * 2;
    }

    @Override
    public GridGgfsHandshakeResponse handshake(String logDir) {
        this.ggfs.clientLogDirectory(logDir);
        return new GridGgfsHandshakeResponse(this.ggfs.name(), this.ggfs.proxyPaths(), this.ggfs.groupBlockSize(), this.ggfs.globalSampling());
    }

    @Override
    public void close(boolean force) {
        for (GridGgfsHadoopStreamEventListener lsnr : this.lsnrs.values()) {
            try {
                lsnr.onClose();
            }
            catch (GridException e) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)"Failed to notify stream event listener", (Throwable)e);
            }
        }
    }

    @Override
    public GridGgfsFile info(GridGgfsPath path) throws GridException {
        try {
            return this.ggfs.info(path);
        }
        catch (IllegalStateException e) {
            throw new GridGgfsHadoopCommunicationException("Failed to get file info because Grid is stopping: " + path);
        }
    }

    @Override
    public GridGgfsFile update(GridGgfsPath path, Map<String, String> props) throws GridException {
        try {
            return this.ggfs.update(path, props);
        }
        catch (IllegalStateException e) {
            throw new GridGgfsHadoopCommunicationException("Failed to update file because Grid is stopping: " + path);
        }
    }

    @Override
    public Boolean setTimes(GridGgfsPath path, long accessTime, long modificationTime) throws GridException {
        try {
            this.ggfs.setTimes(path, accessTime, modificationTime);
            return true;
        }
        catch (IllegalStateException e) {
            throw new GridGgfsHadoopCommunicationException("Failed to set path times because Grid is stopping: " + path);
        }
    }

    @Override
    public Boolean rename(GridGgfsPath src, GridGgfsPath dest) throws GridException {
        try {
            this.ggfs.rename(src, dest);
            return true;
        }
        catch (IllegalStateException e) {
            throw new GridGgfsHadoopCommunicationException("Failed to rename path because Grid is stopping: " + src);
        }
    }

    @Override
    public Boolean delete(GridGgfsPath path, boolean recursive) throws GridException {
        try {
            return this.ggfs.delete(path, recursive);
        }
        catch (IllegalStateException e) {
            throw new GridGgfsHadoopCommunicationException("Failed to delete path because Grid is stopping: " + path);
        }
    }

    @Override
    public GridGgfsStatus fsStatus() throws GridException {
        try {
            return this.ggfs.globalSpace();
        }
        catch (IllegalStateException e) {
            throw new GridGgfsHadoopCommunicationException("Failed to get file system status because Grid is stopping.");
        }
    }

    @Override
    public Collection<GridGgfsPath> listPaths(GridGgfsPath path) throws GridException {
        try {
            return this.ggfs.listPaths(path);
        }
        catch (IllegalStateException e) {
            throw new GridGgfsHadoopCommunicationException("Failed to list paths because Grid is stopping: " + path);
        }
    }

    @Override
    public Collection<GridGgfsFile> listFiles(GridGgfsPath path) throws GridException {
        try {
            return this.ggfs.listFiles(path);
        }
        catch (IllegalStateException e) {
            throw new GridGgfsHadoopCommunicationException("Failed to list files because Grid is stopping: " + path);
        }
    }

    @Override
    public Boolean mkdirs(GridGgfsPath path, Map<String, String> props) throws GridException {
        try {
            this.ggfs.mkdirs(path, props);
            return true;
        }
        catch (IllegalStateException e) {
            throw new GridGgfsHadoopCommunicationException("Failed to create directory because Grid is stopping: " + path);
        }
    }

    @Override
    public GridGgfsPathSummary contentSummary(GridGgfsPath path) throws GridException {
        try {
            return this.ggfs.summary(path);
        }
        catch (IllegalStateException e) {
            throw new GridGgfsHadoopCommunicationException("Failed to get content summary because Grid is stopping: " + path);
        }
    }

    @Override
    public Collection<GridGgfsBlockLocation> affinity(GridGgfsPath path, long start, long len) throws GridException {
        try {
            return this.ggfs.affinity(path, start, len);
        }
        catch (IllegalStateException e) {
            throw new GridGgfsHadoopCommunicationException("Failed to get affinity because Grid is stopping: " + path);
        }
    }

    @Override
    public GridGgfsHadoopStreamDelegate open(GridGgfsPath path) throws GridException {
        try {
            GridGgfsInputStreamAdapter stream = this.ggfs.open(path, this.bufSize);
            return new GridGgfsHadoopStreamDelegate(this, (Object)stream, stream.fileInfo().length());
        }
        catch (IllegalStateException e) {
            throw new GridGgfsHadoopCommunicationException("Failed to open file because Grid is stopping: " + path);
        }
    }

    @Override
    public GridGgfsHadoopStreamDelegate open(GridGgfsPath path, int seqReadsBeforePrefetch) throws GridException {
        try {
            GridGgfsInputStreamAdapter stream = this.ggfs.open(path, this.bufSize, seqReadsBeforePrefetch);
            return new GridGgfsHadoopStreamDelegate(this, (Object)stream, stream.fileInfo().length());
        }
        catch (IllegalStateException e) {
            throw new GridGgfsHadoopCommunicationException("Failed to open file because Grid is stopping: " + path);
        }
    }

    @Override
    public GridGgfsHadoopStreamDelegate create(GridGgfsPath path, boolean overwrite, boolean colocate, int replication, long blockSize, @Nullable Map<String, String> props) throws GridException {
        try {
            GridGgfsOutputStream stream = this.ggfs.create(path, this.bufSize, overwrite, colocate ? this.ggfs.nextAffinityKey() : null, replication, blockSize, props);
            return new GridGgfsHadoopStreamDelegate(this, stream);
        }
        catch (IllegalStateException e) {
            throw new GridGgfsHadoopCommunicationException("Failed to create file because Grid is stopping: " + path);
        }
    }

    @Override
    public GridGgfsHadoopStreamDelegate append(GridGgfsPath path, boolean create, @Nullable Map<String, String> props) throws GridException {
        try {
            GridGgfsOutputStream stream = this.ggfs.append(path, this.bufSize, create, props);
            return new GridGgfsHadoopStreamDelegate(this, stream);
        }
        catch (IllegalStateException e) {
            throw new GridGgfsHadoopCommunicationException("Failed to append file because Grid is stopping: " + path);
        }
    }

    @Override
    public GridPlainFuture<byte[]> readData(GridGgfsHadoopStreamDelegate delegate, long pos, int len, @Nullable byte[] outBuf, int outOff, int outLen) {
        GridGgfsInputStreamAdapter stream = (GridGgfsInputStreamAdapter)((Object)delegate.target());
        try {
            byte[] res = null;
            if (outBuf != null) {
                int outTailLen = outBuf.length - outOff;
                if (len <= outTailLen) {
                    stream.readFully(pos, outBuf, outOff, len);
                } else {
                    stream.readFully(pos, outBuf, outOff, outTailLen);
                    int remainderLen = len - outTailLen;
                    res = new byte[remainderLen];
                    stream.readFully(pos, res, 0, remainderLen);
                }
            } else {
                res = new byte[len];
                stream.readFully(pos, res, 0, len);
            }
            return new GridPlainFutureAdapter((Object)res);
        }
        catch (IOException | IllegalStateException e) {
            GridGgfsHadoopStreamEventListener lsnr = this.lsnrs.get(delegate);
            if (lsnr != null) {
                lsnr.onError(e.getMessage());
            }
            return new GridPlainFutureAdapter((Throwable)e);
        }
    }

    @Override
    public void writeData(GridGgfsHadoopStreamDelegate delegate, byte[] data, int off, int len) throws IOException {
        try {
            GridGgfsOutputStream stream = (GridGgfsOutputStream)delegate.target();
            stream.write(data, off, len);
        }
        catch (IOException | IllegalStateException e) {
            GridGgfsHadoopStreamEventListener lsnr = this.lsnrs.get(delegate);
            if (lsnr != null) {
                lsnr.onError(e.getMessage());
            }
            if (e instanceof IllegalStateException) {
                throw new IOException("Failed to write data to GGFS stream because Grid is stopping.", e);
            }
            throw e;
        }
    }

    @Override
    public void flush(GridGgfsHadoopStreamDelegate delegate) throws IOException {
        try {
            GridGgfsOutputStream stream = (GridGgfsOutputStream)delegate.target();
            stream.flush();
        }
        catch (IOException | IllegalStateException e) {
            GridGgfsHadoopStreamEventListener lsnr = this.lsnrs.get(delegate);
            if (lsnr != null) {
                lsnr.onError(e.getMessage());
            }
            if (e instanceof IllegalStateException) {
                throw new IOException("Failed to flush data to GGFS stream because Grid is stopping.", e);
            }
            throw e;
        }
    }

    @Override
    public void closeStream(GridGgfsHadoopStreamDelegate desc) throws IOException {
        Closeable closeable = (Closeable)desc.target();
        try {
            closeable.close();
        }
        catch (IllegalStateException e) {
            throw new IOException("Failed to close GGFS stream because Grid is stopping.", e);
        }
    }

    @Override
    public void addEventListener(GridGgfsHadoopStreamDelegate delegate, GridGgfsHadoopStreamEventListener lsnr) {
        GridGgfsHadoopStreamEventListener lsnr0 = this.lsnrs.put(delegate, lsnr);
        assert (lsnr0 == null || lsnr0 == lsnr);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Added stream event listener [delegate=" + delegate + ']'));
        }
    }

    @Override
    public void removeEventListener(GridGgfsHadoopStreamDelegate delegate) {
        GridGgfsHadoopStreamEventListener lsnr0 = this.lsnrs.remove(delegate);
        if (lsnr0 != null && this.log.isDebugEnabled()) {
            this.log.debug((Object)("Removed stream event listener [delegate=" + delegate + ']'));
        }
    }
}

