/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.ggfs.hadoop;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.hadoop.fs.PositionedReadable;
import org.apache.hadoop.fs.Seekable;
import org.gridgain.grid.GridException;
import org.gridgain.grid.kernal.ggfs.hadoop.GridGgfsHadoopLogger;
import org.gridgain.grid.kernal.ggfs.hadoop.GridGgfsHadoopStreamDelegate;
import org.gridgain.grid.kernal.ggfs.hadoop.GridGgfsHadoopStreamEventListener;
import org.gridgain.grid.kernal.ggfs.hadoop.GridGgfsHadoopUtils;
import org.gridgain.grid.util.lang.GridPlainFuture;
import org.gridgain.grid.util.typedef.internal.A;
import org.gridgain.grid.util.typedef.internal.U;
import org.jetbrains.annotations.NotNull;

public final class GridGgfsHadoopInputStream
extends InputStream
implements Seekable,
PositionedReadable,
GridGgfsHadoopStreamEventListener {
    private static final int MIN_BUF_SIZE = 4096;
    private GridGgfsHadoopStreamDelegate delegate;
    private long logStreamId;
    private long pos;
    private long limit;
    private long markPos = -1L;
    private DoubleFetchBuffer buf = new DoubleFetchBuffer();
    private int bufHalfSize;
    private volatile boolean closed;
    private boolean connBroken;
    private Log log;
    private GridGgfsHadoopLogger clientLog;
    private long readTime;
    private long userTime;
    private long lastTs;
    private long total;

    public GridGgfsHadoopInputStream(GridGgfsHadoopStreamDelegate delegate, long limit, int bufSize, Log log, GridGgfsHadoopLogger clientLog, long logStreamId) {
        assert (limit >= 0L);
        this.delegate = delegate;
        this.limit = limit;
        this.log = log;
        this.clientLog = clientLog;
        this.logStreamId = logStreamId;
        this.bufHalfSize = Math.max(bufSize, 4096);
        this.lastTs = System.nanoTime();
        delegate.hadoop().addEventListener(delegate, this);
    }

    private void readStart() {
        long now = System.nanoTime();
        this.userTime += now - this.lastTs;
        this.lastTs = now;
    }

    private void readEnd() {
        long now = System.nanoTime();
        this.readTime += now - this.lastTs;
        this.lastTs = now;
    }

    @Override
    public synchronized int read() throws IOException {
        this.checkClosed();
        this.readStart();
        try {
            if (this.eof()) {
                int n = -1;
                return n;
            }
            this.buf.refreshAhead(this.pos);
            int res = this.buf.atPosition(this.pos);
            ++this.pos;
            ++this.total;
            this.buf.refreshAhead(this.pos);
            int n = res;
            return n;
        }
        catch (GridException e) {
            throw GridGgfsHadoopUtils.cast(e);
        }
        finally {
            this.readEnd();
        }
    }

    @Override
    public synchronized int read(@NotNull byte[] b, int off, int len) throws IOException {
        this.checkClosed();
        if (this.eof()) {
            return -1;
        }
        this.readStart();
        try {
            long remaining = this.limit - this.pos;
            int read = this.buf.flatten(b, this.pos, off, len);
            this.pos += (long)read;
            this.total += (long)read;
            if ((remaining -= (long)read) > 0L && read != len) {
                int readAmt = (int)Math.min(remaining, (long)(len - read));
                this.delegate.hadoop().readData(this.delegate, this.pos, readAmt, b, off + read, len - read).get();
                read += readAmt;
                this.pos += (long)readAmt;
                this.total += (long)readAmt;
            }
            this.buf.refreshAhead(this.pos);
            int n = read;
            return n;
        }
        catch (GridException e) {
            throw GridGgfsHadoopUtils.cast(e);
        }
        finally {
            this.readEnd();
        }
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        this.checkClosed();
        if (this.clientLog.isLogEnabled()) {
            this.clientLog.logSkip(this.logStreamId, n);
        }
        long oldPos = this.pos;
        this.pos = this.pos + n <= this.limit ? (this.pos += n) : this.limit;
        this.buf.refreshAhead(this.pos);
        return this.pos - oldPos;
    }

    @Override
    public synchronized int available() throws IOException {
        this.checkClosed();
        int available = this.buf.available(this.pos);
        assert (available >= 0);
        return available;
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.closed) {
            this.readStart();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Closing input stream: " + this.delegate));
            }
            this.delegate.hadoop().closeStream(this.delegate);
            this.readEnd();
            if (this.clientLog.isLogEnabled()) {
                this.clientLog.logCloseIn(this.logStreamId, this.userTime, this.readTime, this.total);
            }
            this.markClosed(false);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Closed stream [delegate=" + this.delegate + ", readTime=" + this.readTime + ", userTime=" + this.userTime + ']'));
            }
        }
    }

    @Override
    public synchronized void mark(int readLimit) {
        this.markPos = this.pos;
        if (this.clientLog.isLogEnabled()) {
            this.clientLog.logMark(this.logStreamId, readLimit);
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        this.checkClosed();
        if (this.clientLog.isLogEnabled()) {
            this.clientLog.logReset(this.logStreamId);
        }
        if (this.markPos == -1L) {
            throw new IOException("Stream was not marked.");
        }
        this.pos = this.markPos;
        this.buf.refreshAhead(this.pos);
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    public synchronized int read(long position, byte[] buf, int off, int len) throws IOException {
        long remaining = this.limit - position;
        int read = (int)Math.min((long)len, remaining);
        if (read == 0) {
            return -1;
        }
        this.readFully(position, buf, off, read);
        return read;
    }

    public synchronized void readFully(long position, byte[] buf, int off, int len) throws IOException {
        long remaining = this.limit - position;
        this.checkClosed();
        if ((long)len > remaining) {
            throw new EOFException("End of stream reached before data was fully read.");
        }
        this.readStart();
        try {
            int read = this.buf.flatten(buf, position, off, len);
            this.total += (long)read;
            if (read != len) {
                int readAmt = len - read;
                this.delegate.hadoop().readData(this.delegate, position + (long)read, readAmt, buf, off + read, readAmt).get();
                this.total += (long)readAmt;
            }
            if (this.clientLog.isLogEnabled()) {
                this.clientLog.logRandomRead(this.logStreamId, position, len);
            }
        }
        catch (GridException e) {
            throw GridGgfsHadoopUtils.cast(e);
        }
        finally {
            this.readEnd();
        }
    }

    public void readFully(long position, byte[] buf) throws IOException {
        this.readFully(position, buf, 0, buf.length);
    }

    public synchronized void seek(long pos) throws IOException {
        A.ensure((pos >= 0L ? 1 : 0) != 0, (String)"position must be non-negative");
        this.checkClosed();
        if (this.clientLog.isLogEnabled()) {
            this.clientLog.logSeek(this.logStreamId, pos);
        }
        if (pos > this.limit) {
            pos = this.limit;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Seek to position [delegate=" + this.delegate + ", pos=" + pos + ", oldPos=" + this.pos + ']'));
        }
        this.pos = pos;
        this.buf.refreshAhead(pos);
    }

    public synchronized long getPos() {
        return this.pos;
    }

    public synchronized boolean seekToNewSource(long targetPos) {
        return false;
    }

    @Override
    public void onClose() {
        this.markClosed(true);
    }

    @Override
    public void onError(String errMsg) {
    }

    private void markClosed(boolean connBroken) {
        if (!this.closed) {
            this.closed = true;
            this.connBroken = connBroken;
            this.delegate.hadoop().removeEventListener(this.delegate);
        }
    }

    private void checkClosed() throws IOException {
        if (this.closed) {
            if (this.connBroken) {
                throw new IOException("Server connection was lost.");
            }
            throw new IOException("Stream is closed.");
        }
    }

    private boolean eof() {
        return this.limit == this.pos;
    }

    private class DoubleFetchBuffer {
        private FetchBufferPart first;
        private FetchBufferPart second;

        private DoubleFetchBuffer() {
        }

        public int flatten(byte[] dst, long pos, int dstOff, int len) throws GridException {
            assert (dstOff >= 0);
            assert (dstOff + len <= dst.length) : "Invalid indices [dst.length=" + dst.length + ", dstOff=" + dstOff + ", len=" + len + ']';
            int bytesCopied = 0;
            if (this.first != null && (bytesCopied += this.first.flatten(dst, pos, dstOff, len)) != len && this.second != null) {
                assert (this.second.pos == this.first.pos + (long)this.first.len);
                bytesCopied += this.second.flatten(dst, pos + (long)bytesCopied, dstOff + bytesCopied, len - bytesCopied);
            }
            return bytesCopied;
        }

        public int atPosition(long pos) throws GridException {
            assert (this.first != null);
            if (this.first.contains(pos)) {
                byte[] bytes = (byte[])this.first.readFut.get();
                return bytes[(int)(pos - this.first.pos)] & 0xFF;
            }
            assert (this.second != null);
            assert (this.second.contains(pos));
            byte[] bytes = (byte[])this.second.readFut.get();
            return bytes[(int)(pos - this.second.pos)] & 0xFF;
        }

        public void refreshAhead(long pos) {
            if (this.fullPrefetch(pos)) {
                this.first = this.fetch(pos, GridGgfsHadoopInputStream.this.bufHalfSize);
                this.second = this.fetch(pos + (long)GridGgfsHadoopInputStream.this.bufHalfSize, GridGgfsHadoopInputStream.this.bufHalfSize);
            } else if (this.needFlip(pos)) {
                this.first = this.second;
                this.second = this.fetch(this.first.pos + (long)this.first.len, GridGgfsHadoopInputStream.this.bufHalfSize);
            }
        }

        public int available(long pos) {
            int available = 0;
            if (this.first != null) {
                if (this.first.contains(pos)) {
                    if (this.first.ready()) {
                        available = (int)((long)available + (pos - this.first.pos));
                        if (this.second != null && this.second.ready()) {
                            available += this.second.len;
                        }
                    }
                } else if (this.second != null && this.second.contains(pos) && this.second.ready()) {
                    available = (int)((long)available + (pos - this.second.pos));
                }
            }
            return available;
        }

        private boolean needFlip(long pos) {
            return this.second != null && this.second.contains(pos);
        }

        private boolean fullPrefetch(long curPos) {
            return this.first == null || curPos < this.first.pos || this.second != null && curPos >= this.second.pos + (long)this.second.len;
        }

        private FetchBufferPart fetch(long pos, int size) {
            long remaining = GridGgfsHadoopInputStream.this.limit - pos;
            return (size = (int)Math.min((long)size, remaining)) <= 0 ? null : new FetchBufferPart(GridGgfsHadoopInputStream.this.delegate.hadoop().readData(GridGgfsHadoopInputStream.this.delegate, pos, size, null, 0, 0), pos, size);
        }
    }

    private static class FetchBufferPart {
        private GridPlainFuture<byte[]> readFut;
        private long pos;
        private int len;

        private FetchBufferPart(GridPlainFuture<byte[]> readFut, long pos, int len) {
            this.readFut = readFut;
            this.pos = pos;
            this.len = len;
        }

        public int flatten(byte[] dst, long pos, int dstOff, int len) throws GridException {
            if (this.contains(pos)) {
                byte[] data = (byte[])this.readFut.get();
                int srcPos = (int)(pos - this.pos);
                int cpLen = Math.min(len, data.length - srcPos);
                U.arrayCopy((byte[])data, (int)srcPos, (byte[])dst, (int)dstOff, (int)cpLen);
                return cpLen;
            }
            return 0;
        }

        public boolean ready() {
            return this.readFut.isDone();
        }

        public boolean contains(long pos) {
            return this.pos <= pos && this.pos + (long)this.len > pos;
        }
    }
}

