/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.ggfs.hadoop;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.gridgain.grid.GridException;
import org.gridgain.grid.GridInterruptedException;
import org.gridgain.grid.kernal.GridLoggerProxy;
import org.gridgain.grid.kernal.ggfs.common.GridGgfsDataOutputStream;
import org.gridgain.grid.kernal.ggfs.common.GridGgfsIpcCommand;
import org.gridgain.grid.kernal.ggfs.common.GridGgfsMarshaller;
import org.gridgain.grid.kernal.ggfs.common.GridGgfsMessage;
import org.gridgain.grid.kernal.ggfs.common.GridGgfsStreamControlRequest;
import org.gridgain.grid.kernal.ggfs.hadoop.GridGgfsHadoopCommunicationException;
import org.gridgain.grid.kernal.ggfs.hadoop.GridGgfsHadoopFuture;
import org.gridgain.grid.kernal.ggfs.hadoop.GridGgfsHadoopIo;
import org.gridgain.grid.kernal.ggfs.hadoop.GridGgfsHadoopIpcIoListener;
import org.gridgain.grid.kernal.ggfs.hadoop.GridGgfsHadoopJclLogger;
import org.gridgain.grid.logger.GridLogger;
import org.gridgain.grid.util.GridConcurrentHashSet;
import org.gridgain.grid.util.GridStripedLock;
import org.gridgain.grid.util.ipc.GridIpcEndpoint;
import org.gridgain.grid.util.ipc.GridIpcEndpointFactory;
import org.gridgain.grid.util.ipc.shmem.GridIpcOutOfSystemResourcesException;
import org.gridgain.grid.util.lang.GridPlainFuture;
import org.gridgain.grid.util.typedef.internal.U;
import org.jdk8.backport.ConcurrentHashMap8;
import org.jetbrains.annotations.Nullable;

public class GridGgfsHadoopIpcIo
implements GridGgfsHadoopIo {
    private Log log;
    private ConcurrentMap<Long, GridGgfsHadoopFuture> reqMap = new ConcurrentHashMap8();
    private AtomicLong reqIdCnt = new AtomicLong();
    private GridIpcEndpoint endpoint;
    private GridGgfsDataOutputStream out;
    private final GridGgfsMarshaller marsh;
    private Thread reader;
    private final ReadWriteLock busyLock = new ReentrantReadWriteLock();
    private volatile boolean stopping;
    private final String endpointAddr;
    private final AtomicInteger activeCnt = new AtomicInteger(1);
    private final Collection<GridGgfsHadoopIpcIoListener> lsnrs = new GridConcurrentHashSet();
    private static final ConcurrentMap<String, GridGgfsHadoopIpcIo> ipcCache = new ConcurrentHashMap8();
    private static final GridStripedLock initLock = new GridStripedLock(32);

    public GridGgfsHadoopIpcIo(String endpointAddr, GridGgfsMarshaller marsh, Log log) {
        assert (endpointAddr != null);
        assert (marsh != null);
        this.endpointAddr = endpointAddr;
        this.marsh = marsh;
        this.log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GridGgfsHadoopIpcIo get(Log log, String endpoint) throws IOException {
        GridGgfsHadoopIpcIo clientIo;
        while ((clientIo = (GridGgfsHadoopIpcIo)ipcCache.get(endpoint)) != null) {
            if (clientIo.acquire()) {
                return clientIo;
            }
            ipcCache.remove(endpoint, clientIo);
        }
        Lock lock = initLock.getLock((Object)endpoint);
        lock.lock();
        try {
            clientIo = (GridGgfsHadoopIpcIo)ipcCache.get(endpoint);
            if (clientIo != null) {
                if (clientIo.acquire()) {
                    GridGgfsHadoopIpcIo gridGgfsHadoopIpcIo = clientIo;
                    return gridGgfsHadoopIpcIo;
                }
                ipcCache.remove(endpoint, clientIo);
            }
            clientIo = new GridGgfsHadoopIpcIo(endpoint, new GridGgfsMarshaller(), log);
            try {
                clientIo.start();
            }
            catch (GridException e) {
                throw new IOException(e.getMessage(), e);
            }
            GridGgfsHadoopIpcIo old = ipcCache.putIfAbsent(endpoint, clientIo);
            assert (old == null);
            GridGgfsHadoopIpcIo gridGgfsHadoopIpcIo = clientIo;
            return gridGgfsHadoopIpcIo;
        }
        finally {
            lock.unlock();
        }
    }

    private boolean acquire() {
        int cnt;
        do {
            if ((cnt = this.activeCnt.get()) != 0) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("IPC IO not acquired (count was 0): " + this));
            }
            return false;
        } while (!this.activeCnt.compareAndSet(cnt, cnt + 1));
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("IPC IO acquired: " + this));
        }
        return true;
    }

    public void release() {
        int cnt;
        do {
            if ((cnt = this.activeCnt.get()) != 0) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("IPC IO not released (count was 0): " + this));
            }
            return;
        } while (!this.activeCnt.compareAndSet(cnt, cnt - 1));
        if (cnt == 1) {
            ipcCache.remove(this.endpointAddr, this);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("IPC IO stopping as unused: " + this));
            }
            this.stop();
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("IPC IO released: " + this));
        }
    }

    public void forceClose() {
        if (ipcCache.remove(this.endpointAddr, this)) {
            this.stop();
        }
    }

    private void start() throws GridException {
        boolean success = false;
        try {
            this.endpoint = GridIpcEndpointFactory.connectEndpoint((String)this.endpointAddr, (GridLogger)new GridLoggerProxy((GridLogger)new GridGgfsHadoopJclLogger(this.log), null, null, ""));
            this.out = new GridGgfsDataOutputStream(new BufferedOutputStream(this.endpoint.outputStream()));
            this.reader = new ReaderThread();
            this.reader.setDaemon(true);
            this.reader.start();
            success = true;
        }
        catch (GridException e) {
            GridIpcOutOfSystemResourcesException resEx = (GridIpcOutOfSystemResourcesException)e.getCause(GridIpcOutOfSystemResourcesException.class);
            if (resEx != null) {
                throw new GridException("Failed to allocate shared memory segment (for troubleshooting see http://bit.ly/GridGain-Troubleshooting)", (Throwable)resEx);
            }
            throw e;
        }
        finally {
            if (!success) {
                this.stop();
            }
        }
    }

    private void stop() {
        this.close0(null);
        if (this.reader != null) {
            try {
                U.interrupt((Thread)this.reader);
                U.join((Thread)this.reader);
                this.reader = null;
            }
            catch (GridInterruptedException ignored) {
                Thread.currentThread().interrupt();
                this.log.warn((Object)"Got interrupted while waiting for reader thread to shut down (will return).");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEventListener(GridGgfsHadoopIpcIoListener lsnr) {
        if (!this.busyLock.readLock().tryLock()) {
            lsnr.onClose();
            return;
        }
        boolean invokeNow = false;
        try {
            invokeNow = this.stopping;
            if (!invokeNow) {
                this.lsnrs.add(lsnr);
            }
        }
        finally {
            this.busyLock.readLock().unlock();
            if (invokeNow) {
                lsnr.onClose();
            }
        }
    }

    @Override
    public void removeEventListener(GridGgfsHadoopIpcIoListener lsnr) {
        this.lsnrs.remove(lsnr);
    }

    @Override
    public GridPlainFuture<GridGgfsMessage> send(GridGgfsMessage msg) throws GridException {
        return this.send(msg, null, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> GridPlainFuture<T> send(GridGgfsMessage msg, @Nullable byte[] outBuf, int outOff, int outLen) throws GridException {
        assert (outBuf == null || msg.command() == GridGgfsIpcCommand.READ_BLOCK);
        if (!this.busyLock.readLock().tryLock()) {
            throw new GridGgfsHadoopCommunicationException("Failed to send message (client is being concurrently closed).");
        }
        try {
            Object object;
            if (this.stopping) {
                throw new GridGgfsHadoopCommunicationException("Failed to send message (client is being concurrently closed).");
            }
            long reqId = this.reqIdCnt.getAndIncrement();
            GridGgfsHadoopFuture fut = new GridGgfsHadoopFuture();
            fut.outputBuffer(outBuf);
            fut.outputOffset(outOff);
            fut.outputLength(outLen);
            fut.read(msg.command() == GridGgfsIpcCommand.READ_BLOCK);
            GridGgfsHadoopFuture oldFut = this.reqMap.putIfAbsent(reqId, fut);
            assert (oldFut == null);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Sending GGFS message [reqId=" + reqId + ", msg=" + msg + ']'));
            }
            byte[] hdr = GridGgfsMarshaller.createHeader(reqId, msg.command());
            GridException err = null;
            try {
                object = this;
                synchronized (object) {
                    this.marsh.marshall(msg, hdr, this.out);
                    this.out.flush();
                }
            }
            catch (GridException e) {
                err = e;
            }
            catch (IOException e) {
                err = new GridGgfsHadoopCommunicationException(e);
            }
            if (err != null) {
                this.reqMap.remove(reqId, (Object)fut);
                fut.onDone(err);
            }
            object = fut;
            return object;
        }
        finally {
            this.busyLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendPlain(GridGgfsMessage msg) throws GridException {
        if (!this.busyLock.readLock().tryLock()) {
            throw new GridGgfsHadoopCommunicationException("Failed to send message (client is being concurrently closed).");
        }
        try {
            if (this.stopping) {
                throw new GridGgfsHadoopCommunicationException("Failed to send message (client is being concurrently closed).");
            }
            assert (msg.command() == GridGgfsIpcCommand.WRITE_BLOCK);
            GridGgfsStreamControlRequest req = (GridGgfsStreamControlRequest)msg;
            byte[] hdr = GridGgfsMarshaller.createHeader(-1L, GridGgfsIpcCommand.WRITE_BLOCK);
            U.longToBytes((long)req.streamId(), (byte[])hdr, (int)12);
            U.intToBytes((int)req.length(), (byte[])hdr, (int)20);
            GridGgfsHadoopIpcIo gridGgfsHadoopIpcIo = this;
            synchronized (gridGgfsHadoopIpcIo) {
                this.out.write(hdr);
                this.out.write(req.data(), (int)req.position(), req.length());
                this.out.flush();
            }
        }
        catch (IOException e) {
            throw new GridGgfsHadoopCommunicationException(e);
        }
        finally {
            this.busyLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close0(@Nullable Throwable err) {
        this.busyLock.writeLock().lock();
        try {
            if (this.stopping) {
                return;
            }
            this.stopping = true;
        }
        finally {
            this.busyLock.writeLock().unlock();
        }
        if (err == null) {
            err = new GridException("Failed to perform request (connection was concurrently closed before response is received).");
        }
        U.closeQuiet((Closeable)this.out);
        if (this.endpoint != null) {
            this.endpoint.close();
        }
        Iterator it = this.reqMap.values().iterator();
        while (it.hasNext()) {
            GridGgfsHadoopFuture fut = (GridGgfsHadoopFuture)((Object)it.next());
            fut.onDone(err);
            it.remove();
        }
        for (GridGgfsHadoopIpcIoListener lsnr : this.lsnrs) {
            lsnr.onClose();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [endpointAddr=" + this.endpointAddr + ", activeCnt=" + this.activeCnt + ", stopping=" + this.stopping + ']';
    }

    static /* synthetic */ GridIpcEndpoint access$100(GridGgfsHadoopIpcIo x0) {
        return x0.endpoint;
    }

    static /* synthetic */ Collection access$200(GridGgfsHadoopIpcIo x0) {
        return x0.lsnrs;
    }

    static /* synthetic */ ConcurrentMap access$300(GridGgfsHadoopIpcIo x0) {
        return x0.reqMap;
    }

    static /* synthetic */ Log access$400(GridGgfsHadoopIpcIo x0) {
        return x0.log;
    }

    static /* synthetic */ GridGgfsMarshaller access$500(GridGgfsHadoopIpcIo x0) {
        return x0.marsh;
    }

    static /* synthetic */ boolean access$600(GridGgfsHadoopIpcIo x0) {
        return x0.stopping;
    }

    static /* synthetic */ void access$700(GridGgfsHadoopIpcIo x0, Throwable x1) {
        x0.close0(x1);
    }

    private class ReaderThread
    extends Thread {
        private ReaderThread() {
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

