/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.ggfs.hadoop;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.gridgain.grid.GridException;
import org.gridgain.grid.kernal.ggfs.hadoop.GridGgfsHadoopLogger;
import org.gridgain.grid.kernal.ggfs.hadoop.GridGgfsHadoopStreamDelegate;
import org.gridgain.grid.kernal.ggfs.hadoop.GridGgfsHadoopStreamEventListener;
import org.jetbrains.annotations.NotNull;

public class GridGgfsHadoopOutputStream
extends OutputStream
implements GridGgfsHadoopStreamEventListener {
    private Log log;
    private GridGgfsHadoopLogger clientLog;
    private long logStreamId;
    private GridGgfsHadoopStreamDelegate delegate;
    private volatile boolean closed;
    private boolean connBroken;
    private volatile String errMsg;
    private long writeTime;
    private long userTime;
    private long lastTs;
    private long total;

    public GridGgfsHadoopOutputStream(GridGgfsHadoopStreamDelegate delegate, Log log, GridGgfsHadoopLogger clientLog, long logStreamId) {
        this.delegate = delegate;
        this.log = log;
        this.clientLog = clientLog;
        this.logStreamId = logStreamId;
        this.lastTs = System.nanoTime();
        delegate.hadoop().addEventListener(delegate, this);
    }

    private void writeStart() {
        long now = System.nanoTime();
        this.userTime += now - this.lastTs;
        this.lastTs = now;
    }

    private void writeEnd() {
        long now = System.nanoTime();
        this.writeTime += now - this.lastTs;
        this.lastTs = now;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(@NotNull byte[] b, int off, int len) throws IOException {
        this.check();
        this.writeStart();
        try {
            this.delegate.hadoop().writeData(this.delegate, b, off, len);
            this.total += (long)len;
        }
        finally {
            this.writeEnd();
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b});
        ++this.total;
    }

    @Override
    public void flush() throws IOException {
        this.delegate.hadoop().flush(this.delegate);
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Closing output stream: " + this.delegate));
            }
            this.writeStart();
            this.delegate.hadoop().closeStream(this.delegate);
            this.markClosed(false);
            this.writeEnd();
            if (this.clientLog.isLogEnabled()) {
                this.clientLog.logCloseOut(this.logStreamId, this.userTime, this.writeTime, this.total);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Closed output stream [delegate=" + this.delegate + ", writeTime=" + this.writeTime / 1000L + ", userTime=" + this.userTime / 1000L + ']'));
            }
        } else if (this.connBroken) {
            throw new IOException("Failed to close stream, because connection was broken (data could have been lost).");
        }
    }

    private void markClosed(boolean connBroken) {
        if (!this.closed) {
            this.closed = true;
            this.delegate.hadoop().removeEventListener(this.delegate);
            this.connBroken = connBroken;
        }
    }

    private void check() throws IOException {
        String errMsg0 = this.errMsg;
        if (errMsg0 != null) {
            throw new IOException(errMsg0);
        }
        if (this.closed) {
            if (this.connBroken) {
                throw new IOException("Server connection was lost.");
            }
            throw new IOException("Stream is closed.");
        }
    }

    @Override
    public void onClose() throws GridException {
        this.markClosed(true);
    }

    @Override
    public void onError(String errMsg) {
        this.errMsg = errMsg;
    }
}

