/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.ggfs.hadoop;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.PositionedReadable;
import org.apache.hadoop.fs.Seekable;
import org.gridgain.grid.kernal.ggfs.hadoop.GridGgfsHadoopLogger;

public class GridGgfsHadoopProxyInputStream
extends InputStream
implements Seekable,
PositionedReadable {
    private final FSDataInputStream is;
    private final GridGgfsHadoopLogger clientLog;
    private final long logStreamId;
    private long readTime;
    private long userTime;
    private long lastTs;
    private long total;
    private boolean closed;

    public GridGgfsHadoopProxyInputStream(FSDataInputStream is, GridGgfsHadoopLogger clientLog, long logStreamId) {
        assert (is != null);
        assert (clientLog != null);
        this.is = is;
        this.clientLog = clientLog;
        this.logStreamId = logStreamId;
        this.lastTs = System.nanoTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int read(byte[] b) throws IOException {
        int res;
        this.readStart();
        try {
            res = this.is.read(b);
        }
        finally {
            this.readEnd();
        }
        if (res != -1) {
            this.total += (long)res;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int res;
        this.readStart();
        try {
            res = super.read(b, off, len);
        }
        finally {
            this.readEnd();
        }
        if (res != -1) {
            this.total += (long)res;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized long skip(long n) throws IOException {
        long res;
        this.readStart();
        try {
            res = this.is.skip(n);
        }
        finally {
            this.readEnd();
        }
        if (this.clientLog.isLogEnabled()) {
            this.clientLog.logSkip(this.logStreamId, res);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int available() throws IOException {
        this.readStart();
        try {
            int n = this.is.available();
            return n;
        }
        finally {
            this.readEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.readStart();
            try {
                this.is.close();
            }
            finally {
                this.readEnd();
            }
            if (this.clientLog.isLogEnabled()) {
                this.clientLog.logCloseIn(this.logStreamId, this.userTime, this.readTime, this.total);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void mark(int readLimit) {
        this.readStart();
        try {
            this.is.mark(readLimit);
        }
        finally {
            this.readEnd();
        }
        if (this.clientLog.isLogEnabled()) {
            this.clientLog.logMark(this.logStreamId, readLimit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void reset() throws IOException {
        this.readStart();
        try {
            this.is.reset();
        }
        finally {
            this.readEnd();
        }
        if (this.clientLog.isLogEnabled()) {
            this.clientLog.logReset(this.logStreamId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean markSupported() {
        this.readStart();
        try {
            boolean bl = this.is.markSupported();
            return bl;
        }
        finally {
            this.readEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int read() throws IOException {
        int res;
        this.readStart();
        try {
            res = this.is.read();
        }
        finally {
            this.readEnd();
        }
        if (res != -1) {
            ++this.total;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int read(long pos, byte[] buf, int off, int len) throws IOException {
        int res;
        this.readStart();
        try {
            res = this.is.read(pos, buf, off, len);
        }
        finally {
            this.readEnd();
        }
        if (res != -1) {
            this.total += (long)res;
        }
        if (this.clientLog.isLogEnabled()) {
            this.clientLog.logRandomRead(this.logStreamId, pos, res);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void readFully(long pos, byte[] buf, int off, int len) throws IOException {
        this.readStart();
        try {
            this.is.readFully(pos, buf, off, len);
        }
        finally {
            this.readEnd();
        }
        this.total += (long)len;
        if (this.clientLog.isLogEnabled()) {
            this.clientLog.logRandomRead(this.logStreamId, pos, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void readFully(long pos, byte[] buf) throws IOException {
        this.readStart();
        try {
            this.is.readFully(pos, buf);
        }
        finally {
            this.readEnd();
        }
        this.total += (long)buf.length;
        if (this.clientLog.isLogEnabled()) {
            this.clientLog.logRandomRead(this.logStreamId, pos, buf.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void seek(long pos) throws IOException {
        this.readStart();
        try {
            this.is.seek(pos);
        }
        finally {
            this.readEnd();
        }
        if (this.clientLog.isLogEnabled()) {
            this.clientLog.logSeek(this.logStreamId, pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long getPos() throws IOException {
        this.readStart();
        try {
            long l = this.is.getPos();
            return l;
        }
        finally {
            this.readEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean seekToNewSource(long targetPos) throws IOException {
        this.readStart();
        try {
            boolean bl = this.is.seekToNewSource(targetPos);
            return bl;
        }
        finally {
            this.readEnd();
        }
    }

    private void readStart() {
        long now = System.nanoTime();
        this.userTime += now - this.lastTs;
        this.lastTs = now;
    }

    private void readEnd() {
        long now = System.nanoTime();
        this.readTime += now - this.lastTs;
        this.lastTs = now;
    }
}

