/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.ggfs.hadoop;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.gridgain.grid.kernal.ggfs.hadoop.GridGgfsHadoopLogger;

public class GridGgfsHadoopProxyOutputStream
extends OutputStream {
    private FSDataOutputStream os;
    private final GridGgfsHadoopLogger clientLog;
    private final long logStreamId;
    private long writeTime;
    private long userTime;
    private long lastTs;
    private long total;
    private boolean closed;

    public GridGgfsHadoopProxyOutputStream(FSDataOutputStream os, GridGgfsHadoopLogger clientLog, long logStreamId) {
        assert (os != null);
        assert (clientLog != null);
        this.os = os;
        this.clientLog = clientLog;
        this.logStreamId = logStreamId;
        this.lastTs = System.nanoTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void write(int b) throws IOException {
        this.writeStart();
        try {
            this.os.write(b);
        }
        finally {
            this.writeEnd();
        }
        ++this.total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void write(byte[] b) throws IOException {
        this.writeStart();
        try {
            this.os.write(b);
        }
        finally {
            this.writeEnd();
        }
        this.total += (long)b.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        this.writeStart();
        try {
            this.os.write(b, off, len);
        }
        finally {
            this.writeEnd();
        }
        this.total += (long)len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void flush() throws IOException {
        this.writeStart();
        try {
            this.os.flush();
        }
        finally {
            this.writeEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.writeStart();
            try {
                this.os.close();
            }
            finally {
                this.writeEnd();
            }
            if (this.clientLog.isLogEnabled()) {
                this.clientLog.logCloseOut(this.logStreamId, this.userTime, this.writeTime, this.total);
            }
        }
    }

    private void writeStart() {
        long now = System.nanoTime();
        this.userTime += now - this.lastTs;
        this.lastTs = now;
    }

    private void writeEnd() {
        long now = System.nanoTime();
        this.writeTime += now - this.lastTs;
        this.lastTs = now;
    }
}

