/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.ggfs.hadoop;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.PathExistsException;
import org.apache.hadoop.fs.PathIsNotEmptyDirectoryException;
import org.gridgain.grid.GridException;
import org.gridgain.grid.ggfs.GridGgfsException;
import org.gridgain.grid.ggfs.GridGgfsFileNotFoundException;
import org.gridgain.grid.ggfs.GridGgfsParentNotDirectoryException;
import org.gridgain.grid.ggfs.GridGgfsPathAlreadyExistsException;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsDirectoryNotEmptyException;
import org.jetbrains.annotations.Nullable;

public class GridGgfsHadoopUtils {
    public static final String PARAM_GGFS_ENDPOINT_NO_EMBED = "fs.ggfs.%s.endpoint.no_embed";
    public static final String PARAM_GGFS_ENDPOINT_NO_LOCAL_SHMEM = "fs.ggfs.%s.endpoint.no_local_shmem";
    public static final String PARAM_GGFS_ENDPOINT_NO_LOCAL_TCP = "fs.ggfs.%s.endpoint.no_local_tcp";

    public static String parameter(Configuration cfg, String name, String authority, String dflt) {
        return cfg.get(String.format(name, authority != null ? authority : ""), dflt);
    }

    public static int parameter(Configuration cfg, String name, String authority, int dflt) throws IOException {
        String name0 = String.format(name, authority != null ? authority : "");
        try {
            return cfg.getInt(name0, dflt);
        }
        catch (NumberFormatException ignore) {
            throw new IOException("Failed to parse parameter value to integer: " + name0);
        }
    }

    public static boolean parameter(Configuration cfg, String name, String authority, boolean dflt) {
        return cfg.getBoolean(String.format(name, authority != null ? authority : ""), dflt);
    }

    public static IOException cast(GridException e) {
        return GridGgfsHadoopUtils.cast(e, null);
    }

    public static IOException cast(GridException e, @Nullable String path) {
        assert (e != null);
        if (e.hasCause(new Class[]{IOException.class})) {
            return (IOException)e.getCause(IOException.class);
        }
        if (e instanceof GridGgfsFileNotFoundException) {
            return new FileNotFoundException(path);
        }
        if (e instanceof GridGgfsParentNotDirectoryException) {
            return new ParentNotDirectoryException(path);
        }
        if (path != null && e instanceof GridGgfsDirectoryNotEmptyException) {
            return new PathIsNotEmptyDirectoryException(path);
        }
        if (path != null && e instanceof GridGgfsPathAlreadyExistsException) {
            return new PathExistsException(path);
        }
        return new IOException(e);
    }

    public static GridGgfsException cast(IOException e) {
        if (e instanceof FileNotFoundException) {
            return new GridGgfsFileNotFoundException((Throwable)e);
        }
        if (e instanceof ParentNotDirectoryException) {
            return new GridGgfsParentNotDirectoryException((Throwable)e);
        }
        if (e instanceof PathIsNotEmptyDirectoryException) {
            return new GridGgfsDirectoryNotEmptyException(e);
        }
        if (e instanceof PathExistsException) {
            return new GridGgfsPathAlreadyExistsException((Throwable)e);
        }
        return new GridGgfsException((Throwable)e);
    }

    private GridGgfsHadoopUtils() {
    }
}

