/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.ggfs;

import java.nio.ByteBuffer;
import org.gridgain.grid.GridException;
import org.gridgain.grid.GridUuid;
import org.gridgain.grid.kernal.GridDirectTransient;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsCommunicationMessage;
import org.gridgain.grid.marshaller.GridMarshaller;
import org.gridgain.grid.util.direct.GridTcpCommunicationMessageAdapter;
import org.jetbrains.annotations.Nullable;

public class GridGgfsAckMessage
extends GridGgfsCommunicationMessage {
    private static final long serialVersionUID = 0L;
    private GridUuid fileId;
    private long id;
    @GridDirectTransient
    private GridException err;
    private byte[] errBytes;

    public GridGgfsAckMessage() {
    }

    public GridGgfsAckMessage(GridUuid fileId, long id, @Nullable GridException err) {
        this.fileId = fileId;
        this.id = id;
        this.err = err;
    }

    public GridUuid fileId() {
        return this.fileId;
    }

    public long id() {
        return this.id;
    }

    public GridException error() {
        return this.err;
    }

    @Override
    public void prepareMarshal(GridMarshaller marsh) throws GridException {
        super.prepareMarshal(marsh);
        if (this.err != null) {
            this.errBytes = marsh.marshal((Object)this.err);
        }
    }

    @Override
    public void finishUnmarshal(GridMarshaller marsh, @Nullable ClassLoader ldr) throws GridException {
        super.finishUnmarshal(marsh, ldr);
        if (this.errBytes != null) {
            this.err = (GridException)((Object)marsh.unmarshal(this.errBytes, ldr));
        }
    }

    public GridTcpCommunicationMessageAdapter clone() {
        GridGgfsAckMessage _clone = new GridGgfsAckMessage();
        this.clone0(_clone);
        return _clone;
    }

    @Override
    protected void clone0(GridTcpCommunicationMessageAdapter _msg) {
        super.clone0(_msg);
        GridGgfsAckMessage _clone = (GridGgfsAckMessage)_msg;
        _clone.fileId = this.fileId;
        _clone.id = this.id;
        _clone.err = this.err;
        _clone.errBytes = this.errBytes;
    }

    @Override
    public boolean writeTo(ByteBuffer buf) {
        this.commState.setBuffer(buf);
        if (!super.writeTo(buf)) {
            return false;
        }
        if (!this.commState.typeWritten) {
            if (!this.commState.putByte(this.directType())) {
                return false;
            }
            this.commState.typeWritten = true;
        }
        switch (this.commState.idx) {
            case 0: {
                if (!this.commState.putByteArray(this.errBytes)) {
                    return false;
                }
                ++this.commState.idx;
            }
            case 1: {
                if (!this.commState.putGridUuid(this.fileId)) {
                    return false;
                }
                ++this.commState.idx;
            }
            case 2: {
                if (!this.commState.putLong(this.id)) {
                    return false;
                }
                ++this.commState.idx;
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf) {
        this.commState.setBuffer(buf);
        if (!super.readFrom(buf)) {
            return false;
        }
        switch (this.commState.idx) {
            case 0: {
                byte[] errBytes0 = this.commState.getByteArray();
                if (errBytes0 == BYTE_ARR_NOT_READ) {
                    return false;
                }
                this.errBytes = errBytes0;
                ++this.commState.idx;
            }
            case 1: {
                GridUuid fileId0 = this.commState.getGridUuid();
                if (fileId0 == GRID_UUID_NOT_READ) {
                    return false;
                }
                this.fileId = fileId0;
                ++this.commState.idx;
            }
            case 2: {
                if (buf.remaining() < 8) {
                    return false;
                }
                this.id = this.commState.getLong();
                ++this.commState.idx;
            }
        }
        return true;
    }

    public byte directType() {
        return 65;
    }
}

