/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.ggfs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.gridgain.grid.ggfs.GridGgfsMode;
import org.gridgain.grid.util.typedef.internal.U;

public class GridGgfsAttributes
implements Externalizable {
    private static final long serialVersionUID = 0L;
    private String ggfsName;
    private int blockSize;
    private int grpSize;
    private String metaCacheName;
    private String dataCacheName;
    private GridGgfsMode dfltMode;
    private boolean fragmentizerEnabled;
    private Map<String, GridGgfsMode> pathModes;

    public GridGgfsAttributes(String ggfsName, int blockSize, int grpSize, String metaCacheName, String dataCacheName, GridGgfsMode dfltMode, Map<String, GridGgfsMode> pathModes, boolean fragmentizerEnabled) {
        this.blockSize = blockSize;
        this.ggfsName = ggfsName;
        this.grpSize = grpSize;
        this.metaCacheName = metaCacheName;
        this.dataCacheName = dataCacheName;
        this.dfltMode = dfltMode;
        this.pathModes = pathModes;
        this.fragmentizerEnabled = fragmentizerEnabled;
    }

    public GridGgfsAttributes() {
    }

    public String ggfsName() {
        return this.ggfsName;
    }

    public int blockSize() {
        return this.blockSize;
    }

    public int groupSize() {
        return this.grpSize;
    }

    public String metaCacheName() {
        return this.metaCacheName;
    }

    public String dataCacheName() {
        return this.dataCacheName;
    }

    public GridGgfsMode defaultMode() {
        return this.dfltMode;
    }

    public Map<String, GridGgfsMode> pathModes() {
        return this.pathModes != null ? Collections.unmodifiableMap(this.pathModes) : null;
    }

    public boolean fragmentizerEnabled() {
        return this.fragmentizerEnabled;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeString((DataOutput)out, (String)this.ggfsName);
        out.writeInt(this.blockSize);
        out.writeInt(this.grpSize);
        U.writeString((DataOutput)out, (String)this.metaCacheName);
        U.writeString((DataOutput)out, (String)this.dataCacheName);
        U.writeEnum0((DataOutput)out, (Enum)this.dfltMode);
        out.writeBoolean(this.fragmentizerEnabled);
        if (this.pathModes != null) {
            out.writeBoolean(true);
            out.writeInt(this.pathModes.size());
            for (Map.Entry<String, GridGgfsMode> pathMode : this.pathModes.entrySet()) {
                U.writeString((DataOutput)out, (String)pathMode.getKey());
                U.writeEnum0((DataOutput)out, (Enum)((Enum)pathMode.getValue()));
            }
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.ggfsName = U.readString((DataInput)in);
        this.blockSize = in.readInt();
        this.grpSize = in.readInt();
        this.metaCacheName = U.readString((DataInput)in);
        this.dataCacheName = U.readString((DataInput)in);
        this.dfltMode = GridGgfsMode.fromOrdinal((int)U.readEnumOrdinal0((DataInput)in));
        this.fragmentizerEnabled = in.readBoolean();
        if (in.readBoolean()) {
            int size = in.readInt();
            this.pathModes = new HashMap<String, GridGgfsMode>(size, 1.0f);
            for (int i = 0; i < size; ++i) {
                this.pathModes.put(U.readString((DataInput)in), GridGgfsMode.fromOrdinal((int)U.readEnumOrdinal0((DataInput)in)));
            }
        }
    }
}

