/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.ggfs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.gridgain.grid.GridUuid;
import org.gridgain.grid.kernal.processors.task.GridInternal;
import org.gridgain.grid.util.direct.GridTcpCommunicationMessageAdapter;
import org.gridgain.grid.util.typedef.F;
import org.gridgain.grid.util.typedef.internal.S;
import org.gridgain.grid.util.typedef.internal.U;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@GridInternal
public final class GridGgfsBlockKey
extends GridTcpCommunicationMessageAdapter
implements Externalizable,
Comparable<GridGgfsBlockKey> {
    private static final long serialVersionUID = 0L;
    private GridUuid fileId;
    private long blockId;
    private GridUuid affKey;
    private boolean evictExclude;

    public GridGgfsBlockKey(GridUuid fileId, @Nullable GridUuid affKey, boolean evictExclude, long blockId) {
        assert (fileId != null);
        assert (blockId >= 0L);
        this.fileId = fileId;
        this.affKey = affKey;
        this.evictExclude = evictExclude;
        this.blockId = blockId;
    }

    public GridGgfsBlockKey() {
    }

    public GridUuid getFileId() {
        return this.fileId;
    }

    public GridUuid affinityKey() {
        return this.affKey;
    }

    public boolean evictExclude() {
        return this.evictExclude;
    }

    public long getBlockId() {
        return this.blockId;
    }

    @Override
    public int compareTo(@NotNull GridGgfsBlockKey o) {
        int res = this.fileId.compareTo(o.fileId);
        if (res != 0) {
            return res;
        }
        long v1 = this.blockId;
        long v2 = o.blockId;
        if (v1 != v2) {
            return v1 > v2 ? 1 : -1;
        }
        if (this.affKey == null && o.affKey == null) {
            return 0;
        }
        if (this.affKey != null && o.affKey != null) {
            return this.affKey.compareTo(o.affKey);
        }
        return this.affKey != null ? -1 : 1;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeGridUuid((DataOutput)out, (GridUuid)this.fileId);
        U.writeGridUuid((DataOutput)out, (GridUuid)this.affKey);
        out.writeBoolean(this.evictExclude);
        out.writeLong(this.blockId);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.fileId = U.readGridUuid((DataInput)in);
        this.affKey = U.readGridUuid((DataInput)in);
        this.evictExclude = in.readBoolean();
        this.blockId = in.readLong();
    }

    public int hashCode() {
        return this.fileId.hashCode() + (int)(this.blockId ^ this.blockId >>> 32);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        GridGgfsBlockKey that = (GridGgfsBlockKey)o;
        return this.blockId == that.blockId && this.fileId.equals((Object)that.fileId) && F.eq((Object)this.affKey, (Object)that.affKey) && this.evictExclude == that.evictExclude;
    }

    public GridTcpCommunicationMessageAdapter clone() {
        GridGgfsBlockKey _clone = new GridGgfsBlockKey();
        this.clone0(_clone);
        return _clone;
    }

    protected void clone0(GridTcpCommunicationMessageAdapter _msg) {
        GridGgfsBlockKey _clone = (GridGgfsBlockKey)_msg;
        _clone.fileId = this.fileId;
        _clone.blockId = this.blockId;
        _clone.affKey = this.affKey;
        _clone.evictExclude = this.evictExclude;
    }

    public boolean writeTo(ByteBuffer buf) {
        this.commState.setBuffer(buf);
        if (!this.commState.typeWritten) {
            if (!this.commState.putByte(this.directType())) {
                return false;
            }
            this.commState.typeWritten = true;
        }
        switch (this.commState.idx) {
            case 0: {
                if (!this.commState.putGridUuid(this.affKey)) {
                    return false;
                }
                ++this.commState.idx;
            }
            case 1: {
                if (!this.commState.putLong(this.blockId)) {
                    return false;
                }
                ++this.commState.idx;
            }
            case 2: {
                if (!this.commState.putBoolean(this.evictExclude)) {
                    return false;
                }
                ++this.commState.idx;
            }
            case 3: {
                if (!this.commState.putGridUuid(this.fileId)) {
                    return false;
                }
                ++this.commState.idx;
            }
        }
        return true;
    }

    public boolean readFrom(ByteBuffer buf) {
        this.commState.setBuffer(buf);
        switch (this.commState.idx) {
            case 0: {
                GridUuid affKey0 = this.commState.getGridUuid();
                if (affKey0 == GRID_UUID_NOT_READ) {
                    return false;
                }
                this.affKey = affKey0;
                ++this.commState.idx;
            }
            case 1: {
                if (buf.remaining() < 8) {
                    return false;
                }
                this.blockId = this.commState.getLong();
                ++this.commState.idx;
            }
            case 2: {
                if (buf.remaining() < 1) {
                    return false;
                }
                this.evictExclude = this.commState.getBoolean();
                ++this.commState.idx;
            }
            case 3: {
                GridUuid fileId0 = this.commState.getGridUuid();
                if (fileId0 == GRID_UUID_NOT_READ) {
                    return false;
                }
                this.fileId = fileId0;
                ++this.commState.idx;
            }
        }
        return true;
    }

    public byte directType() {
        return 66;
    }

    public String toString() {
        return S.toString(GridGgfsBlockKey.class, (Object)this);
    }
}

