/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.ggfs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.UUID;
import org.apache.hadoop.fs.BlockLocation;
import org.gridgain.grid.GridException;
import org.gridgain.grid.GridNode;
import org.gridgain.grid.ggfs.GridGgfsBlockLocation;
import org.gridgain.grid.util.tostring.GridToStringInclude;
import org.gridgain.grid.util.typedef.F;
import org.gridgain.grid.util.typedef.internal.S;
import org.gridgain.grid.util.typedef.internal.U;

public class GridGgfsBlockLocationImpl
implements GridGgfsBlockLocation,
Externalizable {
    private static final long serialVersionUID = 0L;
    private long start;
    private long len;
    @GridToStringInclude
    private Collection<UUID> nodeIds;
    private Collection<String> names;
    private Collection<String> hosts;

    public GridGgfsBlockLocationImpl() {
    }

    public GridGgfsBlockLocationImpl(BlockLocation location) throws IOException {
        assert (location != null);
        this.start = location.getOffset();
        this.len = location.getLength();
        this.names = Arrays.asList(location.getNames());
        this.hosts = Arrays.asList(location.getHosts());
    }

    public GridGgfsBlockLocationImpl(GridGgfsBlockLocation location, long len) {
        assert (location != null);
        this.start = location.start();
        this.len = len;
        this.nodeIds = location.nodeIds();
        this.names = location.names();
        this.hosts = location.hosts();
    }

    public GridGgfsBlockLocationImpl(long start, long len, Collection<GridNode> nodes) {
        assert (start >= 0L);
        assert (len > 0L);
        assert (nodes != null && !nodes.isEmpty());
        this.start = start;
        this.len = len;
        this.convertFromNodes(nodes);
    }

    public long start() {
        return this.start;
    }

    public long length() {
        return this.len;
    }

    public Collection<UUID> nodeIds() {
        return this.nodeIds;
    }

    public Collection<String> names() {
        return this.names;
    }

    public Collection<String> hosts() {
        return this.hosts;
    }

    public int hashCode() {
        int res = (int)(this.start ^ this.start >>> 32);
        res = 31 * res + (int)(this.len ^ this.len >>> 32);
        res = 31 * res + this.nodeIds.hashCode();
        return res;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GridGgfsBlockLocationImpl that = (GridGgfsBlockLocationImpl)o;
        return this.len == that.len && this.start == that.start && F.eq(this.nodeIds, that.nodeIds) && F.eq(this.names, that.names) && F.eq(this.hosts, that.hosts);
    }

    public String toString() {
        return S.toString(GridGgfsBlockLocationImpl.class, (Object)this);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        assert (this.names != null);
        assert (this.hosts != null);
        out.writeLong(this.start);
        out.writeLong(this.len);
        out.writeBoolean(this.nodeIds != null);
        if (this.nodeIds != null) {
            out.writeInt(this.nodeIds.size());
            for (UUID nodeId : this.nodeIds) {
                U.writeUuid((DataOutput)out, (UUID)nodeId);
            }
        }
        out.writeInt(this.names.size());
        for (String name : this.names) {
            out.writeUTF(name);
        }
        out.writeInt(this.hosts.size());
        for (String host : this.hosts) {
            out.writeUTF(host);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int i;
        int size;
        this.start = in.readLong();
        this.len = in.readLong();
        if (in.readBoolean()) {
            size = in.readInt();
            this.nodeIds = new ArrayList<UUID>(size);
            for (i = 0; i < size; ++i) {
                this.nodeIds.add(U.readUuid((DataInput)in));
            }
        }
        size = in.readInt();
        this.names = new ArrayList<String>(size);
        for (i = 0; i < size; ++i) {
            this.names.add(in.readUTF());
        }
        size = in.readInt();
        this.hosts = new ArrayList<String>(size);
        for (i = 0; i < size; ++i) {
            this.hosts.add(in.readUTF());
        }
    }

    private void convertFromNodes(Collection<GridNode> nodes) {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        LinkedHashSet<String> hosts = new LinkedHashSet<String>();
        ArrayList<UUID> nodeIds = new ArrayList<UUID>(nodes.size());
        for (GridNode node : nodes) {
            try {
                Collection addrs = U.toInetAddresses((GridNode)node);
                for (InetAddress addr : addrs) {
                    if (addr.getHostName() == null) {
                        names.add(addr.getHostAddress() + ":" + 9001);
                        continue;
                    }
                    names.add(addr.getHostName() + ":" + 9001);
                    hosts.add(addr.getHostName());
                }
            }
            catch (GridException ignored) {
                names.addAll(node.addresses());
            }
            nodeIds.add(node.id());
        }
        this.nodeIds = nodeIds;
        this.names = names;
        this.hosts = hosts;
    }
}

