/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.ggfs;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.gridgain.grid.GridUuid;
import org.gridgain.grid.kernal.GridDirectMap;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsBlockKey;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsCommunicationMessage;
import org.gridgain.grid.util.direct.GridTcpCommunicationMessageAdapter;

public class GridGgfsBlocksMessage
extends GridGgfsCommunicationMessage {
    private static final long serialVersionUID = 0L;
    private GridUuid fileId;
    private long id;
    @GridDirectMap(keyType=GridGgfsBlockKey.class, valueType=byte[].class)
    private Map<GridGgfsBlockKey, byte[]> blocks;

    public GridGgfsBlocksMessage() {
    }

    public GridGgfsBlocksMessage(GridUuid fileId, long id, Map<GridGgfsBlockKey, byte[]> blocks) {
        this.fileId = fileId;
        this.id = id;
        this.blocks = blocks;
    }

    public GridUuid fileId() {
        return this.fileId;
    }

    public long id() {
        return this.id;
    }

    public Map<GridGgfsBlockKey, byte[]> blocks() {
        return this.blocks;
    }

    public GridTcpCommunicationMessageAdapter clone() {
        GridGgfsBlocksMessage _clone = new GridGgfsBlocksMessage();
        this.clone0(_clone);
        return _clone;
    }

    @Override
    protected void clone0(GridTcpCommunicationMessageAdapter _msg) {
        super.clone0(_msg);
        GridGgfsBlocksMessage _clone = (GridGgfsBlocksMessage)_msg;
        _clone.fileId = this.fileId;
        _clone.id = this.id;
        _clone.blocks = this.blocks;
    }

    @Override
    public boolean writeTo(ByteBuffer buf) {
        this.commState.setBuffer(buf);
        if (!super.writeTo(buf)) {
            return false;
        }
        if (!this.commState.typeWritten) {
            if (!this.commState.putByte(this.directType())) {
                return false;
            }
            this.commState.typeWritten = true;
        }
        switch (this.commState.idx) {
            case 0: {
                if (this.blocks != null) {
                    if (this.commState.it == null) {
                        if (!this.commState.putInt(this.blocks.size())) {
                            return false;
                        }
                        this.commState.it = this.blocks.entrySet().iterator();
                    }
                    while (this.commState.it.hasNext() || this.commState.cur != NULL) {
                        if (this.commState.cur == NULL) {
                            this.commState.cur = this.commState.it.next();
                        }
                        Map.Entry e = (Map.Entry)this.commState.cur;
                        if (!this.commState.keyDone) {
                            if (!this.commState.putMessage((GridTcpCommunicationMessageAdapter)e.getKey())) {
                                return false;
                            }
                            this.commState.keyDone = true;
                        }
                        if (!this.commState.putByteArray((byte[])e.getValue())) {
                            return false;
                        }
                        this.commState.keyDone = false;
                        this.commState.cur = NULL;
                    }
                    this.commState.it = null;
                } else if (!this.commState.putInt(-1)) {
                    return false;
                }
                ++this.commState.idx;
            }
            case 1: {
                if (!this.commState.putGridUuid(this.fileId)) {
                    return false;
                }
                ++this.commState.idx;
            }
            case 2: {
                if (!this.commState.putLong(this.id)) {
                    return false;
                }
                ++this.commState.idx;
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf) {
        this.commState.setBuffer(buf);
        if (!super.readFrom(buf)) {
            return false;
        }
        switch (this.commState.idx) {
            case 0: {
                if (this.commState.readSize == -1) {
                    if (buf.remaining() < 4) {
                        return false;
                    }
                    this.commState.readSize = this.commState.getInt();
                }
                if (this.commState.readSize >= 0) {
                    if (this.blocks == null) {
                        this.blocks = new HashMap<GridGgfsBlockKey, byte[]>(this.commState.readSize);
                    }
                    for (int i = this.commState.readItems; i < this.commState.readSize; ++i) {
                        Object _val;
                        if (!this.commState.keyDone) {
                            _val = this.commState.getMessage();
                            if (_val == MSG_NOT_READ) {
                                return false;
                            }
                            this.commState.cur = _val;
                            this.commState.keyDone = true;
                        }
                        if ((_val = (Object)this.commState.getByteArray()) == BYTE_ARR_NOT_READ) {
                            return false;
                        }
                        this.blocks.put((GridGgfsBlockKey)this.commState.cur, (byte[])_val);
                        this.commState.keyDone = false;
                        ++this.commState.readItems;
                    }
                }
                this.commState.readSize = -1;
                this.commState.readItems = 0;
                this.commState.cur = null;
                ++this.commState.idx;
            }
            case 1: {
                GridUuid fileId0 = this.commState.getGridUuid();
                if (fileId0 == GRID_UUID_NOT_READ) {
                    return false;
                }
                this.fileId = fileId0;
                ++this.commState.idx;
            }
            case 2: {
                if (buf.remaining() < 8) {
                    return false;
                }
                this.id = this.commState.getLong();
                ++this.commState.idx;
            }
        }
        return true;
    }

    public byte directType() {
        return 67;
    }
}

