/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.ggfs;

import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.gridgain.grid.GridException;
import org.gridgain.grid.GridNode;
import org.gridgain.grid.GridNodeShadow;
import org.gridgain.grid.ggfs.GridGgfsConfiguration;
import org.gridgain.grid.kernal.GridKernalContext;
import org.gridgain.grid.kernal.managers.communication.GridIoPolicy;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsAttributes;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsCommunicationMessage;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsDataManager;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsEx;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsFragmentizerManager;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsImpl;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsManager;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsMetaManager;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsServerManager;
import org.gridgain.grid.util.direct.GridTcpCommunicationMessageAdapter;
import org.gridgain.grid.util.typedef.F;
import org.jetbrains.annotations.Nullable;

public class GridGgfsContext {
    private final GridKernalContext ctx;
    private final GridGgfsConfiguration cfg;
    private List<GridGgfsManager> mgrs = new LinkedList<GridGgfsManager>();
    private final GridGgfsMetaManager metaMgr;
    private final GridGgfsDataManager dataMgr;
    private final GridGgfsServerManager srvMgr;
    private final GridGgfsFragmentizerManager fragmentizerMgr;
    private final GridGgfsEx ggfs;

    public GridGgfsContext(GridKernalContext ctx, GridGgfsConfiguration cfg, GridGgfsMetaManager metaMgr, GridGgfsDataManager dataMgr, GridGgfsServerManager srvMgr, GridGgfsFragmentizerManager fragmentizerMgr) throws GridException {
        this.ctx = ctx;
        this.cfg = cfg;
        this.metaMgr = this.add(metaMgr);
        this.dataMgr = this.add(dataMgr);
        this.srvMgr = this.add(srvMgr);
        this.fragmentizerMgr = this.add(fragmentizerMgr);
        this.ggfs = new GridGgfsImpl(this);
    }

    public GridGgfsEx ggfs() {
        return this.ggfs;
    }

    public GridKernalContext kernalContext() {
        return this.ctx;
    }

    public GridGgfsConfiguration configuration() {
        return this.cfg;
    }

    public List<GridGgfsManager> managers() {
        return this.mgrs;
    }

    public GridGgfsMetaManager meta() {
        return this.metaMgr;
    }

    public GridGgfsDataManager data() {
        return this.dataMgr;
    }

    public GridGgfsServerManager server() {
        return this.srvMgr;
    }

    public GridGgfsFragmentizerManager fragmentizer() {
        return this.fragmentizerMgr;
    }

    public void send(UUID nodeId, Object topic, GridGgfsCommunicationMessage msg, GridIoPolicy plc) throws GridException {
        if (!this.kernalContext().localNodeId().equals(nodeId)) {
            msg.prepareMarshal(this.kernalContext().config().getMarshaller());
        }
        this.kernalContext().io().send(nodeId, topic, (GridTcpCommunicationMessageAdapter)msg, plc);
    }

    public void send(GridNode node, Object topic, GridGgfsCommunicationMessage msg, GridIoPolicy plc) throws GridException {
        if (!this.kernalContext().localNodeId().equals(node.id())) {
            msg.prepareMarshal(this.kernalContext().config().getMarshaller());
        }
        this.kernalContext().io().send(node, topic, (GridTcpCommunicationMessageAdapter)msg, plc);
    }

    public boolean ggfsNode(GridNodeShadow node) {
        assert (node != null);
        GridGgfsAttributes[] ggfs = (GridGgfsAttributes[])node.attribute("org.gridgain.ggfs");
        if (ggfs != null) {
            for (GridGgfsAttributes attrs : ggfs) {
                if (!F.eq((Object)this.cfg.getName(), (Object)attrs.ggfsName())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean ggfsNode(GridNode node) {
        assert (node != null);
        GridGgfsAttributes[] ggfs = (GridGgfsAttributes[])node.attribute("org.gridgain.ggfs");
        if (ggfs != null) {
            for (GridGgfsAttributes attrs : ggfs) {
                if (!F.eq((Object)this.cfg.getName(), (Object)attrs.ggfsName())) continue;
                return true;
            }
        }
        return false;
    }

    private <T extends GridGgfsManager> T add(@Nullable T mgr) {
        if (mgr != null) {
            this.mgrs.add(mgr);
        }
        return mgr;
    }
}

