/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.ggfs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.fs.FSDataInputStream;
import org.gridgain.grid.GridException;
import org.gridgain.grid.GridFuture;
import org.gridgain.grid.GridFutureTimeoutException;
import org.gridgain.grid.GridInterruptedException;
import org.gridgain.grid.GridNode;
import org.gridgain.grid.GridTopologyException;
import org.gridgain.grid.GridUuid;
import org.gridgain.grid.cache.GridCache;
import org.gridgain.grid.cache.GridCacheAtomicityMode;
import org.gridgain.grid.cache.GridCacheConfiguration;
import org.gridgain.grid.cache.GridCacheEntry;
import org.gridgain.grid.cache.GridCacheTx;
import org.gridgain.grid.cache.GridCacheTxConcurrency;
import org.gridgain.grid.cache.GridCacheTxIsolation;
import org.gridgain.grid.cache.affinity.GridCacheAffinityKeyMapper;
import org.gridgain.grid.dataload.GridDataLoader;
import org.gridgain.grid.events.GridDiscoveryEvent;
import org.gridgain.grid.events.GridEvent;
import org.gridgain.grid.ggfs.GridGgfsBlockLocation;
import org.gridgain.grid.ggfs.GridGgfsConfiguration;
import org.gridgain.grid.ggfs.GridGgfsException;
import org.gridgain.grid.ggfs.GridGgfsGroupDataBlocksKeyMapper;
import org.gridgain.grid.ggfs.GridGgfsOutOfSpaceException;
import org.gridgain.grid.ggfs.GridGgfsPath;
import org.gridgain.grid.kernal.GridKernalContext;
import org.gridgain.grid.kernal.GridTopic;
import org.gridgain.grid.kernal.managers.communication.GridIoPolicy;
import org.gridgain.grid.kernal.managers.communication.GridMessageListener;
import org.gridgain.grid.kernal.managers.eventstorage.GridLocalEventListener;
import org.gridgain.grid.kernal.processors.cache.GridCacheProjectionEx;
import org.gridgain.grid.kernal.processors.cache.GridCacheUtils;
import org.gridgain.grid.kernal.processors.dataload.GridDataLoadCacheUpdaters;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsAckMessage;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsBlockKey;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsBlockLocationImpl;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsBlocksMessage;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsCommunicationMessage;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsEx;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsFileAffinityRange;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsFileInfo;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsFileMap;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsFileWorkerBatch;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsLocalMetrics;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsManager;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsSecondaryInputStreamWrapper;
import org.gridgain.grid.kernal.processors.task.GridInternal;
import org.gridgain.grid.lang.GridBiTuple;
import org.gridgain.grid.lang.GridClosure;
import org.gridgain.grid.lang.GridInClosure;
import org.gridgain.grid.lang.GridPredicate;
import org.gridgain.grid.logger.GridLogger;
import org.gridgain.grid.thread.GridThreadPoolExecutor;
import org.gridgain.grid.util.GridConcurrentHashSet;
import org.gridgain.grid.util.future.GridFinishedFuture;
import org.gridgain.grid.util.future.GridFutureAdapter;
import org.gridgain.grid.util.lang.GridPlainCallable;
import org.gridgain.grid.util.typedef.CI1;
import org.gridgain.grid.util.typedef.CX1;
import org.gridgain.grid.util.typedef.F;
import org.gridgain.grid.util.typedef.internal.S;
import org.gridgain.grid.util.typedef.internal.U;
import org.gridgain.grid.util.worker.GridWorker;
import org.jdk8.backport.ConcurrentHashMap8;
import org.jetbrains.annotations.Nullable;

public class GridGgfsDataManager
extends GridGgfsManager {
    private GridGgfsEx ggfs;
    private GridCacheProjectionEx<GridGgfsBlockKey, byte[]> dataCachePrj;
    private GridCache<Object, Object> dataCache;
    private GridGgfsLocalMetrics metrics;
    private long grpBlockSize;
    private int grpSize;
    private ByteBufferBlocksWriter byteBufWriter = new ByteBufferBlocksWriter();
    private DataInputBlocksWriter dataInputWriter = new DataInputBlocksWriter();
    private ConcurrentMap<GridUuid, WriteCompletionFuture> pendingWrites = new ConcurrentHashMap8();
    private AtomicLong affKeyGen = new AtomicLong();
    private ExecutorService ggfsSvc;
    private AtomicLong reqIdCtr = new AtomicLong();
    private Object topic;
    private AsyncDeleteWorker delWorker;
    private long trashPurgeTimeout;
    private final ConcurrentHashMap8<GridGgfsBlockKey, GridFuture<byte[]>> rmtReadFuts = new ConcurrentHashMap8();
    private volatile ExecutorService putExecSvc;
    private volatile boolean putExecSvcShutdown;
    private volatile long maxPendingPuts;
    private long curPendingPuts;
    private final Lock pendingPutsLock = new ReentrantLock();
    private final Condition pendingPutsCond = this.pendingPutsLock.newCondition();

    @Override
    protected void start0() throws GridException {
        this.ggfs = this.ggfsCtx.ggfs();
        this.dataCachePrj = this.ggfsCtx.kernalContext().cache().internalCache(this.ggfsCtx.configuration().getDataCacheName());
        this.dataCache = this.ggfsCtx.kernalContext().cache().internalCache(this.ggfsCtx.configuration().getDataCacheName());
        if (this.dataCache.configuration().getAtomicityMode() != GridCacheAtomicityMode.TRANSACTIONAL) {
            throw new GridException("Data cache should be transactional: " + this.ggfsCtx.configuration().getDataCacheName());
        }
        this.metrics = this.ggfsCtx.ggfs().localMetrics();
        assert (this.dataCachePrj != null);
        GridCacheAffinityKeyMapper mapper = this.ggfsCtx.kernalContext().cache().internalCache(this.ggfsCtx.configuration().getDataCacheName()).configuration().getAffinityMapper();
        this.grpSize = mapper instanceof GridGgfsGroupDataBlocksKeyMapper ? ((GridGgfsGroupDataBlocksKeyMapper)mapper).groupSize() : 1;
        this.grpBlockSize = this.ggfsCtx.configuration().getBlockSize() * this.grpSize;
        String ggfsName = this.ggfsCtx.configuration().getName();
        this.topic = F.isEmpty((String)ggfsName) ? GridTopic.TOPIC_GGFS : GridTopic.TOPIC_GGFS.topic(ggfsName);
        this.ggfsCtx.kernalContext().io().addMessageListener(this.topic, new GridMessageListener(){

            public void onMessage(UUID nodeId, Object msg) {
                if (msg instanceof GridGgfsBlocksMessage) {
                    GridGgfsDataManager.this.processBlocksMessage(nodeId, (GridGgfsBlocksMessage)((Object)msg));
                } else if (msg instanceof GridGgfsAckMessage) {
                    GridGgfsDataManager.this.processAckMessage(nodeId, (GridGgfsAckMessage)((Object)msg));
                }
            }
        });
        this.ggfsCtx.kernalContext().event().addLocalEventListener(new GridLocalEventListener(){

            public void onEvent(GridEvent evt) {
                assert (evt.type() == 12 || evt.type() == 11);
                GridDiscoveryEvent discoEvt = (GridDiscoveryEvent)evt;
                if (GridGgfsDataManager.this.ggfsCtx.ggfsNode(discoEvt.eventNode())) {
                    for (WriteCompletionFuture future : GridGgfsDataManager.this.pendingWrites.values()) {
                        future.onError(discoEvt.eventNode().id(), (GridException)new GridTopologyException("Node left grid before write completed: " + evt.node().id()));
                    }
                }
            }
        }, 11, new int[]{12});
        this.ggfsSvc = this.ggfsCtx.kernalContext().config().getGgfsExecutorService();
        this.trashPurgeTimeout = this.ggfsCtx.configuration().getTrashPurgeTimeout();
        this.putExecSvc = this.ggfsCtx.configuration().getDualModePutExecutorService();
        if (this.putExecSvc != null) {
            this.putExecSvcShutdown = this.ggfsCtx.configuration().getDualModePutExecutorServiceShutdown();
        } else {
            int coresCnt = Runtime.getRuntime().availableProcessors();
            this.putExecSvc = new GridThreadPoolExecutor(coresCnt, coresCnt, 0L, new LinkedBlockingDeque());
            this.putExecSvcShutdown = true;
        }
        this.maxPendingPuts = this.ggfsCtx.configuration().getDualModeMaxPendingPutsSize();
        this.delWorker = new AsyncDeleteWorker(this.ggfsCtx.kernalContext().gridName(), "ggfs-" + ggfsName + "-delete-worker", this.log);
    }

    @Override
    protected void onKernalStart0() throws GridException {
        new Thread((Runnable)((Object)this.delWorker)).start();
    }

    @Override
    protected void onKernalStop0(boolean cancel) {
        if (cancel) {
            this.delWorker.cancel();
        } else {
            this.delWorker.stop();
        }
        try {
            U.join((GridWorker)this.delWorker);
        }
        catch (GridInterruptedException e) {
            this.log.warning("Got interrupter while waiting for delete worker to stop (will continue stopping).", (Throwable)e);
        }
        if (this.putExecSvcShutdown) {
            U.shutdownNow(this.getClass(), (ExecutorService)this.putExecSvc, (GridLogger)this.log);
        }
    }

    public long spaceSize() {
        return this.dataCachePrj.ggfsDataSpaceUsed();
    }

    public long maxSpaceSize() {
        return this.dataCachePrj.ggfsDataSpaceMax();
    }

    public GridUuid nextAffinityKey(@Nullable GridUuid prevAffKey) {
        GridUuid key;
        if (!GridCacheUtils.isAffinityNode((GridCacheConfiguration)this.dataCache.configuration())) {
            return null;
        }
        UUID nodeId = this.ggfsCtx.kernalContext().localNodeId();
        if (prevAffKey != null && this.dataCache.affinity().mapKeyToNode((Object)prevAffKey).isLocal()) {
            return prevAffKey;
        }
        do {
            key = new GridUuid(nodeId, this.affKeyGen.getAndIncrement());
        } while (!this.dataCache.affinity().mapKeyToNode((Object)key).isLocal());
        return key;
    }

    public GridNode affinityNode(Object affinityKey) {
        return this.dataCache.affinity().mapKeyToNode(affinityKey);
    }

    private GridDataLoader<GridGgfsBlockKey, byte[]> dataLoader() {
        GridDataLoader ldr = this.ggfsCtx.kernalContext().dataLoad().dataLoader(this.dataCachePrj.name());
        GridGgfsConfiguration cfg = this.ggfsCtx.configuration();
        if (cfg.getPerNodeBatchSize() > 0) {
            ldr.perNodeBufferSize(cfg.getPerNodeBatchSize());
        }
        if (cfg.getPerNodeParallelBatchCount() > 0) {
            ldr.perNodeParallelLoadOperations(cfg.getPerNodeParallelBatchCount());
        }
        ldr.updater(GridDataLoadCacheUpdaters.batchedSorted());
        return ldr;
    }

    public List<Long> listLocalDataBlocks(GridGgfsFileInfo fileInfo) throws GridException {
        assert (fileInfo != null);
        int prevGrpIdx = 0;
        boolean prevPrimaryFlag = false;
        ArrayList<Long> res = new ArrayList<Long>();
        for (long i = 0L; i < fileInfo.blocksCount(); ++i) {
            int grpIdx = (int)(i % (long)this.grpSize);
            if (prevGrpIdx < grpIdx) {
                if (prevPrimaryFlag) {
                    res.add(i);
                }
            } else {
                GridGgfsBlockKey key = new GridGgfsBlockKey(fileInfo.id(), fileInfo.affinityKey(), fileInfo.evictExclude(), i);
                Collection affNodes = this.dataCache.affinity().mapKeyToPrimaryAndBackups((Object)key);
                assert (affNodes != null && !affNodes.isEmpty());
                GridNode primaryNode = (GridNode)affNodes.iterator().next();
                if (primaryNode.id().equals(this.ggfsCtx.kernalContext().localNodeId())) {
                    res.add(i);
                    prevPrimaryFlag = true;
                } else {
                    prevPrimaryFlag = false;
                }
            }
            prevGrpIdx = grpIdx;
        }
        return res;
    }

    @Nullable
    public GridFuture<byte[]> dataBlock(final GridGgfsFileInfo fileInfo, final GridGgfsPath path, final long blockIdx, final @Nullable GridGgfsSecondaryInputStreamWrapper inWrapper) throws GridException {
        assert (fileInfo != null);
        assert (blockIdx >= 0L);
        final GridGgfsBlockKey key = this.blockKey(blockIdx, fileInfo);
        if (this.log.isDebugEnabled()) {
            GridCacheEntry entry = this.dataCachePrj.entry((Object)key);
            assert (entry != null);
            if (!entry.primary() && !entry.backup()) {
                this.log.debug("Reading non-local data block [path=" + path + ", fileInfo=" + fileInfo + ", blockIdx=" + blockIdx + ']');
            }
        }
        GridFuture fut = this.dataCachePrj.getAsync((Object)key);
        if (inWrapper != null) {
            fut = fut.chain((GridClosure)new CX1<GridFuture<byte[]>, byte[]>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public byte[] applyx(GridFuture<byte[]> fut) throws GridException {
                    byte[] res = (byte[])fut.get();
                    if (res == null) {
                        GridFutureAdapter rmtReadFut = new GridFutureAdapter(GridGgfsDataManager.this.ggfsCtx.kernalContext());
                        GridFuture oldRmtReadFut = (GridFuture)GridGgfsDataManager.this.rmtReadFuts.putIfAbsent((Object)key, (Object)rmtReadFut);
                        if (oldRmtReadFut == null) {
                            try {
                                int read;
                                if (GridGgfsDataManager.this.log.isDebugEnabled()) {
                                    GridGgfsDataManager.this.log.debug("Reading non-local data block in the secondary file system [path=" + path + ", fileInfo=" + fileInfo + ", blockIdx=" + blockIdx + ']');
                                }
                                int blockSize = fileInfo.blockSize();
                                long pos = blockIdx * (long)blockSize;
                                res = new byte[blockSize];
                                GridGgfsSecondaryInputStreamWrapper gridGgfsSecondaryInputStreamWrapper = inWrapper;
                                synchronized (gridGgfsSecondaryInputStreamWrapper) {
                                    try {
                                        int r;
                                        FSDataInputStream in = inWrapper.in();
                                        for (read = 0; read < blockSize && (r = in.read(pos + (long)read, res, read, blockSize - read)) >= 0; read += r) {
                                        }
                                    }
                                    catch (IOException e) {
                                        throw new GridException("Failed to read data due to secondary file system exception: " + e.getMessage(), (Throwable)e);
                                    }
                                }
                                if (read != blockSize) {
                                    res = Arrays.copyOf(res, read);
                                }
                                rmtReadFut.onDone((Object)res);
                                GridGgfsDataManager.this.putSafe(key, res);
                                GridGgfsDataManager.this.metrics.addReadBlocks(1, 1);
                            }
                            catch (GridException e) {
                                rmtReadFut.onDone((Throwable)e);
                                throw e;
                            }
                            finally {
                                boolean rmv = GridGgfsDataManager.this.rmtReadFuts.remove((Object)key, (Object)rmtReadFut);
                                assert (rmv);
                            }
                        }
                        res = (byte[])oldRmtReadFut.get();
                        GridGgfsDataManager.this.metrics.addReadBlocks(1, 0);
                    } else {
                        GridGgfsDataManager.this.metrics.addReadBlocks(1, 0);
                    }
                    return res;
                }
            });
        } else {
            this.metrics.addReadBlocks(1, 0);
        }
        return fut;
    }

    public GridFuture<Boolean> writeStart(GridGgfsFileInfo fileInfo) {
        WriteCompletionFuture fut = new WriteCompletionFuture(this.ggfsCtx.kernalContext(), fileInfo.id());
        WriteCompletionFuture oldFut = this.pendingWrites.putIfAbsent(fileInfo.id(), fut);
        assert (oldFut == null) : "Opened write that is being concurrently written: " + fileInfo;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Registered write completion future for file output stream [fileInfo=" + fileInfo + ", fut=" + (Object)((Object)fut) + ']');
        }
        return fut;
    }

    public void writeClose(GridGgfsFileInfo fileInfo) {
        WriteCompletionFuture fut = (WriteCompletionFuture)((Object)this.pendingWrites.get(fileInfo.id()));
        if (fut != null) {
            fut.markWaitingLastAck();
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Failed to find write completion future for file in pending write map (most likely it was failed): " + fileInfo);
        }
    }

    @Nullable
    public byte[] storeDataBlocks(GridGgfsFileInfo fileInfo, long reservedLen, @Nullable byte[] remainder, int remainderLen, ByteBuffer data, boolean flush, GridGgfsFileAffinityRange affinityRange, @Nullable GridGgfsFileWorkerBatch batch) throws GridException {
        return this.byteBufWriter.storeDataBlocks(fileInfo, reservedLen, remainder, remainderLen, data, data.remaining(), flush, affinityRange, batch);
    }

    @Nullable
    public byte[] storeDataBlocks(GridGgfsFileInfo fileInfo, long reservedLen, @Nullable byte[] remainder, int remainderLen, DataInput in, int len, boolean flush, GridGgfsFileAffinityRange affinityRange, @Nullable GridGgfsFileWorkerBatch batch) throws GridException, IOException {
        return this.dataInputWriter.storeDataBlocks(fileInfo, reservedLen, remainder, remainderLen, in, len, flush, affinityRange, batch);
    }

    public GridFuture<Object> delete(GridGgfsFileInfo fileInfo) {
        if (!fileInfo.isFile()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Cannot delete content of not-data file: " + fileInfo);
            }
            return new GridFinishedFuture(this.ggfsCtx.kernalContext());
        }
        return this.delWorker.deleteAsync(fileInfo);
    }

    public GridGgfsBlockKey blockKey(long blockIdx, GridGgfsFileInfo fileInfo) {
        if (fileInfo.affinityKey() != null) {
            return new GridGgfsBlockKey(fileInfo.id(), fileInfo.affinityKey(), fileInfo.evictExclude(), blockIdx);
        }
        if (fileInfo.fileMap() != null) {
            GridUuid affKey = fileInfo.fileMap().affinityKey(blockIdx * (long)fileInfo.blockSize(), false);
            return new GridGgfsBlockKey(fileInfo.id(), affKey, fileInfo.evictExclude(), blockIdx);
        }
        return new GridGgfsBlockKey(fileInfo.id(), null, fileInfo.evictExclude(), blockIdx);
    }

    public void cleanBlocks(GridGgfsFileInfo fileInfo, GridGgfsFileAffinityRange range, boolean cleanNonColocated) {
        long startIdx = range.startOffset() / (long)fileInfo.blockSize();
        long endIdx = range.endOffset() / (long)fileInfo.blockSize();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Cleaning blocks [fileInfo=" + fileInfo + ", range=" + range + ", cleanNonColocated=" + cleanNonColocated + ", startIdx=" + startIdx + ", endIdx=" + endIdx + ']');
        }
        try (GridDataLoader<GridGgfsBlockKey, byte[]> ldr = this.dataLoader();){
            for (long idx = startIdx; idx <= endIdx; ++idx) {
                ldr.removeData((Object)new GridGgfsBlockKey(fileInfo.id(), range.affinityKey(), fileInfo.evictExclude(), idx));
                if (!cleanNonColocated) continue;
                ldr.removeData((Object)new GridGgfsBlockKey(fileInfo.id(), null, fileInfo.evictExclude(), idx));
            }
        }
        catch (GridException e) {
            this.log.error("Failed to clean up file range [fileInfo=" + fileInfo + ", range=" + range + ']', (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void spreadBlocks(GridGgfsFileInfo fileInfo, GridGgfsFileAffinityRange range) {
        startIdx = range.startOffset() / (long)fileInfo.blockSize();
        endIdx = range.endOffset() / (long)fileInfo.blockSize();
        try {
            ldr = this.dataLoader();
            var8_7 = null;
            try {
                bytesProcessed = 0L;
                for (idx = startIdx; idx <= endIdx; ++idx) {
                    colocatedKey = new GridGgfsBlockKey(fileInfo.id(), range.affinityKey(), fileInfo.evictExclude(), idx);
                    key = new GridGgfsBlockKey(fileInfo.id(), null, fileInfo.evictExclude(), idx);
                    block = (byte[])this.dataCachePrj.get((Object)colocatedKey);
                    if (block != null) {
                        if (block.length != fileInfo.blockSize()) {
                            tx = this.dataCachePrj.txStart(GridCacheTxConcurrency.PESSIMISTIC, GridCacheTxIsolation.REPEATABLE_READ);
                            try {
                                vals = this.dataCachePrj.getAll((Collection)F.asList((Object[])new GridGgfsBlockKey[]{colocatedKey, key}));
                                val = (byte[])vals.get(colocatedKey);
                                if (val != null) {
                                    this.dataCachePrj.putx((Object)key, (Object)val, new GridPredicate[0]);
                                    tx.commit();
                                }
                                if (!this.log.isDebugEnabled()) ** GOTO lbl31
                                this.log.debug("Failed to find colocated file block for spread (will ignore) [fileInfo=" + fileInfo + ", range=" + range + ", startIdx=" + startIdx + ", endIdx=" + endIdx + ", idx=" + idx + ']');
                            }
                            finally {
                                tx.close();
                            }
                        } else {
                            ldr.addData((Object)key, (Object)block);
                        }
lbl31:
                        // 4 sources

                        if ((bytesProcessed += (long)block.length) < this.ggfsCtx.configuration().getFragmentizerThrottlingBlockLength()) continue;
                        ldr.flush();
                        bytesProcessed = 0L;
                        U.sleep((long)this.ggfsCtx.configuration().getFragmentizerThrottlingDelay());
                        continue;
                    }
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Failed to find colocated file block for spread (will ignore) [fileInfo=" + fileInfo + ", range=" + range + ", startIdx=" + startIdx + ", endIdx=" + endIdx + ", idx=" + idx + ']');
                }
            }
            catch (Throwable var9_10) {
                var8_7 = var9_10;
                throw var9_10;
            }
            finally {
                if (ldr != null) {
                    if (var8_7 != null) {
                        try {
                            ldr.close();
                        }
                        catch (Throwable x2) {
                            var8_7.addSuppressed(x2);
                        }
                    } else {
                        ldr.close();
                    }
                }
            }
        }
        catch (GridException e) {
            this.log.error("Failed to clean up file range [fileInfo=" + fileInfo + ", range=" + range + ']', (Throwable)e);
        }
    }

    public Collection<GridGgfsBlockLocation> affinity(GridGgfsFileInfo info, long start, long len) throws GridException {
        return this.affinity(info, start, len, 0L);
    }

    public Collection<GridGgfsBlockLocation> affinity(GridGgfsFileInfo info, long start, long len, long maxLen) throws GridException {
        assert (this.validTxState(false));
        assert (info.isFile()) : "Failed to get affinity (not a file): " + info;
        assert (start >= 0L) : "Start position should not be negative: " + start;
        assert (len >= 0L) : "Part length should not be negative: " + len;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Calculating affinity for file [info=" + info + ", start=" + start + ", len=" + len + ']');
        }
        if (len == 0L) {
            return Collections.emptyList();
        }
        if (maxLen > 0L) {
            if ((maxLen -= maxLen % (long)info.blockSize()) < (long)info.blockSize()) {
                maxLen = info.blockSize();
            }
        } else {
            maxLen = 0L;
        }
        if (info.affinityKey() != null) {
            LinkedList<GridGgfsBlockLocation> res = new LinkedList<GridGgfsBlockLocation>();
            this.splitBlocks(start, len, maxLen, this.dataCache.affinity().mapKeyToPrimaryAndBackups((Object)new GridGgfsBlockKey(info.id(), info.affinityKey(), info.evictExclude(), 0L)), res);
            return res;
        }
        LinkedList<GridGgfsBlockLocation> res = new LinkedList<GridGgfsBlockLocation>();
        if (info.fileMap().ranges().isEmpty()) {
            this.affinity0(info, start, len, maxLen, res);
            return res;
        }
        long pos = start;
        long end = start + len;
        for (GridGgfsFileAffinityRange range : info.fileMap().ranges()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Checking range [range=" + range + ", pos=" + pos + ']');
            }
            if (range.less(pos)) {
                long partEnd = Math.min(end, range.startOffset());
                this.affinity0(info, pos, partEnd - pos, maxLen, res);
                pos = partEnd;
            }
            GridGgfsBlockLocation last = (GridGgfsBlockLocation)res.peekLast();
            if (range.belongs(pos)) {
                long partEnd = Math.min(range.endOffset() + 1L, end);
                Collection affNodes = this.dataCache.affinity().mapKeyToPrimaryAndBackups((Object)range.affinityKey());
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Calculated affinity for range [start=" + pos + ", end=" + partEnd + ", nodes=" + F.nodeIds((Collection)affNodes) + ", range=" + range + ", affNodes=" + F.nodeIds((Collection)affNodes) + ']');
                }
                if (last != null && this.equal(last.nodeIds(), F.viewReadOnly((Collection)affNodes, (GridClosure)F.node2id(), (GridPredicate[])new GridPredicate[0]))) {
                    res.removeLast();
                    this.splitBlocks(last.start(), last.length() + partEnd - pos, maxLen, affNodes, res);
                } else {
                    this.splitBlocks(pos, partEnd - pos, maxLen, affNodes, res);
                }
                pos = partEnd;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Finished range check [range=" + range + ", pos=" + pos + ", res=" + res + ']');
            }
            if (pos != end) continue;
            break;
        }
        if (pos != end) {
            this.affinity0(info, pos, end, maxLen, res);
        }
        return res;
    }

    private void affinity0(GridGgfsFileInfo info, long start, long len, long maxLen, Deque<GridGgfsBlockLocation> res) throws GridException {
        long limitGrpIdx = (start + len + this.grpBlockSize - 1L) / this.grpBlockSize;
        long firstGrpIdx = start / this.grpBlockSize;
        if (limitGrpIdx - firstGrpIdx > Integer.MAX_VALUE) {
            throw new GridGgfsException("Failed to get affinity (range is too wide) [info=" + info + ", start=" + start + ", len=" + len + ']');
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Mapping file region [fileInfo=" + info + ", start=" + start + ", len=" + len + ']');
        }
        for (long grpIdx = firstGrpIdx; grpIdx < limitGrpIdx; ++grpIdx) {
            GridGgfsBlockLocation last;
            long blockLen;
            long blockStart;
            if (grpIdx == firstGrpIdx) {
                blockStart = start % this.grpBlockSize;
                blockLen = Math.min(this.grpBlockSize - blockStart, len);
            } else if (grpIdx == limitGrpIdx - 1L) {
                blockStart = 0L;
                blockLen = (start + len - 1L) % this.grpBlockSize + 1L;
            } else {
                blockStart = 0L;
                blockLen = this.grpBlockSize;
            }
            GridGgfsBlockKey key = new GridGgfsBlockKey(info.id(), info.affinityKey(), info.evictExclude(), grpIdx * (long)this.grpSize);
            Collection affNodes = this.dataCache.affinity().mapKeyToPrimaryAndBackups((Object)key);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Mapped key to nodes [key=" + key + ", nodes=" + F.nodeIds((Collection)affNodes) + ", blockStart=" + blockStart + ", blockLen=" + blockLen + ']');
            }
            if ((last = res.peekLast()) != null && this.equal(last.nodeIds(), F.viewReadOnly((Collection)affNodes, (GridClosure)F.node2id(), (GridPredicate[])new GridPredicate[0]))) {
                res.removeLast();
                this.splitBlocks(last.start(), last.length() + blockLen, maxLen, affNodes, res);
                continue;
            }
            this.splitBlocks(grpIdx * this.grpBlockSize + blockStart, blockLen, maxLen, affNodes, res);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Calculated file affinity [info=" + info + ", start=" + start + ", len=" + len + ", res=" + res + ']');
        }
    }

    private void splitBlocks(long start, long len, long maxLen, Collection<GridNode> nodes, Collection<GridGgfsBlockLocation> res) {
        if (maxLen > 0L) {
            long len0;
            long end = start + len;
            for (long start0 = start; start0 < end; start0 += len0) {
                len0 = Math.min(maxLen, end - start0);
                res.add(new GridGgfsBlockLocationImpl(start0, len0, nodes));
            }
        } else {
            res.add(new GridGgfsBlockLocationImpl(start, len, nodes));
        }
    }

    public long groupBlockSize() {
        return this.grpBlockSize;
    }

    private boolean equal(Collection<UUID> one, Collection<UUID> two) {
        if (one.size() != two.size()) {
            return false;
        }
        Iterator<UUID> it1 = one.iterator();
        Iterator<UUID> it2 = two.iterator();
        int size = one.size();
        for (int i = 0; i < size; ++i) {
            if (it1.next().equals(it2.next())) continue;
            return false;
        }
        return true;
    }

    private boolean validTxState(boolean inTx) {
        boolean txState;
        boolean bl = txState = inTx == (this.dataCachePrj.tx() != null);
        assert (txState) : (inTx ? "Method cannot be called outside transaction: " : "Method cannot be called in transaction: ") + this.dataCachePrj.tx();
        return txState;
    }

    private void processBatch(GridUuid fileId, GridNode node, final Map<GridGgfsBlockKey, byte[]> blocks) throws GridException {
        final long batchId = this.reqIdCtr.getAndIncrement();
        final WriteCompletionFuture completionFut = (WriteCompletionFuture)((Object)this.pendingWrites.get(fileId));
        if (completionFut == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Missing completion future for file write request (most likely exception occurred which will be thrown upon stream close) [nodeId=" + node.id() + ", fileId=" + fileId + ']');
            }
            return;
        }
        if (completionFut.isDone()) {
            completionFut.get();
        }
        completionFut.onWriteRequest(node.id(), batchId);
        final UUID nodeId = node.id();
        if (!node.isLocal()) {
            final GridGgfsBlocksMessage msg = new GridGgfsBlocksMessage(fileId, batchId, blocks);
            this.callGgfsLocalSafe((Callable)new GridPlainCallable<Object>(){

                @Nullable
                public Object call() throws Exception {
                    try {
                        GridGgfsDataManager.this.ggfsCtx.send(nodeId, GridGgfsDataManager.this.topic, (GridGgfsCommunicationMessage)msg, GridIoPolicy.SYSTEM_POOL);
                    }
                    catch (GridException e) {
                        completionFut.onError(nodeId, e);
                    }
                    return null;
                }
            });
        } else {
            this.callGgfsLocalSafe((Callable)new GridPlainCallable<Object>(){

                @Nullable
                public Object call() throws Exception {
                    GridGgfsDataManager.this.storeBlocksAsync(blocks).listenAsync((GridInClosure)new CI1<GridFuture<?>>(){

                        public void apply(GridFuture<?> fut) {
                            try {
                                fut.get();
                                completionFut.onWriteAck(nodeId, batchId);
                            }
                            catch (GridException e) {
                                completionFut.onError(nodeId, e);
                            }
                        }
                    });
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPartialBlockWrite(GridUuid fileId, GridGgfsBlockKey colocatedKey, int startOff, byte[] data) throws GridException {
        if (this.dataCachePrj.ggfsDataSpaceUsed() >= this.dataCachePrj.ggfsDataSpaceMax()) {
            try {
                this.ggfs.awaitDeletesAsync().get(this.trashPurgeTimeout);
            }
            catch (GridFutureTimeoutException ignore) {
                // empty catch block
            }
            if (this.dataCachePrj.ggfsDataSpaceUsed() >= this.dataCachePrj.ggfsDataSpaceMax()) {
                WriteCompletionFuture completionFut = (WriteCompletionFuture)((Object)this.pendingWrites.get(fileId));
                if (completionFut == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Missing completion future for file write request (most likely exception occurred which will be thrown upon stream close) [fileId=" + fileId + ']');
                    }
                    return;
                }
                completionFut.onLocalError((GridException)new GridGgfsOutOfSpaceException("Failed to write data block (GGFS maximum data size exceeded) [used=" + this.dataCachePrj.ggfsDataSpaceUsed() + ", allowed=" + this.dataCachePrj.ggfsDataSpaceMax() + ']'));
                return;
            }
        }
        if (colocatedKey.affinityKey() == null) {
            this.dataCachePrj.transform((Object)colocatedKey, (GridClosure)new UpdateClosure(startOff, data));
            return;
        }
        if (startOff == 0) {
            this.dataCachePrj.putx((Object)colocatedKey, (Object)data, new GridPredicate[0]);
            return;
        }
        GridGgfsBlockKey key = new GridGgfsBlockKey(colocatedKey.getFileId(), null, colocatedKey.evictExclude(), colocatedKey.getBlockId());
        try (GridCacheTx tx = this.dataCachePrj.txStart(GridCacheTxConcurrency.PESSIMISTIC, GridCacheTxIsolation.REPEATABLE_READ);){
            Map vals = this.dataCachePrj.getAll((Collection)F.asList((Object[])new GridGgfsBlockKey[]{colocatedKey, key}));
            boolean hasVal = false;
            UpdateClosure transformClos = new UpdateClosure(startOff, data);
            if (vals.get(colocatedKey) != null) {
                this.dataCachePrj.transform((Object)colocatedKey, (GridClosure)transformClos);
                hasVal = true;
            }
            if (vals.get(key) != null) {
                this.dataCachePrj.transform((Object)key, (GridClosure)transformClos);
                hasVal = true;
            }
            if (!hasVal) {
                throw new GridException("Failed to write partial block (no previous data was found in cache) [key=" + colocatedKey + ", relaxedKey=" + key + ", startOff=" + startOff + ", dataLen=" + data.length + ']');
            }
            tx.commit();
        }
    }

    private <T> void callGgfsLocalSafe(Callable<T> c) {
        try {
            this.ggfsSvc.submit(c);
        }
        catch (RejectedExecutionException ignored) {
            try {
                c.call();
            }
            catch (Exception e) {
                this.log.warning("Failed to execute GGFS callable: " + c, (Throwable)e);
            }
        }
    }

    private void putSafe(final GridGgfsBlockKey key, final byte[] data) throws GridException {
        assert (key != null);
        assert (data != null);
        if (this.maxPendingPuts > 0L) {
            this.pendingPutsLock.lock();
            try {
                while (this.curPendingPuts > this.maxPendingPuts) {
                    this.pendingPutsCond.await(2000L, TimeUnit.MILLISECONDS);
                }
                this.curPendingPuts += (long)data.length;
            }
            catch (InterruptedException ignore) {
                throw new GridException("Failed to put GGFS data block into cache due to interruption: " + key);
            }
            finally {
                this.pendingPutsLock.unlock();
            }
        }
        Runnable task = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    GridGgfsDataManager.this.dataCachePrj.putx((Object)key, (Object)data, new GridPredicate[0]);
                }
                catch (GridException e) {
                    U.warn((GridLogger)GridGgfsDataManager.this.log, (Object)("Failed to put GGFS data block into cache [key=" + key + ", err=" + (Object)((Object)e) + ']'));
                }
                finally {
                    if (GridGgfsDataManager.this.maxPendingPuts > 0L) {
                        GridGgfsDataManager.this.pendingPutsLock.lock();
                        try {
                            GridGgfsDataManager.this.curPendingPuts -= data.length;
                            GridGgfsDataManager.this.pendingPutsCond.signalAll();
                        }
                        finally {
                            GridGgfsDataManager.this.pendingPutsLock.unlock();
                        }
                    }
                }
            }
        };
        try {
            this.putExecSvc.submit(task);
        }
        catch (RejectedExecutionException ignore) {
            task.run();
        }
    }

    private GridFuture<?> storeBlocksAsync(Map<GridGgfsBlockKey, byte[]> blocks) {
        assert (!blocks.isEmpty());
        if (this.dataCachePrj.ggfsDataSpaceUsed() >= this.dataCachePrj.ggfsDataSpaceMax()) {
            try {
                try {
                    this.ggfs.awaitDeletesAsync().get(this.trashPurgeTimeout);
                }
                catch (GridFutureTimeoutException ignore) {
                    // empty catch block
                }
                if (this.dataCachePrj.ggfsDataSpaceUsed() >= this.dataCachePrj.ggfsDataSpaceMax()) {
                    return new GridFinishedFuture(this.ggfsCtx.kernalContext(), (Throwable)new GridGgfsOutOfSpaceException("Failed to write data block (GGFS maximum data size exceeded) [used=" + this.dataCachePrj.ggfsDataSpaceUsed() + ", allowed=" + this.dataCachePrj.ggfsDataSpaceMax() + ']'));
                }
            }
            catch (GridException e) {
                return new GridFinishedFuture(this.ggfsCtx.kernalContext(), (Throwable)new GridException("Failed to store data block due to unexpected exception.", (Throwable)e));
            }
        }
        return this.dataCachePrj.putAllAsync(blocks, new GridPredicate[0]);
    }

    private void processBlocksMessage(final UUID nodeId, final GridGgfsBlocksMessage blocksMsg) {
        this.storeBlocksAsync(blocksMsg.blocks()).listenAsync((GridInClosure)new CI1<GridFuture<?>>(){

            public void apply(GridFuture<?> fut) {
                GridException err = null;
                try {
                    fut.get();
                }
                catch (GridException e) {
                    err = e;
                }
                try {
                    GridGgfsDataManager.this.ggfsCtx.send(nodeId, GridGgfsDataManager.this.topic, (GridGgfsCommunicationMessage)new GridGgfsAckMessage(blocksMsg.fileId(), blocksMsg.id(), err), GridIoPolicy.SYSTEM_POOL);
                }
                catch (GridException e) {
                    U.warn((GridLogger)GridGgfsDataManager.this.log, (Object)("Failed to send batch acknowledgement (did node leave the grid?) [nodeId=" + nodeId + ", fileId=" + blocksMsg.fileId() + ", batchId=" + blocksMsg.id() + ']'), (Object)((Object)e));
                }
            }
        });
    }

    private void processAckMessage(UUID nodeId, GridGgfsAckMessage ackMsg) {
        try {
            ackMsg.finishUnmarshal(this.ggfsCtx.kernalContext().config().getMarshaller(), null);
        }
        catch (GridException e) {
            U.error((GridLogger)this.log, (Object)("Failed to unmarshal message (will ignore): " + (Object)((Object)ackMsg)), (Throwable)e);
            return;
        }
        GridUuid fileId = ackMsg.fileId();
        WriteCompletionFuture fut = (WriteCompletionFuture)((Object)this.pendingWrites.get(fileId));
        if (fut != null) {
            if (ackMsg.error() != null) {
                fut.onError(nodeId, ackMsg.error());
            } else {
                fut.onWriteAck(nodeId, ackMsg.id());
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("Received write acknowledgement for non-existent write future (most likely future was failed) [nodeId=" + nodeId + ", fileId=" + fileId + ']');
        }
    }

    private GridGgfsBlockKey createBlockKey(long block, GridGgfsFileInfo fileInfo, GridGgfsFileAffinityRange locRange) {
        if (fileInfo.affinityKey() != null) {
            return new GridGgfsBlockKey(fileInfo.id(), fileInfo.affinityKey(), fileInfo.evictExclude(), block);
        }
        if (locRange == null || locRange.done()) {
            return new GridGgfsBlockKey(fileInfo.id(), null, fileInfo.evictExclude(), block);
        }
        long blockStart = block * (long)fileInfo.blockSize();
        if (locRange.less(blockStart)) {
            GridUuid affKey = fileInfo.fileMap().affinityKey(blockStart, false);
            return new GridGgfsBlockKey(fileInfo.id(), affKey, fileInfo.evictExclude(), block);
        }
        if ((float)this.dataCachePrj.ggfsDataSpaceUsed() > (float)this.dataCachePrj.ggfsDataSpaceMax() * this.ggfsCtx.configuration().getFragmentizerLocalWritesRatio()) {
            locRange.markDone();
            return new GridGgfsBlockKey(fileInfo.id(), null, fileInfo.evictExclude(), block);
        }
        if (!locRange.belongs(blockStart)) {
            locRange.expand(blockStart, fileInfo.blockSize());
        }
        return new GridGgfsBlockKey(fileInfo.id(), locRange.affinityKey(), fileInfo.evictExclude(), block);
    }

    private class WriteCompletionFuture
    extends GridFutureAdapter<Boolean> {
        private static final long serialVersionUID = 0L;
        private GridUuid fileId;
        private ConcurrentMap<UUID, Set<Long>> pendingAcks;
        private volatile boolean awaitingLast;

        public WriteCompletionFuture() {
            this.pendingAcks = new ConcurrentHashMap8();
        }

        private WriteCompletionFuture(GridKernalContext ctx, GridUuid fileId) {
            super(ctx);
            this.pendingAcks = new ConcurrentHashMap8();
            assert (fileId != null);
            this.fileId = fileId;
        }

        public boolean onDone(@Nullable Boolean res, @Nullable Throwable err) {
            if (!this.isDone()) {
                GridGgfsDataManager.this.pendingWrites.remove(this.fileId, (Object)this);
                if (super.onDone((Object)res, err)) {
                    return true;
                }
            }
            return false;
        }

        private void onWriteRequest(UUID nodeId, long batchId) {
            if (!this.isDone()) {
                Set reqIds = (Set)this.pendingAcks.get(nodeId);
                if (reqIds == null) {
                    reqIds = (Set)F.addIfAbsent(this.pendingAcks, (Object)nodeId, (Object)new GridConcurrentHashSet());
                }
                reqIds.add(batchId);
            }
        }

        private void onError(UUID nodeId, GridException e) {
            Set reqIds = (Set)this.pendingAcks.get(nodeId);
            if (reqIds != null && !reqIds.isEmpty()) {
                if (e instanceof GridGgfsOutOfSpaceException) {
                    this.onDone(new GridException("Failed to write data (not enough space on node): " + nodeId, (Throwable)e));
                } else {
                    this.onDone(new GridException("Failed to wait for write completion (write failed on node): " + nodeId, (Throwable)e));
                }
            }
        }

        private void onLocalError(GridException e) {
            if (e instanceof GridGgfsOutOfSpaceException) {
                this.onDone(new GridException("Failed to write data (not enough space on node): " + GridGgfsDataManager.this.ggfsCtx.kernalContext().localNodeId(), (Throwable)e));
            } else {
                this.onDone(new GridException("Failed to wait for write completion (write failed on node): " + GridGgfsDataManager.this.ggfsCtx.kernalContext().localNodeId(), (Throwable)e));
            }
        }

        private void onWriteAck(UUID nodeId, long batchId) {
            if (!this.isDone()) {
                Set reqIds = (Set)this.pendingAcks.get(nodeId);
                assert (reqIds != null) : "Received acknowledgement message for not registered node [nodeId=" + nodeId + ", batchId=" + batchId + ']';
                boolean rmv = reqIds.remove(batchId);
                assert (rmv) : "Received acknowledgement message for not registered batch [nodeId=" + nodeId + ", batchId=" + batchId + ']';
                if (this.awaitingLast && this.checkCompleted()) {
                    this.onDone(true);
                }
            }
        }

        private void markWaitingLastAck() {
            this.awaitingLast = true;
            if (log.isDebugEnabled()) {
                log.debug("Marked write completion future as awaiting last ack: " + this.fileId);
            }
            if (this.checkCompleted()) {
                this.onDone(true);
            }
        }

        private boolean checkCompleted() {
            for (Map.Entry entry : this.pendingAcks.entrySet()) {
                Set reqIds = (Set)entry.getValue();
                if (reqIds.isEmpty()) continue;
                return false;
            }
            return true;
        }
    }

    private class AsyncDeleteWorker
    extends GridWorker {
        private final GridGgfsFileInfo stopInfo;
        private BlockingQueue<GridBiTuple<GridFutureAdapter<Object>, GridGgfsFileInfo>> delReqs;

        protected AsyncDeleteWorker(String gridName, String name, GridLogger log) {
            super(gridName, name, log);
            this.stopInfo = new GridGgfsFileInfo();
            this.delReqs = new LinkedBlockingQueue<GridBiTuple<GridFutureAdapter<Object>, GridGgfsFileInfo>>();
        }

        private void stop() {
            this.delReqs.offer((GridBiTuple<GridFutureAdapter<Object>, GridGgfsFileInfo>)F.t((Object)new GridFutureAdapter(GridGgfsDataManager.this.ggfsCtx.kernalContext()), (Object)this.stopInfo));
        }

        private GridFuture<Object> deleteAsync(GridGgfsFileInfo info) {
            GridFutureAdapter fut = new GridFutureAdapter(GridGgfsDataManager.this.ggfsCtx.kernalContext());
            this.delReqs.offer((GridBiTuple<GridFutureAdapter<Object>, GridGgfsFileInfo>)F.t((Object)fut, (Object)info));
            return fut;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void body() throws InterruptedException, GridInterruptedException {
            GridBiTuple req;
            try {
                block78: while (!this.isCancelled()) {
                    GridUuid fileId;
                    long size;
                    long block;
                    req = this.delReqs.take();
                    GridFutureAdapter fut = (GridFutureAdapter)req.get1();
                    GridGgfsFileInfo fileInfo = (GridGgfsFileInfo)req.get2();
                    if (fileInfo == this.stopInfo) {
                        fut.onDone();
                        return;
                    }
                    GridDataLoader ldr = GridGgfsDataManager.this.dataLoader();
                    try {
                        GridGgfsFileMap map = fileInfo.fileMap();
                        block = 0L;
                        size = fileInfo.blocksCount();
                        while (true) {
                            if (block >= size) continue block78;
                            GridUuid affKey = map == null ? null : map.affinityKey(block * (long)fileInfo.blockSize(), true);
                            ldr.removeData((Object)new GridGgfsBlockKey(fileInfo.id(), affKey, fileInfo.evictExclude(), block));
                            if (affKey != null) {
                                ldr.removeData((Object)new GridGgfsBlockKey(fileInfo.id(), null, fileInfo.evictExclude(), block));
                            }
                            ++block;
                        }
                    }
                    catch (GridInterruptedException ignored) {
                        try {
                            fileId = fileInfo.id();
                            block = 0L;
                            size = fileInfo.blocksCount();
                            while (true) {
                                if (block >= size) continue block78;
                                ldr.removeData((Object)new GridGgfsBlockKey(fileId, fileInfo.affinityKey(), fileInfo.evictExclude(), block));
                                ++block;
                            }
                        }
                        catch (GridException e) {
                            log.error("Failed to remove file contents: " + fileInfo, (Throwable)e);
                        }
                        finally {
                            try {
                                ldr.close(this.isCancelled());
                            }
                            catch (GridException e) {
                                log.error("Failed to stop data loader while shutting down ggfs async delete thread.", (Throwable)e);
                            }
                            finally {
                                fut.onDone();
                            }
                        }
                    }
                    catch (GridException e) {
                        log.error("Failed to remove file contents: " + fileInfo, (Throwable)e);
                    }
                    finally {
                        try {
                            fileId = fileInfo.id();
                            block = 0L;
                            size = fileInfo.blocksCount();
                            while (true) {
                                if (block >= size) continue block78;
                                ldr.removeData((Object)new GridGgfsBlockKey(fileId, fileInfo.affinityKey(), fileInfo.evictExclude(), block));
                                ++block;
                            }
                        }
                        catch (GridException e) {
                            log.error("Failed to remove file contents: " + fileInfo, (Throwable)e);
                        }
                        finally {
                            try {
                                ldr.close(this.isCancelled());
                            }
                            catch (GridException e) {
                                log.error("Failed to stop data loader while shutting down ggfs async delete thread.", (Throwable)e);
                            }
                            finally {
                                fut.onDone();
                            }
                        }
                    }
                }
                return;
            }
            finally {
                if (log.isDebugEnabled()) {
                    log.debug("Stopping asynchronous ggfs file delete thread: " + this.name());
                }
                req = (GridBiTuple)this.delReqs.poll();
                while (true) {
                    if (req == null) {
                    }
                    ((GridFutureAdapter)req.get1()).onCancelled();
                    req = (GridBiTuple)this.delReqs.poll();
                }
            }
        }
    }

    @GridInternal
    private static final class UpdateClosure
    implements GridClosure<byte[], byte[]>,
    Externalizable {
        private static final long serialVersionUID = 0L;
        private int start;
        private byte[] data;

        public UpdateClosure() {
        }

        private UpdateClosure(int start, byte[] data) {
            assert (start >= 0);
            assert (data != null);
            assert (start + data.length >= 0) : "Too much data [start=" + start + ", data.length=" + data.length + ']';
            this.start = start;
            this.data = data;
        }

        public byte[] apply(byte[] e) {
            int size = this.data.length;
            if (e == null || e.length == 0) {
                e = new byte[this.start + size];
            } else if (e.length < this.start + size) {
                byte[] tmp = new byte[this.start + size];
                U.arrayCopy((byte[])e, (int)0, (byte[])tmp, (int)0, (int)e.length);
                e = tmp;
            }
            U.arrayCopy((byte[])this.data, (int)0, (byte[])e, (int)this.start, (int)size);
            return e;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.start);
            U.writeByteArray((DataOutput)out, (byte[])this.data);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException {
            this.start = in.readInt();
            this.data = U.readByteArray((DataInput)in);
        }

        public String toString() {
            return S.toString(UpdateClosure.class, (Object)this, (String)"start", (Object)this.start, (String)"data.length", (Object)this.data.length);
        }
    }

    private class DataInputBlocksWriter
    extends BlocksWriter<DataInput> {
        private DataInputBlocksWriter() {
        }

        @Override
        protected void readData(DataInput src, byte[] dst, int dstOff) throws GridException {
            try {
                src.readFully(dst, dstOff, dst.length - dstOff);
            }
            catch (IOException e) {
                throw new GridException((Throwable)e);
            }
        }
    }

    private class ByteBufferBlocksWriter
    extends BlocksWriter<ByteBuffer> {
        private ByteBufferBlocksWriter() {
        }

        @Override
        protected void readData(ByteBuffer src, byte[] dst, int dstOff) {
            src.get(dst, dstOff, dst.length - dstOff);
        }
    }

    private abstract class BlocksWriter<T> {
        private BlocksWriter() {
        }

        @Nullable
        public byte[] storeDataBlocks(GridGgfsFileInfo fileInfo, long reservedLen, @Nullable byte[] remainder, int remainderLen, T src, int srcLen, boolean flush, GridGgfsFileAffinityRange affinityRange, @Nullable GridGgfsFileWorkerBatch batch) throws GridException {
            GridUuid id = fileInfo.id();
            int blockSize = fileInfo.blockSize();
            int len = remainderLen + srcLen;
            if ((long)len > reservedLen) {
                throw new GridGgfsException("Not enough space reserved to store data [id=" + id + ", reservedLen=" + reservedLen + ", remainderLen=" + remainderLen + ", data.length=" + srcLen + ']');
            }
            long start = reservedLen - (long)len;
            long first = start / (long)blockSize;
            long limit = (start + (long)len + (long)blockSize - 1L) / (long)blockSize;
            int written = 0;
            int remainderOff = 0;
            LinkedHashMap<GridGgfsBlockKey, byte[]> nodeBlocks = new LinkedHashMap<GridGgfsBlockKey, byte[]>((int)(limit - first));
            GridNode node = null;
            int off = 0;
            for (long block = first; block < limit; ++block) {
                long blockStartOff = block == first ? start % (long)blockSize : 0L;
                long blockEndOff = block == limit - 1L ? (start + (long)len - 1L) % (long)blockSize : (long)(blockSize - 1);
                long size = blockEndOff - blockStartOff + 1L;
                assert (size > 0L && size <= (long)blockSize);
                assert (blockStartOff + size <= (long)blockSize);
                byte[] portion = new byte[(int)size];
                int portionOff = Math.min((int)size, remainderLen - remainderOff);
                if (remainderOff != remainderLen) {
                    U.arrayCopy((byte[])remainder, (int)remainderOff, (byte[])portion, (int)0, (int)portionOff);
                    remainderOff += portionOff;
                }
                if ((long)portionOff < size) {
                    this.readData(src, portion, portionOff);
                }
                GridGgfsBlockKey key = GridGgfsDataManager.this.createBlockKey(block, fileInfo, affinityRange);
                GridNode primaryNode = GridGgfsDataManager.this.dataCachePrj.cache().affinity().mapKeyToNode((Object)key);
                if (block == first) {
                    off = (int)blockStartOff;
                    node = primaryNode;
                }
                if (size == (long)blockSize) {
                    assert (blockStartOff == 0L) : "Cannot write the whole block not from start position [start=" + start + ", block=" + block + ", blockStartOff=" + blockStartOff + ", blockEndOff=" + blockEndOff + ", size=" + size + ", first=" + first + ", limit=" + limit + ", blockSize=" + blockSize + ']';
                } else if (blockStartOff == 0L && !flush) {
                    assert (written + portion.length == len);
                    if (!nodeBlocks.isEmpty()) {
                        GridGgfsDataManager.this.processBatch(id, node, nodeBlocks);
                        GridGgfsDataManager.this.metrics.addWriteBlocks(1, 0);
                    }
                    return portion;
                }
                int writtenSecondary = 0;
                if (batch != null) {
                    if (!batch.write(portion)) {
                        throw new GridException("Cannot write more data to the secondary file system output stream because it was marked as closed: " + batch.path());
                    }
                    writtenSecondary = 1;
                }
                assert (primaryNode != null);
                int writtenTotal = 0;
                if (!primaryNode.id().equals(node.id())) {
                    if (!nodeBlocks.isEmpty()) {
                        GridGgfsDataManager.this.processBatch(id, node, nodeBlocks);
                    }
                    writtenTotal = nodeBlocks.size();
                    nodeBlocks = new LinkedHashMap((int)(limit - first));
                    node = primaryNode;
                }
                assert (size == (long)portion.length);
                if (size != (long)blockSize) {
                    GridGgfsDataManager.this.processPartialBlockWrite(id, key, block == first ? off : 0, portion);
                    ++writtenTotal;
                } else {
                    nodeBlocks.put(key, portion);
                }
                GridGgfsDataManager.this.metrics.addWriteBlocks(writtenTotal, writtenSecondary);
                written += portion.length;
            }
            if (!nodeBlocks.isEmpty()) {
                GridGgfsDataManager.this.processBatch(id, node, nodeBlocks);
                GridGgfsDataManager.this.metrics.addWriteBlocks(nodeBlocks.size(), 0);
            }
            assert (written == len);
            return null;
        }

        protected abstract void readData(T var1, byte[] var2, int var3) throws GridException;
    }
}

