/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.ggfs;

import java.nio.ByteBuffer;
import org.gridgain.grid.GridException;
import org.gridgain.grid.GridUuid;
import org.gridgain.grid.kernal.GridDirectTransient;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsCommunicationMessage;
import org.gridgain.grid.marshaller.GridMarshaller;
import org.gridgain.grid.util.direct.GridTcpCommunicationMessageAdapter;
import org.gridgain.grid.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class GridGgfsDeleteMessage
extends GridGgfsCommunicationMessage {
    private static final long serialVersionUID = 0L;
    private GridUuid id;
    @GridDirectTransient
    private GridException err;
    private byte[] errBytes;

    public GridGgfsDeleteMessage() {
    }

    public GridGgfsDeleteMessage(GridUuid id) {
        assert (id != null);
        this.id = id;
    }

    public GridGgfsDeleteMessage(GridUuid id, GridException err) {
        assert (err != null);
        this.id = id;
        this.err = err;
    }

    public GridUuid id() {
        return this.id;
    }

    public GridException error() {
        return this.err;
    }

    @Override
    public void prepareMarshal(GridMarshaller marsh) throws GridException {
        super.prepareMarshal(marsh);
        if (this.err != null) {
            this.errBytes = marsh.marshal((Object)this.err);
        }
    }

    @Override
    public void finishUnmarshal(GridMarshaller marsh, @Nullable ClassLoader ldr) throws GridException {
        super.finishUnmarshal(marsh, ldr);
        if (this.errBytes != null) {
            this.err = (GridException)((Object)marsh.unmarshal(this.errBytes, ldr));
        }
    }

    public GridTcpCommunicationMessageAdapter clone() {
        GridGgfsDeleteMessage _clone = new GridGgfsDeleteMessage();
        this.clone0(_clone);
        return _clone;
    }

    @Override
    protected void clone0(GridTcpCommunicationMessageAdapter _msg) {
        super.clone0(_msg);
        GridGgfsDeleteMessage _clone = (GridGgfsDeleteMessage)_msg;
        _clone.id = this.id;
        _clone.err = this.err;
        _clone.errBytes = this.errBytes;
    }

    @Override
    public boolean writeTo(ByteBuffer buf) {
        this.commState.setBuffer(buf);
        if (!super.writeTo(buf)) {
            return false;
        }
        if (!this.commState.typeWritten) {
            if (!this.commState.putByte(this.directType())) {
                return false;
            }
            this.commState.typeWritten = true;
        }
        switch (this.commState.idx) {
            case 0: {
                if (!this.commState.putByteArray(this.errBytes)) {
                    return false;
                }
                ++this.commState.idx;
            }
            case 1: {
                if (!this.commState.putGridUuid(this.id)) {
                    return false;
                }
                ++this.commState.idx;
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf) {
        this.commState.setBuffer(buf);
        if (!super.readFrom(buf)) {
            return false;
        }
        switch (this.commState.idx) {
            case 0: {
                byte[] errBytes0 = this.commState.getByteArray();
                if (errBytes0 == BYTE_ARR_NOT_READ) {
                    return false;
                }
                this.errBytes = errBytes0;
                ++this.commState.idx;
            }
            case 1: {
                GridUuid id0 = this.commState.getGridUuid();
                if (id0 == GRID_UUID_NOT_READ) {
                    return false;
                }
                this.id = id0;
                ++this.commState.idx;
            }
        }
        return true;
    }

    public byte directType() {
        return 68;
    }

    public String toString() {
        return S.toString(GridGgfsDeleteMessage.class, (Object)((Object)this));
    }
}

