/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.ggfs;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gridgain.grid.GridException;
import org.gridgain.grid.GridFutureCancelledException;
import org.gridgain.grid.GridInterruptedException;
import org.gridgain.grid.GridNode;
import org.gridgain.grid.GridUuid;
import org.gridgain.grid.events.GridEvent;
import org.gridgain.grid.events.GridGgfsEvent;
import org.gridgain.grid.kernal.GridTopic;
import org.gridgain.grid.kernal.managers.communication.GridIoPolicy;
import org.gridgain.grid.kernal.managers.eventstorage.GridEventStorageManager;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsCommunicationMessage;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsContext;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsDataManager;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsDeleteMessage;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsFileInfo;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsListingEntry;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsMetaManager;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsThread;
import org.gridgain.grid.logger.GridLogger;
import org.gridgain.grid.util.future.GridCompoundFuture;
import org.gridgain.grid.util.typedef.F;
import org.gridgain.grid.util.typedef.internal.LT;
import org.gridgain.grid.util.typedef.internal.U;

public class GridGgfsDeleteWorker
extends GridGgfsThread {
    private static final long FREQUENCY = 1000L;
    private static final int MAX_DELETE_BATCH = 100;
    private final GridGgfsContext ggfsCtx;
    private final GridGgfsMetaManager meta;
    private final GridGgfsDataManager data;
    private final GridEventStorageManager evts;
    private final GridLogger log;
    private final Lock lock = new ReentrantLock();
    private final Condition cond = this.lock.newCondition();
    private boolean force;
    private volatile boolean cancelled;
    private Object topic;

    GridGgfsDeleteWorker(GridGgfsContext ggfsCtx) {
        super("ggfs-delete-worker%" + ggfsCtx.ggfs().name() + "%" + ggfsCtx.kernalContext().localNodeId() + "%");
        assert (ggfsCtx != null);
        this.ggfsCtx = ggfsCtx;
        this.meta = ggfsCtx.meta();
        this.data = ggfsCtx.data();
        this.evts = ggfsCtx.kernalContext().event();
        String ggfsName = ggfsCtx.ggfs().name();
        Object object = this.topic = F.isEmpty((String)ggfsName) ? GridTopic.TOPIC_GGFS : GridTopic.TOPIC_GGFS.topic(ggfsName);
        assert (this.meta != null);
        assert (this.data != null);
        this.log = ggfsCtx.kernalContext().log(GridGgfsDeleteWorker.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void body() throws InterruptedException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Delete worker started.");
        }
        while (!this.cancelled) {
            this.lock.lock();
            try {
                if (!this.cancelled && !this.force) {
                    this.cond.await(1000L, TimeUnit.MILLISECONDS);
                }
                this.force = false;
            }
            finally {
                this.lock.unlock();
            }
            if (this.cancelled) continue;
            this.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void signal() {
        this.lock.lock();
        try {
            this.force = true;
            this.cond.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    void cancel() {
        this.cancelled = true;
        this.interrupt();
    }

    private void delete() {
        GridGgfsFileInfo info = null;
        try {
            info = this.meta.info(GridGgfsFileInfo.TRASH_ID);
        }
        catch (GridException e) {
            U.error((GridLogger)this.log, (Object)"Cannot obtain trash directory info.", (Throwable)e);
        }
        if (info != null) {
            for (Map.Entry<String, GridGgfsListingEntry> entry : info.listing().entrySet()) {
                GridUuid fileId = entry.getValue().fileId();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Deleting GGFS trash entry [name=" + entry.getKey() + ", fileId=" + fileId + ']');
                }
                try {
                    if (this.cancelled) break;
                    if (!this.delete(entry.getKey(), fileId)) continue;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Sending delete confirmation message [name=" + entry.getKey() + ", fileId=" + fileId + ']');
                    }
                    this.sendDeleteMessage(new GridGgfsDeleteMessage(fileId));
                }
                catch (GridInterruptedException ignored) {
                }
                catch (GridException e) {
                    U.error((GridLogger)this.log, (Object)("Failed to delete entry from the trash directory: " + entry.getKey()), (Throwable)e);
                    this.sendDeleteMessage(new GridGgfsDeleteMessage(fileId, e));
                }
            }
        }
    }

    private boolean delete(String name, GridUuid id) throws GridException {
        GridGgfsFileInfo info;
        assert (name != null);
        assert (id != null);
        while ((info = this.meta.info(id)) != null) {
            if (info.isDirectory()) {
                this.deleteDirectory(GridGgfsFileInfo.TRASH_ID, id);
                if (!this.meta.delete(GridGgfsFileInfo.TRASH_ID, name, id)) continue;
                return true;
            }
            assert (info.isFile());
            this.data.delete(info).get();
            boolean ret = this.meta.delete(GridGgfsFileInfo.TRASH_ID, name, id);
            if (this.evts.isRecordable(127)) {
                if (info.path() != null) {
                    this.evts.record((GridEvent)new GridGgfsEvent(info.path(), this.ggfsCtx.kernalContext().discovery().localNode(), 127));
                } else {
                    LT.warn((GridLogger)this.log, null, (String)("Removing file without path info: " + info));
                }
            }
            return ret;
        }
        return false;
    }

    private void deleteDirectory(GridUuid parentId, GridUuid id) throws GridException {
        GridGgfsFileInfo info;
        assert (parentId != null);
        assert (id != null);
        while ((info = this.meta.info(id)) != null) {
            Map<String, GridGgfsListingEntry> delListing;
            assert (info.isDirectory());
            Map<String, GridGgfsListingEntry> listing = info.listing();
            if (listing.isEmpty()) {
                return;
            }
            if (listing.size() <= 100) {
                delListing = listing;
            } else {
                delListing = new HashMap<String, GridGgfsListingEntry>(100, 1.0f);
                int i = 0;
                for (Map.Entry entry : listing.entrySet()) {
                    delListing.put((String)entry.getKey(), (GridGgfsListingEntry)entry.getValue());
                    if (++i != 100) continue;
                    break;
                }
            }
            GridCompoundFuture fut = new GridCompoundFuture(this.ggfsCtx.kernalContext());
            for (GridGgfsListingEntry gridGgfsListingEntry : delListing.values()) {
                if (!this.cancelled) {
                    if (gridGgfsListingEntry.isDirectory()) {
                        this.deleteDirectory(id, gridGgfsListingEntry.fileId());
                        continue;
                    }
                    GridGgfsFileInfo fileInfo = this.meta.info(gridGgfsListingEntry.fileId());
                    if (fileInfo == null) continue;
                    assert (fileInfo.isFile());
                    fut.add(this.data.delete(fileInfo));
                    continue;
                }
                return;
            }
            fut.markInitialized();
            try {
                fut.get();
            }
            catch (GridFutureCancelledException ignore) {
                this.cancelled = true;
                return;
            }
            Collection<GridUuid> delIds = this.meta.delete(id, delListing);
            if (delListing != listing || delListing.size() != delIds.size()) continue;
            break;
        }
    }

    private void sendDeleteMessage(GridGgfsDeleteMessage msg) {
        assert (msg != null);
        Collection<GridNode> nodes = this.meta.metaCacheNodes();
        boolean first = true;
        for (GridNode node : nodes) {
            GridGgfsDeleteMessage msg0 = first ? msg : (GridGgfsCommunicationMessage)msg.clone();
            first = false;
            try {
                this.ggfsCtx.send(node, this.topic, (GridGgfsCommunicationMessage)msg0, GridIoPolicy.SYSTEM_POOL);
            }
            catch (GridException e) {
                U.warn((GridLogger)this.log, (Object)("Failed to send GGFS delete message to node [nodeId=" + node.id() + ", msg=" + (Object)((Object)msg) + ", err=" + e.getMessage() + ']'));
            }
        }
    }
}

