/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.ggfs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.gridgain.grid.GridUuid;
import org.gridgain.grid.util.direct.GridTcpCommunicationMessageAdapter;
import org.gridgain.grid.util.typedef.F;
import org.gridgain.grid.util.typedef.internal.S;
import org.gridgain.grid.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class GridGgfsFileAffinityRange
extends GridTcpCommunicationMessageAdapter
implements Externalizable {
    private static final long serialVersionUID = 0L;
    public static final int RANGE_STATUS_INITIAL = 0;
    public static final int RANGE_STATUS_MOVING = 1;
    public static final int RANGE_STATUS_MOVED = 2;
    private GridUuid affKey;
    private int status = 0;
    private long startOff;
    private long endOff;
    private boolean done;

    public GridGgfsFileAffinityRange() {
    }

    GridGgfsFileAffinityRange(long startOff, long endOff, GridUuid affKey) {
        this.startOff = startOff;
        this.endOff = endOff;
        this.affKey = affKey;
    }

    GridGgfsFileAffinityRange(GridGgfsFileAffinityRange other, int status) {
        this.startOff = other.startOff;
        this.endOff = other.endOff;
        this.affKey = other.affKey;
        this.status = status;
    }

    public GridUuid affinityKey() {
        return this.affKey;
    }

    public long startOffset() {
        return this.startOff;
    }

    public long endOffset() {
        return this.endOff;
    }

    public boolean belongs(long blockStartOff) {
        return blockStartOff >= this.startOff && blockStartOff < this.endOff;
    }

    public boolean less(long blockStartOff) {
        return blockStartOff < this.startOff;
    }

    public boolean greater(long blockStartOff) {
        return blockStartOff > this.endOff;
    }

    public boolean empty() {
        return this.startOff == this.endOff;
    }

    public int status() {
        return this.status;
    }

    public void expand(long blockStartOff, int expansionSize) {
        if (this.endOff == this.startOff) {
            assert (this.endOff == blockStartOff) : "Failed to expand range [endOff=" + this.endOff + ", blockStartOff=" + blockStartOff + ", expansionSize=" + expansionSize + ']';
            this.endOff += (long)(expansionSize - 1);
        } else {
            assert (this.endOff == blockStartOff - 1L);
            this.endOff += (long)expansionSize;
        }
    }

    public Collection<GridGgfsFileAffinityRange> split(long maxSize) {
        long len = this.endOff - this.startOff + 1L;
        if (len > maxSize) {
            int size = (int)(len / maxSize + 1L);
            ArrayList<GridGgfsFileAffinityRange> res = new ArrayList<GridGgfsFileAffinityRange>(size);
            long pos = this.startOff;
            while (pos < this.endOff + 1L) {
                long end = Math.min(pos + maxSize - 1L, this.endOff);
                GridGgfsFileAffinityRange part = new GridGgfsFileAffinityRange(pos, end, this.affKey);
                part.status = this.status;
                res.add(part);
                pos = end + 1L;
            }
            return res;
        }
        return Collections.singletonList(this);
    }

    @Nullable
    public GridGgfsFileAffinityRange concat(GridGgfsFileAffinityRange range) {
        if (this.endOff + 1L != range.startOff || !F.eq((Object)this.affKey, (Object)range.affKey) || this.status != 0) {
            return null;
        }
        return new GridGgfsFileAffinityRange(this.startOff, range.endOff, this.affKey);
    }

    public void markDone() {
        this.done = true;
    }

    public boolean done() {
        return this.done;
    }

    public boolean regionEqual(GridGgfsFileAffinityRange other) {
        return this.startOff == other.startOff && this.endOff == other.endOff;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeGridUuid((DataOutput)out, (GridUuid)this.affKey);
        out.writeInt(this.status);
        out.writeLong(this.startOff);
        out.writeLong(this.endOff);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.affKey = U.readGridUuid((DataInput)in);
        this.status = in.readInt();
        this.startOff = in.readLong();
        this.endOff = in.readLong();
    }

    public GridTcpCommunicationMessageAdapter clone() {
        GridGgfsFileAffinityRange _clone = new GridGgfsFileAffinityRange();
        this.clone0(_clone);
        return _clone;
    }

    protected void clone0(GridTcpCommunicationMessageAdapter _msg) {
        GridGgfsFileAffinityRange _clone = (GridGgfsFileAffinityRange)_msg;
        _clone.affKey = this.affKey;
        _clone.status = this.status;
        _clone.startOff = this.startOff;
        _clone.endOff = this.endOff;
        _clone.done = this.done;
    }

    public boolean writeTo(ByteBuffer buf) {
        this.commState.setBuffer(buf);
        if (!this.commState.typeWritten) {
            if (!this.commState.putByte(this.directType())) {
                return false;
            }
            this.commState.typeWritten = true;
        }
        switch (this.commState.idx) {
            case 0: {
                if (!this.commState.putGridUuid(this.affKey)) {
                    return false;
                }
                ++this.commState.idx;
            }
            case 1: {
                if (!this.commState.putBoolean(this.done)) {
                    return false;
                }
                ++this.commState.idx;
            }
            case 2: {
                if (!this.commState.putLong(this.endOff)) {
                    return false;
                }
                ++this.commState.idx;
            }
            case 3: {
                if (!this.commState.putLong(this.startOff)) {
                    return false;
                }
                ++this.commState.idx;
            }
            case 4: {
                if (!this.commState.putInt(this.status)) {
                    return false;
                }
                ++this.commState.idx;
            }
        }
        return true;
    }

    public boolean readFrom(ByteBuffer buf) {
        this.commState.setBuffer(buf);
        switch (this.commState.idx) {
            case 0: {
                GridUuid affKey0 = this.commState.getGridUuid();
                if (affKey0 == GRID_UUID_NOT_READ) {
                    return false;
                }
                this.affKey = affKey0;
                ++this.commState.idx;
            }
            case 1: {
                if (buf.remaining() < 1) {
                    return false;
                }
                this.done = this.commState.getBoolean();
                ++this.commState.idx;
            }
            case 2: {
                if (buf.remaining() < 8) {
                    return false;
                }
                this.endOff = this.commState.getLong();
                ++this.commState.idx;
            }
            case 3: {
                if (buf.remaining() < 8) {
                    return false;
                }
                this.startOff = this.commState.getLong();
                ++this.commState.idx;
            }
            case 4: {
                if (buf.remaining() < 4) {
                    return false;
                }
                this.status = this.commState.getInt();
                ++this.commState.idx;
            }
        }
        return true;
    }

    public byte directType() {
        return 69;
    }

    public String toString() {
        return S.toString(GridGgfsFileAffinityRange.class, (Object)this);
    }
}

