/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.ggfs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Map;
import org.gridgain.grid.GridUuid;
import org.gridgain.grid.ggfs.GridGgfsFile;
import org.gridgain.grid.ggfs.GridGgfsPath;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsFileInfo;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsListingEntry;
import org.gridgain.grid.util.typedef.internal.A;
import org.gridgain.grid.util.typedef.internal.S;
import org.gridgain.grid.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public final class GridGgfsFileImpl
implements GridGgfsFile,
Externalizable {
    private static final long serialVersionUID = 0L;
    private GridGgfsPath path;
    private GridUuid fileId;
    private int blockSize;
    private long grpBlockSize;
    private long len;
    private long accessTime;
    private long modificationTime;
    private Map<String, String> props;

    public GridGgfsFileImpl() {
    }

    public GridGgfsFileImpl(GridGgfsPath path, GridGgfsFileInfo info, long globalGrpBlockSize) {
        A.notNull((Object)path, (String)"path");
        A.notNull((Object)info, (String)"info");
        this.path = path;
        this.fileId = info.id();
        if (info.isFile()) {
            this.blockSize = info.blockSize();
            this.len = info.length();
            this.grpBlockSize = info.affinityKey() == null ? globalGrpBlockSize : (info.length() == 0L ? globalGrpBlockSize : info.length());
        }
        this.props = info.properties();
        if (this.props == null) {
            this.props = Collections.emptyMap();
        }
        this.accessTime = info.accessTime();
        this.modificationTime = info.modificationTime();
    }

    public GridGgfsFileImpl(GridGgfsPath path, GridGgfsListingEntry entry, long globalGrpSize) {
        A.notNull((Object)path, (String)"path");
        A.notNull((Object)entry, (String)"entry");
        this.path = path;
        this.fileId = entry.fileId();
        this.blockSize = entry.blockSize();
        this.grpBlockSize = entry.affinityKey() == null ? globalGrpSize : (entry.length() == 0L ? globalGrpSize : entry.length());
        this.len = entry.length();
        this.props = entry.properties();
        this.accessTime = entry.accessTime();
        this.modificationTime = entry.modificationTime();
    }

    public GridGgfsPath path() {
        return this.path;
    }

    public GridUuid fileId() {
        return this.fileId;
    }

    public boolean isFile() {
        return this.blockSize > 0;
    }

    public boolean isDirectory() {
        return this.blockSize == 0;
    }

    public long length() {
        return this.len;
    }

    public int blockSize() {
        return this.blockSize;
    }

    public long groupBlockSize() {
        return this.grpBlockSize;
    }

    public long accessTime() {
        return this.accessTime;
    }

    public long modificationTime() {
        return this.modificationTime;
    }

    public String property(String name) throws IllegalArgumentException {
        String val = this.props.get(name);
        if (val == null) {
            throw new IllegalArgumentException("File property not found [path=" + this.path + ", name=" + name + ']');
        }
        return val;
    }

    public String property(String name, @Nullable String dfltVal) {
        String val = this.props.get(name);
        return val == null ? dfltVal : val;
    }

    public Map<String, String> properties() {
        return this.props;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.path.writeExternal(out);
        out.writeInt(this.blockSize);
        out.writeLong(this.grpBlockSize);
        out.writeLong(this.len);
        U.writeStringMap((DataOutput)out, this.props);
        out.writeLong(this.accessTime);
        out.writeLong(this.modificationTime);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.path = new GridGgfsPath();
        this.path.readExternal(in);
        this.blockSize = in.readInt();
        this.grpBlockSize = in.readLong();
        this.len = in.readLong();
        this.props = U.readStringMap((DataInput)in);
        this.accessTime = in.readLong();
        this.modificationTime = in.readLong();
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GridGgfsFileImpl that = (GridGgfsFileImpl)o;
        return this.path.equals((Object)that.path);
    }

    public String toString() {
        return S.toString(GridGgfsFileImpl.class, (Object)this);
    }
}

