/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.ggfs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.gridgain.grid.GridUuid;
import org.gridgain.grid.ggfs.GridGgfsPath;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsFileMap;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsListingEntry;
import org.gridgain.grid.util.GridLeanMap;
import org.gridgain.grid.util.tostring.GridToStringInclude;
import org.gridgain.grid.util.typedef.F;
import org.gridgain.grid.util.typedef.internal.S;
import org.gridgain.grid.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public final class GridGgfsFileInfo
implements Externalizable {
    private static final long serialVersionUID = 0L;
    public static final GridUuid ROOT_ID = new GridUuid(new UUID(0L, 0L), 0L);
    public static final GridUuid TRASH_ID = new GridUuid(new UUID(0L, 1L), 0L);
    private GridUuid id;
    private long len;
    private int blockSize;
    private Map<String, String> props;
    private GridUuid lockId;
    private GridUuid affKey;
    private GridGgfsFileMap fileMap;
    private long accessTime;
    private long modificationTime;
    @GridToStringInclude
    private Map<String, GridGgfsListingEntry> listing;
    private boolean evictExclude;
    private GridGgfsPath path;

    public GridGgfsFileInfo() {
        this(ROOT_ID);
    }

    GridGgfsFileInfo(GridUuid id) {
        this(true, id, 0, 0L, null, null, null, null, false, System.currentTimeMillis(), false);
    }

    GridGgfsFileInfo(boolean isDir, @Nullable Map<String, String> props) {
        this(isDir, null, isDir ? 0 : 65536, 0L, null, null, props, null, false, System.currentTimeMillis(), false);
    }

    GridGgfsFileInfo(Map<String, GridGgfsListingEntry> listing) {
        this(true, null, 0, 0L, null, listing, null, null, false, System.currentTimeMillis(), false);
    }

    GridGgfsFileInfo(int blockSize, @Nullable GridUuid affKey, boolean evictExclude, @Nullable Map<String, String> props) {
        this(false, null, blockSize, 0L, affKey, null, props, null, true, System.currentTimeMillis(), evictExclude);
    }

    GridGgfsFileInfo(int blockSize, long len, @Nullable GridUuid affKey, @Nullable GridUuid lockId, boolean evictExclude, @Nullable Map<String, String> props) {
        this(false, null, blockSize, len, affKey, null, props, lockId, true, System.currentTimeMillis(), evictExclude);
    }

    GridGgfsFileInfo(GridGgfsFileInfo info, long len) {
        this(info.isDirectory(), info.id, info.blockSize, len, info.affKey, info.listing, info.props, info.fileMap(), info.lockId, true, info.accessTime, info.modificationTime, info.evictExclude());
    }

    GridGgfsFileInfo(GridGgfsFileInfo info, long accessTime, long modificationTime) {
        this(info.isDirectory(), info.id, info.blockSize, info.len, info.affKey, info.listing, info.props, info.fileMap(), info.lockId, false, accessTime, modificationTime, info.evictExclude());
    }

    GridGgfsFileInfo(GridGgfsFileInfo info, @Nullable Map<String, String> props) {
        this(info.isDirectory(), info.id, info.blockSize, info.len, info.affKey, info.listing, props, info.fileMap(), info.lockId, true, info.accessTime, info.modificationTime, info.evictExclude());
    }

    GridGgfsFileInfo(int blockSize, long len, boolean evictExclude, @Nullable Map<String, String> props) {
        this(false, null, blockSize, len, null, null, props, null, true, System.currentTimeMillis(), evictExclude);
    }

    GridGgfsFileInfo(GridGgfsFileInfo info, @Nullable GridUuid lockId, long modificationTime) {
        this(info.isDirectory(), info.id, info.blockSize, info.len, info.affKey, info.listing, info.props, info.fileMap(), lockId, true, info.accessTime, modificationTime, info.evictExclude());
    }

    GridGgfsFileInfo(Map<String, GridGgfsListingEntry> listing, GridGgfsFileInfo old) {
        this(old.isDirectory(), old.id, old.blockSize, old.len, old.affKey, listing, old.props, old.fileMap(), old.lockId, false, old.accessTime, old.modificationTime, old.evictExclude());
    }

    private GridGgfsFileInfo(boolean isDir, @Nullable GridUuid id, int blockSize, long len, @Nullable GridUuid affKey, @Nullable Map<String, GridGgfsListingEntry> listing, @Nullable Map<String, String> props, @Nullable GridUuid lockId, boolean cpProps, long modificationTime, boolean evictExclude) {
        this(isDir, id, blockSize, len, affKey, listing, props, null, lockId, cpProps, modificationTime, modificationTime, evictExclude);
    }

    private GridGgfsFileInfo(boolean isDir, @Nullable GridUuid id, int blockSize, long len, @Nullable GridUuid affKey, @Nullable Map<String, GridGgfsListingEntry> listing, @Nullable Map<String, String> props, @Nullable GridGgfsFileMap fileMap, @Nullable GridUuid lockId, boolean cpProps, long accessTime, long modificationTime, boolean evictExclude) {
        assert (F.isEmpty(listing) || isDir);
        if (isDir) {
            assert (len == 0L) : "Directory length should be zero: " + len;
            assert (blockSize == 0) : "Directory block size should be zero: " + blockSize;
        } else {
            assert (len >= 0L) : "File length cannot be negative: " + len;
            assert (blockSize > 0) : "File block size should be positive: " + blockSize;
        }
        this.id = id == null ? GridUuid.randomUuid() : id;
        this.len = isDir ? 0L : len;
        this.blockSize = isDir ? 0 : blockSize;
        this.affKey = affKey;
        this.listing = listing;
        if (fileMap == null && !isDir) {
            fileMap = new GridGgfsFileMap();
        }
        this.fileMap = fileMap;
        this.accessTime = accessTime;
        this.modificationTime = modificationTime;
        Object object = props == null || props.isEmpty() ? null : (this.props = cpProps ? new GridLeanMap((Map)props) : props);
        if (listing == null && isDir) {
            this.listing = Collections.emptyMap();
        }
        this.lockId = lockId;
        this.evictExclude = evictExclude;
    }

    public GridGgfsFileInfo(GridGgfsFileInfo info) {
        this(info.isDirectory(), info.id, info.blockSize, info.len, info.affKey, info.listing, info.props, info.fileMap(), info.lockId, true, info.accessTime, info.modificationTime, info.evictExclude());
    }

    public static Builder builder() {
        return new Builder(new GridGgfsFileInfo());
    }

    public static Builder builder(GridGgfsFileInfo origin) {
        return new Builder(new GridGgfsFileInfo(origin));
    }

    public GridUuid id() {
        return this.id;
    }

    public boolean isFile() {
        return this.blockSize > 0;
    }

    public boolean isDirectory() {
        return this.blockSize == 0;
    }

    public long length() {
        assert (this.isFile());
        return this.len;
    }

    public int blockSize() {
        assert (this.isFile());
        return this.blockSize;
    }

    public long blocksCount() {
        assert (this.isFile());
        return (this.len + (long)this.blockSize() - 1L) / (long)this.blockSize();
    }

    public long accessTime() {
        return this.accessTime;
    }

    public long modificationTime() {
        return this.modificationTime;
    }

    public Map<String, GridGgfsListingEntry> listing() {
        if (this.isFile()) {
            return Collections.unmodifiableMap(Collections.emptyMap());
        }
        assert (this.listing != null);
        return Collections.unmodifiableMap(this.listing);
    }

    @Nullable
    public GridUuid affinityKey() {
        return this.affKey;
    }

    public void affinityKey(GridUuid affKey) {
        this.affKey = affKey;
    }

    public GridGgfsFileMap fileMap() {
        return this.fileMap;
    }

    public void fileMap(GridGgfsFileMap fileMap) {
        this.fileMap = fileMap;
    }

    public Map<String, String> properties() {
        return this.props == null || this.props.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(this.props);
    }

    @Nullable
    public GridUuid lockId() {
        return this.lockId;
    }

    public boolean evictExclude() {
        return this.evictExclude;
    }

    public GridGgfsPath path() {
        return this.path;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeGridUuid((DataOutput)out, (GridUuid)this.id);
        out.writeInt(this.blockSize);
        out.writeLong(this.len);
        U.writeStringMap((DataOutput)out, this.props);
        U.writeGridUuid((DataOutput)out, (GridUuid)this.lockId);
        U.writeGridUuid((DataOutput)out, (GridUuid)this.affKey);
        out.writeObject(this.listing);
        out.writeObject(this.fileMap);
        out.writeLong(this.accessTime);
        out.writeLong(this.modificationTime);
        out.writeBoolean(this.evictExclude);
        out.writeObject(this.path);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = U.readGridUuid((DataInput)in);
        this.blockSize = in.readInt();
        this.len = in.readLong();
        this.props = U.readStringMap((DataInput)in);
        this.lockId = U.readGridUuid((DataInput)in);
        this.affKey = U.readGridUuid((DataInput)in);
        this.listing = (Map)in.readObject();
        this.fileMap = (GridGgfsFileMap)in.readObject();
        this.accessTime = in.readLong();
        this.modificationTime = in.readLong();
        this.evictExclude = in.readBoolean();
        this.path = (GridGgfsPath)in.readObject();
    }

    public int hashCode() {
        return this.id.hashCode() ^ this.blockSize ^ (int)(this.len ^ this.len >>> 32) ^ (this.props == null ? 0 : this.props.hashCode()) ^ (this.lockId == null ? 0 : this.lockId.hashCode());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GridGgfsFileInfo that = (GridGgfsFileInfo)obj;
        return this.id.equals((Object)that.id) && this.blockSize == that.blockSize && this.len == that.len && F.eq((Object)this.affKey, (Object)that.affKey) && F.eq(this.props, that.props) && F.eq((Object)this.lockId, (Object)that.lockId);
    }

    public String toString() {
        return S.toString(GridGgfsFileInfo.class, (Object)this);
    }

    public static class Builder {
        private final GridGgfsFileInfo info;

        private Builder(GridGgfsFileInfo info) {
            this.info = info;
        }

        public Builder path(GridGgfsPath path) {
            this.info.path = path;
            return this;
        }

        public GridGgfsFileInfo build() {
            return this.info;
        }
    }
}

