/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.ggfs;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsFileWorkerBatch;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsThread;

public class GridGgfsFileWorker
extends GridGgfsThread {
    private static final long THREAD_REUSE_WAIT_TIME = 5000L;
    private final Lock lock = new ReentrantLock();
    private final Condition cond = this.lock.newCondition();
    private GridGgfsFileWorkerBatch nextBatch;
    private GridGgfsFileWorkerBatch curBatch;
    private volatile boolean cancelled;

    GridGgfsFileWorker(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addBatch(GridGgfsFileWorkerBatch batch) {
        assert (batch != null);
        this.lock.lock();
        try {
            if (!this.cancelled) {
                assert (this.nextBatch == null);
                this.nextBatch = batch;
                this.cond.signalAll();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void body() throws InterruptedException {
        while (!this.cancelled) {
            this.lock.lock();
            try {
                if (!this.cancelled && this.nextBatch == null) {
                    this.cond.await(5000L, TimeUnit.MILLISECONDS);
                }
                this.curBatch = this.nextBatch;
                this.nextBatch = null;
                if (this.cancelled && this.curBatch != null) {
                    this.curBatch.finish();
                }
            }
            finally {
                this.lock.unlock();
            }
            if (this.curBatch != null) {
                this.curBatch.process();
                continue;
            }
            this.lock.lock();
            try {
                if (this.nextBatch != null) continue;
                this.cancelled = true;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    protected void cleanup() {
        assert (this.cancelled);
        boolean interrupted = GridGgfsFileWorker.interrupted();
        if (this.nextBatch != null) {
            this.nextBatch.process();
        }
        this.onFinish();
        if (interrupted) {
            this.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancel() {
        this.lock.lock();
        try {
            this.cancelled = true;
            if (this.curBatch != null) {
                this.curBatch.finish();
            }
            if (this.nextBatch != null) {
                this.nextBatch.finish();
            }
            this.cond.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GridGgfsFileWorkerBatch currentBatch() {
        this.lock.lock();
        try {
            GridGgfsFileWorkerBatch gridGgfsFileWorkerBatch = this.nextBatch == null ? this.curBatch : this.nextBatch;
            return gridGgfsFileWorkerBatch;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void onFinish() {
    }
}

