/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.ggfs;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.gridgain.grid.GridException;
import org.gridgain.grid.GridInterruptedException;
import org.gridgain.grid.ggfs.GridGgfsPath;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsFileWorkerTask;
import org.gridgain.grid.util.typedef.internal.U;

public class GridGgfsFileWorkerBatch {
    private final CountDownLatch completeLatch = new CountDownLatch(1);
    private final AtomicBoolean finishGuard = new AtomicBoolean();
    private final ReadWriteLock finishLock = new ReentrantReadWriteLock();
    private final BlockingDeque<GridGgfsFileWorkerTask> queue = new LinkedBlockingDeque<GridGgfsFileWorkerTask>();
    private final GridGgfsPath path;
    private final FSDataOutputStream out;
    private volatile GridException err;
    private boolean lastTask;

    GridGgfsFileWorkerBatch(GridGgfsPath path, FSDataOutputStream out) {
        assert (path != null);
        assert (out != null);
        this.path = path;
        this.out = out;
    }

    boolean write(final byte[] data) {
        return this.addTask(new GridGgfsFileWorkerTask(){

            @Override
            public void execute() throws GridException {
                try {
                    GridGgfsFileWorkerBatch.this.out.write(data);
                }
                catch (IOException e) {
                    throw new GridException("Failed to write data to the file due to secondary file system exception: " + GridGgfsFileWorkerBatch.this.path, (Throwable)e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void process() {
        try {
            boolean cancelled = false;
            while (!cancelled) {
                try {
                    GridGgfsFileWorkerTask task = this.queue.poll(1000L, TimeUnit.MILLISECONDS);
                    if (task == null) continue;
                    task.execute();
                    if (!this.lastTask) continue;
                    cancelled = true;
                }
                catch (GridException e) {
                    this.err = e;
                    cancelled = true;
                }
                catch (InterruptedException ignore) {
                    Thread.currentThread().interrupt();
                    cancelled = true;
                }
            }
        }
        finally {
            try {
                this.onComplete();
            }
            finally {
                U.closeQuiet((Closeable)this.out);
                this.completeLatch.countDown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finish() {
        if (this.finishGuard.compareAndSet(false, true)) {
            this.finishLock.writeLock().lock();
            try {
                this.queue.add(new GridGgfsFileWorkerTask(){

                    @Override
                    public void execute() {
                        assert (GridGgfsFileWorkerBatch.this.queue.isEmpty());
                        GridGgfsFileWorkerBatch.this.lastTask = true;
                    }
                });
            }
            finally {
                this.finishLock.writeLock().unlock();
            }
        }
    }

    void await() throws GridException {
        try {
            this.completeLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new GridInterruptedException(e);
        }
        GridException err0 = this.err;
        if (err0 != null) {
            throw err0;
        }
    }

    void awaitIfFinished() throws GridException {
        if (this.finishGuard.get()) {
            this.await();
        }
    }

    GridGgfsPath path() {
        return this.path;
    }

    protected void onComplete() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean addTask(GridGgfsFileWorkerTask task) {
        this.finishLock.readLock().lock();
        try {
            if (!this.finishGuard.get()) {
                try {
                    this.queue.put(task);
                    boolean bl = true;
                    return bl;
                }
                catch (InterruptedException ignore) {
                    Thread.currentThread().interrupt();
                    boolean bl = false;
                    this.finishLock.readLock().unlock();
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.finishLock.readLock().unlock();
        }
    }
}

