/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.ggfs;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gridgain.grid.GridException;
import org.gridgain.grid.GridInterruptedException;
import org.gridgain.grid.GridNode;
import org.gridgain.grid.GridRuntimeException;
import org.gridgain.grid.GridTopologyException;
import org.gridgain.grid.GridUuid;
import org.gridgain.grid.events.GridDiscoveryEvent;
import org.gridgain.grid.events.GridEvent;
import org.gridgain.grid.kernal.GridTopic;
import org.gridgain.grid.kernal.managers.communication.GridIoPolicy;
import org.gridgain.grid.kernal.managers.communication.GridMessageListener;
import org.gridgain.grid.kernal.managers.eventstorage.GridLocalEventListener;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsCommunicationMessage;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsFileAffinityRange;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsFileInfo;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsFileMap;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsFragmentizerRequest;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsFragmentizerResponse;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsInvalidRangeException;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsManager;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsSyncMessage;
import org.gridgain.grid.lang.GridBiTuple;
import org.gridgain.grid.lang.GridClosure;
import org.gridgain.grid.lang.GridPredicate;
import org.gridgain.grid.logger.GridLogger;
import org.gridgain.grid.thread.GridThread;
import org.gridgain.grid.util.GridConcurrentHashSet;
import org.gridgain.grid.util.GridSpinReadWriteLock;
import org.gridgain.grid.util.typedef.CX1;
import org.gridgain.grid.util.typedef.F;
import org.gridgain.grid.util.typedef.P1;
import org.gridgain.grid.util.typedef.X;
import org.gridgain.grid.util.typedef.internal.LT;
import org.gridgain.grid.util.typedef.internal.U;
import org.gridgain.grid.util.worker.GridWorker;
import org.jetbrains.annotations.Nullable;

public class GridGgfsFragmentizerManager
extends GridGgfsManager {
    private static final int MSG_OFFER_TIMEOUT = 1000;
    private static final int FRAGMENTIZER_CHECK_INTERVAL = 3000;
    private static final int MESSAGE_SEND_RETRY_INTERVAL = 1000;
    private static final int MESSAGE_SEND_RETRY_COUNT = 3;
    private volatile boolean stopping;
    private volatile FragmentizerCoordinator fragmentizerCrd;
    private volatile boolean fragmentizerEnabled = true;
    private FragmentizerWorker fragmentizerWorker;
    private GridSpinReadWriteLock rw = new GridSpinReadWriteLock();
    private Object topic;

    @Override
    protected void start0() throws GridException {
        if (!this.ggfsCtx.configuration().isFragmentizerEnabled()) {
            return;
        }
        this.ggfsCtx.kernalContext().event().addLocalEventListener(new GridLocalEventListener(){

            public void onEvent(GridEvent evt) {
                assert (evt.type() == 11 || evt.type() == 12);
                GridDiscoveryEvent discoEvt = (GridDiscoveryEvent)evt;
                GridGgfsFragmentizerManager.this.checkLaunchCoordinator(discoEvt);
            }
        }, 11, new int[]{12});
        this.fragmentizerWorker = new FragmentizerWorker();
        String ggfsName = this.ggfsCtx.configuration().getName();
        this.topic = F.isEmpty((String)ggfsName) ? GridTopic.TOPIC_GGFS : GridTopic.TOPIC_GGFS.topic(ggfsName);
        this.ggfsCtx.kernalContext().io().addMessageListener(this.topic, (GridMessageListener)this.fragmentizerWorker);
        new GridThread((GridWorker)this.fragmentizerWorker).start();
    }

    @Override
    protected void onKernalStart0() throws GridException {
        if (this.ggfsCtx.configuration().isFragmentizerEnabled()) {
            GridDiscoveryEvent locJoinEvt = this.ggfsCtx.kernalContext().discovery().localJoinEvent();
            this.checkLaunchCoordinator(locJoinEvt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onKernalStop0(boolean cancel) {
        boolean interrupted = false;
        while (true) {
            try {
                while (!this.rw.tryWriteLock(200L, TimeUnit.MILLISECONDS)) {
                    Thread.sleep(200L);
                }
            }
            catch (InterruptedException ignore) {
                interrupted = true;
                continue;
            }
            break;
        }
        try {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            this.stopping = true;
        }
        finally {
            this.rw.writeUnlock();
        }
        GridGgfsFragmentizerManager gridGgfsFragmentizerManager = this;
        synchronized (gridGgfsFragmentizerManager) {
            if (this.fragmentizerCrd != null) {
                this.fragmentizerCrd.cancel();
            }
        }
        if (this.fragmentizerWorker != null) {
            this.fragmentizerWorker.cancel();
        }
        U.join((GridWorker)this.fragmentizerCrd, (GridLogger)this.log);
        U.join((GridWorker)this.fragmentizerWorker, (GridLogger)this.log);
    }

    private void sendWithRetries(UUID nodeId, GridGgfsCommunicationMessage msg) throws GridException {
        for (int i = 0; i < 3; ++i) {
            try {
                this.ggfsCtx.send(nodeId, this.topic, msg, GridIoPolicy.SYSTEM_POOL);
                return;
            }
            catch (GridException e) {
                if (!this.ggfsCtx.kernalContext().discovery().alive(nodeId)) {
                    throw new GridTopologyException("Failed to send message (node left the grid) [nodeId=" + nodeId + ", msg=" + (Object)((Object)msg) + ']');
                }
                if (i == 2) {
                    throw e;
                }
                U.sleep((long)1000L);
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkLaunchCoordinator(GridDiscoveryEvent discoEvt) {
        block11: {
            this.rw.readLock();
            try {
                if (this.stopping) {
                    return;
                }
                if (this.fragmentizerCrd != null) break block11;
                long minNodeOrder = Long.MAX_VALUE;
                Collection nodes = discoEvt.topologyNodes();
                for (GridNode node : nodes) {
                    if (node.order() >= minNodeOrder || !this.ggfsCtx.ggfsNode(node)) continue;
                    minNodeOrder = node.order();
                }
                GridNode locNode = this.ggfsCtx.kernalContext().grid().localNode();
                if (locNode.order() != minNodeOrder) break block11;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Detected local node to be the eldest GGFS node in topology, starting fragmentizer coordinator thread [discoEvt=" + discoEvt + ", locNode=" + locNode + ']');
                }
                GridGgfsFragmentizerManager gridGgfsFragmentizerManager = this;
                synchronized (gridGgfsFragmentizerManager) {
                    if (this.fragmentizerCrd == null && !this.stopping) {
                        this.fragmentizerCrd = new FragmentizerCoordinator();
                        new GridThread((GridWorker)this.fragmentizerCrd).start();
                    }
                }
            }
            finally {
                this.rw.readUnlock();
            }
        }
    }

    private void processFragmentizerRequest(GridGgfsFragmentizerRequest req) throws GridException {
        req.finishUnmarshal(this.ggfsCtx.kernalContext().config().getMarshaller(), null);
        Collection<GridGgfsFileAffinityRange> ranges = req.fragmentRanges();
        GridUuid fileId = req.fileId();
        GridGgfsFileInfo fileInfo = this.ggfsCtx.meta().info(fileId);
        if (fileInfo == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Failed to find file info for fragmentizer request: " + (Object)((Object)req));
            }
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Moving file ranges for fragmentizer request [req=" + (Object)((Object)req) + ", fileInfo=" + fileInfo + ']');
        }
        for (GridGgfsFileAffinityRange range : ranges) {
            try {
                switch (range.status()) {
                    case 0: {
                        GridGgfsFileInfo updated = this.ggfsCtx.meta().updateInfo(fileId, this.updateRange(range, 1));
                        if (updated == null) {
                            this.ggfsCtx.data().cleanBlocks(fileInfo, range, true);
                            break;
                        }
                    }
                    case 1: {
                        this.ggfsCtx.data().spreadBlocks(fileInfo, range);
                        GridGgfsFileInfo updated = this.ggfsCtx.meta().updateInfo(fileId, this.updateRange(range, 2));
                        if (updated == null) {
                            this.ggfsCtx.data().cleanBlocks(fileInfo, range, true);
                            break;
                        }
                    }
                    case 2: {
                        this.ggfsCtx.data().cleanBlocks(fileInfo, range, false);
                        GridGgfsFileInfo updated = this.ggfsCtx.meta().updateInfo(fileId, this.deleteRange(range));
                        if (updated != null) break;
                        this.ggfsCtx.data().cleanBlocks(fileInfo, range, true);
                    }
                }
            }
            catch (GridGgfsInvalidRangeException e) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Failed to update file range [range=" + range + "fileId=" + fileId + ", err=" + e.getMessage() + ']');
            }
        }
    }

    private GridClosure<GridGgfsFileInfo, GridGgfsFileInfo> updateRange(final GridGgfsFileAffinityRange range, final int status) {
        return new CX1<GridGgfsFileInfo, GridGgfsFileInfo>(){

            public GridGgfsFileInfo applyx(GridGgfsFileInfo info) throws GridException {
                GridGgfsFileMap map = new GridGgfsFileMap(info.fileMap());
                map.updateRangeStatus(range, status);
                if (GridGgfsFragmentizerManager.this.log.isDebugEnabled()) {
                    GridGgfsFragmentizerManager.this.log.debug("Updated file map for range [fileId=" + info.id() + ", range=" + range + ", status=" + status + ", oldMap=" + info.fileMap() + ", newMap=" + map + ']');
                }
                GridGgfsFileInfo updated = new GridGgfsFileInfo(info, info.length());
                updated.fileMap(map);
                return updated;
            }
        };
    }

    private GridClosure<GridGgfsFileInfo, GridGgfsFileInfo> deleteRange(final GridGgfsFileAffinityRange range) {
        return new CX1<GridGgfsFileInfo, GridGgfsFileInfo>(){

            public GridGgfsFileInfo applyx(GridGgfsFileInfo info) throws GridException {
                GridGgfsFileMap map = new GridGgfsFileMap(info.fileMap());
                map.deleteRange(range);
                if (GridGgfsFragmentizerManager.this.log.isDebugEnabled()) {
                    GridGgfsFragmentizerManager.this.log.debug("Deleted range from file map [fileId=" + info.id() + ", range=" + range + ", oldMap=" + info.fileMap() + ", newMap=" + map + ']');
                }
                GridGgfsFileInfo updated = new GridGgfsFileInfo(info, info.length());
                updated.fileMap(map);
                return updated;
            }
        };
    }

    @Nullable
    private GridGgfsFileInfo fileForFragmentizer(Collection<GridUuid> exclude) throws GridException {
        return this.fragmentizerEnabled ? this.ggfsCtx.meta().fileForFragmentizer(exclude) : null;
    }

    private static class IdentityHashSet
    extends GridConcurrentHashSet<UUID> {
        private static final long serialVersionUID = 0L;

        private IdentityHashSet(Collection<UUID> c) {
            super(c);
        }

        public boolean equals(Object o) {
            return this == o;
        }
    }

    private class FragmentizerWorker
    extends GridWorker
    implements GridMessageListener {
        private BlockingQueue<GridBiTuple<UUID, GridGgfsCommunicationMessage>> msgs;

        protected FragmentizerWorker() {
            super(GridGgfsFragmentizerManager.this.ggfsCtx.kernalContext().gridName(), "fragmentizer-worker", GridGgfsFragmentizerManager.this.ggfsCtx.kernalContext().log());
            this.msgs = new LinkedBlockingDeque<GridBiTuple<UUID, GridGgfsCommunicationMessage>>();
        }

        public void onMessage(UUID nodeId, Object msg) {
            if (msg instanceof GridGgfsFragmentizerRequest || msg instanceof GridGgfsSyncMessage) {
                if (log.isDebugEnabled()) {
                    log.debug("Received fragmentizer request from remote node [nodeId=" + nodeId + ", msg=" + msg + ']');
                }
                GridBiTuple tup = F.t((Object)nodeId, (Object)((Object)((GridGgfsCommunicationMessage)((Object)msg))));
                try {
                    if (!this.msgs.offer((GridBiTuple<UUID, GridGgfsCommunicationMessage>)tup, 1000L, TimeUnit.MILLISECONDS)) {
                        U.error((GridLogger)log, (Object)("Failed to process fragmentizer communication message (will discard) [nodeId=" + nodeId + ", msg=" + msg + ']'));
                    }
                }
                catch (InterruptedException ignored) {
                    Thread.currentThread().interrupt();
                    U.warn((GridLogger)log, (Object)("Failed to process fragmentizer communication message (thread was interrupted) [nodeId=" + nodeId + ", msg=" + msg + ']'));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void body() throws InterruptedException, GridInterruptedException {
            while (!this.isCancelled()) {
                GridBiTuple<UUID, GridGgfsCommunicationMessage> req = this.msgs.take();
                UUID nodeId = (UUID)req.get1();
                if (req.get2() instanceof GridGgfsFragmentizerRequest) {
                    GridGgfsFragmentizerRequest fragmentizerReq = (GridGgfsFragmentizerRequest)((Object)req.get2());
                    if (!GridGgfsFragmentizerManager.this.rw.tryReadLock()) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug("Received fragmentizing request while stopping grid (will ignore) [nodeId=" + nodeId + ", req=" + req.get2() + ']');
                        continue;
                    }
                    try {
                        try {
                            GridGgfsFragmentizerManager.this.processFragmentizerRequest(fragmentizerReq);
                            continue;
                        }
                        catch (GridException e) {
                            if (e.hasCause(new Class[]{GridTopologyException.class})) {
                                if (!log.isDebugEnabled()) continue;
                                log.debug("Failed to process fragmentizer request (remote node left the grid) [req=" + req + ", err=" + e.getMessage() + ']');
                                continue;
                            }
                            U.error((GridLogger)log, (Object)("Failed to process fragmentizer request [nodeId=" + nodeId + ", req=" + req + ']'), (Throwable)e);
                            continue;
                        }
                        finally {
                            this.sendResponse(nodeId, new GridGgfsFragmentizerResponse(fragmentizerReq.fileId()));
                            continue;
                        }
                    }
                    finally {
                        GridGgfsFragmentizerManager.this.rw.readUnlock();
                        continue;
                    }
                }
                assert (req.get2() instanceof GridGgfsSyncMessage);
                GridGgfsSyncMessage syncMsg = (GridGgfsSyncMessage)((Object)req.get2());
                if (syncMsg.response()) continue;
                GridGgfsSyncMessage res = new GridGgfsSyncMessage(syncMsg.order(), true);
                if (log.isDebugEnabled()) {
                    log.debug("Sending fragmentizer sync response to remote node [nodeId=" + nodeId + ", res=" + (Object)((Object)res) + ']');
                }
                this.sendResponse(nodeId, res);
            }
        }

        private void sendResponse(UUID nodeId, GridGgfsCommunicationMessage msg) {
            try {
                GridGgfsFragmentizerManager.this.sendWithRetries(nodeId, msg);
            }
            catch (GridException e) {
                if (e.hasCause(new Class[]{GridTopologyException.class})) {
                    if (log.isDebugEnabled()) {
                        log.debug("Failed to send sync response to GGFS fragmentizer coordinator (originating node left the grid): " + nodeId);
                    }
                }
                U.error((GridLogger)log, (Object)("Failed to send sync response to GGFS fragmentizer coordinator: " + nodeId), (Throwable)e);
            }
        }
    }

    private class FragmentizerCoordinator
    extends GridWorker
    implements GridLocalEventListener,
    GridMessageListener {
        private ConcurrentMap<GridUuid, Collection<UUID>> fragmentingFiles;
        private volatile Collection<UUID> startSync;
        private Lock lock;
        private Condition cond;

        protected FragmentizerCoordinator() {
            super(GridGgfsFragmentizerManager.this.ggfsCtx.kernalContext().gridName(), "fragmentizer-coordinator", GridGgfsFragmentizerManager.this.ggfsCtx.kernalContext().log());
            this.fragmentingFiles = new ConcurrentHashMap<GridUuid, Collection<UUID>>();
            this.lock = new ReentrantLock();
            this.cond = this.lock.newCondition();
            GridGgfsFragmentizerManager.this.ggfsCtx.kernalContext().event().addLocalEventListener((GridLocalEventListener)this, 11, new int[]{12});
            GridGgfsFragmentizerManager.this.ggfsCtx.kernalContext().io().addMessageListener(GridGgfsFragmentizerManager.this.topic, (GridMessageListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void body() throws InterruptedException, GridInterruptedException {
            this.syncStart();
            while (!this.isCancelled()) {
                try {
                    GridGgfsFileInfo fileInfo;
                    while (this.fragmentingFiles.size() < GridGgfsFragmentizerManager.this.ggfsCtx.configuration().getFragmentizerConcurrentFiles() && (fileInfo = GridGgfsFragmentizerManager.this.fileForFragmentizer(this.fragmentingFiles.keySet())) != null) {
                        this.requestFragmenting(fileInfo);
                    }
                }
                catch (GridException | GridRuntimeException e) {
                    if (X.hasCause((Throwable)e, (Class[])new Class[]{InterruptedException.class}) || X.hasCause((Throwable)e, (Class[])new Class[]{GridInterruptedException.class})) {
                        if (!log.isDebugEnabled()) break;
                        log.debug("Got interrupted exception in fragmentizer coordinator (grid is stopping).");
                        break;
                    }
                    LT.warn((GridLogger)log, (Throwable)e, (String)"Failed to get fragmentizer file info (will retry).");
                }
                this.lock.lock();
                try {
                    if (this.fragmentingFiles.size() >= GridGgfsFragmentizerManager.this.ggfsCtx.configuration().getFragmentizerConcurrentFiles()) continue;
                    this.cond.await(3000L, TimeUnit.MILLISECONDS);
                }
                finally {
                    this.lock.unlock();
                }
            }
        }

        public void onEvent(GridEvent evt) {
            assert (evt.type() == 11 || evt.type() == 12);
            GridDiscoveryEvent discoEvt = (GridDiscoveryEvent)evt;
            if (log.isDebugEnabled()) {
                log.debug("Processing node leave event: " + discoEvt);
            }
            boolean signal = false;
            Collection<UUID> startSync0 = this.startSync;
            if (startSync0 != null && !startSync0.isEmpty()) {
                startSync0.remove(discoEvt.eventNode().id());
                if (startSync0.isEmpty()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Completed fragmentizer coordinator sync start.");
                    }
                    signal = true;
                }
            }
            if (!signal) {
                Iterator it = this.fragmentingFiles.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    Collection nodeIds = (Collection)entry.getValue();
                    if (!nodeIds.remove(discoEvt.eventNode().id()) || !nodeIds.isEmpty()) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("Received all responses for fragmentizer task [fileId=" + entry.getKey() + ']');
                    }
                    it.remove();
                    signal = true;
                }
            }
            if (signal) {
                this.wakeUp();
            }
        }

        public void onMessage(UUID nodeId, Object msg) {
            GridGgfsSyncMessage sync;
            if (msg instanceof GridGgfsFragmentizerResponse) {
                GridGgfsFragmentizerResponse res = (GridGgfsFragmentizerResponse)((Object)msg);
                GridUuid fileId = res.fileId();
                Collection nodeIds = (Collection)this.fragmentingFiles.get(fileId);
                if (nodeIds != null) {
                    if (nodeIds.remove(nodeId) && nodeIds.isEmpty()) {
                        if (log.isDebugEnabled()) {
                            log.debug("Received all responses for fragmentizer task [fileId=" + fileId + ']');
                        }
                        this.fragmentingFiles.remove(fileId, nodeIds);
                        this.wakeUp();
                    }
                } else {
                    log.warning("Received fragmentizer response for file ID which was not requested (will ignore) [nodeId=" + nodeId + ", fileId=" + res.fileId() + ']');
                }
            } else if (msg instanceof GridGgfsSyncMessage && (sync = (GridGgfsSyncMessage)((Object)msg)).response() && sync.order() == GridGgfsFragmentizerManager.this.ggfsCtx.kernalContext().grid().localNode().order()) {
                Collection<UUID> startSync0;
                if (log.isDebugEnabled()) {
                    log.debug("Received fragmentizer sync response from remote node: " + nodeId);
                }
                if ((startSync0 = this.startSync) != null) {
                    startSync0.remove(nodeId);
                    if (startSync0.isEmpty()) {
                        if (log.isDebugEnabled()) {
                            log.debug("Completed fragmentizer coordinator sync start: " + startSync0);
                        }
                        this.wakeUp();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void wakeUp() {
            this.lock.lock();
            try {
                this.cond.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void syncStart() throws InterruptedException {
            GridConcurrentHashSet startSync0 = this.startSync = new GridConcurrentHashSet(F.viewReadOnly((Collection)GridGgfsFragmentizerManager.this.ggfsCtx.kernalContext().discovery().allNodes(), (GridClosure)F.node2id(), (GridPredicate[])new GridPredicate[]{new P1<GridNode>(){

                public boolean apply(GridNode n) {
                    return GridGgfsFragmentizerManager.this.ggfsCtx.ggfsNode(n);
                }
            }}));
            GridNode locNode = GridGgfsFragmentizerManager.this.ggfsCtx.kernalContext().grid().localNode();
            while (!startSync0.isEmpty()) {
                for (UUID nodeId : startSync0) {
                    GridGgfsSyncMessage syncReq = new GridGgfsSyncMessage(locNode.order(), false);
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug("Sending fragmentizer sync start request to remote node [nodeId=" + nodeId + ", syncReq=" + (Object)((Object)syncReq) + ']');
                        }
                        GridGgfsFragmentizerManager.this.sendWithRetries(nodeId, syncReq);
                        if (GridGgfsFragmentizerManager.this.ggfsCtx.kernalContext().discovery().alive(nodeId)) continue;
                        startSync0.remove(nodeId);
                    }
                    catch (GridException e) {
                        if (e.hasCause(new Class[]{GridTopologyException.class})) {
                            if (log.isDebugEnabled()) {
                                log.debug("Failed to send sync message to remote node (node has left the grid): " + nodeId);
                            }
                        } else {
                            U.error((GridLogger)log, (Object)("Failed to send synchronize message to remote node (will not wait for reply): " + nodeId), (Throwable)e);
                        }
                        startSync0.remove(nodeId);
                    }
                }
                this.lock.lock();
                try {
                    if (startSync0.isEmpty()) continue;
                    this.cond.await(10000L, TimeUnit.MILLISECONDS);
                }
                finally {
                    this.lock.unlock();
                }
            }
        }

        private void requestFragmenting(GridGgfsFileInfo fileInfo) {
            GridGgfsFileMap map = fileInfo.fileMap();
            assert (map != null && !map.ranges().isEmpty());
            HashMap<UUID, LinkedList<GridGgfsFileAffinityRange>> grpMap = new HashMap<UUID, LinkedList<GridGgfsFileAffinityRange>>(map.ranges().size());
            for (GridGgfsFileAffinityRange range : map.ranges()) {
                UUID nodeId = GridGgfsFragmentizerManager.this.ggfsCtx.data().affinityNode(range.affinityKey()).id();
                LinkedList<GridGgfsFileAffinityRange> nodeRanges = (LinkedList<GridGgfsFileAffinityRange>)grpMap.get(nodeId);
                if (nodeRanges == null) {
                    nodeRanges = new LinkedList<GridGgfsFileAffinityRange>();
                    grpMap.put(nodeId, nodeRanges);
                }
                nodeRanges.addAll(range.split(GridGgfsFragmentizerManager.this.ggfsCtx.data().groupBlockSize()));
            }
            IdentityHashSet nodeIds = new IdentityHashSet(grpMap.keySet());
            if (log.isDebugEnabled()) {
                log.debug("Calculating fragmentizer groups for file [fileInfo=" + fileInfo + ", nodeIds=" + (Object)((Object)nodeIds) + ']');
            }
            Collection<UUID> old = this.fragmentingFiles.putIfAbsent(fileInfo.id(), (Collection<UUID>)((Object)nodeIds));
            assert (old == null);
            for (Map.Entry entry : grpMap.entrySet()) {
                UUID nodeId = (UUID)entry.getKey();
                GridGgfsFragmentizerRequest msg = new GridGgfsFragmentizerRequest(fileInfo.id(), (Collection)entry.getValue());
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Sending fragmentizer request to remote node [nodeId=" + nodeId + ", fileId=" + fileInfo.id() + ", msg=" + (Object)((Object)msg) + ']');
                    }
                    GridGgfsFragmentizerManager.this.sendWithRetries(nodeId, msg);
                }
                catch (GridException e) {
                    if (e.hasCause(new Class[]{GridTopologyException.class})) {
                        if (log.isDebugEnabled()) {
                            log.debug("Failed to send fragmentizer request to remote node (node left grid): " + nodeId);
                        }
                    } else {
                        U.error((GridLogger)log, (Object)("Failed to send fragmentizer request to remote node [nodeId=" + nodeId + ", msg=" + (Object)((Object)msg) + ']'), (Throwable)e);
                    }
                    nodeIds.remove(nodeId);
                }
            }
            if (nodeIds.isEmpty()) {
                if (log.isDebugEnabled()) {
                    log.debug("Got empty wait set for fragmentized file: " + fileInfo);
                }
                this.fragmentingFiles.remove(fileInfo.id(), (Object)nodeIds);
            }
        }
    }
}

