/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.ggfs;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import org.gridgain.grid.GridUuid;
import org.gridgain.grid.kernal.GridDirectCollection;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsCommunicationMessage;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsFileAffinityRange;
import org.gridgain.grid.util.direct.GridTcpCommunicationMessageAdapter;
import org.gridgain.grid.util.tostring.GridToStringInclude;
import org.gridgain.grid.util.typedef.internal.S;

public class GridGgfsFragmentizerRequest
extends GridGgfsCommunicationMessage {
    private static final long serialVersionUID = 0L;
    private GridUuid fileId;
    @GridToStringInclude
    @GridDirectCollection(value=GridGgfsFileAffinityRange.class)
    private Collection<GridGgfsFileAffinityRange> fragmentRanges;

    public GridGgfsFragmentizerRequest() {
    }

    public GridGgfsFragmentizerRequest(GridUuid fileId, Collection<GridGgfsFileAffinityRange> fragmentRanges) {
        this.fileId = fileId;
        this.fragmentRanges = fragmentRanges;
    }

    public GridUuid fileId() {
        return this.fileId;
    }

    public Collection<GridGgfsFileAffinityRange> fragmentRanges() {
        return this.fragmentRanges;
    }

    public String toString() {
        return S.toString(GridGgfsFragmentizerRequest.class, (Object)((Object)this));
    }

    public GridTcpCommunicationMessageAdapter clone() {
        GridGgfsFragmentizerRequest _clone = new GridGgfsFragmentizerRequest();
        this.clone0(_clone);
        return _clone;
    }

    @Override
    protected void clone0(GridTcpCommunicationMessageAdapter _msg) {
        super.clone0(_msg);
        GridGgfsFragmentizerRequest _clone = (GridGgfsFragmentizerRequest)_msg;
        _clone.fileId = this.fileId;
        _clone.fragmentRanges = this.fragmentRanges;
    }

    @Override
    public boolean writeTo(ByteBuffer buf) {
        this.commState.setBuffer(buf);
        if (!super.writeTo(buf)) {
            return false;
        }
        if (!this.commState.typeWritten) {
            if (!this.commState.putByte(this.directType())) {
                return false;
            }
            this.commState.typeWritten = true;
        }
        switch (this.commState.idx) {
            case 0: {
                if (!this.commState.putGridUuid(this.fileId)) {
                    return false;
                }
                ++this.commState.idx;
            }
            case 1: {
                if (this.fragmentRanges != null) {
                    if (this.commState.it == null) {
                        if (!this.commState.putInt(this.fragmentRanges.size())) {
                            return false;
                        }
                        this.commState.it = this.fragmentRanges.iterator();
                    }
                    while (this.commState.it.hasNext() || this.commState.cur != NULL) {
                        if (this.commState.cur == NULL) {
                            this.commState.cur = this.commState.it.next();
                        }
                        if (!this.commState.putMessage((GridTcpCommunicationMessageAdapter)((GridGgfsFileAffinityRange)this.commState.cur))) {
                            return false;
                        }
                        this.commState.cur = NULL;
                    }
                    this.commState.it = null;
                } else if (!this.commState.putInt(-1)) {
                    return false;
                }
                ++this.commState.idx;
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf) {
        this.commState.setBuffer(buf);
        if (!super.readFrom(buf)) {
            return false;
        }
        switch (this.commState.idx) {
            case 0: {
                GridUuid fileId0 = this.commState.getGridUuid();
                if (fileId0 == GRID_UUID_NOT_READ) {
                    return false;
                }
                this.fileId = fileId0;
                ++this.commState.idx;
            }
            case 1: {
                if (this.commState.readSize == -1) {
                    if (buf.remaining() < 4) {
                        return false;
                    }
                    this.commState.readSize = this.commState.getInt();
                }
                if (this.commState.readSize >= 0) {
                    if (this.fragmentRanges == null) {
                        this.fragmentRanges = new ArrayList<GridGgfsFileAffinityRange>(this.commState.readSize);
                    }
                    for (int i = this.commState.readItems; i < this.commState.readSize; ++i) {
                        GridTcpCommunicationMessageAdapter _val = this.commState.getMessage();
                        if (_val == MSG_NOT_READ) {
                            return false;
                        }
                        this.fragmentRanges.add((GridGgfsFileAffinityRange)_val);
                        ++this.commState.readItems;
                    }
                }
                this.commState.readSize = -1;
                this.commState.readItems = 0;
                ++this.commState.idx;
            }
        }
        return true;
    }

    public byte directType() {
        return 70;
    }
}

