/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.ggfs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsPaths;
import org.gridgain.grid.util.typedef.internal.U;

public class GridGgfsHandshakeResponse
implements Externalizable {
    private static final long serialVersionUID = 0L;
    private String ggfsName;
    private GridGgfsPaths paths;
    private long blockSize;
    private Boolean sampling;

    public GridGgfsHandshakeResponse() {
    }

    public GridGgfsHandshakeResponse(String ggfsName, GridGgfsPaths paths, long blockSize, Boolean sampling) {
        assert (paths != null);
        this.ggfsName = ggfsName;
        this.paths = paths;
        this.blockSize = blockSize;
        this.sampling = sampling;
    }

    public String ggfsName() {
        return this.ggfsName;
    }

    public GridGgfsPaths secondaryPaths() {
        return this.paths;
    }

    public long blockSize() {
        return this.blockSize;
    }

    public Boolean sampling() {
        return this.sampling;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeString((DataOutput)out, (String)this.ggfsName);
        this.paths.writeExternal(out);
        out.writeLong(this.blockSize);
        if (this.sampling != null) {
            out.writeBoolean(true);
            out.writeBoolean(this.sampling);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.ggfsName = U.readString((DataInput)in);
        this.paths = new GridGgfsPaths();
        this.paths.readExternal(in);
        this.blockSize = in.readLong();
        if (in.readBoolean()) {
            this.sampling = in.readBoolean();
        }
    }
}

