/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.ggfs;

import java.util.Map;
import org.apache.hadoop.fs.permission.FsPermission;
import org.gridgain.grid.GridException;

class GridGgfsHdfsProperties {
    private String usrName;
    private String grpName;
    private FsPermission perm;

    GridGgfsHdfsProperties(Map<String, String> props) throws GridException {
        this.usrName = props.get("usrName");
        this.grpName = props.get("grpName");
        String permStr = props.get("permission");
        if (permStr != null) {
            try {
                this.perm = new FsPermission((short)Integer.parseInt(permStr, 8));
            }
            catch (NumberFormatException ignore) {
                throw new GridException("Permissions cannot be parsed: " + permStr);
            }
        }
    }

    String userName() {
        return this.usrName;
    }

    String groupName() {
        return this.grpName;
    }

    FsPermission permission() {
        return this.perm;
    }
}

