/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.ggfs;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.ipc.RemoteException;
import org.gridgain.grid.Grid;
import org.gridgain.grid.GridException;
import org.gridgain.grid.GridFuture;
import org.gridgain.grid.GridNode;
import org.gridgain.grid.GridUuid;
import org.gridgain.grid.cache.GridCacheConfiguration;
import org.gridgain.grid.cache.eviction.GridCacheEvictionPolicy;
import org.gridgain.grid.cache.eviction.ggfs.GridCacheGgfsPerBlockLruEvictionPolicy;
import org.gridgain.grid.compute.GridComputeJob;
import org.gridgain.grid.compute.GridComputeJobAdapter;
import org.gridgain.grid.compute.GridComputeJobResult;
import org.gridgain.grid.compute.GridComputeJobResultPolicy;
import org.gridgain.grid.compute.GridComputeTask;
import org.gridgain.grid.compute.GridComputeTaskSplitAdapter;
import org.gridgain.grid.events.GridDiscoveryEvent;
import org.gridgain.grid.events.GridEvent;
import org.gridgain.grid.events.GridGgfsEvent;
import org.gridgain.grid.ggfs.GridGgfs;
import org.gridgain.grid.ggfs.GridGgfsBlockLocation;
import org.gridgain.grid.ggfs.GridGgfsConfiguration;
import org.gridgain.grid.ggfs.GridGgfsException;
import org.gridgain.grid.ggfs.GridGgfsFile;
import org.gridgain.grid.ggfs.GridGgfsFileNotFoundException;
import org.gridgain.grid.ggfs.GridGgfsInvalidHdfsVersionException;
import org.gridgain.grid.ggfs.GridGgfsInvalidPathException;
import org.gridgain.grid.ggfs.GridGgfsMetrics;
import org.gridgain.grid.ggfs.GridGgfsMode;
import org.gridgain.grid.ggfs.GridGgfsOutputStream;
import org.gridgain.grid.ggfs.GridGgfsParentNotDirectoryException;
import org.gridgain.grid.ggfs.GridGgfsPath;
import org.gridgain.grid.ggfs.GridGgfsPathAlreadyExistsException;
import org.gridgain.grid.ggfs.GridGgfsPathSummary;
import org.gridgain.grid.ggfs.mapreduce.GridGgfsRecordResolver;
import org.gridgain.grid.ggfs.mapreduce.GridGgfsTask;
import org.gridgain.grid.kernal.GridKernal;
import org.gridgain.grid.kernal.GridTopic;
import org.gridgain.grid.kernal.managers.communication.GridMessageListener;
import org.gridgain.grid.kernal.managers.eventstorage.GridEventStorageManager;
import org.gridgain.grid.kernal.managers.eventstorage.GridLocalEventListener;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsAttributes;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsContext;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsDataManager;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsDeleteMessage;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsDirectoryNotEmptyException;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsEx;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsFileImpl;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsFileInfo;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsFileWorker;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsFileWorkerBatch;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsHdfsProperties;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsInputStreamAdapter;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsInputStreamImpl;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsListingEntry;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsLocalMetrics;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsMetaManager;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsMetricsAdapter;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsModeResolver;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsOutputStreamImpl;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsPaths;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsSecondaryInputStreamDescriptor;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsSecondaryInputStreamWrapper;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsSecondaryOutputStreamDescriptor;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsStatus;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsTaskArgsImpl;
import org.gridgain.grid.kernal.processors.task.GridInternal;
import org.gridgain.grid.lang.GridBiTuple;
import org.gridgain.grid.lang.GridClosure;
import org.gridgain.grid.lang.GridPredicate;
import org.gridgain.grid.logger.GridLogger;
import org.gridgain.grid.resources.GridInstanceResource;
import org.gridgain.grid.util.GridSpinBusyLock;
import org.gridgain.grid.util.future.GridCompoundFuture;
import org.gridgain.grid.util.future.GridFinishedFuture;
import org.gridgain.grid.util.future.GridFutureAdapter;
import org.gridgain.grid.util.typedef.C1;
import org.gridgain.grid.util.typedef.F;
import org.gridgain.grid.util.typedef.T2;
import org.gridgain.grid.util.typedef.X;
import org.gridgain.grid.util.typedef.internal.A;
import org.gridgain.grid.util.typedef.internal.LT;
import org.gridgain.grid.util.typedef.internal.S;
import org.gridgain.grid.util.typedef.internal.U;
import org.jdk8.backport.ConcurrentHashMap8;
import org.jetbrains.annotations.Nullable;

public final class GridGgfsImpl
implements GridGgfsEx {
    private static final String PERMISSION_DFLT_VAL = "0777";
    private static final Map<String, String> DFLT_DIR_META = F.asMap((Object)"permission", (Object)"0777");
    private final GridGgfsPaths secondaryPaths;
    private GridGgfsMetaManager meta;
    private GridGgfsDataManager data;
    private GridGgfsConfiguration cfg;
    private GridGgfsContext ggfsCtx;
    private GridEventStorageManager evts;
    private GridNode locNode;
    private GridLogger log;
    private final GridGgfsModeResolver modeRslvr;
    private FileSystem secondaryFs;
    private final GridSpinBusyLock busyLock = new GridSpinBusyLock();
    private final ConcurrentHashMap8<GridGgfsPath, GridGgfsFileWorker> workerMap = new ConcurrentHashMap8();
    private final ConcurrentHashMap8<GridUuid, GridFutureAdapter<Object>> delFuts = new ConcurrentHashMap8();
    private final GridMessageListener delMsgLsnr = new FormatMessageListener();
    private final GridLocalEventListener delDiscoLsnr = new FormatDiscoveryListener();
    private final GridGgfsLocalMetrics metrics = new GridGgfsLocalMetrics();
    private volatile String logDir;
    private Object topic;
    private GridCacheGgfsPerBlockLruEvictionPolicy evictPlc;

    GridGgfsImpl(GridGgfsContext ggfsCtx) throws GridException {
        GridGgfsMode dfltMode;
        boolean dualToPrimary;
        assert (ggfsCtx != null);
        this.ggfsCtx = ggfsCtx;
        this.cfg = ggfsCtx.configuration();
        this.log = ggfsCtx.kernalContext().log(GridGgfsImpl.class);
        this.evts = ggfsCtx.kernalContext().event();
        this.meta = ggfsCtx.meta();
        this.data = ggfsCtx.data();
        boolean bl = dualToPrimary = this.cfg.getSecondaryHadoopFileSystemConfigPath() == null && this.cfg.getSecondaryHadoopFileSystemUri() == null;
        if (dualToPrimary) {
            assert (ggfsCtx.configuration().getDefaultMode() != GridGgfsMode.PROXY);
            dfltMode = GridGgfsMode.PRIMARY;
        } else {
            dfltMode = ggfsCtx.configuration().getDefaultMode();
        }
        boolean initHdfs = dfltMode != GridGgfsMode.PRIMARY;
        LinkedHashMap cfgModes = new LinkedHashMap();
        LinkedHashMap<String, GridGgfsMode> dfltModes = new LinkedHashMap<String, GridGgfsMode>(4, 1.0f);
        dfltModes.put("/gridgain/primary", GridGgfsMode.PRIMARY);
        String secUri = ggfsCtx.configuration().getSecondaryHadoopFileSystemUri();
        if (secUri != null) {
            if (!secUri.endsWith("/")) {
                secUri = secUri + "/";
                ggfsCtx.configuration().setSecondaryHadoopFileSystemUri(secUri);
            }
            dfltModes.put("/gridgain/proxy", GridGgfsMode.PROXY);
            dfltModes.put("/gridgain/sync", GridGgfsMode.DUAL_SYNC);
            dfltModes.put("/gridgain/async", GridGgfsMode.DUAL_ASYNC);
        }
        cfgModes.putAll(dfltModes);
        if (ggfsCtx.configuration().getPathModes() != null) {
            for (Map.Entry e : ggfsCtx.configuration().getPathModes().entrySet()) {
                if (!dfltModes.containsKey(e.getKey())) {
                    cfgModes.put(e.getKey(), e.getValue());
                    continue;
                }
                U.warn((GridLogger)this.log, (Object)("Ignoring path mode because it conflicts with GridGain reserved path (use another path) [mode=" + e.getValue() + ", path=" + (String)e.getKey() + ']'));
            }
        }
        ArrayList<T2> modes = null;
        if (cfgModes != null && !cfgModes.isEmpty()) {
            modes = new ArrayList<T2>(cfgModes.size());
            for (Map.Entry mode : cfgModes.entrySet()) {
                GridGgfsMode mode0 = dualToPrimary ? (mode.getValue() == GridGgfsMode.PROXY ? GridGgfsMode.PROXY : GridGgfsMode.PRIMARY) : (GridGgfsMode)mode.getValue();
                try {
                    modes.add(new T2((Object)new GridGgfsPath((String)mode.getKey()), (Object)mode0));
                }
                catch (IllegalArgumentException e) {
                    throw new GridException("Invalid path found in mode pattern: " + (String)mode.getKey(), (Throwable)e);
                }
                if (mode0 == GridGgfsMode.PRIMARY) continue;
                initHdfs = true;
            }
        }
        this.modeRslvr = new GridGgfsModeResolver(dfltMode, modes);
        if (initHdfs) {
            URI hadoopUri;
            try {
                hadoopUri = new URI(secUri);
            }
            catch (URISyntaxException ignore) {
                throw new GridException("Failed to resolve secondary file system URI: " + secUri);
            }
            URL hadoopCfgUrl = U.resolveGridGainUrl((String)ggfsCtx.configuration().getSecondaryHadoopFileSystemConfigPath());
            if (hadoopCfgUrl == null) {
                throw new GridException("Failed to resolve secondary file system config URL: " + ggfsCtx.configuration().getSecondaryHadoopFileSystemConfigPath());
            }
            Configuration hadoopCfg = new Configuration();
            hadoopCfg.addResource(hadoopCfgUrl);
            try {
                this.secondaryFs = FileSystem.get((URI)hadoopUri, (Configuration)hadoopCfg);
            }
            catch (IOException e) {
                throw this.handleSecondaryFsError(e, "Failed to connect to the secondary Hadoop file system [uri=" + secUri + ", configPath=" + ggfsCtx.configuration().getSecondaryHadoopFileSystemConfigPath() + ']');
            }
        }
        this.secondaryPaths = new GridGgfsPaths(this.cfg.getSecondaryHadoopFileSystemUri(), this.cfg.getSecondaryHadoopFileSystemConfigPath(), dfltMode, this.modeRslvr.modesOrdered());
        String dataCacheName = ggfsCtx.configuration().getDataCacheName();
        for (GridCacheConfiguration cacheCfg : ggfsCtx.kernalContext().config().getCacheConfiguration()) {
            if (!F.eq((Object)dataCacheName, (Object)cacheCfg.getName())) continue;
            GridCacheEvictionPolicy evictPlc = cacheCfg.getEvictionPolicy();
            if (!(evictPlc != null & evictPlc instanceof GridCacheGgfsPerBlockLruEvictionPolicy)) break;
            this.evictPlc = (GridCacheGgfsPerBlockLruEvictionPolicy)evictPlc;
            break;
        }
        this.topic = F.isEmpty((String)this.name()) ? GridTopic.TOPIC_GGFS : GridTopic.TOPIC_GGFS.topic(this.name());
        ggfsCtx.kernalContext().io().addMessageListener(this.topic, this.delMsgLsnr);
        ggfsCtx.kernalContext().event().addLocalEventListener(this.delDiscoLsnr, 11, new int[]{12});
    }

    private GridNode localNode() {
        if (this.locNode == null) {
            this.locNode = this.ggfsCtx.kernalContext().discovery().localNode();
        }
        return this.locNode;
    }

    @Override
    public void stop() {
        this.busyLock.block();
        boolean interrupted = Thread.interrupted();
        for (GridGgfsFileWorker w : this.workerMap.values()) {
            w.cancel();
        }
        for (GridGgfsFileWorker w : this.workerMap.values()) {
            try {
                w.join();
            }
            catch (InterruptedException e) {
                U.error((GridLogger)this.log, (Object)e.getMessage(), (Throwable)e);
            }
        }
        this.workerMap.clear();
        U.closeQuiet((Closeable)this.secondaryFs);
        this.ggfsCtx.kernalContext().io().removeMessageListener(this.topic, this.delMsgLsnr);
        this.ggfsCtx.kernalContext().event().removeLocalEventListener(this.delDiscoLsnr, new int[0]);
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GridGgfsFileWorkerBatch newBatch(final GridGgfsPath path, FSDataOutputStream out) throws GridException {
        assert (path != null);
        assert (out != null);
        if (this.busyLock.enterBusy()) {
            try {
                GridGgfsFileWorkerBatch batch;
                block10: {
                    GridGgfsFileWorker worker;
                    batch = new GridGgfsFileWorkerBatch(path, out);
                    while (true) {
                        if ((worker = (GridGgfsFileWorker)this.workerMap.get((Object)path)) != null) {
                            if (!worker.addBatch(batch)) {
                                this.workerMap.remove((Object)path, (Object)worker);
                                continue;
                            }
                            break block10;
                        }
                        worker = new GridGgfsFileWorker("ggfs-file-worker-" + path){

                            @Override
                            protected void onFinish() {
                                GridGgfsImpl.this.workerMap.remove((Object)path, (Object)this);
                            }
                        };
                        boolean b = worker.addBatch(batch);
                        assert (b);
                        if (this.workerMap.putIfAbsent((Object)path, (Object)worker) == null) break;
                    }
                    worker.start();
                }
                GridGgfsFileWorkerBatch gridGgfsFileWorkerBatch = batch;
                return gridGgfsFileWorkerBatch;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new GridException("Cannot create new output stream to the secondary file system because GGFS is stopping: " + path);
    }

    void await(GridGgfsPath ... paths) {
        assert (paths != null);
        for (Map.Entry workerEntry : this.workerMap.entrySet()) {
            GridGgfsFileWorkerBatch batch;
            GridGgfsPath workerPath = (GridGgfsPath)workerEntry.getKey();
            boolean await = false;
            for (GridGgfsPath path : paths) {
                if (!workerPath.isSubDirectoryOf(path) && !workerPath.isSame(path)) continue;
                await = true;
                break;
            }
            if (!await || (batch = ((GridGgfsFileWorker)workerEntry.getValue()).currentBatch()) == null) continue;
            try {
                batch.awaitIfFinished();
            }
            catch (GridException ignore) {}
        }
    }

    @Override
    public GridGgfsContext context() {
        return this.ggfsCtx;
    }

    GridGgfsModeResolver modeResolver() {
        return this.modeRslvr;
    }

    private GridGgfsPath primaryPath(GridGgfsPath parent, Path path) {
        assert (this.cfg.getSecondaryHadoopFileSystemUri() != null);
        String root = path.toString();
        for (Path curRoot = path.getParent(); curRoot != null; curRoot = curRoot.getParent()) {
            root = curRoot.toString();
        }
        return new GridGgfsPath(parent.root().toString() + path.toString().substring(root.length()));
    }

    private Path secondaryPath(GridGgfsPath path) {
        assert (this.cfg.getSecondaryHadoopFileSystemUri() != null);
        return new Path(this.cfg.getSecondaryHadoopFileSystemUri() + path.toString().substring(path.root().toString().length()));
    }

    private Map<String, String> properties(FileStatus status) {
        FsPermission perm = status.getPermission();
        if (perm == null) {
            perm = FsPermission.getDefault();
        }
        return F.asMap((Object)"permission", (Object)String.format("%04o", perm.toShort()), (Object)"usrName", (Object)status.getOwner(), (Object)"grpName", (Object)status.getGroup());
    }

    @Nullable
    public String name() {
        return this.cfg.getName();
    }

    public GridGgfsConfiguration configuration() {
        return this.cfg;
    }

    @Override
    public GridGgfsPaths proxyPaths() {
        return this.secondaryPaths;
    }

    @Override
    public String clientLogDirectory() {
        return this.logDir;
    }

    @Override
    public void clientLogDirectory(String logDir) {
        this.logDir = logDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridGgfsStatus globalSpace() throws GridException {
        if (this.busyLock.enterBusy()) {
            try {
                GridBiTuple space = (GridBiTuple)this.ggfsCtx.kernalContext().grid().compute().execute((GridComputeTask)new GgfsGlobalSpaceTask(this.name()), null).get();
                GridGgfsStatus gridGgfsStatus = new GridGgfsStatus((Long)space.get1(), (Long)space.get2());
                return gridGgfsStatus;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to get global space because Grid is stopping.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void globalSampling(@Nullable Boolean val) throws GridException {
        if (!this.busyLock.enterBusy()) throw new IllegalStateException("Failed to set global sampling flag because Grid is stopping.");
        try {
            if (!this.meta.sampling(val)) return;
            if (val == null) {
                this.log.info("Sampling flag has been cleared. All further file system connections will perform logging depending on their configuration.");
                return;
            } else if (val.booleanValue()) {
                this.log.info("Sampling flag has been set to \"true\". All further file system connections will perform logging.");
                return;
            } else {
                this.log.info("Sampling flag has been set to \"false\". All further file system connections will not perform logging.");
            }
            return;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Boolean globalSampling() {
        if (this.busyLock.enterBusy()) {
            try {
                Boolean bl = this.meta.sampling();
                return bl;
            }
            catch (GridException e) {
                U.error((GridLogger)this.log, (Object)"Failed to get sampling state.", (Throwable)e);
                Boolean bl = false;
                return bl;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to get global sampling flag because Grid is stopping.");
    }

    @Override
    public GridGgfsLocalMetrics localMetrics() {
        return this.metrics;
    }

    @Override
    public long groupBlockSize() {
        return this.data.groupBlockSize();
    }

    public boolean exists(GridGgfsPath path) throws GridException {
        A.notNull((Object)path, (String)"path");
        if (this.log.isDebugEnabled()) {
            this.log.debug("Check file exists: " + path);
        }
        try {
            GridGgfsMode mode = this.modeRslvr.resolveMode(path);
            if (mode == GridGgfsMode.PROXY) {
                throw new GridException("PROXY mode cannot be used in GGFS directly: " + path);
            }
            boolean res = false;
            switch (mode) {
                case PRIMARY: {
                    res = this.meta.fileId(path) != null;
                    break;
                }
                case DUAL_SYNC: 
                case DUAL_ASYNC: {
                    boolean bl = res = this.meta.fileId(path) != null;
                    if (res) break;
                    res = this.secondaryFs.exists(this.secondaryPath(path));
                    break;
                }
                default: {
                    assert (false) : "Unknown mode.";
                    break;
                }
            }
            return res;
        }
        catch (IOException e) {
            throw this.handleSecondaryFsError(e, "Failed to check file existence due to secondary file system exception: " + path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridGgfsFile info(GridGgfsPath path) throws GridException {
        if (this.busyLock.enterBusy()) {
            try {
                GridGgfsMode mode;
                A.notNull((Object)path, (String)"path");
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Get file info: " + path);
                }
                if ((mode = this.modeRslvr.resolveMode(path)) == GridGgfsMode.PROXY) {
                    throw new GridException("PROXY mode cannot be used in GGFS directly: " + path);
                }
                GridGgfsFileInfo info = this.resolveFileInfo(path, mode);
                if (info == null) {
                    GridGgfsFile gridGgfsFile = null;
                    return gridGgfsFile;
                }
                GridGgfsFileImpl gridGgfsFileImpl = new GridGgfsFileImpl(path, info, this.data.groupBlockSize());
                return gridGgfsFileImpl;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to get path info because grid is stopping.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridGgfsPathSummary summary(GridGgfsPath path) throws GridException {
        if (this.busyLock.enterBusy()) {
            try {
                GridUuid fileId;
                A.notNull((Object)path, (String)"path");
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Calculating path summary: " + path);
                }
                if ((fileId = this.meta.fileId(path)) == null) {
                    throw new GridGgfsFileNotFoundException("Failed to get path summary (path not found): " + path);
                }
                GridGgfsPathSummary sum = new GridGgfsPathSummary(path);
                this.summary0(fileId, sum);
                GridGgfsPathSummary gridGgfsPathSummary = sum;
                return gridGgfsPathSummary;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to get path summary because Grid is stopping.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridGgfsFile update(GridGgfsPath path, Map<String, String> props) throws GridException {
        if (this.busyLock.enterBusy()) {
            try {
                GridGgfsMode mode;
                A.notNull((Object)path, (String)"path");
                A.notNull(props, (String)"props");
                A.ensure((!props.isEmpty() ? 1 : 0) != 0, (String)"!props.isEmpty()");
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Set file properties [path=" + path + ", props=" + props + ']');
                }
                if ((mode = this.modeRslvr.resolveMode(path)) == GridGgfsMode.PROXY) {
                    throw new GridException("PROXY mode cannot be used in GGFS directly: " + path);
                }
                if (mode != GridGgfsMode.PRIMARY) {
                    assert (mode == GridGgfsMode.DUAL_SYNC || mode == GridGgfsMode.DUAL_ASYNC);
                    this.await(path);
                    GridGgfsFileInfo info = this.meta.updateDual(this.secondaryFs, path, props);
                    if (info == null) {
                        GridGgfsFile gridGgfsFile = null;
                        return gridGgfsFile;
                    }
                    GridGgfsFileImpl gridGgfsFileImpl = new GridGgfsFileImpl(path, info, this.data.groupBlockSize());
                    return gridGgfsFileImpl;
                }
                List<GridUuid> fileIds = this.meta.fileIds(path);
                GridUuid fileId = fileIds.get(fileIds.size() - 1);
                if (fileId == null) {
                    GridGgfsFile gridGgfsFile = null;
                    return gridGgfsFile;
                }
                GridUuid parentId = fileIds.size() > 1 ? fileIds.get(fileIds.size() - 2) : null;
                GridGgfsFileInfo info = this.meta.updateProperties(parentId, fileId, path.name(), props);
                if (info != null) {
                    if (this.evts.isRecordable(121)) {
                        this.evts.record((GridEvent)new GridGgfsEvent(path, this.localNode(), 121, props));
                    }
                    GridGgfsFileImpl gridGgfsFileImpl = new GridGgfsFileImpl(path, info, this.data.groupBlockSize());
                    return gridGgfsFileImpl;
                }
                GridGgfsFile gridGgfsFile = null;
                return gridGgfsFile;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to update file because Grid is stopping.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void rename(GridGgfsPath src, GridGgfsPath dest) throws GridException {
        if (!this.busyLock.enterBusy()) throw new IllegalStateException("Failed to set rename path because Grid is stopping.");
        try {
            String destFileName;
            boolean newDest;
            A.notNull((Object)src, (String)"src");
            A.notNull((Object)dest, (String)"dest");
            if (this.log.isDebugEnabled()) {
                this.log.debug("Rename file [src=" + src + ", dest=" + dest + ']');
            }
            GridGgfsMode mode = this.modeRslvr.resolveMode(src);
            Set<GridGgfsMode> childrenModes = this.modeRslvr.resolveChildrenModes(src);
            if (mode == GridGgfsMode.PROXY) {
                throw new GridException("PROXY mode cannot be used in GGFS directly: " + src);
            }
            if (src.equals((Object)dest)) {
                return;
            }
            if (src.parent() == null) {
                throw new GridGgfsInvalidPathException("Failed to rename root directory.");
            }
            if (dest.isSubDirectoryOf(src)) {
                throw new GridGgfsInvalidPathException("Failed to rename directory (cannot move directory of upper level to self sub-dir) [src=" + src + ", dest=" + dest + ']');
            }
            if (this.evictExclude(src, mode == GridGgfsMode.PRIMARY) != this.evictExclude(dest, this.modeRslvr.resolveMode(dest) == GridGgfsMode.PRIMARY)) {
                throw new GridGgfsInvalidPathException("Cannot move file to a path with different eviction exclude setting (need to copy and remove)");
            }
            if (!childrenModes.equals(Collections.singleton(GridGgfsMode.PRIMARY))) {
                assert (mode == GridGgfsMode.DUAL_SYNC || mode == GridGgfsMode.DUAL_ASYNC);
                this.await(src, dest);
                this.meta.renameDual(this.secondaryFs, src, dest);
                return;
            }
            GridGgfsPath destParent = dest.parent();
            FileDescriptor srcDesc = this.getFileDescriptor(src);
            if (srcDesc == null || srcDesc.parentId == null) {
                if (mode != GridGgfsMode.PRIMARY) throw new GridGgfsFileNotFoundException("Failed to rename (source path not found): " + src);
                this.checkConflictWithPrimary(src);
                throw new GridGgfsFileNotFoundException("Failed to rename (source path not found): " + src);
            }
            String srcFileName = src.name();
            FileDescriptor destDesc = this.getFileDescriptor(dest);
            boolean bl = newDest = destDesc == null;
            if (newDest) {
                assert (destParent != null);
                destDesc = this.getFileDescriptor(destParent);
                if (destDesc == null) {
                    throw new GridGgfsFileNotFoundException("Failed to rename (destination directory does not exist): " + dest);
                }
                destFileName = dest.name();
            } else {
                destFileName = srcFileName;
            }
            if (destDesc.isFile) {
                throw new GridGgfsParentNotDirectoryException("Failed to rename (destination is not a directory): " + dest);
            }
            this.meta.move(srcDesc.fileId, srcFileName, srcDesc.parentId, destFileName, destDesc.fileId);
            if (srcDesc.isFile) {
                if (!this.evts.isRecordable(117)) return;
                this.evts.record((GridEvent)new GridGgfsEvent(src, newDest ? dest : new GridGgfsPath(dest, destFileName), this.localNode(), 117));
                return;
            } else {
                if (!this.evts.isRecordable(125)) return;
                this.evts.record((GridEvent)new GridGgfsEvent(src, dest, this.localNode(), 125));
            }
            return;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(GridGgfsPath path, boolean recursive) throws GridException {
        if (this.busyLock.enterBusy()) {
            try {
                A.notNull((Object)path, (String)"path");
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Deleting file [path=" + path + ", recursive=" + recursive + ']');
                }
                GridGgfsMode mode = this.modeRslvr.resolveMode(path);
                Set<GridGgfsMode> childrenModes = this.modeRslvr.resolveChildrenModes(path);
                if (mode == GridGgfsMode.PROXY) {
                    throw new GridException("PROXY mode cannot be used in GGFS directly: " + path);
                }
                boolean res = false;
                FileDescriptor desc = this.getFileDescriptor(path);
                if (childrenModes.contains(GridGgfsMode.PRIMARY)) {
                    if (desc != null) {
                        res = this.delete0(desc, path.parent(), recursive);
                    } else if (mode == GridGgfsMode.PRIMARY) {
                        this.checkConflictWithPrimary(path);
                    }
                }
                if (childrenModes.contains(GridGgfsMode.DUAL_SYNC) || childrenModes.contains(GridGgfsMode.DUAL_ASYNC)) {
                    assert (this.secondaryFs != null);
                    this.await(path);
                    res |= this.meta.deleteDual(this.secondaryFs, path, recursive);
                }
                if (res && desc != null) {
                    if (desc.isFile) {
                        if (this.evts.isRecordable(118)) {
                            this.evts.record((GridEvent)new GridGgfsEvent(path, this.localNode(), 118));
                        }
                    } else if (this.evts.isRecordable(126)) {
                        this.evts.record((GridEvent)new GridGgfsEvent(path, this.localNode(), 126));
                    }
                }
                boolean bl = res;
                return bl;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to set file times because Grid is stopping.");
    }

    private boolean delete0(FileDescriptor desc, @Nullable GridGgfsPath parentPath, boolean recursive) throws GridException {
        GridGgfsPath curPath;
        GridGgfsPath gridGgfsPath = curPath = parentPath == null ? new GridGgfsPath() : new GridGgfsPath(parentPath, desc.fileName);
        if (desc.isFile) {
            this.deleteFile(curPath, desc, true);
            return true;
        }
        if (recursive) {
            this.meta.softDelete(desc.parentId, desc.fileName, desc.fileId);
            return true;
        }
        Map<String, GridGgfsListingEntry> infoMap = this.meta.directoryListing(desc.fileId);
        if (F.isEmpty(infoMap)) {
            this.deleteFile(curPath, desc, true);
            return true;
        }
        throw new GridGgfsDirectoryNotEmptyException("Failed to remove directory (directory is not empty and recursive flag is not set)");
    }

    public void mkdirs(GridGgfsPath path) throws GridException {
        this.mkdirs(path, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mkdirs(GridGgfsPath path, @Nullable Map<String, String> props) throws GridException {
        if (this.busyLock.enterBusy()) {
            try {
                GridGgfsMode mode;
                A.notNull((Object)path, (String)"path");
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Make directories: " + path);
                }
                if (props == null) {
                    props = DFLT_DIR_META;
                }
                if ((mode = this.modeRslvr.resolveMode(path)) == GridGgfsMode.PROXY) {
                    throw new GridException("PROXY mode cannot be used in GGFS directly: " + path);
                }
                if (mode != GridGgfsMode.PRIMARY) {
                    assert (mode == GridGgfsMode.DUAL_SYNC || mode == GridGgfsMode.DUAL_ASYNC);
                    this.await(path);
                    this.meta.mkdirsDual(this.secondaryFs, path, props);
                    return;
                }
                List<GridUuid> ids = this.meta.fileIds(path);
                List components = path.components();
                assert (ids.size() == components.size() + 1) : "Components doesn't contain ROOT element [ids=" + ids + ", components=" + components + ']';
                GridUuid parentId = GridGgfsFileInfo.ROOT_ID;
                GridGgfsPath curPath = path.root();
                int size = components.size();
                for (int step = 0; step < size; ++step) {
                    GridUuid fileId = ids.get(step + 1);
                    if (fileId == null) {
                        GridGgfsFileInfo fileInfo = new GridGgfsFileInfo(true, props);
                        String fileName = (String)components.get(step);
                        curPath = new GridGgfsPath(curPath, fileName);
                        try {
                            GridGgfsFileInfo oldInfo = this.meta.putIfAbsent(parentId, fileName, fileInfo);
                            GridUuid gridUuid = fileId = oldInfo == null ? fileInfo.id() : oldInfo.id();
                            if (oldInfo == null && this.evts.isRecordable(124)) {
                                this.evts.record((GridEvent)new GridGgfsEvent(curPath, this.localNode(), 124));
                            }
                        }
                        catch (GridException e) {
                            GridGgfsFileInfo stored;
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Failed to create directory [path=" + path + ", parentId=" + parentId + ", fileName=" + fileName + ", step=" + step + ", e=" + e.getMessage() + ']');
                            }
                            if ((stored = this.meta.info(this.meta.fileId(parentId, fileName))) == null) {
                                throw new GridGgfsException((Throwable)e);
                            }
                            if (!stored.isDirectory()) {
                                throw new GridGgfsParentNotDirectoryException("Failed to create directory (parent element is not a directory)");
                            }
                            fileId = stored.id();
                        }
                    }
                    assert (fileId != null);
                    parentId = fileId;
                }
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to set file times because Grid is stopping.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<GridGgfsPath> listPaths(final GridGgfsPath path) throws GridException {
        if (this.busyLock.enterBusy()) {
            try {
                GridUuid fileId;
                GridGgfsMode mode;
                A.notNull((Object)path, (String)"path");
                if (this.log.isDebugEnabled()) {
                    this.log.debug("List directory: " + path);
                }
                if ((mode = this.modeRslvr.resolveMode(path)) == GridGgfsMode.PROXY) {
                    throw new GridException("PROXY mode cannot be used in GGFS directly: " + path);
                }
                Set<GridGgfsMode> childrenModes = this.modeRslvr.resolveChildrenModes(path);
                HashSet<String> files = new HashSet<String>();
                if (childrenModes.contains(GridGgfsMode.DUAL_SYNC) || childrenModes.contains(GridGgfsMode.DUAL_ASYNC)) {
                    assert (this.secondaryFs != null);
                    try {
                        FileStatus[] statuses = this.secondaryFs.listStatus(this.secondaryPath(path));
                        if (statuses == null) {
                            throw new GridGgfsFileNotFoundException("Failed to list files (path not found): " + path);
                        }
                        for (FileStatus status : statuses) {
                            files.add(status.getPath().getName());
                        }
                    }
                    catch (FileNotFoundException ignored) {
                        throw new GridGgfsFileNotFoundException("Failed to list files (path not found): " + path);
                    }
                    catch (IOException e) {
                        throw this.handleSecondaryFsError(e, "Failed to list statuses due to secondary file system exception: " + path);
                    }
                }
                if ((fileId = this.meta.fileId(path)) != null) {
                    files.addAll(this.meta.directoryListing(fileId).keySet());
                } else if (mode == GridGgfsMode.PRIMARY) {
                    this.checkConflictWithPrimary(path);
                    throw new GridGgfsFileNotFoundException("Failed to list files (path not found): " + path);
                }
                Collection collection = F.viewReadOnly(files, (GridClosure)new C1<String, GridGgfsPath>(){

                    public GridGgfsPath apply(String e) {
                        return new GridGgfsPath(path, e);
                    }
                }, (GridPredicate[])new GridPredicate[0]);
                return collection;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to set file times because Grid is stopping.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<GridGgfsFile> listFiles(GridGgfsPath path) throws GridException {
        if (this.busyLock.enterBusy()) {
            try {
                GridUuid fileId;
                GridGgfsMode mode;
                A.notNull((Object)path, (String)"path");
                if (this.log.isDebugEnabled()) {
                    this.log.debug("List directory details: " + path);
                }
                if ((mode = this.modeRslvr.resolveMode(path)) == GridGgfsMode.PROXY) {
                    throw new GridException("PROXY mode cannot be used in GGFS directly: " + path);
                }
                Set<GridGgfsMode> childrenModes = this.modeRslvr.resolveChildrenModes(path);
                HashSet<GridGgfsFile> files = new HashSet<GridGgfsFile>();
                if (childrenModes.contains(GridGgfsMode.DUAL_SYNC) || childrenModes.contains(GridGgfsMode.DUAL_ASYNC)) {
                    assert (this.secondaryFs != null);
                    try {
                        FileStatus[] statuses = this.secondaryFs.listStatus(this.secondaryPath(path));
                        if (statuses == null) {
                            throw new GridGgfsFileNotFoundException("Failed to list files (path not found): " + path);
                        }
                        for (FileStatus status : statuses) {
                            GridGgfsFileInfo fsInfo = this.fileInfo(path, status);
                            files.add(new GridGgfsFileImpl(this.primaryPath(path, status.getPath()), fsInfo, this.data.groupBlockSize()));
                        }
                    }
                    catch (FileNotFoundException ignored) {
                        throw new GridGgfsFileNotFoundException("Failed to list files (path not found): " + path);
                    }
                    catch (IOException e) {
                        throw this.handleSecondaryFsError(e, "Failed to list statuses due to secondary file system exception: " + path);
                    }
                }
                if ((fileId = this.meta.fileId(path)) != null) {
                    GridGgfsFileInfo info = this.meta.info(fileId);
                    if (info != null) {
                        if (info.isFile()) {
                            Set<GridGgfsFile> len$ = Collections.singleton(new GridGgfsFileImpl(path, info, this.data.groupBlockSize()));
                            return len$;
                        }
                        for (Map.Entry<String, GridGgfsListingEntry> e : info.listing().entrySet()) {
                            GridGgfsPath p = new GridGgfsPath(path, e.getKey());
                            files.add(new GridGgfsFileImpl(p, e.getValue(), this.data.groupBlockSize()));
                        }
                    }
                } else if (mode == GridGgfsMode.PRIMARY) {
                    this.checkConflictWithPrimary(path);
                    throw new GridGgfsFileNotFoundException("Failed to list files (path not found): " + path);
                }
                HashSet<GridGgfsFile> hashSet = files;
                return hashSet;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to set file times because Grid is stopping.");
    }

    @Override
    public GridGgfsInputStreamAdapter open(GridGgfsPath path) throws GridException {
        return this.open(path, this.cfg.getStreamBufferSize(), this.cfg.getSequentialReadsBeforePrefetch());
    }

    @Override
    public GridGgfsInputStreamAdapter open(GridGgfsPath path, int bufSize) throws GridException {
        return this.open(path, bufSize, this.cfg.getSequentialReadsBeforePrefetch());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridGgfsInputStreamAdapter open(GridGgfsPath path, int bufSize, int seqReadsBeforePrefetch) throws GridException {
        if (this.busyLock.enterBusy()) {
            try {
                GridGgfsMode mode;
                A.notNull((Object)path, (String)"path");
                A.ensure((bufSize >= 0 ? 1 : 0) != 0, (String)"bufSize >= 0");
                A.ensure((seqReadsBeforePrefetch >= 0 ? 1 : 0) != 0, (String)"seqReadsBeforePrefetch >= 0");
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Open file for reading [path=" + path + ", bufSize=" + bufSize + ']');
                }
                if (bufSize == 0) {
                    bufSize = this.cfg.getStreamBufferSize();
                }
                if ((mode = this.modeRslvr.resolveMode(path)) == GridGgfsMode.PROXY) {
                    throw new GridException("PROXY mode cannot be used in GGFS directly: " + path);
                }
                if (mode != GridGgfsMode.PRIMARY) {
                    assert (mode == GridGgfsMode.DUAL_SYNC || mode == GridGgfsMode.DUAL_ASYNC);
                    GridGgfsSecondaryInputStreamDescriptor desc = this.meta.openDual(this.secondaryFs, path, bufSize);
                    GgfsEventAwareInputStream os = new GgfsEventAwareInputStream(this.ggfsCtx, path, desc.info(), this.cfg.getPrefetchBlocks(), seqReadsBeforePrefetch, desc.wrapper(), this.metrics);
                    if (this.evts.isRecordable(119)) {
                        this.evts.record((GridEvent)new GridGgfsEvent(path, this.localNode(), 119));
                    }
                    GgfsEventAwareInputStream ggfsEventAwareInputStream = os;
                    return ggfsEventAwareInputStream;
                }
                GridGgfsFileInfo info = this.meta.info(this.meta.fileId(path));
                if (info == null) {
                    this.checkConflictWithPrimary(path);
                    throw new GridGgfsFileNotFoundException("File not found: " + path);
                }
                if (!info.isFile()) {
                    throw new GridGgfsInvalidPathException("Failed to open file (not a file): " + path);
                }
                GgfsEventAwareInputStream os = new GgfsEventAwareInputStream(this.ggfsCtx, path, info, this.cfg.getPrefetchBlocks(), seqReadsBeforePrefetch, null, this.metrics);
                if (this.evts.isRecordable(119)) {
                    this.evts.record((GridEvent)new GridGgfsEvent(path, this.localNode(), 119));
                }
                GgfsEventAwareInputStream ggfsEventAwareInputStream = os;
                return ggfsEventAwareInputStream;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to open file because Grid is stopping.");
    }

    public GridGgfsOutputStream create(GridGgfsPath path, boolean overwrite) throws GridException {
        return this.create0(path, this.cfg.getStreamBufferSize(), overwrite, null, 0, null, true);
    }

    public GridGgfsOutputStream create(GridGgfsPath path, int bufSize, boolean overwrite, @Nullable GridUuid affKey, int replication, long blockSize, @Nullable Map<String, String> props) throws GridException {
        return this.create0(path, bufSize, overwrite, affKey, replication, props, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GridGgfsOutputStream create0(GridGgfsPath path, int bufSize, boolean overwrite, @Nullable GridUuid affKey, int replication, @Nullable Map<String, String> props, boolean simpleCreate) throws GridException {
        if (this.busyLock.enterBusy()) {
            try {
                GridGgfsFileInfo oldInfo;
                List<GridUuid> ids;
                GridUuid parentId;
                A.notNull((Object)path, (String)"path");
                A.ensure((bufSize >= 0 ? 1 : 0) != 0, (String)"bufSize >= 0");
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Open file for writing [path=" + path + ", bufSize=" + bufSize + ", overwrite=" + overwrite + ", props=" + props + ']');
                }
                GridGgfsMode mode = this.modeRslvr.resolveMode(path);
                GridGgfsFileWorkerBatch batch = null;
                if (mode == GridGgfsMode.PROXY) {
                    throw new GridException("PROXY mode cannot be used in GGFS directly: " + path);
                }
                if (mode != GridGgfsMode.PRIMARY) {
                    assert (mode == GridGgfsMode.DUAL_SYNC || mode == GridGgfsMode.DUAL_ASYNC);
                    this.await(path);
                    GridGgfsHdfsProperties props0 = new GridGgfsHdfsProperties(props != null ? props : Collections.emptyMap());
                    GridGgfsSecondaryOutputStreamDescriptor desc = this.meta.createDual(this.secondaryFs, path, simpleCreate, props0.permission(), overwrite, bufSize, (short)replication, this.groupBlockSize(), affKey);
                    batch = this.newBatch(path, desc.out());
                    GgfsEventAwareOutputStream os = new GgfsEventAwareOutputStream(path, desc.info(), desc.parentId(), bufSize == 0 ? this.cfg.getStreamBufferSize() : bufSize, mode, batch);
                    if (this.evts.isRecordable(120)) {
                        this.evts.record((GridEvent)new GridGgfsEvent(path, this.localNode(), 120));
                    }
                    GgfsEventAwareOutputStream ggfsEventAwareOutputStream = os;
                    return ggfsEventAwareOutputStream;
                }
                GridGgfsPath parent = path.parent();
                if (parent != null) {
                    this.mkdirs(parent, props);
                }
                GridUuid gridUuid = parentId = (ids = this.meta.fileIds(path)).size() >= 2 ? ids.get(ids.size() - 2) : null;
                if (parentId == null) {
                    throw new GridGgfsInvalidPathException("Failed to resolve parent directory: " + path);
                }
                String fileName = path.name();
                GridGgfsFileInfo info = new GridGgfsFileInfo(this.cfg.getBlockSize(), affKey, this.evictExclude(path, true), props);
                while ((oldInfo = this.meta.putIfAbsent(parentId, fileName, info)) != null) {
                    if (!overwrite) {
                        throw new GridGgfsPathAlreadyExistsException("Failed to create file (file already exists): " + path);
                    }
                    if (oldInfo.isDirectory()) {
                        throw new GridGgfsPathAlreadyExistsException("Failed to create file (path points to a directory): " + path);
                    }
                    this.deleteFile(path, new FileDescriptor(parentId, fileName, oldInfo.id(), oldInfo.isFile()), false);
                    if (!this.evts.isRecordable(118)) continue;
                    this.evts.record((GridEvent)new GridGgfsEvent(path, this.localNode(), 118));
                }
                if (this.evts.isRecordable(116)) {
                    this.evts.record((GridEvent)new GridGgfsEvent(path, this.localNode(), 116));
                }
                info = this.meta.lock(info.id());
                GgfsEventAwareOutputStream os = new GgfsEventAwareOutputStream(path, info, parentId, bufSize == 0 ? this.cfg.getStreamBufferSize() : bufSize, mode, batch);
                if (this.evts.isRecordable(120)) {
                    this.evts.record((GridEvent)new GridGgfsEvent(path, this.localNode(), 120));
                }
                GgfsEventAwareOutputStream ggfsEventAwareOutputStream = os;
                return ggfsEventAwareOutputStream;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to create file times because Grid is stopping.");
    }

    public GridGgfsOutputStream append(GridGgfsPath path, boolean create) throws GridException {
        return this.append(path, this.cfg.getStreamBufferSize(), create, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridGgfsOutputStream append(GridGgfsPath path, int bufSize, boolean create, @Nullable Map<String, String> props) throws GridException {
        if (this.busyLock.enterBusy()) {
            try {
                GridUuid parentId;
                A.notNull((Object)path, (String)"path");
                A.ensure((bufSize >= 0 ? 1 : 0) != 0, (String)"bufSize >= 0");
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Open file for appending [path=" + path + ", bufSize=" + bufSize + ", create=" + create + ", props=" + props + ']');
                }
                GridGgfsMode mode = this.modeRslvr.resolveMode(path);
                GridGgfsFileWorkerBatch batch = null;
                if (mode == GridGgfsMode.PROXY) {
                    throw new GridException("PROXY mode cannot be used in GGFS directly: " + path);
                }
                if (mode != GridGgfsMode.PRIMARY) {
                    assert (mode == GridGgfsMode.DUAL_SYNC || mode == GridGgfsMode.DUAL_ASYNC);
                    this.await(path);
                    GridGgfsSecondaryOutputStreamDescriptor desc = this.meta.appendDual(this.secondaryFs, path, bufSize);
                    batch = this.newBatch(path, desc.out());
                    GgfsEventAwareOutputStream ggfsEventAwareOutputStream = new GgfsEventAwareOutputStream(path, desc.info(), desc.parentId(), bufSize == 0 ? this.cfg.getStreamBufferSize() : bufSize, mode, batch);
                    return ggfsEventAwareOutputStream;
                }
                List<GridUuid> ids = this.meta.fileIds(path);
                GridGgfsFileInfo info = this.meta.info(ids.get(ids.size() - 1));
                GridUuid gridUuid = parentId = ids.size() >= 2 ? ids.get(ids.size() - 2) : null;
                if (info == null) {
                    if (!create) {
                        this.checkConflictWithPrimary(path);
                        throw new GridGgfsFileNotFoundException("File not found: " + path);
                    }
                    if (parentId == null) {
                        throw new GridGgfsInvalidPathException("Failed to resolve parent directory: " + path);
                    }
                    info = new GridGgfsFileInfo(this.cfg.getBlockSize(), null, this.evictExclude(path, mode == GridGgfsMode.PRIMARY), props);
                    GridGgfsFileInfo oldInfo = this.meta.putIfAbsent(parentId, path.name(), info);
                    if (oldInfo != null) {
                        info = oldInfo;
                    }
                    if (this.evts.isRecordable(116)) {
                        this.evts.record((GridEvent)new GridGgfsEvent(path, this.localNode(), 116));
                    }
                }
                if (!info.isFile()) {
                    throw new GridGgfsInvalidPathException("Failed to open file (not a file): " + path);
                }
                info = this.meta.lock(info.id());
                if (this.evts.isRecordable(120)) {
                    this.evts.record((GridEvent)new GridGgfsEvent(path, this.localNode(), 120));
                }
                GgfsEventAwareOutputStream ggfsEventAwareOutputStream = new GgfsEventAwareOutputStream(path, info, parentId, bufSize == 0 ? this.cfg.getStreamBufferSize() : bufSize, mode, batch);
                return ggfsEventAwareOutputStream;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to append file times because Grid is stopping.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimes(GridGgfsPath path, long accessTime, long modificationTime) throws GridException {
        if (this.busyLock.enterBusy()) {
            try {
                A.notNull((Object)path, (String)"path");
                if (accessTime == -1L && modificationTime == -1L) {
                    return;
                }
                FileDescriptor desc = this.getFileDescriptor(path);
                if (desc == null) {
                    this.checkConflictWithPrimary(path);
                    throw new GridGgfsFileNotFoundException("Failed to update times (path not found): " + path);
                }
                if (desc.parentId == null) {
                    return;
                }
                this.meta.updateTimes(desc.parentId, desc.fileId, desc.fileName, accessTime, modificationTime);
            }
            finally {
                this.busyLock.leaveBusy();
            }
        } else {
            throw new IllegalStateException("Failed to set file times because Grid is stopping.");
        }
    }

    private void checkConflictWithPrimary(GridGgfsPath path) throws GridException {
        try {
            if (this.secondaryFs != null && this.secondaryFs.getFileStatus(this.secondaryPath(path)) != null) {
                throw new GridException("Path mapped to a PRIMARY mode found in secondary file system. Remove path from secondary file system or change path mapping: " + path);
            }
        }
        catch (FileNotFoundException ignored) {
        }
        catch (IOException e) {
            throw this.handleSecondaryFsError(e, "Failed to get status from secondary file system for path: " + path);
        }
    }

    public Collection<GridGgfsBlockLocation> affinity(GridGgfsPath path, long start, long len) throws GridException {
        return this.affinity(path, start, len, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<GridGgfsBlockLocation> affinity(GridGgfsPath path, long start, long len, long maxLen) throws GridException {
        if (this.busyLock.enterBusy()) {
            try {
                GridGgfsMode mode;
                A.notNull((Object)path, (String)"path");
                A.ensure((start >= 0L ? 1 : 0) != 0, (String)"start >= 0");
                A.ensure((len >= 0L ? 1 : 0) != 0, (String)"len >= 0");
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Get affinity for file block [path=" + path + ", start=" + start + ", len=" + len + ']');
                }
                if ((mode = this.modeRslvr.resolveMode(path)) == GridGgfsMode.PROXY) {
                    throw new GridException("PROXY mode cannot be used in GGFS directly: " + path);
                }
                GridUuid fileId = this.meta.fileId(path);
                GridGgfsFileInfo info = this.meta.info(fileId);
                if (info == null && mode != GridGgfsMode.PRIMARY) {
                    assert (mode == GridGgfsMode.DUAL_SYNC || mode == GridGgfsMode.DUAL_ASYNC);
                    assert (this.secondaryFs != null);
                    info = this.meta.synchronizeFileDual(this.secondaryFs, path);
                }
                if (info == null) {
                    throw new GridGgfsFileNotFoundException("File not found: " + path);
                }
                if (!info.isFile()) {
                    throw new GridGgfsInvalidPathException("Failed to get affinity info for file (not a file): " + path);
                }
                Collection<GridGgfsBlockLocation> collection = this.data.affinity(info, start, len, maxLen);
                return collection;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to get affinity because Grid is stopping.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridGgfsMetrics metrics() throws GridException {
        if (this.busyLock.enterBusy()) {
            try {
                GridGgfsPathSummary sum = new GridGgfsPathSummary();
                this.summary0(GridGgfsFileInfo.ROOT_ID, sum);
                long secondarySpaceSize = 0L;
                if (this.secondaryFs != null) {
                    try {
                        secondarySpaceSize = this.secondaryFs.getContentSummary(this.secondaryPath(new GridGgfsPath())).getSpaceConsumed();
                    }
                    catch (IOException e) {
                        LT.warn((GridLogger)this.log, (Throwable)e, (String)"Failed to get secondary file system consumed space size.");
                        secondarySpaceSize = -1L;
                    }
                }
                GridGgfsMetricsAdapter gridGgfsMetricsAdapter = new GridGgfsMetricsAdapter(this.ggfsCtx.data().spaceSize(), this.ggfsCtx.data().maxSpaceSize(), secondarySpaceSize, sum.directoriesCount(), sum.filesCount(), this.metrics.filesOpenedForRead(), this.metrics.filesOpenedForWrite(), this.metrics.readBlocks(), this.metrics.readBlocksSecondary(), this.metrics.writeBlocks(), this.metrics.writeBlocksSecondary(), this.metrics.readBytes(), this.metrics.readBytesTime(), this.metrics.writeBytes(), this.metrics.writeBytesTime());
                return gridGgfsMetricsAdapter;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to get metrics because Grid is stopping.");
    }

    public void resetMetrics() {
        this.metrics.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long size(GridGgfsPath path) throws GridException {
        if (this.busyLock.enterBusy()) {
            try {
                A.notNull((Object)path, (String)"path");
                GridUuid nextId = this.meta.fileId(path);
                if (nextId == null) {
                    long l = 0L;
                    return l;
                }
                GridGgfsPathSummary sum = new GridGgfsPathSummary(path);
                this.summary0(nextId, sum);
                long l = sum.totalLength();
                return l;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to get path size because Grid is stopping.");
    }

    private void summary0(GridUuid fileId, GridGgfsPathSummary sum) throws GridException {
        assert (sum != null);
        GridGgfsFileInfo info = this.meta.info(fileId);
        if (info != null) {
            if (info.isDirectory()) {
                if (!GridGgfsFileInfo.ROOT_ID.equals((Object)info.id())) {
                    sum.directoriesCount(sum.directoriesCount() + 1);
                }
                for (GridGgfsListingEntry entry : info.listing().values()) {
                    this.summary0(entry.fileId(), sum);
                }
            } else {
                sum.filesCount(sum.filesCount() + 1);
                sum.totalLength(sum.totalLength() + info.length());
            }
        }
    }

    public GridFuture<?> format() throws GridException {
        GridUuid id = this.meta.softDelete(null, null, GridGgfsFileInfo.ROOT_ID);
        if (id == null) {
            return new GridFinishedFuture(this.ggfsCtx.kernalContext());
        }
        GridFutureAdapter fut = new GridFutureAdapter(this.ggfsCtx.kernalContext());
        GridFutureAdapter oldFut = (GridFutureAdapter)this.delFuts.putIfAbsent((Object)id, (Object)fut);
        if (oldFut != null) {
            return oldFut;
        }
        if (!this.meta.exists(id)) {
            fut.onDone();
            this.delFuts.remove((Object)id, (Object)fut);
        }
        return fut;
    }

    @Override
    public GridFuture<?> awaitDeletesAsync() throws GridException {
        Collection<GridUuid> ids = this.meta.pendingDeletes();
        if (!ids.isEmpty()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Constructing delete future for trash entries: " + ids);
            }
            GridCompoundFuture resFut = new GridCompoundFuture(this.ggfsCtx.kernalContext());
            for (GridUuid id : ids) {
                GridFutureAdapter fut;
                GridFuture oldFut = (GridFuture)this.delFuts.putIfAbsent((Object)id, (Object)(fut = new GridFutureAdapter(this.ggfsCtx.kernalContext())));
                if (oldFut != null) {
                    resFut.add(oldFut);
                    continue;
                }
                if (this.meta.exists(id)) {
                    resFut.add((GridFuture)fut);
                    continue;
                }
                fut.onDone();
                this.delFuts.remove((Object)id, (Object)fut);
            }
            resFut.markInitialized();
            return resFut;
        }
        return new GridFinishedFuture(this.ggfsCtx.kernalContext());
    }

    @Nullable
    private GridGgfsFileInfo hadoopFileStatus(GridGgfsPath path) throws GridException {
        assert (this.secondaryFs != null);
        GridGgfsFileInfo info = null;
        try {
            info = this.fileInfo(path, this.secondaryFs.getFileStatus(this.secondaryPath(path)));
        }
        catch (FileNotFoundException ignore) {
        }
        catch (IOException e) {
            throw this.handleSecondaryFsError(e, "Failed to get file status due to secondary file system exception: " + path);
        }
        return info;
    }

    private GridGgfsFileInfo fileInfo(GridGgfsPath path, FileStatus status) {
        assert (status != null);
        return status.isDir() ? new GridGgfsFileInfo(true, this.properties(status)) : new GridGgfsFileInfo(this.cfg.getBlockSize(), status.getLen(), this.evictExclude(path, false), this.properties(status));
    }

    @Nullable
    private FileDescriptor getFileDescriptor(GridGgfsPath path) throws GridException {
        List<GridUuid> ids = this.meta.fileIds(path);
        GridGgfsFileInfo fileInfo = this.meta.info(ids.get(ids.size() - 1));
        if (fileInfo == null) {
            return null;
        }
        GridUuid parentId = ids.size() >= 2 ? ids.get(ids.size() - 2) : null;
        return new FileDescriptor(parentId, path.name(), fileInfo.id(), fileInfo.isFile());
    }

    private void deleteFile(GridGgfsPath path, FileDescriptor desc, boolean rmvLocked) throws GridException {
        GridUuid parentId = desc.parentId;
        GridUuid fileId = desc.fileId;
        if (parentId == null || GridGgfsFileInfo.ROOT_ID.equals((Object)fileId)) {
            assert (parentId == null && GridGgfsFileInfo.ROOT_ID.equals((Object)fileId)) : "Invalid file descriptor: " + desc;
            return;
        }
        if (GridGgfsFileInfo.TRASH_ID.equals((Object)fileId)) {
            return;
        }
        this.meta.removeIfEmpty(parentId, desc.fileName, fileId, path, rmvLocked);
    }

    private boolean sameGgfs(GridGgfsAttributes[] attrs) {
        if (attrs != null) {
            String ggfsName = this.name();
            for (GridGgfsAttributes attr : attrs) {
                if (!F.eq((Object)ggfsName, (Object)attr.ggfsName())) continue;
                return true;
            }
        }
        return false;
    }

    public <T, R> GridFuture<R> execute(GridGgfsTask<T, R> task, @Nullable GridGgfsRecordResolver rslvr, Collection<GridGgfsPath> paths, @Nullable T arg) {
        return this.execute(task, rslvr, paths, true, this.cfg.getMaximumTaskRangeLength(), arg);
    }

    public <T, R> GridFuture<R> execute(GridGgfsTask<T, R> task, @Nullable GridGgfsRecordResolver rslvr, Collection<GridGgfsPath> paths, boolean skipNonExistentFiles, long maxRangeLen, @Nullable T arg) {
        return this.ggfsCtx.kernalContext().task().execute(task, new GridGgfsTaskArgsImpl<T>(this.cfg.getName(), paths, rslvr, skipNonExistentFiles, maxRangeLen, arg));
    }

    public <T, R> GridFuture<R> execute(Class<? extends GridGgfsTask<T, R>> taskCls, @Nullable GridGgfsRecordResolver rslvr, Collection<GridGgfsPath> paths, @Nullable T arg) {
        return this.execute(taskCls, rslvr, paths, true, this.cfg.getMaximumTaskRangeLength(), arg);
    }

    public <T, R> GridFuture<R> execute(Class<? extends GridGgfsTask<T, R>> taskCls, @Nullable GridGgfsRecordResolver rslvr, Collection<GridGgfsPath> paths, boolean skipNonExistentFiles, long maxRangeSize, @Nullable T arg) {
        return this.ggfsCtx.kernalContext().task().execute(taskCls, new GridGgfsTaskArgsImpl<T>(this.cfg.getName(), paths, rslvr, skipNonExistentFiles, maxRangeSize, arg));
    }

    @Override
    public boolean evictExclude(GridGgfsPath path, boolean primary) {
        assert (path != null);
        try {
            return primary || this.evictPlc == null || this.evictPlc.exclude(path);
        }
        catch (GridException e) {
            LT.error((GridLogger)this.log, (Throwable)e, (String)("Failed to check whether the path must be excluded from evictions: " + path));
            return false;
        }
    }

    private GridGgfsFileInfo resolveFileInfo(GridGgfsPath path, GridGgfsMode mode) throws GridException {
        assert (path != null);
        assert (mode != null);
        GridGgfsFileInfo info = null;
        switch (mode) {
            case PRIMARY: {
                info = this.meta.info(this.meta.fileId(path));
                break;
            }
            case DUAL_SYNC: 
            case DUAL_ASYNC: {
                info = this.meta.info(this.meta.fileId(path));
                if (info != null) break;
                info = this.hadoopFileStatus(path);
                break;
            }
            default: {
                assert (false) : "Unknown mode: " + mode;
                break;
            }
        }
        return info;
    }

    private GridGgfsException handleSecondaryFsError(IOException e, String detailMsg) {
        boolean wrongVer = X.hasCause((Throwable)e, (Class[])new Class[]{RemoteException.class}) || e.getMessage() != null && e.getMessage().contains("Failed on local");
        GridGgfsException ggfsErr = !wrongVer ? new GridGgfsException(detailMsg, (Throwable)e) : new GridGgfsInvalidHdfsVersionException("HDFS version you are connecting to differs from local version (start GGFS node with '-h1' option if using HDFS ver. 1.x)", (Throwable)e);
        LT.error((GridLogger)this.log, (Throwable)ggfsErr, (String)"Failed to connect to secondary Hadoop file system.");
        return ggfsErr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridUuid nextAffinityKey() {
        if (this.busyLock.enterBusy()) {
            try {
                GridUuid gridUuid = this.data.nextAffinityKey(null);
                return gridUuid;
            }
            finally {
                this.busyLock.leaveBusy();
            }
        }
        throw new IllegalStateException("Failed to get next affinity key because Grid is stopping.");
    }

    @Override
    public boolean isProxy(URI path) {
        GridGgfsMode mode = F.isEmpty((Map)this.cfg.getPathModes()) ? this.cfg.getDefaultMode() : this.modeRslvr.resolveMode(new GridGgfsPath(path));
        return mode == GridGgfsMode.PROXY;
    }

    private class FormatDiscoveryListener
    implements GridLocalEventListener {
        private FormatDiscoveryListener() {
        }

        public void onEvent(GridEvent evt) {
            assert (evt.type() == 11 || evt.type() == 12);
            GridDiscoveryEvent evt0 = (GridDiscoveryEvent)evt;
            if (evt0.eventNode() != null && GridGgfsImpl.this.sameGgfs((GridGgfsAttributes[])evt0.eventNode().attribute("org.gridgain.ggfs"))) {
                HashSet<GridUuid> rmv = new HashSet<GridUuid>();
                for (Map.Entry fut : GridGgfsImpl.this.delFuts.entrySet()) {
                    GridUuid id = (GridUuid)fut.getKey();
                    try {
                        if (GridGgfsImpl.this.meta.exists(id)) continue;
                        ((GridFutureAdapter)fut.getValue()).onDone();
                        rmv.add(id);
                    }
                    catch (GridException e) {
                        U.error((GridLogger)GridGgfsImpl.this.log, (Object)("Failed to check file existence: " + id), (Throwable)e);
                    }
                }
                for (GridUuid id : rmv) {
                    GridGgfsImpl.this.delFuts.remove((Object)id);
                }
            }
        }
    }

    private class FormatMessageListener
    implements GridMessageListener {
        private FormatMessageListener() {
        }

        public void onMessage(UUID nodeId, Object msg) {
            GridNode node;
            if (msg instanceof GridGgfsDeleteMessage && (node = GridGgfsImpl.this.ggfsCtx.kernalContext().discovery().node(nodeId)) != null && GridGgfsImpl.this.sameGgfs((GridGgfsAttributes[])node.attribute("org.gridgain.ggfs"))) {
                GridGgfsDeleteMessage msg0 = (GridGgfsDeleteMessage)((Object)msg);
                try {
                    msg0.finishUnmarshal(GridGgfsImpl.this.ggfsCtx.kernalContext().config().getMarshaller(), null);
                }
                catch (GridException e) {
                    U.error((GridLogger)GridGgfsImpl.this.log, (Object)("Failed to unmarshal message (will ignore): " + (Object)((Object)msg0)), (Throwable)e);
                    return;
                }
                assert (msg0.id() != null);
                GridFutureAdapter fut = (GridFutureAdapter)GridGgfsImpl.this.delFuts.remove((Object)msg0.id());
                if (fut != null) {
                    if (msg0.error() == null) {
                        fut.onDone();
                    } else {
                        fut.onDone((Throwable)msg0.error());
                    }
                }
            }
        }
    }

    @GridInternal
    private static class GgfsGlobalSpaceTask
    extends GridComputeTaskSplitAdapter<Object, GridBiTuple<Long, Long>> {
        private static final long serialVersionUID = 0L;
        private String ggfsName;

        private GgfsGlobalSpaceTask(@Nullable String ggfsName) {
            this.ggfsName = ggfsName;
        }

        protected Collection<? extends GridComputeJob> split(int gridSize, Object arg) throws GridException {
            ArrayList<1> res = new ArrayList<1>(gridSize);
            for (int i = 0; i < gridSize; ++i) {
                res.add(new GridComputeJobAdapter(){
                    @GridInstanceResource
                    private Grid g;

                    @Nullable
                    public GridBiTuple<Long, Long> execute() throws GridException {
                        GridGgfs ggfs = ((GridKernal)this.g).context().ggfs().ggfs(GgfsGlobalSpaceTask.this.ggfsName);
                        if (ggfs == null) {
                            return F.t((Object)0L, (Object)0L);
                        }
                        GridGgfsMetrics metrics = ggfs.metrics();
                        long loc = metrics.localSpaceSize();
                        return F.t((Object)loc, (Object)metrics.maxSpaceSize());
                    }
                });
            }
            return res;
        }

        @Nullable
        public GridBiTuple<Long, Long> reduce(List<GridComputeJobResult> results) throws GridException {
            long used = 0L;
            long max = 0L;
            for (GridComputeJobResult res : results) {
                GridBiTuple data = (GridBiTuple)res.getData();
                if (data == null) continue;
                used += ((Long)data.get1()).longValue();
                max += ((Long)data.get2()).longValue();
            }
            return F.t((Object)used, (Object)max);
        }

        public GridComputeJobResultPolicy result(GridComputeJobResult res, List<GridComputeJobResult> rcvd) throws GridException {
            return GridComputeJobResultPolicy.WAIT;
        }
    }

    private class GgfsEventAwareInputStream
    extends GridGgfsInputStreamImpl {
        private final AtomicBoolean closeGuard;

        GgfsEventAwareInputStream(GridGgfsContext ggfsCtx, GridGgfsPath path, GridGgfsFileInfo fileInfo, int prefetchBlocks, @Nullable int seqReadsBeforePrefetch, GridGgfsSecondaryInputStreamWrapper inWrapper, GridGgfsLocalMetrics metrics) {
            super(ggfsCtx, path, fileInfo, prefetchBlocks, seqReadsBeforePrefetch, inWrapper, metrics);
            this.closeGuard = new AtomicBoolean(false);
            metrics.incrementFilesOpenedForRead();
        }

        @Override
        public void close() throws IOException {
            if (this.closeGuard.compareAndSet(false, true)) {
                super.close();
                GridGgfsImpl.this.metrics.decrementFilesOpenedForRead();
                if (GridGgfsImpl.this.evts.isRecordable(123)) {
                    GridGgfsImpl.this.evts.record((GridEvent)new GridGgfsEvent(this.path, GridGgfsImpl.this.localNode(), 123, this.bytes()));
                }
            }
        }
    }

    private class GgfsEventAwareOutputStream
    extends GridGgfsOutputStreamImpl {
        private final AtomicBoolean closeGuard;

        GgfsEventAwareOutputStream(GridGgfsPath path, GridGgfsFileInfo fileInfo, GridUuid parentId, int bufSize, @Nullable GridGgfsMode mode, GridGgfsFileWorkerBatch batch) throws GridException {
            super(GridGgfsImpl.this.ggfsCtx, path, fileInfo, parentId, bufSize, mode, batch, GridGgfsImpl.this.metrics);
            this.closeGuard = new AtomicBoolean(false);
            GridGgfsImpl.this.metrics.incrementFilesOpenedForWrite();
        }

        @Override
        protected void onClose() throws IOException {
            if (this.closeGuard.compareAndSet(false, true)) {
                super.onClose();
                GridGgfsImpl.this.metrics.decrementFilesOpenedForWrite();
                if (GridGgfsImpl.this.evts.isRecordable(122)) {
                    GridGgfsImpl.this.evts.record((GridEvent)new GridGgfsEvent(this.path, GridGgfsImpl.this.localNode(), 122, this.bytes()));
                }
            }
        }
    }

    private static final class FileDescriptor {
        @Nullable
        private final GridUuid parentId;
        private final String fileName;
        private final GridUuid fileId;
        private final boolean isFile;

        private FileDescriptor(@Nullable GridUuid parentId, String fileName, GridUuid fileId, boolean isFile) {
            assert (fileName != null);
            this.parentId = parentId;
            this.fileName = fileName;
            this.fileId = fileId;
            this.isFile = isFile;
        }

        public int hashCode() {
            int res = this.parentId != null ? this.parentId.hashCode() : 0;
            res = 31 * res + this.fileName.hashCode();
            res = 31 * res + this.fileId.hashCode();
            res = 31 * res + (this.isFile ? 1231 : 1237);
            return res;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FileDescriptor that = (FileDescriptor)o;
            return this.fileId.equals((Object)that.fileId) && this.isFile == that.isFile && this.fileName.equals(that.fileName) && (this.parentId == null ? that.parentId == null : this.parentId.equals((Object)that.parentId));
        }

        public String toString() {
            return S.toString(FileDescriptor.class, (Object)this);
        }
    }
}

