/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.ggfs;

import java.io.EOFException;
import java.io.IOError;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gridgain.grid.GridException;
import org.gridgain.grid.GridFuture;
import org.gridgain.grid.ggfs.GridGgfsCorruptedFileException;
import org.gridgain.grid.ggfs.GridGgfsFileNotFoundException;
import org.gridgain.grid.ggfs.GridGgfsInputStream;
import org.gridgain.grid.ggfs.GridGgfsPath;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsContext;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsDataManager;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsFileInfo;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsInputStreamAdapter;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsLocalMetrics;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsMetaManager;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsSecondaryInputStreamWrapper;
import org.gridgain.grid.lang.GridInClosure;
import org.gridgain.grid.logger.GridLogger;
import org.gridgain.grid.util.GridConcurrentHashSet;
import org.gridgain.grid.util.typedef.internal.S;
import org.gridgain.grid.util.typedef.internal.U;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridGgfsInputStreamImpl
extends GridGgfsInputStreamAdapter {
    private static final byte[][] EMPTY_CHUNKS = new byte[0][];
    private final GridGgfsMetaManager meta;
    private final GridGgfsDataManager data;
    private final GridGgfsSecondaryInputStreamWrapper inWrapper;
    private GridLogger log;
    protected final GridGgfsPath path;
    private volatile GridGgfsFileInfo fileInfo;
    private long pos;
    private final Map<Long, GridFuture<byte[]>> locCache;
    private final int maxLocCacheSize;
    private final Set<GridFuture<byte[]>> pendingFuts;
    private final Lock pendingFutsLock = new ReentrantLock();
    private final Condition pendingFutsCond = this.pendingFutsLock.newCondition();
    private boolean closed;
    private int prefetchBlocks;
    private int seqReadsBeforePrefetch;
    private long bytes;
    private long prevBlockIdx = -1L;
    private int seqReads;
    private long time;
    private final GridGgfsLocalMetrics metrics;

    GridGgfsInputStreamImpl(GridGgfsContext ggfsCtx, GridGgfsPath path, GridGgfsFileInfo fileInfo, int prefetchBlocks, int seqReadsBeforePrefetch, @Nullable GridGgfsSecondaryInputStreamWrapper inWrapper, GridGgfsLocalMetrics metrics) {
        assert (ggfsCtx != null);
        assert (path != null);
        assert (fileInfo != null);
        assert (metrics != null);
        this.path = path;
        this.fileInfo = fileInfo;
        this.prefetchBlocks = prefetchBlocks;
        this.seqReadsBeforePrefetch = seqReadsBeforePrefetch;
        this.inWrapper = inWrapper;
        this.metrics = metrics;
        this.meta = ggfsCtx.meta();
        this.data = ggfsCtx.data();
        this.log = ggfsCtx.kernalContext().log(GridGgfsInputStream.class);
        this.maxLocCacheSize = (prefetchBlocks > 0 ? prefetchBlocks : 1) * 3 / 2;
        this.locCache = new LinkedHashMap<Long, GridFuture<byte[]>>(this.maxLocCacheSize, 1.0f);
        this.pendingFuts = new GridConcurrentHashSet(prefetchBlocks > 0 ? prefetchBlocks : 1);
    }

    public synchronized long bytes() {
        return this.bytes;
    }

    @Override
    public GridGgfsFileInfo fileInfo() {
        return this.fileInfo;
    }

    public synchronized int read() throws IOException {
        byte[] buf = new byte[1];
        int read = this.read(buf, 0, 1);
        if (read == -1) {
            return -1;
        }
        return buf[0] & 0xFF;
    }

    public synchronized int read(@NotNull byte[] b, int off, int len) throws IOException {
        int read = this.readFromStore(this.pos, b, off, len);
        if (read != -1) {
            this.pos += (long)read;
        }
        return read;
    }

    public synchronized void seek(long pos) throws IOException {
        if (pos < 0L) {
            throw new IOException("Seek position cannot be negative: " + pos);
        }
        this.pos = pos;
    }

    public synchronized long position() throws IOException {
        return this.pos;
    }

    public synchronized int available() throws IOException {
        long l = this.fileInfo.length() - this.pos;
        if (l < 0L) {
            return 0;
        }
        if (l > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l;
    }

    public synchronized void readFully(long pos, byte[] buf) throws IOException {
        this.readFully(pos, buf, 0, buf.length);
    }

    public synchronized void readFully(long pos, byte[] buf, int off, int len) throws IOException {
        int read;
        for (int readBytes = 0; readBytes < len; readBytes += read) {
            read = this.readFromStore(pos + (long)readBytes, buf, off + readBytes, len - readBytes);
            if (read != -1) continue;
            throw new EOFException("Failed to read stream fully (stream ends unexpectedly)[pos=" + pos + ", buf.length=" + buf.length + ", off=" + off + ", len=" + len + ']');
        }
    }

    public synchronized int read(long pos, byte[] buf, int off, int len) throws IOException {
        return this.readFromStore(pos, buf, off, len);
    }

    @Override
    public synchronized byte[][] readChunks(long pos, int len) throws IOException {
        long readable = this.fileInfo.length() - pos;
        if (readable <= 0L) {
            return EMPTY_CHUNKS;
        }
        long startTime = System.nanoTime();
        if (readable < (long)len) {
            len = (int)readable;
        }
        assert (len > 0);
        this.bytes += (long)len;
        int start = (int)(pos / (long)this.fileInfo.blockSize());
        int end = (int)((pos + (long)len - 1L) / (long)this.fileInfo.blockSize());
        int chunkCnt = end - start + 1;
        byte[][] chunks = new byte[chunkCnt][];
        for (int i = 0; i < chunkCnt; ++i) {
            int blockOff;
            byte[] block = this.blockFragmentizerSafe(start + i);
            int blockLen = Math.min(len, block.length - (blockOff = (int)(pos % (long)this.fileInfo.blockSize())));
            if (blockLen == block.length) {
                chunks[i] = block;
            } else {
                assert (i == 0 || i == chunkCnt - 1);
                chunks[i] = Arrays.copyOfRange(block, blockOff, blockOff + blockLen);
            }
            len -= blockLen;
            pos += (long)blockLen;
        }
        assert (len == 0);
        this.time += System.nanoTime() - startTime;
        return chunks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws IOException {
        try {
            if (this.inWrapper != null) {
                this.inWrapper.close();
                for (GridFuture<byte[]> fut : this.locCache.values()) {
                    try {
                        fut.get();
                    }
                    catch (GridException gridException) {}
                }
                while (!this.pendingFuts.isEmpty()) {
                    this.pendingFutsLock.lock();
                    try {
                        this.pendingFutsCond.await(100L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException ignore) {}
                    continue;
                    finally {
                        this.pendingFutsLock.unlock();
                    }
                }
                if (!this.meta.exists(this.fileInfo.id())) {
                    this.data.delete(this.fileInfo);
                }
            }
        }
        catch (GridException e) {
            throw new IOError(e);
        }
        finally {
            this.closed = true;
            this.metrics.addReadBytesTime(this.bytes, this.time);
            this.locCache.clear();
        }
    }

    private int readFromStore(long pos, byte[] buf, int off, int len) throws IOException {
        if (pos < 0L) {
            throw new IllegalArgumentException("Read position cannot be negative: " + pos);
        }
        if (buf == null) {
            throw new NullPointerException("Destination buffer cannot be null.");
        }
        if (off < 0 || len < 0 || buf.length < len + off) {
            throw new IndexOutOfBoundsException("Invalid buffer boundaries [buf.length=" + buf.length + ", off=" + off + ", len=" + len + ']');
        }
        if (len == 0) {
            return 0;
        }
        long readable = this.fileInfo.length() - pos;
        if (readable <= 0L) {
            return -1;
        }
        long startTime = System.nanoTime();
        if (readable < (long)len) {
            len = (int)readable;
        }
        assert (len > 0);
        byte[] block = this.blockFragmentizerSafe(pos / (long)this.fileInfo.blockSize());
        int blockOff = (int)(pos % (long)this.fileInfo.blockSize());
        len = Math.min(len, block.length - blockOff);
        U.arrayCopy((byte[])block, (int)blockOff, (byte[])buf, (int)off, (int)len);
        this.bytes += (long)len;
        this.time += System.nanoTime() - startTime;
        return len;
    }

    private byte[] blockFragmentizerSafe(long blockIdx) throws IOException {
        try {
            try {
                return this.block(blockIdx);
            }
            catch (GridGgfsCorruptedFileException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Failed to fetch file block [path=" + this.path + ", fileInfo=" + this.fileInfo + ", blockIdx=" + blockIdx + ", errMsg=" + e.getMessage() + ']');
                }
                if (this.fileInfo.fileMap() != null && !this.fileInfo.fileMap().ranges().isEmpty()) {
                    GridGgfsFileInfo newInfo = this.meta.info(this.fileInfo.id());
                    if (newInfo == null) {
                        throw new GridGgfsFileNotFoundException("Failed to read file block (file was concurrently deleted) [path=" + this.path + ", blockIdx=" + blockIdx + ']');
                    }
                    this.fileInfo = newInfo;
                    this.locCache.clear();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Updated input stream file info after block fetch failure [path=" + this.path + ", fileInfo=" + this.fileInfo + ']');
                    }
                    return this.block(blockIdx);
                }
                throw new IOException(e.getMessage(), e);
            }
        }
        catch (GridException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private byte[] block(long blockIdx) throws IOException, GridException {
        byte[] bytes;
        assert (blockIdx >= 0L);
        GridFuture<byte[]> bytesFut = this.locCache.get(blockIdx);
        if (bytesFut == null) {
            if (this.closed) {
                throw new IOException("Stream is already closed: " + (Object)((Object)this));
            }
            this.seqReads = this.prevBlockIdx != -1L && this.prevBlockIdx + 1L == blockIdx ? (this.seqReads = this.seqReads + 1) : 0;
            this.prevBlockIdx = blockIdx;
            bytesFut = this.dataBlock(this.fileInfo, blockIdx);
            assert (bytesFut != null);
            this.addLocalCacheFuture(blockIdx, bytesFut);
        }
        if (this.prefetchBlocks > 0 && this.seqReads >= this.seqReadsBeforePrefetch - 1) {
            for (int i = 1; i <= this.prefetchBlocks && (long)this.fileInfo.blockSize() * ((long)i + blockIdx) < this.fileInfo.length(); ++i) {
                if (this.locCache.get(blockIdx + (long)i) != null) continue;
                this.addLocalCacheFuture(blockIdx + (long)i, this.dataBlock(this.fileInfo, blockIdx + (long)i));
            }
        }
        if ((bytes = (byte[])bytesFut.get()) == null) {
            throw new GridGgfsCorruptedFileException("Failed to retrieve file's data block (corrupted file?) [path=" + this.path + ", blockIdx=" + blockIdx + ']');
        }
        int blockSize = this.fileInfo.blockSize();
        if (blockIdx == this.fileInfo.blocksCount() - 1L) {
            blockSize = (int)(this.fileInfo.length() % (long)blockSize);
        }
        if (bytes.length < blockSize) {
            throw new IOException("Inconsistent file's data block (incorrectly written?) [path=" + this.path + ", blockIdx=" + blockIdx + ", blockSize=" + bytes.length + ", expectedBlockSize=" + blockSize + ", fileBlockSize=" + this.fileInfo.blockSize() + ", fileLen=" + this.fileInfo.length() + ']');
        }
        return bytes;
    }

    private void addLocalCacheFuture(long idx, GridFuture<byte[]> fut) {
        assert (Thread.holdsLock((Object)this));
        if (!this.locCache.containsKey(idx)) {
            GridFuture<byte[]> evictFut;
            if (this.locCache.size() == this.maxLocCacheSize && !(evictFut = this.locCache.remove(this.locCache.keySet().iterator().next())).isDone()) {
                this.pendingFuts.add(evictFut);
                evictFut.listenAsync((GridInClosure)new GridInClosure<GridFuture<byte[]>>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void apply(GridFuture<byte[]> t) {
                        GridGgfsInputStreamImpl.this.pendingFuts.remove(evictFut);
                        GridGgfsInputStreamImpl.this.pendingFutsLock.lock();
                        try {
                            GridGgfsInputStreamImpl.this.pendingFutsCond.signalAll();
                        }
                        finally {
                            GridGgfsInputStreamImpl.this.pendingFutsLock.unlock();
                        }
                    }
                });
            }
            this.locCache.put(idx, fut);
        }
    }

    @Nullable
    protected GridFuture<byte[]> dataBlock(GridGgfsFileInfo fileInfo, long blockIdx) throws GridException {
        return this.data.dataBlock(fileInfo, this.path, blockIdx, this.inWrapper);
    }

    public String toString() {
        return S.toString(GridGgfsInputStreamImpl.class, (Object)((Object)this));
    }
}

