/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.ggfs;

import java.io.IOException;
import org.gridgain.grid.Grid;
import org.gridgain.grid.GridException;
import org.gridgain.grid.compute.GridComputeJob;
import org.gridgain.grid.ggfs.GridGgfs;
import org.gridgain.grid.ggfs.GridGgfsInputStream;
import org.gridgain.grid.ggfs.GridGgfsPath;
import org.gridgain.grid.ggfs.mapreduce.GridGgfsFileRange;
import org.gridgain.grid.ggfs.mapreduce.GridGgfsJob;
import org.gridgain.grid.ggfs.mapreduce.GridGgfsRecordResolver;
import org.gridgain.grid.kernal.GridInternalWrapper;
import org.gridgain.grid.logger.GridLogger;
import org.gridgain.grid.resources.GridInstanceResource;
import org.gridgain.grid.resources.GridLoggerResource;

public class GridGgfsJobImpl
implements GridComputeJob,
GridInternalWrapper<GridGgfsJob> {
    private static final long serialVersionUID = 0L;
    private GridGgfsJob job;
    private String ggfsName;
    private GridGgfsPath path;
    private long start;
    private long len;
    private GridGgfsRecordResolver rslvr;
    @GridInstanceResource
    private Grid grid;
    @GridLoggerResource
    private GridLogger log;

    public GridGgfsJobImpl(GridGgfsJob job, String ggfsName, GridGgfsPath path, long start, long len, GridGgfsRecordResolver rslvr) {
        this.job = job;
        this.ggfsName = ggfsName;
        this.path = path;
        this.start = start;
        this.len = len;
        this.rslvr = rslvr;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object execute() throws GridException {
        GridGgfs ggfs = this.grid.ggfs(this.ggfsName);
        try (GridGgfsInputStream in = ggfs.open(this.path);){
            GridGgfsFileRange split = new GridGgfsFileRange(this.path, this.start, this.len);
            if (this.rslvr != null && (split = this.rslvr.resolveRecords(ggfs, in, split)) == null) {
                this.log.warning("No data found for split on local node after resolver is applied [ggfsName=" + this.ggfsName + ", path=" + this.path + ", start=" + this.start + ", len=" + this.len + ']');
                Object var5_7 = null;
                return var5_7;
            }
            in.seek(split.start());
            Object object = this.job.execute(ggfs, new GridGgfsFileRange(this.path, split.start(), split.length()), in);
            return object;
        }
        catch (IOException e) {
            throw new GridException("Failed to execute GGFS job for file split [ggfsName=" + this.ggfsName + ", path=" + this.path + ", start=" + this.start + ", len=" + this.len + ']', (Throwable)e);
        }
    }

    public void cancel() {
        this.job.cancel();
    }

    public GridGgfsJob userObject() {
        return this.job;
    }
}

