/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.ggfs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import org.gridgain.grid.GridUuid;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsFileInfo;
import org.gridgain.grid.util.typedef.internal.S;
import org.gridgain.grid.util.typedef.internal.U;

public class GridGgfsListingEntry
implements Externalizable {
    private static final long serialVersionUID = 0L;
    private GridUuid fileId;
    private GridUuid affKey;
    private int blockSize;
    private long len;
    private long accessTime;
    private long modificationTime;
    private Map<String, String> props;

    public GridGgfsListingEntry() {
    }

    public GridGgfsListingEntry(GridGgfsFileInfo fileInfo) {
        this.fileId = fileInfo.id();
        this.affKey = fileInfo.affinityKey();
        if (fileInfo.isFile()) {
            this.blockSize = fileInfo.blockSize();
            this.len = fileInfo.length();
        }
        this.props = fileInfo.properties();
        this.accessTime = fileInfo.accessTime();
        this.modificationTime = fileInfo.modificationTime();
    }

    public GridGgfsListingEntry(GridGgfsListingEntry entry, long len, long accessTime, long modificationTime) {
        this.fileId = entry.fileId;
        this.affKey = entry.affKey;
        this.blockSize = entry.blockSize;
        this.props = entry.props;
        this.accessTime = accessTime;
        this.modificationTime = modificationTime;
        this.len = len;
    }

    public GridUuid fileId() {
        return this.fileId;
    }

    public GridUuid affinityKey() {
        return this.affKey;
    }

    public boolean isFile() {
        return this.blockSize > 0;
    }

    public boolean isDirectory() {
        return this.blockSize == 0;
    }

    public int blockSize() {
        return this.blockSize;
    }

    public long length() {
        return this.len;
    }

    public long accessTime() {
        return this.accessTime;
    }

    public long modificationTime() {
        return this.modificationTime;
    }

    public Map<String, String> properties() {
        return this.props;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeGridUuid((DataOutput)out, (GridUuid)this.fileId);
        out.writeInt(this.blockSize);
        out.writeLong(this.len);
        U.writeStringMap((DataOutput)out, this.props);
        out.writeLong(this.accessTime);
        out.writeLong(this.modificationTime);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fileId = U.readGridUuid((DataInput)in);
        this.blockSize = in.readInt();
        this.len = in.readLong();
        this.props = U.readStringMap((DataInput)in);
        this.accessTime = in.readLong();
        this.modificationTime = in.readLong();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GridGgfsListingEntry)) {
            return false;
        }
        GridGgfsListingEntry that = (GridGgfsListingEntry)o;
        return this.fileId.equals((Object)that.fileId);
    }

    public int hashCode() {
        return this.fileId.hashCode();
    }

    public String toString() {
        return S.toString(GridGgfsListingEntry.class, (Object)this);
    }
}

