/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.ggfs;

import org.gridgain.grid.lang.GridBiTuple;
import org.gridgain.grid.util.typedef.F;
import org.jdk8.backport.LongAdder;

public class GridGgfsLocalMetrics {
    private volatile GridBiTuple<LongAdder, LongAdder> blocksRead;
    private volatile GridBiTuple<LongAdder, LongAdder> blocksWritten;
    private volatile GridBiTuple<LongAdder, LongAdder> bytesRead;
    private volatile GridBiTuple<LongAdder, LongAdder> bytesWritten;
    private final LongAdder filesOpenedForRead = new LongAdder();
    private final LongAdder filesOpenedForWrite = new LongAdder();

    GridGgfsLocalMetrics() {
        this.reset();
    }

    long readBytes() {
        return ((LongAdder)this.bytesRead.get1()).longValue();
    }

    long readBytesTime() {
        return ((LongAdder)this.bytesRead.get2()).longValue();
    }

    void addReadBytesTime(long readBytes, long readTime) {
        GridBiTuple<LongAdder, LongAdder> bytesRead0 = this.bytesRead;
        ((LongAdder)bytesRead0.get1()).add(readBytes);
        ((LongAdder)bytesRead0.get2()).add(readTime);
    }

    long writeBytes() {
        return ((LongAdder)this.bytesWritten.get1()).longValue();
    }

    long writeBytesTime() {
        return ((LongAdder)this.bytesWritten.get2()).longValue();
    }

    void addWrittenBytesTime(long writtenBytes, long writeTime) {
        GridBiTuple<LongAdder, LongAdder> bytesWritten0 = this.bytesWritten;
        ((LongAdder)bytesWritten0.get1()).add(writtenBytes);
        ((LongAdder)bytesWritten0.get2()).add(writeTime);
    }

    long readBlocks() {
        return ((LongAdder)this.blocksRead.get1()).longValue();
    }

    long readBlocksSecondary() {
        return ((LongAdder)this.blocksRead.get2()).longValue();
    }

    void addReadBlocks(int total, int secondary) {
        GridBiTuple<LongAdder, LongAdder> blocksRead0 = this.blocksRead;
        ((LongAdder)blocksRead0.get1()).add((long)total);
        ((LongAdder)blocksRead0.get2()).add((long)secondary);
    }

    long writeBlocks() {
        return ((LongAdder)this.blocksWritten.get1()).longValue();
    }

    long writeBlocksSecondary() {
        return ((LongAdder)this.blocksWritten.get2()).longValue();
    }

    void addWriteBlocks(int total, int secondary) {
        GridBiTuple<LongAdder, LongAdder> blocksWritten0 = this.blocksWritten;
        ((LongAdder)blocksWritten0.get1()).add((long)total);
        ((LongAdder)blocksWritten0.get2()).add((long)secondary);
    }

    void incrementFilesOpenedForRead() {
        this.filesOpenedForRead.increment();
    }

    void decrementFilesOpenedForRead() {
        this.filesOpenedForRead.decrement();
    }

    int filesOpenedForRead() {
        return this.filesOpenedForRead.intValue();
    }

    void incrementFilesOpenedForWrite() {
        this.filesOpenedForWrite.increment();
    }

    void decrementFilesOpenedForWrite() {
        this.filesOpenedForWrite.decrement();
    }

    int filesOpenedForWrite() {
        return this.filesOpenedForWrite.intValue();
    }

    void reset() {
        this.blocksRead = F.t((Object)new LongAdder(), (Object)new LongAdder());
        this.blocksWritten = F.t((Object)new LongAdder(), (Object)new LongAdder());
        this.bytesRead = F.t((Object)new LongAdder(), (Object)new LongAdder());
        this.bytesWritten = F.t((Object)new LongAdder(), (Object)new LongAdder());
    }
}

