/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.kernal.processors.ggfs;

import java.util.concurrent.atomic.AtomicBoolean;
import org.gridgain.grid.GridException;
import org.gridgain.grid.kernal.processors.ggfs.GridGgfsContext;
import org.gridgain.grid.logger.GridLogger;

public abstract class GridGgfsManager {
    protected GridGgfsContext ggfsCtx;
    protected GridLogger log;
    private AtomicBoolean starting = new AtomicBoolean();

    public void start(GridGgfsContext ggfsCtx) throws GridException {
        if (!this.starting.compareAndSet(false, true)) assert (false) : "Method start is called more than once for manager: " + this;
        assert (ggfsCtx != null);
        this.ggfsCtx = ggfsCtx;
        this.log = ggfsCtx.kernalContext().log(this.getClass());
        this.start0();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug(this.startInfo());
        }
    }

    public final void stop(boolean cancel) {
        if (!this.starting.get()) {
            return;
        }
        this.stop0(cancel);
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug(this.stopInfo());
        }
    }

    public final void onKernalStart() throws GridException {
        this.onKernalStart0();
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug(this.kernalStartInfo());
        }
    }

    public final void onKernalStop(boolean cancel) {
        if (!this.starting.get()) {
            return;
        }
        this.onKernalStop0(cancel);
        if (this.log != null && this.log.isDebugEnabled()) {
            this.log.debug(this.kernalStopInfo());
        }
    }

    protected void start0() throws GridException {
    }

    protected void stop0(boolean cancel) {
    }

    protected void onKernalStart0() throws GridException {
    }

    protected void onKernalStop0(boolean cancel) {
    }

    protected String startInfo() {
        return "Cache manager started: " + this.getClass().getSimpleName();
    }

    protected String stopInfo() {
        return "Cache manager stopped: " + this.getClass().getSimpleName();
    }

    protected String kernalStartInfo() {
        return "Cache manager received onKernalStart() callback: " + this.getClass().getSimpleName();
    }

    protected String kernalStopInfo() {
        return "Cache manager received onKernalStop() callback: " + this.getClass().getSimpleName();
    }
}

